/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import org.xml.sax.SAXException;

public abstract class ChoiceElement
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private String elementName;
    private EbicsElement element;

    protected ChoiceElement() {
    }

    protected ChoiceElement(String elementName, EbicsElement element) {
        this.elementName = elementName;
        this.element = element;
    }

    @Override
    public final void printValue(EbicsPrintStream ps) {
        if (this.element.isSubSequence()) {
            this.element.printValue(ps);
        } else {
            this.element.printOut(this.elementName, ps);
        }
    }

    public String getElementName() {
        return this.elementName;
    }

    @Override
    protected boolean isSubSequence() {
        return true;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(0);
    }

    protected <T extends EbicsElement> T get(Class<T> t, String name) {
        return (T)(name.equals(this.elementName) ? (EbicsElement)t.cast(this.element) : null);
    }

    protected <T extends EbicsElement> T get(Class<T> t) {
        if (this.element == null) {
            return null;
        }
        return (T)(t.isAssignableFrom(this.element.getClass()) ? (EbicsElement)t.cast(this.element) : null);
    }

    public EbicsElement getElement() {
        return this.element;
    }

    protected EbicsElement setElement(String elementName, EbicsElement element) {
        this.elementName = elementName;
        this.element = element;
        return element;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        if (this.element != null) {
            sb.append(':').append(this.element);
        }
        return sb.toString();
    }
}

