/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import org.xml.sax.SAXException;

public class BooleanElement
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    protected boolean value;
    public static final BooleanElement TRUE = new BooleanElement(true);
    public static final BooleanElement FALSE = new BooleanElement(false);

    public BooleanElement() {
    }

    protected BooleanElement(boolean value) {
        this.value = value;
    }

    public static BooleanElement getInstance(boolean b) {
        return b ? TRUE : FALSE;
    }

    public boolean booleanValue() {
        return this.value;
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        ps.print(Boolean.toString(this.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value ? 1231 : 1237);
        return result;
    }

    @Override
    public ElementParser createParser() {
        return new SimpleStringElement.StringParser(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BooleanElement)) {
            return false;
        }
        return ((BooleanElement)obj).value == this.value;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        SimpleStringElement.StringParser sp = (SimpleStringElement.StringParser)parser;
        String s = sp.getCondensed();
        if (s.equals("true") || s.equals("1")) {
            this.value = true;
        } else if (s.equals("false") || s.equals("0")) {
            this.value = false;
        } else {
            throw new SAXException(s + " is no boolean value");
        }
    }

    public static class Parser
    extends SimpleStringElement.Parser {
        protected Parser() {
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            String s = this.getCondensed();
            if (s.equals("true") || s.equals("1")) {
                return TRUE;
            }
            if (s.equals("false") || s.equals("0")) {
                return FALSE;
            }
            throw new SAXException(s + " is no boolean value");
        }
    }
}

