/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import java.math.BigInteger;
import org.xml.sax.SAXException;

public class BigIntegerElement
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private BigInteger value;

    public BigIntegerElement() {
        this.value = BigInteger.ZERO;
    }

    public BigIntegerElement(BigInteger value) {
        this.value = value;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    protected void printValue(EbicsPrintStream ps) {
        ps.print(this.value.toString());
    }

    @Override
    public ElementParser createParser() {
        return new Parser(this);
    }

    private static class Parser
    extends EbicsElement.Parser {
        private char sign = (char)32;
        private boolean digits = false;

        public Parser(BigIntegerElement parsed) {
            super(parsed);
        }

        @Override
        protected void characters(char[] ch, int start, int length) throws SAXException {
            BigIntegerElement bi = (BigIntegerElement)this.toReturn;
            length += start;
            for (int i = start; i < length; ++i) {
                char c = ch[i];
                if (Character.isWhitespace(c)) continue;
                if (c == '+' && this.sign == ' ') {
                    this.sign = (char)43;
                    continue;
                }
                if (c == '-' && this.sign == ' ') {
                    this.sign = (char)45;
                    continue;
                }
                if (c >= '0' && c <= '9') {
                    bi.value = bi.value.multiply(BigInteger.TEN);
                    bi.value = bi.value.add(BigInteger.valueOf(c - 48));
                    this.digits = true;
                    if (this.sign != ' ') continue;
                    this.sign = (char)43;
                    continue;
                }
                throw new SAXException("Unexpected character " + c);
            }
        }

        @Override
        public EbicsElement endElement() throws SAXException {
            if (!this.digits) {
                throw new SAXException("No number found");
            }
            if (this.sign == '-') {
                BigIntegerElement bi = (BigIntegerElement)this.toReturn;
                bi.value = bi.value.negate();
            }
            return super.endElement();
        }
    }
}

