/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import java.math.BigDecimal;
import org.xml.sax.SAXException;

public class BaseAmountElement
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    protected BigDecimal value;

    public BaseAmountElement() {
    }

    public BaseAmountElement(BigDecimal value) {
        this.value = value;
        try {
            this.checkValue();
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public BigDecimal getAmount() {
        return this.value;
    }

    public static void printOut(BigDecimal value, String elementName, EbicsPrintStream ps) {
        ps.openElement(elementName);
        ps.closeTag();
        ps.print(value.toString());
        ps.closeElement();
    }

    @Override
    protected void printValue(EbicsPrintStream ps) {
        ps.print(this.value.toString());
    }

    @Override
    public ElementParser createParser() {
        return new Parser(this);
    }

    @Override
    protected final void endElement(ElementParser parser) {
    }

    protected void checkValue() throws SAXException {
        if (this.value == null) {
            throw new SAXException("No value set");
        }
        if (this.getMinimumValueConstraint() != null && this.value.compareTo(this.getMinimumValueConstraint()) < 0) {
            throw new SAXException("Value smaller than minumum (" + String.valueOf(this.value) + "<" + String.valueOf(this.getMinimumValueConstraint()));
        }
        if (this.getMaximumValueConstraint() != null && this.value.compareTo(this.getMaximumValueConstraint()) > 0) {
            throw new SAXException("Value larger than maximum (" + String.valueOf(this.value) + ">" + String.valueOf(this.getMaximumValueConstraint()));
        }
        if (this.isFractionDigitsChecking() && this.value.scale() > this.getFractionDigitsConstraint()) {
            throw new SAXException("Too many fraction digits. Value:" + this.value.toString() + " (Maximum fraction digits:" + this.getFractionDigitsConstraint() + ", set:" + this.value.scale() + ")");
        }
        if (this.isTotalDigitsChecking() && this.value.precision() > this.getTotalDigitsConstraint()) {
            throw new SAXException("Invalid number of digits. Value:" + this.value.toString() + " (Maximum total digits:" + this.getTotalDigitsConstraint() + ", set:" + this.value.precision() + ")");
        }
    }

    protected boolean isFractionDigitsChecking() {
        return true;
    }

    protected boolean isTotalDigitsChecking() {
        return true;
    }

    protected int getFractionDigitsConstraint() {
        return 2;
    }

    protected int getTotalDigitsConstraint() {
        return 18;
    }

    protected BigDecimal getMinimumValueConstraint() {
        return null;
    }

    protected BigDecimal getMaximumValueConstraint() {
        return null;
    }

    private static class Parser
    extends SimpleStringElement.Parser {
        private final BaseAmountElement toReturn;

        private Parser(BaseAmountElement toReturn) {
            this.toReturn = toReturn;
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            this.toReturn.setAttributes(attributes);
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            try {
                this.toReturn.value = new BigDecimal(this.getCondensed());
                this.toReturn.checkValue();
            }
            catch (NumberFormatException nfe) {
                throw new SAXException(nfe);
            }
            return this.toReturn;
        }
    }
}

