/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.xml.sax.SAXException;

public class Base64Element
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private static final char[] ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] BITS = new byte[128];
    protected byte[] value;

    @Deprecated
    public Base64Element() {
    }

    public Base64Element(byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    protected void printValue(EbicsPrintStream ps) {
        if (this.value != null) {
            int i = 0;
            while (i < this.value.length) {
                int b = this.value[i] & 0xFF;
                ps.print(ALPHABET[b >> 2]);
                if (++i < this.value.length) {
                    int n = (b & 3) << 4;
                    b = this.value[i] & 0xFF;
                    ps.print(ALPHABET[n | b >> 4]);
                    if (++i < this.value.length) {
                        int n2 = (b & 0xF) << 2;
                        b = this.value[i] & 0xFF;
                        ps.print(ALPHABET[n2 | b >> 6]);
                        ps.print(ALPHABET[b & 0x3F]);
                        ++i;
                        continue;
                    }
                    ps.print(ALPHABET[(b & 0xF) << 2]);
                    ps.print('=');
                    continue;
                }
                ps.print(ALPHABET[(b & 3) << 4]);
                ps.print("==");
            }
        }
    }

    @Override
    public ElementParser createParser() {
        return new Base64Parser(this);
    }

    public static byte[] value(Base64Element e) {
        return e == null ? null : e.getValue();
    }

    static {
        Arrays.fill(BITS, (byte)64);
        byte i = (byte)ALPHABET.length;
        while ((i = (byte)(i - 1)) >= 0) {
            Base64Element.BITS[Base64Element.ALPHABET[i]] = i;
        }
    }

    private static class Base64Parser
    extends Parser {
        private final Base64Element toReturn;

        private Base64Parser(Base64Element toReturn) {
            this.toReturn = toReturn;
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            this.toReturn.setAttributes(attributes);
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.toReturn.value = this.getValue();
            this.toReturn.endElement(this);
            return this.toReturn;
        }
    }

    public static class Parser
    extends ElementParser {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        char[] buffer = new char[4];
        int bufferPos = 0;

        public Parser() {
            super(0);
        }

        @Override
        protected void characters(char[] content, int offset, int length) throws SAXException {
            length = offset + length;
            for (int i = offset; i < length; ++i) {
                if (Character.isWhitespace(content[i])) continue;
                char c = content[i];
                if (c >= '\u0080' || BITS[c] == 64 && (c != '=' || this.bufferPos < 2)) {
                    throw new SAXException("Illegal base64 character: " + c);
                }
                this.buffer[this.bufferPos++] = c;
                if (this.bufferPos == -1) {
                    throw new SAXException("Unexpected base64 input");
                }
                if (this.bufferPos != 4) continue;
                this.bufferPos = 0;
                byte b1 = BITS[this.buffer[1]];
                this.bos.write(BITS[this.buffer[0]] << 2 | (b1 & 0x30) >> 4);
                if (this.buffer[2] != '=') {
                    byte b2 = BITS[this.buffer[2]];
                    this.bos.write((b1 & 0xF) << 4 | (b2 & 0x3C) >> 2);
                    if (this.buffer[3] != '=') {
                        this.bos.write((b2 & 3) << 6 | BITS[this.buffer[3]]);
                        continue;
                    }
                    if ((b2 & 3) != 0) {
                        throw new SAXException("Illegal padding");
                    }
                    this.bufferPos = -1;
                    continue;
                }
                if ((b1 & 0xF) != 0 || this.buffer[3] != '=') {
                    throw new SAXException("Illegal padding");
                }
                this.bufferPos = -1;
            }
        }

        protected byte[] getValue() throws SAXException {
            if (this.bufferPos > 0) {
                throw new SAXException("Illegal padding");
            }
            return this.bos.toByteArray();
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            return new Base64Element(this.getValue());
        }
    }
}

