/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema;

import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.h005.ContainerFlagType;
import de.businesslogics.ebics.schema.h005.ContainerStringType;
import de.businesslogics.ebics.schema.h005.MessageType;
import de.businesslogics.ebics.schema.h005.NumStringType;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.h005.ScopeStringType;
import de.businesslogics.ebics.schema.h005.ServiceNameStringType;
import de.businesslogics.ebics.schema.h005.ServiceOptionStringType;
import de.businesslogics.util.StringUtils;
import java.io.Serializable;

public class BTF
implements Serializable {
    private static final char VARIANT_PREFIX = '(';
    private static final char CONTAINER_PREFIX = ')';
    private static final char FORMAT_PREFIX = '*';
    private static final char OPTION_PREFIX = '+';
    private static final char VERSION_PREFIX = ',';
    private static final char SCOPE_PREFIX = '-';
    private static final long serialVersionUID = 1L;
    private String container;
    private String scope;
    private String serviceName;
    private String serviceOption;
    private String msgName;
    private String msgFormat;
    private String msgVersion;
    private String msgVariant;

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        if (container != null && container.length() == 0) {
            container = null;
        }
        this.container = container;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceOption() {
        return this.serviceOption;
    }

    public void setServiceOption(String serviceOption) {
        if (serviceOption != null && serviceOption.length() == 0) {
            serviceOption = null;
        }
        this.serviceOption = serviceOption;
    }

    public String getMsgName() {
        return this.msgName;
    }

    public void setMsgName(String msgName) {
        this.msgName = msgName;
    }

    public String getMsgFormat() {
        return this.msgFormat;
    }

    public void setMsgFormat(String msgFormat) {
        if (msgFormat != null && msgFormat.length() == 0) {
            msgFormat = null;
        }
        this.msgFormat = msgFormat;
    }

    public String getMsgVariant() {
        return this.msgVariant;
    }

    public void setMsgVariant(String msgVariant) {
        if (msgVariant != null && msgVariant.length() == 0) {
            msgVariant = null;
        }
        this.msgVariant = msgVariant;
    }

    public String getMsgVersion() {
        return this.msgVersion;
    }

    public void setMsgVersion(String msgVersion) {
        if (msgVersion != null && msgVersion.length() == 0) {
            msgVersion = null;
        }
        this.msgVersion = msgVersion;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (scope != null && scope.length() == 0) {
            scope = null;
        }
        this.scope = scope;
    }

    public void setService(RestrictedServiceType rst) {
        if (rst == null) {
            this.scope = null;
            this.msgVariant = null;
            this.msgVersion = null;
            this.msgFormat = null;
            this.msgName = null;
            this.serviceOption = null;
            this.serviceName = null;
            this.container = null;
        } else {
            this.serviceName = rst.getServiceName().getValue();
            MessageType mt = rst.getMsgName();
            this.msgName = mt.getValue();
            this.msgFormat = SimpleStringElement.getValue(mt.getFormat());
            this.msgVersion = SimpleStringElement.getValue(mt.getVersion());
            this.msgVariant = SimpleStringElement.getValue(mt.getVariant());
            this.setScope(SimpleStringElement.getValue(rst.getScope()));
            this.serviceOption = SimpleStringElement.getValue(rst.getServiceOption());
            this.container = rst.getContainer() != null ? rst.getContainer().getContainerType().getValue() : null;
        }
    }

    public RestrictedServiceType getService() {
        if (StringUtils.isEmpty(this.serviceName) || StringUtils.isEmpty(this.msgName)) {
            return null;
        }
        MessageType mt = new MessageType(this.msgName);
        RestrictedServiceType toReturn = new RestrictedServiceType(new ServiceNameStringType(this.serviceName), mt);
        if (!StringUtils.isEmpty(this.serviceOption)) {
            toReturn.setServiceOption(new ServiceOptionStringType(this.serviceOption));
        }
        if (!StringUtils.isEmpty(this.scope)) {
            toReturn.setScope(new ScopeStringType(this.scope));
        }
        if (!StringUtils.isEmpty(this.msgFormat)) {
            mt.setFormat(new MessageType.MessageType_L1(this.msgFormat));
        }
        if (!StringUtils.isEmpty(this.msgVersion)) {
            mt.setVersion(new NumStringType(this.msgVersion));
        }
        if (!StringUtils.isEmpty(this.msgVariant)) {
            mt.setVariant(new NumStringType(this.msgVariant));
        }
        if (!StringUtils.isEmpty(this.container)) {
            toReturn.setContainer(new ContainerFlagType(new ContainerStringType(this.container)));
        }
        return toReturn;
    }

    private static void append(StringBuilder sb, SimpleStringElement s, char delim) {
        if (s == null) {
            return;
        }
        sb.append(delim).append(s.getValue());
    }

    public static String toString(RestrictedServiceType rst) {
        if (rst == null) {
            return null;
        }
        StringBuilder toReturn = new StringBuilder(45);
        toReturn.append(rst.getServiceName().getValue());
        MessageType mt = rst.getMsgName();
        toReturn.append(mt.getValue());
        BTF.append(toReturn, mt.getVariant(), '(');
        BTF.append(toReturn, mt.getVersion(), ',');
        BTF.append(toReturn, mt.getFormat(), '*');
        BTF.append(toReturn, rst.getServiceOption(), '+');
        BTF.append(toReturn, rst.getScope(), '-');
        if (rst.getContainer() != null) {
            BTF.append(toReturn, rst.getContainer().getContainerType(), ')');
        }
        return toReturn.toString();
    }

    public static String toAlternateString(RestrictedServiceType rst, String btf1) {
        if (rst == null || rst.getScope() != null && !"GLB".equals(rst.getScope().getValue())) {
            return btf1;
        }
        StringBuilder toReturn = new StringBuilder(45);
        toReturn.append(rst.getServiceName().getValue());
        MessageType mt = rst.getMsgName();
        toReturn.append(mt.getValue());
        BTF.append(toReturn, mt.getVariant(), '(');
        BTF.append(toReturn, mt.getVersion(), ',');
        BTF.append(toReturn, mt.getFormat(), '*');
        BTF.append(toReturn, rst.getServiceOption(), '+');
        if (rst.getScope() == null) {
            BTF.append(toReturn, "GLB", '-');
        }
        if (rst.getContainer() != null) {
            BTF.append(toReturn, rst.getContainer().getContainerType(), ')');
        }
        return toReturn.toString();
    }

    public static RestrictedServiceType rstFromString(String s) {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        MiniTokenizer t = new MiniTokenizer(s);
        MessageType mt = new MessageType(t.nextString());
        RestrictedServiceType toReturn = new RestrictedServiceType(new ServiceNameStringType(s.substring(0, 3)), mt);
        if (t.delim == '(') {
            mt.setVariant(new NumStringType(t.nextString()));
        }
        if (t.delim == ',') {
            mt.setVersion(new NumStringType(t.nextString()));
        }
        if (t.delim == '*') {
            mt.setFormat(new MessageType.MessageType_L1(t.nextString()));
        }
        if (t.delim == '+') {
            toReturn.setServiceOption(new ServiceOptionStringType(t.nextString()));
        }
        if (t.delim == '-') {
            toReturn.setScope(new ScopeStringType(t.nextString()));
        }
        if (t.delim == ')') {
            toReturn.setContainer(new ContainerFlagType(new ContainerStringType(t.nextString())));
        }
        return toReturn;
    }

    public static BTF fromString(String s) {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        MiniTokenizer t = new MiniTokenizer(s);
        BTF toReturn = new BTF();
        toReturn.msgName = t.nextString();
        toReturn.serviceName = s.substring(0, 3);
        if (t.delim == '(') {
            toReturn.msgVariant = t.nextString();
        }
        if (t.delim == ',') {
            toReturn.msgVersion = t.nextString();
        }
        if (t.delim == '*') {
            toReturn.msgFormat = t.nextString();
        }
        if (t.delim == '+') {
            toReturn.serviceOption = t.nextString();
        }
        if (t.delim == '-') {
            toReturn.scope = t.nextString();
        }
        if (t.delim == ')') {
            toReturn.container = t.nextString();
        }
        return toReturn;
    }

    private static void append(StringBuilder sb, String s, char delim) {
        if (s == null) {
            return;
        }
        sb.append(delim).append(s);
    }

    public String toString() {
        if (this.serviceName == null || this.msgName == null) {
            return null;
        }
        StringBuilder toReturn = new StringBuilder(45);
        toReturn.append(this.serviceName);
        toReturn.append(this.msgName);
        BTF.append(toReturn, this.msgVariant, '(');
        BTF.append(toReturn, this.msgVersion, ',');
        BTF.append(toReturn, this.msgFormat, '*');
        BTF.append(toReturn, this.serviceOption, '+');
        BTF.append(toReturn, this.scope, '-');
        BTF.append(toReturn, this.container, ')');
        return toReturn.toString();
    }

    public String toAlternateString(String btf1) {
        if (this.serviceName == null || this.msgName == null || this.scope != null && !"GLB".equals(this.scope)) {
            return btf1;
        }
        StringBuilder toReturn = new StringBuilder(45);
        toReturn.append(this.serviceName);
        toReturn.append(this.msgName);
        BTF.append(toReturn, this.msgVariant, '(');
        BTF.append(toReturn, this.msgVersion, ',');
        BTF.append(toReturn, this.msgFormat, '*');
        BTF.append(toReturn, this.serviceOption, '+');
        if (this.scope == null) {
            BTF.append(toReturn, "GLB", '-');
        }
        BTF.append(toReturn, this.container, ')');
        return toReturn.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
        result = 31 * result + (this.msgFormat == null ? 0 : this.msgFormat.hashCode());
        result = 31 * result + (this.msgName == null ? 0 : this.msgName.hashCode());
        result = 31 * result + (this.msgVariant == null ? 0 : this.msgVariant.hashCode());
        result = 31 * result + (this.msgVersion == null ? 0 : this.msgVersion.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = 31 * result + (this.serviceOption == null ? 0 : this.serviceOption.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BTF other = (BTF)obj;
        if (this.container == null ? other.container != null : !this.container.equals(other.container)) {
            return false;
        }
        if (this.msgFormat == null ? other.msgFormat != null : !this.msgFormat.equals(other.msgFormat)) {
            return false;
        }
        if (this.msgName == null ? other.msgName != null : !this.msgName.equals(other.msgName)) {
            return false;
        }
        if (this.msgVariant == null ? other.msgVariant != null : !this.msgVariant.equals(other.msgVariant)) {
            return false;
        }
        if (this.msgVersion == null ? other.msgVersion != null : !this.msgVersion.equals(other.msgVersion)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
            return false;
        }
        return !(this.serviceOption == null ? other.serviceOption != null : !this.serviceOption.equals(other.serviceOption));
    }

    private static class MiniTokenizer {
        private final String s;
        private char delim;
        private int pos;

        private MiniTokenizer(String s) {
            this.s = s;
            this.pos = 3;
        }

        public String nextString() {
            for (int i = this.pos + 1; i < this.s.length(); ++i) {
                char c = this.s.charAt(i);
                if (c < '(' || c > '-') continue;
                this.delim = c;
                String toReturn = this.s.substring(this.pos, i);
                this.pos = i + 1;
                return toReturn;
            }
            this.delim = (char)32;
            return this.s.substring(this.pos);
        }
    }
}

