/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.ebics.schema.types.SegmentNumber;
import de.businesslogics.ebics.schema.types.TransactionID;
import de.businesslogics.util.HexTool;
import java.io.Serializable;

public class TransferState
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected TransactionID transactionID;
    protected boolean ioExceptionOnAcknowledge = false;
    protected int numSegments;
    protected int segmentNumber;

    protected TransferState(TransactionID transactionID, int numSegments) {
        this.transactionID = transactionID;
        this.numSegments = numSegments;
        this.segmentNumber = 1;
    }

    public String getTransactionID() {
        if (this.transactionID != null && this.transactionID.getValue() != null) {
            return HexTool.toHex(this.transactionID.getValue());
        }
        return null;
    }

    public int getTotalNumberOfSegments() {
        return this.numSegments;
    }

    public int getCurrentSegmentNumber() {
        return this.segmentNumber;
    }

    public SegmentNumber getSegmentNumber() {
        return new SegmentNumber(this.segmentNumber, this.segmentNumber == this.numSegments);
    }
}

