/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.ebics.client.BTFTranslatorBase;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.request.OrderType;
import java.util.Collection;
import java.util.Collections;

public class SwissBTFTranslator
extends BTFTranslatorBase {
    public static final Collection<OrderType> STANDARD_FETCH_ORDER_TYPES;
    public static final Collection<OrderType> STANDARD_SEND_ORDER_TYPES;
    private static final SwissBTFTranslator t;

    public SwissBTFTranslator() {
        this.add("STM", "DE", null, "camt.052", "ZIP", D, "C52");
        this.add("EOP", "DE", null, "camt.053", "ZIP", D, "C53");
        this.add("STM", "DE", null, "camt.054", "ZIP", D, "C54");
        this.add("PSR", "GLB", "SDD", "pain.002", "ZIP", D, "CDZ");
        this.add("EOP", "DE", null, "mt940", null, D, "STA");
        this.add("STM", "DE", null, "mt942", null, D, "VMK");
        this.add("PSR", "CGI", "XCH", "pain.002", "ZIP", D, "XG2");
        this.add("PSR", "CH", null, "pain.002", "ZIP", D, "Z01");
        this.add("PSR", "BIL", "CH003Z02", "pain.002", "ZIP", D, "Z02");
        this.add("PSR", "BIL", "CH003Z03", "pain.002", "ZIP", D, "Z03");
        this.add("PSR", "BIL", "CH003Z04", "pain.002", null, D, "Z04");
        this.add("STM", "CH", null, "camt.052", "ZIP", D, "Z52");
        this.add("EOP", "CH", null, "camt.053", "ZIP", D, "Z53");
        this.add("REP", "CH", null, "camt.054", "ZIP", D, "Z54");
        this.add("PSR", "GLB", null, "mt195", null, D, "Z95");
        this.add("PSR", "GLB", null, "mt196", null, D, "Z96");
        this.add("FCX", "GLB", null, "mt300", null, D, "ZAA");
        this.add("FCX", "GLB", null, "mt305", null, D, "ZAB");
        this.add("FCX", "GLB", null, "mt330", null, D, "ZAD");
        this.add("FCX", "GLB", null, "mt350", null, D, "ZAE");
        this.add("STR", "GLB", null, "mt515", null, D, "ZAG");
        this.add("SSM", "GLB", null, "mt535", "ZIP", D, "ZAH");
        this.add("SES", "GLB", null, "mt544", null, D, "ZAI");
        this.add("SES", "GLB", null, "mt545", null, D, "ZAJ");
        this.add("SES", "GLB", null, "mt546", null, D, "ZAK");
        this.add("SES", "GLB", null, "mt547", null, D, "ZAL");
        this.add("SES", "GLB", null, "mt548", null, D, "ZAM");
        this.add("SEV", "GLB", null, "mt566", null, D, "ZAN");
        this.add("FCX", "GLB", "SDD", "mt320", null, D, "ZAU");
        this.add("SSM", "GLB", null, "mt536", "ZIP", D, "ZAV");
        this.add("SES", "GLB", null, "mt599", null, D, "ZAW");
        this.add("PMC", "GLB", "XCH", "mt600", null, D, "ZAX");
        this.add("EOP", "GLB", null, "mt950", "ZIP", D, "ZAY");
        this.add("INV", "BIL", "CH003ZD2", "inv.rep", null, D, "ZD2");
        this.add("INV", "BIL", "CH003ZD3", "reg.status", null, D, "ZD3");
        this.add("INV", "BIL", "CH003ZD4", "inv.status", null, D, "ZD4");
        this.add("INV", "BIL", "CH003ZD5", "lookup.rep", null, D, "ZD5");
        this.add("DAR", "CH", null, "documents", "ZIP", D, "ZDF");
        this.add("EOP", "CH", "XISR", "camt.054", "ZIP", D, "ZE1");
        this.add("STM", "CH", "XISR", "camt.054", "ZIP", D, "ZE2");
        this.add("INV", "CH", null, "ebill.rcvd", null, D, "ZEB");
        this.add("STM", "GLB", null, "mt900", null, D, "ZK1");
        this.add("STM", "GLB", null, "mt910", null, D, "ZK2");
        this.add("EOP", "CH", null, "mt940", null, D, "ZK3");
        this.add("STR", "GLB", null, "mt506", null, D, "ZM1");
        this.add("STR", "GLB", null, "mt509", null, D, "ZM2");
        this.add("STR", "GLB", null, "mt513", null, D, "ZM3");
        this.add("SES", "GLB", null, "mt516", null, D, "ZM4");
        this.add("SSM", "GLB", null, "mt537", "ZIP", D, "ZM5");
        this.add("SEV", "GLB", null, "mt564", null, D, "ZM6");
        this.add("SEV", "GLB", null, "mt568", null, D, "ZM7");
        this.add("SES", "GLB", null, "mt590", "ZIP", D, "ZM8");
        this.add("PMC", "GLB", null, "mt601", null, D, "ZM9");
        this.add("PMC", "GLB", null, "mt608", null, D, "ZMA");
        this.add("REP", "GLB", null, "mt941", "ZIP", D, "ZMB");
        this.add("REP", "GLB", null, "mt990", null, D, "ZMC");
        this.add("STM", "CH", "XQRR", "camt.054", "ZIP", D, "ZQ2");
        this.add("EOP", "CH", "XQRR", "camt.054", "ZIP", D, "ZQR");
        this.add("STM", "CH", "XSCR", "camt.054", "ZIP", D, "ZR2");
        this.add("EOP", "CH", "XSCR", "camt.054", "ZIP", D, "ZRF");
        this.add("REP", "CH", "XDCI", "camt.054", "ZIP", D, "ZS2");
        this.add("EOP", "CH", "XDDD", "camt.054", "ZIP", D, "ZS3");
        this.add("EOP", "CH", null, "camt.054", "ZIP", D, "ZS4");
        this.add("STM", "CH", "XDDD", "camt.054", "ZIP", D, "ZS6");
        this.add("STM", "CH", null, "camt.054", "ZIP", D, "ZS7");
        this.add("INV", "BIL", "CH001ZYB", "yllwb.rcvd", null, D, "ZYB");
        this.add("EOP", "BIL", "CH001IMG", "camt.053", "ZIP", D, "ZZ3");
        this.add("REP", "BIL", "CH001IMG", "camt.054", "ZIP", D, "ZZ4");
        this.add("EOP", "BIL", "CH001IMG", "mt940", "ZIP", D, "ZZ9");
        this.add("SDD", "GLB", "COR", "pain.008", null, U, "CDD");
        this.add("RFT", "GLB", null, "mt101", null, U, "RFT");
        this.add("SDD", "GLB", "B2B", "pain.008", null, U, "SDD");
        this.add("XCT", null, null, "pain.001", null, U, "XCT");
        this.add("INV", "BIL", "CH003XD2", "mt506", "ZIP", U, "XD2");
        this.add("INV", "BIL", "CH003XD5", "mt506", null, U, "XD5");
        this.add("MCT", "CH", null, "pain.001", null, U, "XE2");
        this.add("SDD", "CH", null, "pain.008", null, U, "XE3");
        this.add("SDD", "CH", "XB2B", "pain.008", null, U, "XE4");
        this.add("SCT", "GLB", null, "pain.001", null, U, "XET");
        this.add("MCT", "CGI", "XCH", "pain.001", null, U, "XG1");
        this.add("DDD", "CH", null, "ta875", null, U, "XL1");
        this.add("DDD", "CH", "XB2B", "ta875", null, U, "XL2");
        this.add("DDD", "CH", null, "pain.008", null, U, "XL3");
        this.add("DDD", "CH", "XB2B", "pain.008", null, U, "XL4");
        this.add("DDD", "BIL", "CH001COR", "pain.008", null, U, "XL5");
        this.add("DDD", "BIL", "CH001B2B", "pain.008", null, U, "XL6");
        this.add("MCT", "BIL", "CH000ZA1", "pain.001", null, U, "YE1");
        this.add("MCT", "BIL", "CH000ZA4", "pain.001", null, U, "YE4");
        this.add("MCT", "BIL", "CH000ZA5", "pain.001", null, U, "YE5");
        this.add("MCT", "BIL", "CH000ZA6", "pain.001", null, U, "YE6");
        this.add("RFT", "GLB", null, "mt192", null, U, "Z92");
        this.add("REP", "CH", "XCT", "pain.002", "ZIP", D, "AXS");
        this.add("REP", "CH", "VOP", "pain.002", "ZIP", D, "VPZ");
    }

    @Override
    public String getBTFFromSendOrderType2(String orderType) {
        RestrictedServiceType rst = t.convertSend(new OrderType(orderType));
        if (rst != null) {
            return SwissBTFTranslator.convertToString(rst);
        }
        return null;
    }

    public static String getSendOrderTypeFromBTF(String s) throws IllegalArgumentException {
        OrderType ot;
        RestrictedServiceType rst = SwissBTFTranslator.convertFromStringToBTF(s).getService();
        if (rst != null && (ot = t.convertSend(rst)) != null) {
            return ot.getValue();
        }
        return null;
    }

    public static String getFetchOrderTypeFromBTF(String s) throws IllegalArgumentException {
        OrderType ot;
        RestrictedServiceType rst = SwissBTFTranslator.convertFromStringToBTF(s).getService();
        if (rst != null && (ot = t.convertFetch(rst)) != null) {
            return ot.getValue();
        }
        return null;
    }

    public static String getBTFFromSendOrderType(OrderType ot) {
        RestrictedServiceType rst = t.convertSend(ot);
        if (rst != null) {
            return SwissBTFTranslator.convertToString(rst);
        }
        return null;
    }

    public static String getBTFFromSendOrderType(String orderType) {
        RestrictedServiceType rst = t.convertSend(new OrderType(orderType));
        if (rst != null) {
            return SwissBTFTranslator.convertToString(rst);
        }
        return null;
    }

    public static String getBTFFromFetchOrderType(OrderType ot) {
        RestrictedServiceType rst = t.convertFetch(ot);
        if (rst != null) {
            return SwissBTFTranslator.convertToString(rst);
        }
        return null;
    }

    public static String getBTFFromFetchOrderType(String orderType) {
        RestrictedServiceType rst = t.convertFetch(new OrderType(orderType));
        if (rst != null) {
            return SwissBTFTranslator.convertToString(rst);
        }
        return null;
    }

    static {
        t = new SwissBTFTranslator();
        STANDARD_FETCH_ORDER_TYPES = Collections.unmodifiableCollection(SwissBTFTranslator.t.fetchOt2Btf.keySet());
        STANDARD_SEND_ORDER_TYPES = Collections.unmodifiableCollection(SwissBTFTranslator.t.sendOt2Btf.keySet());
    }
}

