/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.ebics.client.EbicsBusinessUser;
import de.businesslogics.ebics.client.EbicsLog;
import de.businesslogics.ebics.client.TransferState;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.ebics.security.EncryptionHandler;
import de.businesslogics.ebics.security.SignatureHandler;
import de.businesslogics.io.BufferFiller;
import de.businesslogics.io.ContentFactory;
import de.businesslogics.io.NullOutputStream;
import de.businesslogics.io.Streams;
import de.businesslogics.io.YOutputStream;
import de.businesslogics.util.SystemUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SendTransferState
extends TransferState {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(SendTransferState.class.getName());
    public static final int BLOCK_SIZE = 786432;
    private transient InputStream src;
    private transient OutputStream out;
    private transient BufferFiller bf;
    private transient boolean alreadyCompressed = false;
    private OrderID orderID;
    final long totalLength;
    final ContentFactory factory;
    final SecretKey key;
    final byte[] digest;
    final byte[] digest5;

    SendTransferState(EncryptionHandler handler, ContentFactory factory, OrderID orderID, OutputStream pipe, EbicsBusinessUser[] signers) throws IOException {
        super(null, 1);
        this.orderID = orderID;
        this.key = SendTransferState.strip(handler.createSecretKey());
        NullOutputStream nos = new NullOutputStream();
        OutputStream os = this.wrap(handler, nos);
        os = EbicsLog.wrapDataOutput(os);
        if (pipe != null) {
            os = new YOutputStream(os, pipe);
        }
        byte[] ripeMd = null;
        byte[] sha256 = null;
        for (EbicsBusinessUser signer : signers) {
            if (signer.getSignatureVersion().equals(SignatureVersion.A004)) {
                if (ripeMd != null) continue;
                ripeMd = new byte[20];
                continue;
            }
            if (sha256 != null) continue;
            sha256 = new byte[32];
        }
        this.digest = ripeMd;
        this.digest5 = sha256;
        SendTransferState.getMessageDigest(factory.getContent(), os, ripeMd, sha256);
        this.totalLength = nos.getWritten();
        this.numSegments = (int)((nos.getWritten() - 1L) / 786432L) + 1;
        nos.close();
        this.factory = factory;
        this.src = factory.getContent();
        this.open(handler);
    }

    @Deprecated
    public SendTransferState(EncryptionHandler handler, InputStream in, long totalLength, OrderID orderID, byte[] digest, byte[] digest5) throws IOException {
        super(null, 1);
        this.digest = digest;
        this.digest5 = digest5;
        this.totalLength = handler.computeEncryptedSize(totalLength);
        this.orderID = orderID;
        this.key = SendTransferState.strip(handler.createSecretKey());
        this.numSegments = (int)((this.totalLength - 1L) / 786432L) + 1;
        this.factory = null;
        this.src = in;
        this.alreadyCompressed = true;
        this.open(handler);
    }

    private static SecretKeySpec strip(SecretKey key) {
        if (key.getClass().equals(SecretKeySpec.class)) {
            return (SecretKeySpec)key;
        }
        return new SecretKeySpec(key.getEncoded(), key.getAlgorithm());
    }

    private static void getMessageDigest(InputStream src, OutputStream os, byte[] ripeMd, byte[] sha256) throws IOException {
        try {
            if (os == null) {
                os = new NullOutputStream();
            }
            MessageDigest digest4 = null;
            MessageDigest digest5 = null;
            if (ripeMd != null) {
                digest4 = SignatureHandler.A004.getMessageDigest();
                os = new DigestOutputStream(os, digest4);
            }
            if (sha256 != null) {
                digest5 = SignatureHandler.A005.getMessageDigest();
                os = new DigestOutputStream(os, digest5);
            }
            Streams.copy(src, os);
            if (ripeMd != null) {
                digest4.digest(ripeMd, 0, 20);
            }
            if (sha256 != null) {
                digest5.digest(sha256, 0, 32);
            }
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    void fillBuffer(EncryptionHandler handler, byte[] buffer) throws IOException {
        if (this.bf != null) {
            this.bf.setBuffer(buffer);
            if (this.bf.isBufferFull()) {
                return;
            }
        }
        if (this.out == null) {
            this.open(handler);
            this.bf.setBuffer(buffer);
        }
        byte[] myBuffer = new byte[1024];
        while (!this.bf.isBufferFull()) {
            int i = this.src.read(myBuffer);
            if (i < 0) {
                this.close();
                break;
            }
            this.out.write(myBuffer, 0, i);
        }
        LOGGER.fine(this.bf.written() + "/" + buffer.length + " bytes are written.");
        if (!this.bf.isBufferFull()) {
            throw new EOFException();
        }
    }

    void close() {
        if (this.src != null) {
            SystemUtils.close(this.src);
            this.src = null;
        }
        if (this.out != null) {
            SystemUtils.close(this.out);
            this.out = null;
        }
    }

    private OutputStream wrap(EncryptionHandler handler, OutputStream os) throws IOException {
        os = handler.encryptContent(this.key, os);
        if (!this.alreadyCompressed) {
            return new DeflaterOutputStream(os);
        }
        return os;
    }

    private void open(EncryptionHandler handler) throws IOException {
        if (this.src == null) {
            if (this.factory == null) {
                throw new NullPointerException("Recovery not possible: Content factory missing!");
            }
            this.src = this.factory.getContent();
        }
        this.bf = new BufferFiller();
        this.out = this.wrap(handler, this.bf);
        if (this.segmentNumber > 1) {
            byte[] buffer = new byte[786432];
            int i = this.segmentNumber;
            while (i-- > 1) {
                this.fillBuffer(handler, buffer);
            }
        }
    }

    public OrderID getOrderID() {
        return this.orderID;
    }

    void setOrderID(OrderID orderID) {
        this.orderID = orderID;
    }
}

