/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.ebics.client.EbicsBusinessUser;
import de.businesslogics.ebics.client.EbicsPartner;
import de.businesslogics.ebics.client.EbicsSession;
import de.businesslogics.ebics.client.FileTransfer;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.h003.HCSRequestOrderData;
import de.businesslogics.ebics.schema.h004.AuthenticationCertificateInfoType;
import de.businesslogics.ebics.schema.h004.EncryptionCertificateInfoType;
import de.businesslogics.ebics.schema.h004.H3KRequestOrderData;
import de.businesslogics.ebics.schema.h004.SignatureCertificateInfoType;
import de.businesslogics.ebics.schema.keymgmtrequest.EbicsUnsecuredRequest;
import de.businesslogics.ebics.schema.keymgmtrequest.EbicsUnsignedRequest;
import de.businesslogics.ebics.schema.keymgmtrequest.UnsecuredRequestBody;
import de.businesslogics.ebics.schema.keymgmtrequest.UnsecuredRequestDataTransfer;
import de.businesslogics.ebics.schema.keymgmtrequest.UnsecuredRequestHeader;
import de.businesslogics.ebics.schema.keymgmtrequest.UnsecuredRequestOrderDetails;
import de.businesslogics.ebics.schema.keymgmtrequest.UnsecuredRequestStaticHeader;
import de.businesslogics.ebics.schema.keymgmtrequest.UnsignedRequestBody;
import de.businesslogics.ebics.schema.keymgmtrequest.UnsignedRequestDataTransfer;
import de.businesslogics.ebics.schema.keymgmtrequest.UnsignedRequestHeader;
import de.businesslogics.ebics.schema.keymgmtrequest.UnsignedRequestStaticHeader;
import de.businesslogics.ebics.schema.keymgmtresponse.EbicsKeyManagementResponse;
import de.businesslogics.ebics.schema.orders.HCARequestOrderData;
import de.businesslogics.ebics.schema.orders.HIARequestOrderData;
import de.businesslogics.ebics.schema.orders.HSARequestOrderData;
import de.businesslogics.ebics.schema.orders.StandardOrderParams;
import de.businesslogics.ebics.schema.orders.UserSignatureData;
import de.businesslogics.ebics.schema.request.Body;
import de.businesslogics.ebics.schema.request.DataTransfer;
import de.businesslogics.ebics.schema.request.EbicsRequest;
import de.businesslogics.ebics.schema.request.Header;
import de.businesslogics.ebics.schema.request.Mutable;
import de.businesslogics.ebics.schema.request.OrderAttribute;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.request.Static;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.s001.SignaturePubKeyInfoType;
import de.businesslogics.ebics.schema.s001.SignaturePubKeyOrderData;
import de.businesslogics.ebics.schema.signature.RSAKeyValue;
import de.businesslogics.ebics.schema.signature.X509Data;
import de.businesslogics.ebics.schema.types.AuthenticationPubKeyInfo;
import de.businesslogics.ebics.schema.types.AuthenticationVersion;
import de.businesslogics.ebics.schema.types.DataDigest;
import de.businesslogics.ebics.schema.types.EncryptionPubKeyInfo;
import de.businesslogics.ebics.schema.types.EncryptionVersion;
import de.businesslogics.ebics.schema.types.HostID;
import de.businesslogics.ebics.schema.types.NumSegments;
import de.businesslogics.ebics.schema.types.PartnerID;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.PubKeyInfo;
import de.businesslogics.ebics.schema.types.PubKeyValue;
import de.businesslogics.ebics.schema.types.SecurityMedium;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.ebics.schema.types.TransactionPhase;
import de.businesslogics.ebics.schema.types.UserID;
import de.businesslogics.ebics.security.AuthenticationHandler;
import de.businesslogics.ebics.security.EncryptionHandler;
import de.businesslogics.ebics.security.SignatureHandler;
import de.businesslogics.zkasecurity.A004PublicKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.List;

public class KeyManagement {
    private final EbicsSession session;
    private static final byte[] SPR_BYTES = new byte[]{32};

    public KeyManagement(EbicsSession session) {
        this.session = session;
    }

    public OrderID lockAccess() throws IOException, EbicsException {
        return this.lockAccess(null);
    }

    public OrderID lockAccess(OrderID proposed) throws IOException, EbicsException {
        ProtocolVersion pv = this.session.getProtocolVersion();
        Static sh = this.session.createStaticHeader(OrderType.SPR, this.session.nextOrderID(OrderType.SPR, proposed), pv.compareTo(ProtocolVersion.H005) < 0 ? OrderAttribute.UZHNN : null, new SecurityMedium(this.session.businessUser.getSecurityMedium()), new StandardOrderParams(null));
        byte[] digest = SignatureHandler.getInstance(this.session.businessUser.getSignatureVersion()).getMessageDigest().digest(SPR_BYTES);
        Header header = new Header(sh, new Mutable(TransactionPhase.INITIALIZATION, null));
        Date now = new Date();
        UserSignatureData usd = new UserSignatureData(this.session.getProtocolVersion());
        this.session.addSignatureData(usd, this.session.businessUser, digest, "memory", now, "SPR");
        DataTransfer dataTransfer = new DataTransfer();
        if (this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) >= 0) {
            dataTransfer.setDataDigest(new DataDigest(digest, this.session.businessUser.getSignatureVersion()));
        }
        dataTransfer.setSignatureData(usd);
        sh.getInitialisation().setNumSegments(new NumSegments(0));
        dataTransfer.encrypt(this.session.getEncryptionHandler(), this.session.getBankEncrKey(), this.session.bankEncrDigest, null);
        Body body = new Body(new Body.InitialisationBody(null, dataTransfer));
        EbicsRequest ebics = new EbicsRequest(pv, header, body);
        this.session.sendSigned(ebics);
        return this.session.lastOrderID;
    }

    @Deprecated
    public OrderID sendHCA(RSAPublicKey newAuthKey, RSAPublicKey newEncrKey) throws IOException, EbicsException {
        return this.sendHCA(newAuthKey, null, newEncrKey, null);
    }

    public OrderID sendHCA(RSAPublicKey newAuthKey, List<X509Certificate> authCerts, RSAPublicKey newEncrKey, List<X509Certificate> encrCerts) throws IOException, EbicsException {
        FileTransfer transfer = new FileTransfer(this.session);
        return transfer.sendFile(this.buildHCARequest(newAuthKey, authCerts, newEncrKey, encrCerts), OrderType.HCA, null, false);
    }

    public byte[] buildHCARequest(RSAPublicKey newAuthKey, List<X509Certificate> authCerts, RSAPublicKey newEncrKey, List<X509Certificate> encrCerts) {
        return KeyManagement.buildHCA(this.session.getProtocolVersion(), this.session.getPartnerID(), this.session.getBusinessUserID(), newAuthKey, authCerts, newEncrKey, encrCerts);
    }

    public static byte[] buildHCA(ProtocolVersion protocolVersion, PartnerID partnerId, UserID userid, RSAPublicKey newAuthKey, List<X509Certificate> authCerts, RSAPublicKey newEncrKey, List<X509Certificate> encrCerts) {
        EncryptionVersion ev = EncryptionHandler.getInstance(protocolVersion).getVersion();
        AuthenticationVersion av = AuthenticationHandler.getInstance(protocolVersion).getVersion();
        short pv = protocolVersion.getVersion();
        AuthenticationPubKeyInfo authenticationPubKeyInfo = new AuthenticationPubKeyInfo(av);
        KeyManagement.fill(authenticationPubKeyInfo, pv, newAuthKey, authCerts);
        EncryptionPubKeyInfo encryptionPubKeyInfo = new EncryptionPubKeyInfo(ev);
        KeyManagement.fill(encryptionPubKeyInfo, pv, newEncrKey, encrCerts);
        HCARequestOrderData hca = new HCARequestOrderData(protocolVersion, authenticationPubKeyInfo, encryptionPubKeyInfo, partnerId, userid);
        return EbicsPrintStream.toByteArray(hca);
    }

    public OrderID sendHCS(SignatureVersion sigVersion, RSAPublicKey newSigKey, List<X509Certificate> sigCerts, RSAPublicKey newAuthKey, List<X509Certificate> authCerts, RSAPublicKey newEncrKey, List<X509Certificate> encrCerts) throws IOException, EbicsException {
        FileTransfer transfer = new FileTransfer(this.session);
        return transfer.sendFile(this.buildHCSRequest(sigVersion, newSigKey, sigCerts, newAuthKey, authCerts, newEncrKey, encrCerts), OrderType.HCS, null, false);
    }

    public OrderID sendH3K(SignatureVersion sigVersion, List<X509Certificate> sigCerts, List<X509Certificate> authCerts, List<X509Certificate> encrCerts) throws IOException, EbicsException {
        byte[] h3kBytes = this.buildH3K(sigVersion, sigCerts, authCerts, encrCerts);
        EbicsBusinessUser businessUser = this.session.businessUser;
        EbicsPartner partner = this.session.systemUser.getPartner();
        ProtocolVersion pv = this.session.getProtocolVersion();
        UnsecuredRequestOrderDetails orderDetails = new UnsecuredRequestOrderDetails(OrderType.H3K, null, pv.compareTo(ProtocolVersion.H005) < 0 ? OrderAttribute.OZNNN : null);
        UnsignedRequestStaticHeader staticHeader = new UnsignedRequestStaticHeader(new HostID(partner.getBank().getHostId()), new PartnerID(partner.getPartnerID()), new UserID(businessUser.getUserID()), orderDetails, new SecurityMedium(businessUser.getSecurityMedium()));
        staticHeader.setProduct(this.session.product);
        UnsignedRequestHeader header = new UnsignedRequestHeader(staticHeader);
        ByteArrayInputStream bis = new ByteArrayInputStream(h3kBytes);
        SignatureHandler sh = SignatureHandler.getInstance(businessUser.getSignatureVersion());
        UserSignatureData usd = new UserSignatureData(pv);
        this.session.addSignatureData(usd, this.session.businessUser, sh.getDigest(bis), "memory", new Date(), "H3K");
        UnsignedRequestDataTransfer dataTransfer = new UnsignedRequestDataTransfer(usd, h3kBytes);
        UnsignedRequestBody body = new UnsignedRequestBody(dataTransfer);
        EbicsUnsignedRequest ebics = new EbicsUnsignedRequest(pv, header, body);
        EbicsKeyManagementResponse rebics = (EbicsKeyManagementResponse)this.session.sendRequest(ebics, EbicsKeyManagementResponse.createParser(ebics.getVersion()));
        if (this.session.lastOrderID == null) {
            this.session.lastOrderID = rebics.getHeader().getMutable().getOrderID();
        }
        rebics.checkOK();
        return this.session.lastOrderID;
    }

    public byte[] buildH3K(SignatureVersion sigVersion, List<X509Certificate> sigCerts, List<X509Certificate> authCerts, List<X509Certificate> encrCerts) {
        return KeyManagement.buildH3K(this.session.getProtocolVersion(), this.session.getPartnerID(), this.session.getBusinessUserID(), sigVersion, sigCerts, authCerts, encrCerts);
    }

    public static byte[] buildH3K(ProtocolVersion protVersion, PartnerID partnerId, UserID userId, SignatureVersion sigVersion, List<X509Certificate> sigCerts, List<X509Certificate> authCerts, List<X509Certificate> encrCerts) {
        SignatureCertificateInfoType sci = new SignatureCertificateInfoType(new X509Data(sigCerts), sigVersion);
        AuthenticationCertificateInfoType aci = new AuthenticationCertificateInfoType(new X509Data(authCerts), AuthenticationHandler.getInstance(protVersion).getVersion());
        EncryptionCertificateInfoType eci = new EncryptionCertificateInfoType(new X509Data(encrCerts), EncryptionHandler.getInstance(protVersion).getVersion());
        H3KRequestOrderData h3k = new H3KRequestOrderData(protVersion, sci, aci, eci, partnerId, userId);
        return EbicsPrintStream.toByteArray(h3k);
    }

    public byte[] buildHCSRequest(SignatureVersion sigVersion, RSAPublicKey newSigKey, List<X509Certificate> sigCerts, RSAPublicKey newAuthKey, List<X509Certificate> authCerts, RSAPublicKey newEncrKey, List<X509Certificate> encrCerts) {
        return KeyManagement.buildHCS(this.session.getProtocolVersion(), this.session.getPartnerID(), this.session.getBusinessUserID(), sigVersion, newSigKey, sigCerts, newAuthKey, authCerts, newEncrKey, encrCerts);
    }

    public static byte[] buildHCS(ProtocolVersion protocolVersion, PartnerID partnerId, UserID userId, SignatureVersion sigVersion, RSAPublicKey newSigKey, List<X509Certificate> sigCerts, RSAPublicKey newAuthKey, List<X509Certificate> authCerts, RSAPublicKey newEncrKey, List<X509Certificate> encrCerts) {
        short pv = protocolVersion.getVersion();
        if (pv < 3) {
            if (EbicsSession.SANITY_CHECK) {
                throw new IllegalArgumentException("HCS is not supported in " + String.valueOf(protocolVersion));
            }
            protocolVersion = ProtocolVersion.H003;
            pv = 3;
        }
        EncryptionVersion ev = EncryptionHandler.getInstance(protocolVersion).getVersion();
        AuthenticationVersion av = AuthenticationHandler.getInstance(protocolVersion).getVersion();
        SignaturePubKeyInfoType signaturePubKeyInfo = new SignaturePubKeyInfoType(sigVersion);
        KeyManagement.fill(signaturePubKeyInfo, pv, newSigKey, sigCerts);
        AuthenticationPubKeyInfo authenticationPubKeyInfo = new AuthenticationPubKeyInfo(av);
        KeyManagement.fill(authenticationPubKeyInfo, pv, newAuthKey, authCerts);
        EncryptionPubKeyInfo encryptionPubKeyInfo = new EncryptionPubKeyInfo(ev);
        KeyManagement.fill(encryptionPubKeyInfo, pv, newEncrKey, encrCerts);
        HCSRequestOrderData hcs = new HCSRequestOrderData(protocolVersion, authenticationPubKeyInfo, encryptionPubKeyInfo, signaturePubKeyInfo, partnerId, userId);
        return EbicsPrintStream.toByteArray(hcs);
    }

    public OrderID sendHIA(RSAPublicKey encrKey, List<X509Certificate> encrCerts, RSAPublicKey authKey, List<X509Certificate> authCerts) throws IOException, EbicsException {
        ProtocolVersion protocolVersion = this.session.getProtocolVersion();
        short pv = protocolVersion.getVersion();
        EbicsBusinessUser businessUser = this.session.businessUser;
        EbicsPartner partner = this.session.systemUser.getPartner();
        EncryptionVersion ev = this.session.getEncryptionHandler().getVersion();
        AuthenticationVersion av = this.session.getAuthenticationHandler().getVersion();
        UnsecuredRequestOrderDetails orderDetails = new UnsecuredRequestOrderDetails(OrderType.HIA, this.session.nextOrderID(OrderType.HIA, null), protocolVersion.compareTo(ProtocolVersion.H005) < 0 ? OrderAttribute.DZNNN : null);
        UnsecuredRequestStaticHeader staticHeader = new UnsecuredRequestStaticHeader(new HostID(partner.getBank().getHostId()), new PartnerID(partner.getPartnerID()), new UserID(businessUser.getUserID()), orderDetails, new SecurityMedium("0000"));
        staticHeader.setProduct(this.session.product);
        if (businessUser != this.session.systemUser) {
            staticHeader.setSystemID(new UserID(this.session.systemUser.getUserID()));
        }
        UnsecuredRequestHeader header = new UnsecuredRequestHeader(staticHeader);
        AuthenticationPubKeyInfo authenticationPubKeyInfo = new AuthenticationPubKeyInfo(av);
        KeyManagement.fill(authenticationPubKeyInfo, pv, authKey, authCerts);
        EncryptionPubKeyInfo encryptionPubKeyInfo = new EncryptionPubKeyInfo(ev);
        KeyManagement.fill(encryptionPubKeyInfo, pv, encrKey, encrCerts);
        HIARequestOrderData hia = new HIARequestOrderData(protocolVersion, authenticationPubKeyInfo, encryptionPubKeyInfo, this.session.getPartnerID(), this.session.getBusinessUserID());
        UnsecuredRequestDataTransfer dataTransfer = new UnsecuredRequestDataTransfer(hia);
        UnsecuredRequestBody body = new UnsecuredRequestBody(dataTransfer);
        EbicsUnsecuredRequest ebics = new EbicsUnsecuredRequest(protocolVersion, header, body);
        EbicsKeyManagementResponse rebics = (EbicsKeyManagementResponse)this.session.sendRequest(ebics, EbicsKeyManagementResponse.createParser(ebics.getVersion()));
        if (this.session.lastOrderID == null) {
            this.session.lastOrderID = rebics.getHeader().getMutable().getOrderID();
        }
        rebics.checkOK();
        return this.session.lastOrderID;
    }

    private static void fill(PubKeyInfo pubKeyInfo, short pv, RSAPublicKey rsaKey, List<X509Certificate> certs) {
        if (pv <= 4) {
            if (EbicsSession.SANITY_CHECK && rsaKey == null) {
                throw new NullPointerException("RSA key missing");
            }
            PubKeyValue pubKeyValue = new PubKeyValue(new RSAKeyValue(rsaKey));
            pubKeyInfo.setPubKeyValue(pubKeyValue);
        }
        if (pv > 2) {
            if (certs != null && !certs.isEmpty()) {
                pubKeyInfo.setX509Data(new X509Data(certs));
            } else if (EbicsSession.SANITY_CHECK && pv >= 5) {
                throw new IllegalArgumentException("Certificates required in H00" + pv);
            }
        }
    }

    public OrderID sendHSA(RSAPublicKey encrKey, RSAPublicKey authKey) throws IOException, EbicsException {
        ProtocolVersion protocolVersion = this.session.getProtocolVersion();
        short pv = protocolVersion.getVersion();
        EbicsBusinessUser businessUser = this.session.businessUser;
        EbicsPartner partner = this.session.systemUser.getPartner();
        EncryptionVersion ev = this.session.getEncryptionHandler().getVersion();
        AuthenticationVersion av = this.session.getAuthenticationHandler().getVersion();
        UnsecuredRequestOrderDetails orderDetails = new UnsecuredRequestOrderDetails(OrderType.HSA, this.session.nextOrderID(OrderType.HSA, null), protocolVersion.compareTo(ProtocolVersion.H005) < 0 ? OrderAttribute.OZNNN : null);
        UnsignedRequestStaticHeader staticHeader = new UnsignedRequestStaticHeader(new HostID(partner.getBank().getHostId()), new PartnerID(partner.getPartnerID()), new UserID(businessUser.getUserID()), orderDetails, new SecurityMedium(businessUser.getSecurityMedium()));
        staticHeader.setProduct(this.session.product);
        UnsignedRequestHeader header = new UnsignedRequestHeader(staticHeader);
        AuthenticationPubKeyInfo authenticationPubKeyInfo = new AuthenticationPubKeyInfo(av);
        KeyManagement.fill(authenticationPubKeyInfo, pv, authKey, null);
        EncryptionPubKeyInfo encryptionPubKeyInfo = new EncryptionPubKeyInfo(ev);
        KeyManagement.fill(encryptionPubKeyInfo, pv, encrKey, null);
        HSARequestOrderData hsa = new HSARequestOrderData(protocolVersion, authenticationPubKeyInfo, encryptionPubKeyInfo, this.session.getPartnerID(), this.session.getBusinessUserID());
        byte[] hsaBytes = EbicsPrintStream.toByteArray(hsa);
        ByteArrayInputStream bis = new ByteArrayInputStream(hsaBytes);
        SignatureHandler sh = SignatureHandler.getInstance(businessUser.getSignatureVersion());
        UserSignatureData usd = new UserSignatureData(protocolVersion);
        this.session.addSignatureData(usd, this.session.businessUser, sh.getDigest(bis), "memory", new Date(), "HSA");
        UnsignedRequestDataTransfer dataTransfer = new UnsignedRequestDataTransfer(usd, hsaBytes);
        UnsignedRequestBody body = new UnsignedRequestBody(dataTransfer);
        EbicsUnsignedRequest ebics = new EbicsUnsignedRequest(protocolVersion, header, body);
        EbicsKeyManagementResponse rebics = (EbicsKeyManagementResponse)this.session.sendRequest(ebics, EbicsKeyManagementResponse.createParser(ebics.getVersion()));
        if (this.session.lastOrderID == null) {
            this.session.lastOrderID = rebics.getHeader().getMutable().getOrderID();
        }
        rebics.checkOK();
        return this.session.lastOrderID;
    }

    public OrderID sendINI(SignatureVersion version, RSAPublicKey sigKey, List<X509Certificate> sigCerts) throws IOException, EbicsException {
        byte[] ini;
        EbicsBusinessUser businessUser = this.session.businessUser;
        EbicsPartner partner = this.session.systemUser.getPartner();
        ProtocolVersion pv = this.session.getProtocolVersion();
        UnsecuredRequestOrderDetails orderDetails = new UnsecuredRequestOrderDetails(OrderType.INI, this.session.nextOrderID(OrderType.INI, null), pv.compareTo(ProtocolVersion.H005) < 0 ? OrderAttribute.DZNNN : null);
        PartnerID partnerID = new PartnerID(partner.getPartnerID());
        UserID userID = new UserID(businessUser.getUserID());
        UnsecuredRequestStaticHeader staticHeader = new UnsecuredRequestStaticHeader(new HostID(partner.getBank().getHostId()), partnerID, userID, orderDetails, new SecurityMedium(businessUser.getSecurityMedium()));
        staticHeader.setProduct(this.session.product);
        if (this.session.systemUser != this.session.businessUser) {
            staticHeader.setSystemID(new UserID(this.session.systemUser.getUserID()));
        }
        UnsecuredRequestHeader header = new UnsecuredRequestHeader(staticHeader);
        boolean xmlIni = Boolean.parseBoolean(System.getProperty("ebics.xml_ini"));
        if (version.equals(SignatureVersion.A004) && sigCerts == null && !xmlIni && userID.getValue().length() <= 8) {
            if (EbicsSession.SANITY_CHECK && pv.compareTo(ProtocolVersion.H005) >= 0) {
                throw new IllegalArgumentException(String.valueOf(version) + " not allowed in " + String.valueOf(pv));
            }
            ini = A004PublicKey.getINI(businessUser.getUserID(), sigKey);
        } else {
            SignaturePubKeyInfoType spki = new SignaturePubKeyInfoType(version);
            KeyManagement.fill(spki, pv.getVersion(), sigKey, sigCerts);
            SignaturePubKeyOrderData spkod = new SignaturePubKeyOrderData(pv, spki, partnerID, userID);
            ini = EbicsPrintStream.toByteArray(spkod);
        }
        UnsecuredRequestDataTransfer dataTransfer = new UnsecuredRequestDataTransfer(ini);
        UnsecuredRequestBody body = new UnsecuredRequestBody(dataTransfer);
        EbicsUnsecuredRequest ebics = new EbicsUnsecuredRequest(pv, header, body);
        EbicsKeyManagementResponse rebics = (EbicsKeyManagementResponse)this.session.sendRequest(ebics, EbicsKeyManagementResponse.createParser(ebics.getVersion()));
        if (this.session.lastOrderID == null) {
            this.session.lastOrderID = rebics.getHeader().getMutable().getOrderID();
        }
        rebics.checkOK();
        return this.session.lastOrderID;
    }

    @Deprecated
    public OrderID sendPUB(SignatureVersion version, RSAPublicKey sigKey) throws IOException, EbicsException {
        return this.sendPUB(version, sigKey, null);
    }

    public OrderID sendPUB(SignatureVersion version, RSAPublicKey sigKey, List<X509Certificate> sigCerts) throws IOException, EbicsException {
        FileTransfer transfer = new FileTransfer(this.session);
        byte[] ini = this.buildPUBRequest(version, sigKey, sigCerts);
        return transfer.sendFile(ini, OrderType.PUB, null, false);
    }

    public byte[] buildPUBRequest(SignatureVersion version, RSAPublicKey sigKey, List<X509Certificate> sigCerts) {
        return KeyManagement.buildPUB(this.session.getProtocolVersion(), this.session.getPartnerID(), this.session.getBusinessUserID(), version, sigKey, sigCerts);
    }

    public static byte[] buildLockAccess() {
        return (byte[])SPR_BYTES.clone();
    }

    public static byte[] buildPUB(ProtocolVersion pv, PartnerID partnerId, UserID userId, SignatureVersion version, RSAPublicKey sigKey, List<X509Certificate> sigCerts) {
        boolean xmlIni = Boolean.parseBoolean(System.getProperty("ebics.xml_ini"));
        if (version.equals(SignatureVersion.A004) && (sigCerts == null || sigCerts.isEmpty()) && !xmlIni) {
            return A004PublicKey.getINI(userId.getValue(), sigKey);
        }
        SignaturePubKeyInfoType spki = new SignaturePubKeyInfoType(version);
        KeyManagement.fill(spki, pv.getVersion(), sigKey, sigCerts);
        SignaturePubKeyOrderData spkod = new SignaturePubKeyOrderData(pv, spki, partnerId, userId);
        return EbicsPrintStream.toByteArray(spkod);
    }
}

