/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.ebics.client.EbicsBusinessUser;
import de.businesslogics.ebics.client.EbicsSession;
import de.businesslogics.ebics.client.FetchTransferState;
import de.businesslogics.ebics.client.FileTransfer;
import de.businesslogics.ebics.client.FrenchBTFTranslator;
import de.businesslogics.ebics.client.SendTransferState;
import de.businesslogics.ebics.client.UserSignature;
import de.businesslogics.ebics.schema.BooleanElement;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.h003.FDLOrderParams;
import de.businesslogics.ebics.schema.h003.FULOrderParams;
import de.businesslogics.ebics.schema.h005.BTDOrderParams;
import de.businesslogics.ebics.schema.h005.BTUOrderParams;
import de.businesslogics.ebics.schema.h005.Parameter;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.h005.SignatureFlagType;
import de.businesslogics.ebics.schema.orders.PreValidationRequest;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.types.Parameter;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.io.ContentFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class FrenchTransfer
extends FileTransfer {
    private FrenchBTFTranslator btfTranslator = new FrenchBTFTranslator();

    public FrenchTransfer(EbicsSession session) {
        super(session);
    }

    public FetchTransferState fetchFDL(FDLOrderParams params, OutputStream dest) throws IOException, EbicsException {
        BTDOrderParams btd = this.convertFDL(params);
        if (btd != null) {
            return this.fetchFileIntern(OrderType.BTD, btd, dest);
        }
        return this.fetchFileIntern(OrderType.FDL, params, dest);
    }

    public FetchTransferState fetchFDL(FDLOrderParams params, File dest) throws IOException, EbicsException {
        BTDOrderParams btd = this.convertFDL(params);
        if (btd != null) {
            return this.fetchFileIntern(OrderType.BTD, btd, dest);
        }
        return this.fetchFileIntern(OrderType.FDL, params, dest);
    }

    public SendTransferState sendFUL(ContentFactory factory, String localFilename, FULOrderParams params, OrderID orderID, EbicsBusinessUser[] signers, boolean onlyTransport) throws IOException, EbicsException {
        BTUOrderParams btu = this.convertFUL(params, onlyTransport);
        if (btu != null) {
            return this.sendFileIntern(factory, localFilename, OrderType.BTU, orderID, signers, onlyTransport, btu, localFilename);
        }
        return this.sendFileIntern(factory, localFilename, OrderType.FUL, orderID, signers, onlyTransport, params, null);
    }

    @Deprecated
    public SendTransferState sendFUL(InputStream in, long zipLength, FULOrderParams params, OrderID orderID, UserSignature[] signatures, boolean onlyTransport, PreValidationRequest preValidationRequest) throws EbicsException, IOException {
        BTUOrderParams btu = this.convertFUL(params, onlyTransport);
        if (btu != null) {
            return this.sendFileIntern(in, zipLength, OrderType.BTU, orderID, signatures, onlyTransport, preValidationRequest, btu);
        }
        return this.sendFileIntern(in, zipLength, OrderType.FUL, orderID, signatures, onlyTransport, preValidationRequest, params);
    }

    public void setBtfTranslator(FrenchBTFTranslator translator) {
        this.btfTranslator = translator;
    }

    private BTUOrderParams convertFUL(FULOrderParams ful, boolean onlyTransport) {
        short pv = this.session.getProtocolVersion().getVersion();
        if (pv < 3) {
            this.session.setProtocolVersion(ProtocolVersion.H003);
        } else if (pv >= 5) {
            RestrictedServiceType rst = this.btfTranslator.convertSend(ful.getFileFormat());
            if (rst != null) {
                BTUOrderParams btu = new BTUOrderParams(rst);
                FrenchTransfer.addParams(ful.getParameters(), btu.getParameters());
                if (!onlyTransport) {
                    SignatureFlagType sft = new SignatureFlagType();
                    sft.setRequestEDS(BooleanElement.TRUE);
                    btu.setSignatureFlag(sft);
                }
                return btu;
            }
            this.session.setProtocolVersion(ProtocolVersion.H004);
        }
        return null;
    }

    private BTDOrderParams convertFDL(FDLOrderParams fdl) {
        short pv = this.session.getProtocolVersion().getVersion();
        if (pv < 3) {
            this.session.setProtocolVersion(ProtocolVersion.H003);
        } else if (pv >= 5) {
            RestrictedServiceType rst = this.btfTranslator.convertFetch(fdl.getFileFormat());
            if (rst != null) {
                BTDOrderParams btd = new BTDOrderParams(rst);
                FrenchTransfer.addParams(fdl.getParameters(), btd.getParameters());
                btd.setDateRange(fdl.getDateRange());
                return btd;
            }
            this.session.setProtocolVersion(ProtocolVersion.H004);
        }
        return null;
    }

    private static void addParams(List<Parameter> src, List<de.businesslogics.ebics.schema.h005.Parameter> dest) {
        for (Parameter p : src) {
            Parameter.Parameter_L1 l1 = new Parameter.Parameter_L1(p.getValue().getValue(), new SimpleStringElement(p.getValue().getType()));
            de.businesslogics.ebics.schema.h005.Parameter n = new de.businesslogics.ebics.schema.h005.Parameter(p.getName(), l1);
            dest.add(n);
        }
    }
}

