/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.h003.FileFormat;
import de.businesslogics.ebics.schema.h005.MessageType;
import de.businesslogics.ebics.schema.h005.NumStringType;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.h005.ScopeStringType;
import de.businesslogics.ebics.schema.h005.ServiceNameStringType;
import de.businesslogics.ebics.schema.h005.ServiceOptionStringType;
import java.util.HashMap;
import java.util.Map;

public class FrenchBTFTranslator {
    private final Map<FileFormat, RestrictedServiceType> sendFf2Btf = new HashMap<FileFormat, RestrictedServiceType>();
    private final Map<RestrictedServiceType, FileFormat> sendBtf2Ff = new HashMap<RestrictedServiceType, FileFormat>();
    private final Map<FileFormat, RestrictedServiceType> fetchFf2Btf = new HashMap<FileFormat, RestrictedServiceType>();
    private final Map<RestrictedServiceType, FileFormat> fetchBtf2Ff = new HashMap<RestrictedServiceType, FileFormat>();

    public FrenchBTFTranslator() {
        this.addSend("pain.xxx.240.oth.cba", "frfc240", "CBA", "FR", null, null, null, null);
        this.addSend("pain.xxx.240.oth.cbm", "frfc240", "CBT", "FR", null, null, null, null);
        this.addFetch("camt.xxx.cfonb240.stm.xbs", "cfonb240", "CCP", "FR", null, null, null, null);
        this.addFetch("camt.xxx.frfc240.fcb", "frfc240", "FCB", "FR", null, null, null, null);
        this.addFetch("camt.xxx.frfcv240.fcb.fcb", "frfcv240", "FCB", "FR", null, null, null, null);
        this.addFetch("camt.xxx.240.dri.icb", "240", "RCA", "FR", null, null, null, null);
        this.addFetch("camt.xxx.cfonb240.dri.rcb", "cfonb240", "REP", "FR", "RCBT", null, null, null);
        this.addFetch("camt.xxx.vcom080.dri", "vcom080", "REP", "BIL", "XXXRFAE", null, null, null);
        this.addFetch("camt.xxx.vcom160.dri", "vcom160", "REP", "BIL", "XXXRECH", null, null, null);
        this.addFetch("camt.xxx.240.dri.acb", "240", "REP", "BIL", "RCBA", null, null, null);
        this.addSend("pain.xxx.chtlm320.ech", "chtlm320", "CHQ", "FR", null, null, null, null);
        this.addSend("pain.xxx.cfonb320.tch", "cfonb320", "CHQ", "FR", null, null, null, null);
        this.addSend("pain.xxx.cfonb240.ech", "cfonb240", "ECH", "FR", null, null, null, null);
        this.addSend("pain.xxx.cfonb160.scl", "cfonb160", "ECH", "FR", null, null, null, null);
        this.addSend("pain.xxx.lchq240.lch", "lchq240", "LCH", "BIL", null, null, null, null);
        this.addFetch("camt.xxx.br15120.ach", "br15120", "ACH", "BIL", null, null, null, null);
        this.addFetch("camt.xxx.br16120.ach", "br16120", "ACH", "BIL", null, null, null, null);
        this.addFetch("camt.xxx.cfonb120.ach", "cfonb120", "ACH", "FR", null, null, null, null);
        this.addFetch("camt.xxx.cfonb240.ach", "cfonb240", "ACH", "FR", null, null, null, null);
        this.addFetch("camt.xxx.cfonb560.ech", "cfonb560", "ACH", "FR", null, null, null, null);
        this.addFetch("camt.xxx.cfonb120.ech", "cfonb120", "ECH", "FR", null, null, null, null);
        this.addFetch("camt.xxx.bri9240.rch", "bri9240", "RCH", "BIL", null, null, null, null);
        this.addFetch("camt.xxx.cfonb240.rch", "cfonb240", "RCH", "FR", null, null, null, null);
        this.addFetch("camt.xxx.cfonb587.rch", "cfonb587", "RCH", "BIL", null, null, null, null);
        this.addSend("pain.xxx.cfonb160.dvd", "cfonb160", "DVD", "FR", null, null, null, null);
        this.addFetch("acmt.02z.001.01.asw", "acmt02z", "ASW", "FR", null, "01", "001", "XML");
        this.addFetch("acmt.02z.001.01.asw.mct", "acmt.02z", "ASW", "FR", "MCT", "01", "001", "XML");
        this.addFetch("acmt.02z.001.01.asw.sdd", "acmt.02z", "ASW", "FR", "SDD", "01", "001", "XML");
        this.addFetch("acmt.022.001.02.cai", "acmt.022", "CAI", null, null, "02", "001", "XML");
        this.addFetch("acmt.022.001.02.cai.cda", "acmt.022", "CAI", null, "SDD", "02", "001", "XML");
        this.addFetch("acmt.022.001.02.cai.cdv", "acmt.022", "CAI", null, "SCT", "02", "001", "XML");
        this.addFetch("camt.xxx.br23240.cai", "br23240", "CAI", "BIL", null, null, null, null);
        this.addFetch("camt.xxx.br83240.cai", "br83240", "CAI", "BIL", null, null, null, null);
        this.addFetch("camt.xxx.cfonb240.cai.cor", "cfonb240", "CAI", "FR", "SCT", null, null, null);
        this.addFetch("camt.xxx.cfonb240.cai.dct", "cfonb240", "CAI", "FR", "SDD", null, null, null);
        this.addFetch("camt.xxx.cfonb240.cai.ipd", "cfonb240", "CAI", null, "SDD", null, null, null);
        this.addSend("pain.xxx.cfonb400.vct.omi", "cfonb400", "VCT", "FR", null, null, null, null);
        this.addSend("pain.xxx.payext912.vct", "payext912", "VCT", "FR", null, null, null, null);
        this.addSend("pain.xxx.payext96a.vct", "payext96a", "VCT", "FR", null, null, null, null);
        this.addSend("pain.xxx.vcom1000.vct", "vcom1000", "VCT", "FR", null, null, null, null);
        this.addSend("pain.xxx.vcom160.vct", "vcom160", "VCT", "FR", null, null, null, null);
        this.addSend("pain.xxx.vcom400.vct", "vcom400", "VCT", "FR", null, null, null, null);
        this.addFetch("camt.xxx.cfonb240.ara", "cfonb240", "PSR", "FR", null, null, null, null);
        this.addFetch("camt.xxx.cfonb560.ara", "cfonb560", "PSR", "FR", null, null, null, null);
        this.addFetch("pain.002.001.02.ara", "pain.002", "PSR", "FR", null, "02", "001", "XML");
        this.addFetch("pain.002.001.03.psr", "pain.002", "PSR", "FR", null, "03", "001", "XML");
        this.addSend("pain.xxx.cfonb240.bco", "cfonb240", "BCO", "FR", null, null, null, null);
        this.addSend("pain.xxx.cfonb240.bco.bal", "cfonb240", "BCO", "BIL", null, null, null, null);
        this.addSend("pain.xxx.apbw240.dco", "apbw240", "DCO", "FR", null, null, null, null);
        this.addSend("pain.xxx.cfonb160.dco", "cfonb160", "DCO", "FR", null, null, null, null);
        this.addFetch("camt.xxx.br33240.pco", "br33240", "PCO", "FR", null, null, null, null);
        this.addFetch("camt.xxx.cfonb240.pco", "cfonb240", "PCO", "FR", null, null, null, null);
        this.addFetch("camt.xxx.cfonb240.rco", "cfonb240", "RCO", "FR", null, null, null, null);
        this.addSend("pain.008.001.02.sbb", "pain.008", "SDD", null, "B2B", null, null, "XML");
        this.addSend("pain.008.001.02.sdd", "pain.008", "SDD", null, null, null, null, "XML");
        this.addSend("pain.008.001.02.sdd.urg", "pain.008", "SDD", null, "URG", null, null, "XML");
        this.addFetch("camt.054.001.02.add", "camt.054", "ADD", "FR", null, "02", "001", "XML");
        this.addFetch("camt.054.001.02.ard", "camt.054", "ARD", "FR", null, "02", "001", "XML");
        this.addFetch("camt.xxx.br25240.ard", "br25240", "BIL", null, null, null, null, null);
        this.addFetch("camt.xxx.cfonb240.ard", "cfonb240", "ADD", "FR", null, null, null, null);
        this.addFetch("camt.054.001.02.rdd.ipp", "camt.054", "RDD", "FR", null, "02", "001", "XML");
        this.addFetch("camt.xxx.cfonb240.rdd", "cfonb240", "RDD", "FR", null, null, null, null);
        this.addFetch("camt.054.001.02.rsd", "camt.054", "RSD", "FR", null, "02", "001", "XML");
        this.addFetch("camt.054.001.02.rdd", "camt.054", "RSD", "FR", "BOOK", null, null, "XML");
        this.addFetch("camt.054.001.02.rdp", "camt.054", "RSD", "FR", "PNDG", null, null, "XML");
        this.addFetch("camt.053.001.02.stm.rlm", "camt.053", "EOP", null, "MTHY", "02", "001", "XML");
        this.addFetch("camt.fin.mt940.stm", "mt940", "EOP", null, null, null, null, null);
        this.addFetch("camt.xxx.br13120.stm", "br13120", "EOP", "BIL", null, null, null, null);
        this.addFetch("camt.xxx.cfonb120.stm", "cfonb120", "EOP", "FR", null, null, null, null);
        this.addFetch("camt.xxx.cfonb120.stm.ctd", "cfonb120", "EOP", "FR", "ACPO", null, null, null);
        this.addFetch("camt.xxx.cfonb120.stm.exm", "cfonb120", "EOP", "FR", "MTHY", null, null, null);
        this.addFetch("camt.fin.mt942.rep", "mt942", "STM", null, null, null, null, null);
        this.addFetch("camt.xxx.cfonb120.rep", "cfonb120", "STM", "FR", null, null, null, null);
        this.addSend("pain.xxx.cfonb160.dct", "cfonb160", "DCT", "FR", null, null, null, null);
        this.addSend("pain.001.001.03.ict", "pain.001", "ICT", "FR", null, null, null, "XML");
        this.addSend("pain.xxx.cfonb160.ict", "cfonb160", "ICT", "FR", null, null, null, null);
        this.addSend("pain.xxx.cfonb320.ict", "cfonb320", "ICT", "FR", null, null, null, null);
        this.addSend("pain.xxx.payord912.ict", "payord912", "ICT", "FR", null, null, null, null);
        this.addSend("pain.001.001.02.mct", "pain.001", "MCT", null, null, null, null, "XML");
        this.addSend("pain.xxx.cfonb320.mct", "cfonb320", "MCT", "FR", null, null, null, null);
        this.addSend("pain.fin.mt101.mct", "mt101", "RFT", null, null, null, null, null);
        this.addSend("pain.001.001.02.rft", "pain.001", "RFT", null, null, null, null, "XML");
        this.addSend("pain.xxx.cfonb320.rft", "cfonb320", "RFT", "FR", null, null, null, null);
        this.addSend("pain.001.001.03.sct", "pain.001", "SCT", null, null, null, null, "XML");
        this.addSend("pain.001.001.03.sct.tut", "pain.001", "SCT", "FR", "MORD", null, null, "XML");
        this.addSend("pain.001.001.03.sct.vcf", "pain.001", "SCT", null, "CFD", null, null, "XML");
        this.addSend("pain.xxx.brsc320.sct", "brsc320", "SCT", "BIL", null, null, null, null);
        this.addSend("pain.xxx.cfonb320.sct", "cfonb320", "SCT", "FR", null, null, null, null);
        this.addSend("pain.001.001.03.xct", "pain.001", "XCT", null, null, null, null, "XML");
        this.addSend("pain.xxx.cfonb320.xct", "cfonb320", "XCT", "FR", null, null, null, null);
        this.addSend("pain.xxx.cfonb320.xct.ttd", "cfonb320", "XCT", "FR", "ICT", null, null, null);
        this.addSend("pain.001.001.03.sct.inst", "pain.001", "SCI", null, null, null, null, "XML");
        this.addFetch("camt.054.001.01.act", "camt.054", "ACT", "FR", null, "01", "001", "XML");
        this.addFetch("camt.054.001.02.act", "camt.054", "ACT", "FR", null, "02", "001", "XML");
        this.addFetch("camt.xxx.brs4240.act", "brs4240", "ACT", "BIL", null, null, null, null);
        this.addFetch("camt.xxx.cfonb240.act", "cfonb240", "ACT", "FR", null, null, null, null);
        this.addFetch("camt.xxx.cfonb240.act.pha", "cfonb240", "ACT", "BIL", null, null, null, null);
        this.addFetch("camt.xxx.cfonb240.act.tut", "cfonb240", "ACT", "FR", "MORD", null, null, null);
        this.addFetch("camt.054.001.02.sct.vrc", "camt.054", "ACT", null, null, "02", "001", "XML");
        this.addFetch("camt.054.001.01.rct", "camt.054", "RCT", "FR", null, "01", "001", "XML");
        this.addFetch("camt.054.001.02.rct", "camt.054", "RCT", "FR", null, "02", "001", "XML");
        this.addFetch("camt.xxx.brs7240.rct", "brs7240", "RCT", "FR", null, null, null, null);
        this.addFetch("camt.xxx.cfonb240.rct", "cfonb240", "RCT", "FR", null, null, null, null);
        this.addFetch("pain.xxx.sepamail.ack", "pain.014", "INV", "FR", "RUBIS", null, null, null);
        this.addSend("pain.xxx.sepamail.ack", "pain.013", "INV", "FR", "RUBIS", null, null, null);
        this.addSend("acmt.xxx.sepamail.ack", "acmt.023", "BAV", "FR", "DIAM", null, null, null);
        this.addFetch("acmt.xxx.sepamail.ack", "acmt.024", "BAV", "FR", "DIAM", null, null, null);
    }

    public RestrictedServiceType convertFetch(FileFormat ff) {
        return this.fetchFf2Btf.get(ff);
    }

    public FileFormat convertFetch(RestrictedServiceType service) {
        return this.fetchBtf2Ff.get(service);
    }

    public RestrictedServiceType convertSend(FileFormat ff) {
        return this.sendFf2Btf.get(ff);
    }

    public FileFormat convertSend(RestrictedServiceType service) {
        return this.sendBtf2Ff.get(service);
    }

    public RestrictedServiceType addFetch(FileFormat ff, RestrictedServiceType rst) {
        EbicsElement removed = this.fetchBtf2Ff.put(rst, ff);
        if (removed != null && !removed.equals(ff)) {
            this.fetchBtf2Ff.put(rst, (FileFormat)removed);
            throw new IllegalStateException("Mapping already exists to order type " + String.valueOf(removed));
        }
        removed = this.fetchFf2Btf.put(ff, rst);
        if (removed != null) {
            this.fetchBtf2Ff.remove(removed);
        }
        return removed;
    }

    public RestrictedServiceType removeFetch(FileFormat ff) {
        RestrictedServiceType removed = this.fetchFf2Btf.remove(ff);
        if (removed != null) {
            this.fetchBtf2Ff.remove(removed);
        }
        return removed;
    }

    public RestrictedServiceType addSend(FileFormat ff, RestrictedServiceType rst) {
        EbicsElement removed = this.sendBtf2Ff.put(rst, ff);
        if (removed != null && !removed.equals(ff)) {
            this.sendBtf2Ff.put(rst, (FileFormat)removed);
            throw new IllegalStateException("Mapping already exists to order type " + String.valueOf(removed));
        }
        removed = this.sendFf2Btf.put(ff, rst);
        if (removed != null) {
            this.sendBtf2Ff.remove(removed);
        }
        return removed;
    }

    public RestrictedServiceType removeSend(FileFormat ff) {
        RestrictedServiceType removed = this.sendFf2Btf.remove(ff);
        if (removed != null) {
            this.sendBtf2Ff.remove(removed);
        }
        return removed;
    }

    private static RestrictedServiceType mkService(String message, String service, String scope, String option, String version, String variant, String format) {
        MessageType mt = new MessageType(message);
        RestrictedServiceType rst = new RestrictedServiceType(new ServiceNameStringType(service), mt);
        if (scope != null) {
            rst.setScope(new ScopeStringType(scope));
        }
        if (option != null) {
            rst.setServiceOption(new ServiceOptionStringType(option));
        }
        if (version != null) {
            mt.setVersion(new NumStringType(version));
        }
        if (variant != null) {
            mt.setVariant(new NumStringType(variant));
        }
        if (format != null) {
            mt.setFormat(new MessageType.MessageType_L1(format));
        }
        return rst;
    }

    private void addSend(String ff, String message, String service, String scope, String option, String version, String variant, String format) {
        FileFormat fileFormat = new FileFormat(ff);
        RestrictedServiceType rst = FrenchBTFTranslator.mkService(message, service, scope, option, version, variant, format);
        rst = this.addSend(fileFormat, rst);
        assert (null == rst);
    }

    private void addFetch(String ff, String message, String service, String scope, String option, String version, String variant, String format) {
        FileFormat fileFormat = new FileFormat(ff);
        RestrictedServiceType rst = FrenchBTFTranslator.mkService(message, service, scope, option, version, variant, format);
        rst = this.addFetch(fileFormat, rst);
        assert (null == rst);
    }
}

