/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.client.AcknowledgeFailedException;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.client.EbicsBusinessUser;
import de.businesslogics.ebics.client.EbicsSession;
import de.businesslogics.ebics.client.FetchTransferState;
import de.businesslogics.ebics.client.PreValidationSupplier;
import de.businesslogics.ebics.client.SendTransferState;
import de.businesslogics.ebics.client.TransferState;
import de.businesslogics.ebics.client.UserSignature;
import de.businesslogics.ebics.schema.BooleanElement;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.h005.BTDOrderParams;
import de.businesslogics.ebics.schema.h005.BTUOrderParams;
import de.businesslogics.ebics.schema.h005.FileNameStringType;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.h005.SignatureFlagType;
import de.businesslogics.ebics.schema.h005.String255Type;
import de.businesslogics.ebics.schema.orders.DateRange;
import de.businesslogics.ebics.schema.orders.PreValidationRequest;
import de.businesslogics.ebics.schema.orders.StandardOrderParams;
import de.businesslogics.ebics.schema.orders.TransferReceipt;
import de.businesslogics.ebics.schema.orders.UserSignatureData;
import de.businesslogics.ebics.schema.request.BankPubKeyDigests;
import de.businesslogics.ebics.schema.request.Body;
import de.businesslogics.ebics.schema.request.DataTransfer;
import de.businesslogics.ebics.schema.request.EbicsRequest;
import de.businesslogics.ebics.schema.request.Header;
import de.businesslogics.ebics.schema.request.Mutable;
import de.businesslogics.ebics.schema.request.OrderAttribute;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.request.Static;
import de.businesslogics.ebics.schema.response.BankPubKeyUpdateRequiredException;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.response.EbicsResponse;
import de.businesslogics.ebics.schema.response.ResponseMutableHeader;
import de.businesslogics.ebics.schema.response.UnknownTransactionIdException;
import de.businesslogics.ebics.schema.types.DataDigest;
import de.businesslogics.ebics.schema.types.NumSegments;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.ReceiptCode;
import de.businesslogics.ebics.schema.types.ReturnCode;
import de.businesslogics.ebics.schema.types.SecurityMedium;
import de.businesslogics.ebics.schema.types.SegmentNumber;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.ebics.schema.types.TransactionPhase;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.ebics.security.EncryptionHandler;
import de.businesslogics.io.ByteArrayContentFactory;
import de.businesslogics.io.ContentFactory;
import de.businesslogics.io.IteratingFileInputStream;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.LogUtils;
import de.businesslogics.util.SystemUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.InflaterInputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.xml.sax.SAXException;

public class FileTransfer {
    private static final String CLASSNAME = FileTransfer.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASSNAME);
    private static final BTFTranslator BTF_TRANSLATOR = new BTFTranslator();
    protected final EbicsSession session;
    private File workDir;
    private PreValidationSupplier prevalidationSupplier;
    private boolean usePrevalidation;
    private static final HashMap<String, Class<? extends PreValidationSupplier>> SUPPLIERS = new HashMap();
    private static boolean PREVALIDATION = Boolean.getBoolean("de.businesslogics.ebics.client.FileTransfer.prevalidation");
    protected BTFTranslator btfTranslator = BTF_TRANSLATOR;

    public FileTransfer(EbicsSession session) {
        this.session = session;
        this.workDir = new File(System.getProperty("java.io.tmpdir"));
        this.usePrevalidation = PREVALIDATION;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void setBTFTranslator(BTFTranslator translator) {
        if (translator == null) {
            throw new NullPointerException();
        }
        this.btfTranslator = translator;
    }

    public boolean isUsePrevalidation() {
        return this.usePrevalidation;
    }

    public EbicsSession getSession() {
        return this.session;
    }

    public void setUsePrevalidation() throws IOException, EbicsException {
        this.usePrevalidation = this.session.getBankParameters().getProtocolParams().isPreValidation();
    }

    public void setUsePrevalidation(boolean usePrevalidation) {
        this.usePrevalidation = usePrevalidation;
    }

    public void setPrevalidationSupplier(PreValidationSupplier supplier) {
        this.prevalidationSupplier = supplier;
        this.usePrevalidation = supplier != null;
    }

    public static void addPrevalidationSupplier(OrderType orderType, Class<? extends PreValidationSupplier> supplier) {
        SUPPLIERS.put(orderType.getValue(), supplier);
    }

    public static void setGlobalPrevalidation(boolean prevalidation) {
        PREVALIDATION = prevalidation;
    }

    public OrderID sendFile(byte[] content, OrderType orderType, EbicsBusinessUser[] signers, boolean onlyTransport) throws IOException, EbicsException {
        SendTransferState ts = this.sendFile(new ByteArrayContentFactory(content), "memory", orderType, null, signers, onlyTransport);
        while (this.nextChunk(ts)) {
        }
        return ts.getOrderID();
    }

    @Deprecated
    public SendTransferState sendFile(InputStream in, long zipLength, OrderType orderType, OrderID orderID, UserSignature[] signatures, boolean onlyTransport, PreValidationRequest preValidationRequest) throws IOException, EbicsException {
        return this.sendFileIntern(in, zipLength, orderType, orderID, signatures, onlyTransport, preValidationRequest, new StandardOrderParams(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected SendTransferState sendFileIntern(InputStream in, long zipLength, OrderType orderType, OrderID orderID, UserSignature[] signatures, boolean onlyTransport, PreValidationRequest preValidationRequest, EbicsElement orderParams) throws IOException, EbicsException {
        orderID = this.session.nextOrderID(orderType, orderID);
        EncryptionHandler ehandler = this.session.getEncryptionHandler();
        SendTransferState state = new SendTransferState(ehandler, in, zipLength, orderID, null, null);
        boolean ok = false;
        try {
            OrderAttribute attr = onlyTransport ? OrderAttribute.DZHNN : OrderAttribute.OZHNN;
            Static sh = this.session.createStaticHeader(orderType, orderID, attr, new SecurityMedium(this.session.businessUser.getSecurityMedium()), orderParams);
            Header header = new Header(sh, new Mutable(TransactionPhase.INITIALIZATION, null));
            UserSignatureData usd = new UserSignatureData(this.session.getProtocolVersion());
            for (UserSignature signature : signatures) {
                this.session.addSignatureData(usd, signature);
            }
            DataTransfer dataTransfer = new DataTransfer();
            dataTransfer.setSignatureData(usd);
            sh.getInitialisation().setNumSegments(new NumSegments(state.numSegments));
            this.session.logSignatureData(dataTransfer);
            dataTransfer.encrypt(ehandler, this.session.getBankEncrKey(), this.session.bankEncrDigest, state.key);
            Body body = new Body(new Body.InitialisationBody(preValidationRequest, dataTransfer));
            EbicsRequest ebics = new EbicsRequest(this.session.getProtocolVersion(), header, body);
            EbicsResponse rebics = this.session.sendSigned(ebics);
            state.transactionID = rebics.getHeader().getStatic().getTransactionID();
            if (orderID == null) {
                state.setOrderID(rebics.getHeader().getMutable().getOrderID());
            }
            ok = true;
            SendTransferState sendTransferState = state;
            return sendTransferState;
        }
        finally {
            if (!ok) {
                try {
                    state.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public SendTransferState sendFile(ContentFactory factory, String localFilename, OrderType orderType, OrderID orderID, EbicsBusinessUser[] signers, boolean onlyTransport) throws IOException, EbicsException {
        return this.sendFile(factory, localFilename, orderType, orderID, signers, onlyTransport, null);
    }

    public SendTransferState sendFile(ContentFactory factory, String localFilename, OrderType orderType, OrderID orderID, EbicsBusinessUser[] signers, boolean onlyTransport, EbicsElement orderParams) throws IOException, EbicsException {
        return this.sendFile(factory, localFilename, orderType, orderID, signers, onlyTransport, orderParams, null);
    }

    public SendTransferState sendFile(ContentFactory factory, String localFilename, OrderType orderType, OrderID orderID, EbicsBusinessUser[] signers, boolean onlyTransport, EbicsElement orderParams, String additionalInfo) throws IOException, EbicsException {
        if (this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) >= 0 && !OrderType.ADMIN30_SEND_ORDER_TYPES.contains(orderType)) {
            RestrictedServiceType service = this.btfTranslator.convertSend(orderType);
            if (service != null) {
                BTUOrderParams params = new BTUOrderParams(service);
                if (localFilename != null) {
                    params.setFileName(new FileNameStringType(localFilename));
                }
                if (!onlyTransport) {
                    SignatureFlagType sf = new SignatureFlagType();
                    sf.setRequestEDS(BooleanElement.TRUE);
                    params.setSignatureFlag(sf);
                }
                return this.sendFileIntern(factory, localFilename, new OrderType("BTU"), null, signers, onlyTransport, params, additionalInfo);
            }
            if (EbicsSession.SANITY_CHECK) {
                throw new IllegalArgumentException("Unknown mapping for order type " + String.valueOf(orderType));
            }
        }
        if (orderParams == null) {
            orderParams = new StandardOrderParams(null);
        }
        return this.sendFileIntern(factory, localFilename, orderType, orderID, signers, onlyTransport, orderParams, additionalInfo);
    }

    public SendTransferState sendFile30(ContentFactory factory, String localFilename, RestrictedServiceType service, EbicsBusinessUser[] signers, boolean onlyTransport, String additionalInfo) throws IOException, EbicsException {
        if (this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) < 0) {
            OrderType ot = this.btfTranslator.convertSend(service);
            if (ot == null) {
                throw new IllegalArgumentException("Unknonw mapping for " + new String(EbicsPrintStream.toByteArray(service)));
            }
            return this.sendFileIntern(factory, localFilename, ot, null, signers, onlyTransport, new StandardOrderParams(null), additionalInfo);
        }
        BTUOrderParams params = new BTUOrderParams(service);
        if (localFilename != null) {
            params.setFileName(new FileNameStringType(localFilename));
        }
        if (!onlyTransport) {
            SignatureFlagType sf = new SignatureFlagType();
            sf.setRequestEDS(BooleanElement.TRUE);
            params.setSignatureFlag(sf);
        }
        return this.sendFile30(factory, params, signers, additionalInfo);
    }

    public SendTransferState sendFile30(ContentFactory factory, BTUOrderParams btu, EbicsBusinessUser[] signers, String additionalInfo) throws IOException, EbicsException {
        if (EbicsSession.SANITY_CHECK && this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) < 0) {
            throw new IllegalStateException("BTF not available in " + String.valueOf(this.session.getProtocolVersion()));
        }
        return this.sendFileIntern(factory, btu.getFileName() != null ? btu.getFileName().getValue() : "", OrderType.BTU, null, signers, btu.getSignatureFlag() == null, btu, additionalInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SendTransferState sendFileIntern(ContentFactory factory, String localFilename, OrderType orderType, OrderID orderID, EbicsBusinessUser[] signers, boolean onlyTransport, EbicsElement orderParams, String additionalInfo) throws IOException, EbicsException {
        orderID = this.session.nextOrderID(orderType, orderID);
        if (signers == null) {
            signers = new EbicsBusinessUser[]{this.session.businessUser};
        }
        PreValidationStream pipe = null;
        if (this.usePrevalidation) {
            if (this.prevalidationSupplier != null) {
                pipe = new PreValidationStream(this.prevalidationSupplier);
            } else {
                Class<? extends PreValidationSupplier> supplier = SUPPLIERS.get(orderType.getValue());
                if (supplier != null) {
                    LOGGER.fine("Using supplier " + supplier.getName());
                    try {
                        pipe = new PreValidationStream(supplier.newInstance());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    LOGGER.fine("No supplier for order type '" + String.valueOf(orderType) + "'");
                }
            }
        }
        EncryptionHandler ehandler = this.session.getEncryptionHandler();
        SendTransferState state = new SendTransferState(ehandler, factory, orderID, pipe, signers);
        Date now = new Date();
        UserSignatureData usd = new UserSignatureData(this.session.getProtocolVersion());
        for (EbicsBusinessUser signer : signers) {
            byte[] digest = signer.getSignatureVersion().equals(SignatureVersion.A004) ? state.digest : state.digest5;
            this.session.addSignatureData(usd, signer, digest, localFilename, now, orderType.getValue());
        }
        PreValidationRequest preValidationRequest = null;
        if (this.usePrevalidation) {
            if (pipe != null) {
                preValidationRequest = pipe.supplier.getPrevalidationRequest();
            }
            if (preValidationRequest == null) {
                preValidationRequest = new PreValidationRequest();
            }
            BitSet svs = new BitSet();
            for (EbicsBusinessUser signer : signers) {
                SignatureVersion sv = signer.getSignatureVersion();
                if (svs.get(sv.getVersion())) continue;
                preValidationRequest.getDataDigests().add(switch (sv.getVersion()) {
                    case 4 -> new DataDigest(state.digest, sv);
                    default -> new DataDigest(state.digest5, sv);
                });
                svs.set(sv.getVersion());
            }
        }
        boolean ok = false;
        boolean retry = false;
        try {
            EbicsResponse rebics;
            while (true) {
                OrderAttribute attr = onlyTransport ? OrderAttribute.DZHNN : OrderAttribute.OZHNN;
                Static sh = this.session.createStaticHeader(orderType, orderID, attr, new SecurityMedium(this.session.businessUser.getSecurityMedium()), orderParams);
                Header header = new Header(sh, new Mutable(TransactionPhase.INITIALIZATION, null));
                DataTransfer dataTransfer = new DataTransfer();
                if (this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) >= 0) {
                    dataTransfer.setDataDigest(new DataDigest(state.digest5, signers[0].getSignatureVersion()));
                    if (additionalInfo != null) {
                        if (additionalInfo.length() > 255 && EbicsSession.SANITY_CHECK) {
                            additionalInfo = additionalInfo.substring(0, 255);
                        }
                        dataTransfer.setAdditionalOrderInfo(new String255Type(additionalInfo));
                    }
                }
                dataTransfer.setSignatureData(usd);
                sh.getInitialisation().setNumSegments(new NumSegments(state.numSegments));
                this.session.logSignatureData(dataTransfer);
                dataTransfer.encrypt(ehandler, this.session.getBankEncrKey(), this.session.bankEncrDigest, state.key);
                Body body = new Body(new Body.InitialisationBody(preValidationRequest, dataTransfer));
                EbicsRequest ebics = new EbicsRequest(this.session.getProtocolVersion(), header, body);
                try {
                    rebics = this.session.sendSigned(ebics);
                    break;
                }
                catch (BankPubKeyUpdateRequiredException bpue) {
                    if (retry) {
                        throw bpue;
                    }
                    retry = true;
                    LOGGER.info("Got BankPubKeyUpdateRequiredException");
                    try {
                        this.session.getBankKeys(false);
                    }
                    catch (EbicsException | IOException e) {
                        if (this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) < 0) {
                            LogUtils.logp(LOGGER, Level.FINEST, CLASSNAME, "sendFileIntern", "automatic HPB for EBICS-2.x failed", e);
                            throw bpue;
                        }
                        throw e;
                    }
                }
            }
            state.transactionID = rebics.getHeader().getStatic().getTransactionID();
            if (orderID == null) {
                state.setOrderID(rebics.getHeader().getMutable().getOrderID());
            }
            ok = true;
            SendTransferState sendTransferState = state;
            return sendTransferState;
        }
        finally {
            if (!ok) {
                try {
                    state.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void fetchFile(OrderType orderType, YYMMDD start, YYMMDD end, OutputStream dest) throws IOException, EbicsException {
        FetchTransferState ts = this.fetchFile25(orderType, start, end, dest);
        while (this.nextChunk(ts)) {
        }
    }

    private FetchTransferState fetchFile25(OrderType orderType, YYMMDD start, YYMMDD end, Object dest) throws IOException, EbicsException {
        DateRange dr;
        if (start != null && end != null) {
            XMLDate sd = new XMLDate(start);
            XMLDate ed = new XMLDate(end);
            dr = new DateRange(sd, ed);
        } else {
            dr = null;
        }
        EbicsElement params = null;
        if (this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) >= 0 && !OrderType.ADMIN30_FETCH_ORDER_TYPES.contains(orderType)) {
            RestrictedServiceType rst = this.btfTranslator.convertFetch(orderType);
            if (rst != null) {
                orderType = OrderType.BTD;
                BTDOrderParams btdParams = new BTDOrderParams(rst);
                btdParams.setDateRange(dr);
                params = btdParams;
            } else if (EbicsSession.SANITY_CHECK) {
                throw new IllegalArgumentException("No mapping for " + String.valueOf(orderType));
            }
        }
        if (params == null) {
            params = new StandardOrderParams(dr);
        }
        return this.fetchFileIntern(orderType, params, dest);
    }

    public FetchTransferState fetchIterating(OrderType orderType, YYMMDD start, YYMMDD end, OutputStream dest) throws IOException, EbicsException {
        return this.fetchFile25(orderType, start, end, dest);
    }

    public FetchTransferState fetchFile(OrderType orderType, YYMMDD start, YYMMDD end, File dest) throws IOException, EbicsException {
        return this.fetchFile25(orderType, start, end, dest);
    }

    public FetchTransferState fetchFile30(RestrictedServiceType service, YYMMDD start, YYMMDD end, OutputStream dest) throws IOException, EbicsException {
        DateRange dr;
        if (start != null && end != null) {
            XMLDate sd = new XMLDate(start);
            XMLDate ed = new XMLDate(end);
            dr = new DateRange(sd, ed);
        } else {
            dr = null;
        }
        if (this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) < 0) {
            OrderType ot = this.btfTranslator.convertFetch(service);
            if (ot == null) {
                throw new IllegalArgumentException("Unknown mapping for " + new String(EbicsPrintStream.toByteArray("Service", service)));
            }
            return this.fetchFileIntern(ot, new StandardOrderParams(dr), dest);
        }
        BTDOrderParams params = new BTDOrderParams(service);
        params.setDateRange(dr);
        return this.fetchFileIntern(OrderType.BTD, params, dest);
    }

    public FetchTransferState fetchFile30(RestrictedServiceType service, YYMMDD start, YYMMDD end, File dest) throws IOException, EbicsException {
        DateRange dr;
        if (start != null && end != null) {
            XMLDate sd = new XMLDate(start);
            XMLDate ed = new XMLDate(end);
            dr = new DateRange(sd, ed);
        } else {
            dr = null;
        }
        if (this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) < 0) {
            OrderType ot = this.btfTranslator.convertFetch(service);
            if (ot == null) {
                throw new IllegalArgumentException("Unknown mapping for " + new String(EbicsPrintStream.toByteArray(service)));
            }
            return this.fetchFileIntern(ot, new StandardOrderParams(dr), dest);
        }
        BTDOrderParams params = new BTDOrderParams(service);
        params.setDateRange(dr);
        return this.fetchFileIntern(OrderType.BTD, params, dest);
    }

    public FetchTransferState fetch30(BTDOrderParams params, OutputStream dest) throws IOException, EbicsException {
        return this.fetch30Intern(params, dest);
    }

    public FetchTransferState fetch30(BTDOrderParams params, File dest) throws IOException, EbicsException {
        return this.fetch30Intern(params, dest);
    }

    private FetchTransferState fetch30Intern(BTDOrderParams params, Object dest) throws IOException, EbicsException {
        if (EbicsSession.SANITY_CHECK && this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) < 0) {
            throw new IllegalStateException("BTF not available in " + String.valueOf(this.session.getProtocolVersion()));
        }
        return this.fetchFileIntern(OrderType.BTD, params, dest);
    }

    protected FetchTransferState fetchFileIntern(OrderType orderType, EbicsElement orderParams, Object dest) throws IOException, EbicsException {
        SecretKeySpec secret;
        EbicsResponse rebics;
        this.session.getBankEncrKey();
        boolean retry = false;
        while (true) {
            Static sh = this.session.createStaticHeader(orderType, null, OrderAttribute.DZHNN, new SecurityMedium(this.session.businessUser.getSecurityMedium()), orderParams);
            Static.Initialisation ini = sh.getInitialisation();
            BankPubKeyDigests bd = new BankPubKeyDigests(this.session.getAuthenticationHandler().createPubKeyDigest(this.session.bankAuthDigest), this.session.getEncryptionHandler().createPubKeyDigest(this.session.bankEncrDigest));
            ini.setBankPubKeyDigests(bd);
            Header header = new Header(sh, new Mutable(TransactionPhase.INITIALIZATION, null));
            Body body = new Body();
            EbicsRequest ebics = new EbicsRequest(this.session.getProtocolVersion(), header, body);
            try {
                rebics = this.session.sendSignedRequest(ebics);
                break;
            }
            catch (BankPubKeyUpdateRequiredException bpue) {
                if (retry) {
                    throw bpue;
                }
                retry = true;
                LOGGER.info("Got BankPubKeyUpdateRequiredException");
                try {
                    this.session.getBankKeys(false);
                }
                catch (EbicsException | IOException e) {
                    if (this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) < 0) {
                        LogUtils.logp(LOGGER, Level.FINEST, CLASSNAME, "sendFileIntern", "automatic HPB for EBICS-2.x failed", e);
                        throw bpue;
                    }
                    throw e;
                }
            }
        }
        DataTransfer dt = rebics.getBody().getDataTransfer();
        byte[] content = dt.getRawOrderData();
        dt.setRawOrderData(null);
        try {
            secret = this.session.decrypt(dt.getDataEncryption());
        }
        catch (SAXException e) {
            IOException toThrow = new IOException("Malformed server response", e);
            throw toThrow;
        }
        FetchTransferState state = new FetchTransferState(rebics.getHeader().getStatic().getTransactionID(), rebics.getHeader().getStatic().getNumSegments().intValue(), dest, secret);
        if (rebics.getHeader().getMutable().getSegmentNumber().isLastSegment()) {
            state.numSegments = 1;
            InputStream is = new ByteArrayInputStream(content);
            EncryptionHandler eh = this.session.getEncryptionHandler();
            is = eh.decryptContent((SecretKey)secret, is);
            is = new InflaterInputStream(is);
            state.copy(this.session, is);
        } else {
            try (FileOutputStream fos = new FileOutputStream(this.createTempFile(state, 1));){
                fos.write(content);
            }
            if (state.numSegments == 1) {
                state.numSegments = 2;
            }
        }
        return state;
    }

    public boolean nextChunk(TransferState ts) throws IOException, EbicsException {
        if (ts.transactionID == null) {
            return false;
        }
        if (ts instanceof SendTransferState) {
            return this.nextSendChunk((SendTransferState)ts);
        }
        return this.nextFetchChunk((FetchTransferState)ts);
    }

    private boolean nextSendChunk(SendTransferState ts) throws IOException, EbicsException {
        EbicsResponse rebics;
        long l = ts.totalLength - 786432L * (long)(ts.segmentNumber - 1);
        if (l <= 0L) {
            return false;
        }
        if (786432L < l) {
            l = 786432L;
        }
        byte[] buffer = new byte[(int)l];
        try {
            ts.fillBuffer(this.session.getEncryptionHandler(), buffer);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Local read error", ioe);
            ts.close();
            throw new RuntimeException(ioe);
        }
        Static sh = new Static(this.session.getBankID(), ts.transactionID);
        Header header = new Header(sh, new Mutable(TransactionPhase.TRANSFER, ts.getSegmentNumber()));
        DataTransfer dataTransfer = new DataTransfer();
        dataTransfer.setRawOrderData(buffer);
        Body body = new Body(new Body.InitialisationBody(null, dataTransfer));
        EbicsRequest ebics = new EbicsRequest(this.session.getProtocolVersion(), header, body);
        try {
            rebics = this.session.sendSigned(ebics);
        }
        catch (IOException ioe) {
            ts.ioExceptionOnAcknowledge = ts.segmentNumber == ts.numSegments;
            ts.close();
            throw ioe;
        }
        catch (EbicsException ee) {
            ts.close();
            if (ts.ioExceptionOnAcknowledge && ee instanceof UnknownTransactionIdException) {
                throw new AcknowledgeFailedException((UnknownTransactionIdException)ee);
            }
            throw ee;
        }
        ResponseMutableHeader rmh = rebics.getHeader().getMutable();
        if (rmh.getReturnCode().equals(ReturnCode.EBICS_TX_RECOVERY_SYNC)) {
            SegmentNumber sn = rmh.getSegmentNumber();
            ts.segmentNumber = sn == null ? 1 : sn.intValue() + 1;
            ts.close();
            return true;
        }
        ++ts.segmentNumber;
        if (ts.segmentNumber <= ts.numSegments) {
            return true;
        }
        ts.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nextFetchChunk(FetchTransferState ts) throws IOException, EbicsException {
        Static sh = new Static(this.session.getBankID(), ts.transactionID);
        if (ts.segmentNumber > ts.numSegments) {
            Header header = new Header(sh, new Mutable(TransactionPhase.RECEIPT, null));
            TransferReceipt tr = new TransferReceipt(new ReceiptCode(!ts.isError()));
            Body body = new Body(tr);
            EbicsRequest ebics = new EbicsRequest(this.session.getProtocolVersion(), header, body);
            try {
                this.session.sendSignedRequest(ebics);
            }
            catch (IOException ioe) {
                ts.ioExceptionOnAcknowledge = true;
                throw ioe;
            }
            catch (UnknownTransactionIdException utie) {
                if (!ts.ioExceptionOnAcknowledge) {
                    throw new AcknowledgeFailedException(utie);
                }
                LOGGER.fine("Ignoring unknown transaction id");
            }
            ts.transactionID = null;
            ts.throwLocalException();
            return false;
        }
        Header header = new Header(sh, new Mutable(TransactionPhase.TRANSFER, ts.getSegmentNumber()));
        Body body = new Body();
        EbicsRequest ebics = new EbicsRequest(this.session.getProtocolVersion(), header, body);
        EbicsResponse rebics = this.session.sendSigned(ebics);
        ResponseMutableHeader rmh = rebics.getHeader().getMutable();
        SegmentNumber sn = rmh.getSegmentNumber();
        if (rmh.getReturnCode().equals(ReturnCode.EBICS_TX_RECOVERY_SYNC)) {
            ts.segmentNumber = sn.intValue() + 1;
            return true;
        }
        ++ts.segmentNumber;
        DataTransfer dt = rebics.getBody().getDataTransfer();
        try (FileOutputStream fos = new FileOutputStream(this.createTempFile(ts, sn.intValue()));){
            fos.write(dt.getRawOrderData());
        }
        if (sn.isLastSegment()) {
            if (sn.intValue() != ts.numSegments) {
                LOGGER.fine("Segment number underrun!");
                ts.numSegments = sn.intValue();
            }
            File[] files = new File[ts.numSegments];
            int i = files.length;
            while (--i >= 0) {
                files[i] = this.createTempFile(ts, i + 1);
            }
            InputStream is = new IteratingFileInputStream(files);
            try {
                is = this.session.getEncryptionHandler().decryptContent((SecretKey)ts.secret, is);
                is = new InflaterInputStream(is);
                ts.copy(this.session, is);
                is = null;
            }
            finally {
                SystemUtils.close(is);
            }
            int i2 = files.length;
            while (--i2 >= 0) {
                files[i2].delete();
            }
        } else if (sn.intValue() == ts.numSegments) {
            LOGGER.fine("Segment number overrun");
            ++ts.numSegments;
        }
        return true;
    }

    private File createTempFile(TransferState ts, int i) {
        File f = new File(this.workDir, "ebicsTransaction" + HexTool.toHex(ts.transactionID.getValue()) + ".part" + i);
        return f;
    }

    private static class PreValidationStream
    extends OutputStream {
        final PreValidationSupplier supplier;
        final byte[] one_byte = new byte[1];

        PreValidationStream(PreValidationSupplier supplier) {
            this.supplier = supplier;
            supplier.reset();
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.supplier.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.one_byte[0] = (byte)b;
            this.supplier.write(this.one_byte, 0, 1);
        }
    }
}

