/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.ebics.client.EbicsLog;
import de.businesslogics.ebics.client.EbicsSession;
import de.businesslogics.ebics.client.LocalIOException;
import de.businesslogics.ebics.client.TransferState;
import de.businesslogics.ebics.schema.types.TransactionID;
import de.businesslogics.io.Streams;
import de.businesslogics.io.YOutputStream;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;

public class FetchTransferState
extends TransferState {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(FetchTransferState.class.getName());
    final SecretKeySpec secret;
    Object dest;
    private boolean error = false;
    private IOException localError;

    FetchTransferState(TransactionID transactionID, int numSegments, Object dest, SecretKeySpec secret) {
        super(transactionID, numSegments);
        this.dest = dest instanceof File ? ((File)dest).getAbsolutePath() : dest;
        this.secret = secret;
        this.segmentNumber = 2;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(IOException reason) {
        this.error = true;
        this.localError = reason;
    }

    public void throwLocalException() throws LocalIOException {
        if (this.localError != null) {
            throw new LocalIOException(this.localError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copy(EbicsSession session, InputStream in) {
        OutputStream out = null;
        try {
            out = this.dest instanceof OutputStream ? (OutputStream)this.dest : (this.dest instanceof String ? new FileOutputStream((String)this.dest) : new FileOutputStream((File)this.dest));
            if (session.getLogDirectory() != null && session.isLogData()) {
                try {
                    File f = new File(session.getLogDirectory(), HexTool.toHex(this.transactionID.getValue()) + ".in");
                    out = new YOutputStream(out, new FileOutputStream(f));
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, "Could not log plain order data", ioe);
                }
            }
            out = EbicsLog.wrapDataOutput(out);
            Streams.copy(in, out);
            out = null;
        }
        catch (IOException ioe) {
            try {
                this.setError(ioe);
            }
            catch (Throwable throwable) {
                SystemUtils.close(out);
                throw throwable;
            }
            SystemUtils.close(out);
        }
        SystemUtils.close(out);
    }

    public Object getDest() {
        return this.dest;
    }
}

