/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.crypto.BCRSAPkcs1PaddingCipher;
import de.businesslogics.ebics.client.BankAuthenticationFailedException;
import de.businesslogics.ebics.client.CertificateAsKey;
import de.businesslogics.ebics.client.EbicsBank;
import de.businesslogics.ebics.client.EbicsBusinessUser;
import de.businesslogics.ebics.client.EbicsHttpEngine;
import de.businesslogics.ebics.client.EbicsHttpEngineImpl;
import de.businesslogics.ebics.client.EbicsLog;
import de.businesslogics.ebics.client.EbicsPartner;
import de.businesslogics.ebics.client.EbicsUser;
import de.businesslogics.ebics.client.FileTransfer;
import de.businesslogics.ebics.client.UserSignature;
import de.businesslogics.ebics.schema.AuthenticableRootElement;
import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.EbicsRootParser;
import de.businesslogics.ebics.schema.EbicsSignatureContentHandler;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SignatureContentHandler;
import de.businesslogics.ebics.schema.SignedInfoSignatureContentHandler;
import de.businesslogics.ebics.schema.h000.EbicsHEVRequest;
import de.businesslogics.ebics.schema.h000.EbicsHEVResponse;
import de.businesslogics.ebics.schema.h000.SystemReturnCode;
import de.businesslogics.ebics.schema.h005.BTUOrderParams;
import de.businesslogics.ebics.schema.keymgmtrequest.EbicsNoPubKeyDigestsRequest;
import de.businesslogics.ebics.schema.keymgmtrequest.NoPubKeyDigestsRequestHeader;
import de.businesslogics.ebics.schema.keymgmtrequest.NoPubKeyDigestsRequestStaticHeader;
import de.businesslogics.ebics.schema.keymgmtrequest.OrderDetails;
import de.businesslogics.ebics.schema.keymgmtresponse.EbicsKeyManagementResponse;
import de.businesslogics.ebics.schema.keymgmtresponse.KeyManagementResponseDataTransfer;
import de.businesslogics.ebics.schema.orders.HPBResponseOrderData;
import de.businesslogics.ebics.schema.orders.HPDResponseOrderData;
import de.businesslogics.ebics.schema.orders.OrderSignature;
import de.businesslogics.ebics.schema.orders.UserSignatureData;
import de.businesslogics.ebics.schema.request.BankPubKeyDigests;
import de.businesslogics.ebics.schema.request.Body;
import de.businesslogics.ebics.schema.request.DataTransfer;
import de.businesslogics.ebics.schema.request.EbicsRequest;
import de.businesslogics.ebics.schema.request.OrderAttribute;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.request.Product;
import de.businesslogics.ebics.schema.request.Static;
import de.businesslogics.ebics.schema.response.AuthenticatedTimeStamp;
import de.businesslogics.ebics.schema.response.AuthenticationFailedException;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.response.EbicsResponse;
import de.businesslogics.ebics.schema.response.InvalidRequestContentException;
import de.businesslogics.ebics.schema.response.MinimalEbicsResponse;
import de.businesslogics.ebics.schema.s001.OrderSignatureDataType;
import de.businesslogics.ebics.schema.sctinst.h005.EbicsInstRequest;
import de.businesslogics.ebics.schema.sctinst.h005.StaticHeaderInstantRequestType;
import de.businesslogics.ebics.schema.sctinst.h005.StaticHeaderOrderDetailsType;
import de.businesslogics.ebics.schema.signature.CanonicalizationMethod;
import de.businesslogics.ebics.schema.signature.DigestMethod;
import de.businesslogics.ebics.schema.signature.Reference;
import de.businesslogics.ebics.schema.signature.SignatureMethod;
import de.businesslogics.ebics.schema.signature.SignatureValue;
import de.businesslogics.ebics.schema.signature.SignedInfo;
import de.businesslogics.ebics.schema.signature.Transform;
import de.businesslogics.ebics.schema.signature.Transforms;
import de.businesslogics.ebics.schema.types.AuthenticationVersion;
import de.businesslogics.ebics.schema.types.DataEncryption;
import de.businesslogics.ebics.schema.types.HostID;
import de.businesslogics.ebics.schema.types.Nonce;
import de.businesslogics.ebics.schema.types.PartnerID;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.ReturnCode;
import de.businesslogics.ebics.schema.types.SecurityMedium;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.ebics.schema.types.UserID;
import de.businesslogics.ebics.security.AuthenticationHandler;
import de.businesslogics.ebics.security.EncryptionHandler;
import de.businesslogics.io.Streams;
import de.businesslogics.io.YInputStream;
import de.businesslogics.io.YOutputStream;
import de.businesslogics.license.NoLicenseException;
import de.businesslogics.license.UnsignedJarLicense;
import de.businesslogics.security.jce.Provider;
import de.businesslogics.util.LogUtils;
import de.businesslogics.util.SystemUtils;
import de.businesslogics.zkasecurity.X001PublicKey;
import de.businesslogics.zkasecurity.X002PublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class EbicsSession {
    private static final String CLASSNAME;
    private static final Logger LOGGER;
    static final boolean SANITY_CHECK;
    static final boolean PEDANTIC_DIGEST;
    @Deprecated
    public static File logDir;
    private File logDirectory;
    private boolean logData;
    private static Product PRODUCT;
    private ProtocolVersion protocolVersion;
    private RSAPublicKey bankEncrKey = null;
    protected byte[] bankEncrDigest;
    private RSAPublicKey bankAuthKey;
    protected byte[] bankAuthDigest;
    HostID bankID;
    private File logFile;
    HPDResponseOrderData bankParameters;
    Date timestampBankParameters;
    Product product = PRODUCT;
    protected final EbicsHttpEngine engine;
    OrderID lastOrderID;
    protected final EbicsUser systemUser;
    protected EbicsBusinessUser businessUser;
    private final SecureRandom random = new SecureRandom();

    public static void setLicense(InputStream in) throws NoLicenseException {
        UnsignedJarLicense lic = new UnsignedJarLicense(in);
        PRODUCT = new Product("bl-ebics", Locale.getDefault(), lic.getProperty("recipient"));
    }

    public EbicsSession(EbicsUser user) {
        this(user, new EbicsHttpEngineImpl());
    }

    public EbicsSession(EbicsUser user, EbicsHttpEngine engine) {
        this.setLog(logDir, true);
        EbicsBank eBank = user.getPartner().getBank();
        this.timestampBankParameters = eBank.getTimestampBankParameters();
        this.bankParameters = eBank.getBankParameters();
        String s = user.getPartner().getBank().getHostId();
        this.bankID = new HostID(s);
        this.systemUser = user;
        this.businessUser = this.systemUser;
        this.engine = engine;
        this.setProtocolVersion(user.getPartner().getBank().getProtocolVersion());
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public boolean isLogData() {
        return this.logData;
    }

    public void setLog(File dir, boolean logData) {
        this.logDirectory = dir;
        this.logData = dir != null && logData;
    }

    public ProtocolVersion getProtocolVersion() {
        if (this.protocolVersion == null) {
            if (this.systemUser.getUserID().length() > 8 || this.businessUser.getUserID().length() > 8 || this.systemUser.getPartnerID().length() > 8 || this.systemUser.getPartner().getBank().getHostId().length() > 8 || !this.businessUser.getSignatureVersion().equals(SignatureVersion.A004)) {
                this.setProtocolVersion(ProtocolVersion.H003);
            } else if (this.bankParameters != null) {
                this.setProtocolVersion(this.bankParameters.getProtocolParams().getVersion().getAuthentication().contains(AuthenticationVersion.X002) ? ProtocolVersion.H003 : ProtocolVersion.H002);
            } else {
                try {
                    this.setProtocolVersion(this.getEbicsVersions().canH003() ? ProtocolVersion.H003 : ProtocolVersion.H002);
                }
                catch (Throwable t) {
                    LogUtils.logp(LOGGER, Level.INFO, LOGGER.getName(), "getProtocolVersion", "Could not fetch ebics versions", t);
                    this.setProtocolVersion(ProtocolVersion.H002);
                }
            }
        }
        return this.protocolVersion;
    }

    public EncryptionHandler getEncryptionHandler() {
        return EncryptionHandler.getInstance(this.getProtocolVersion());
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return AuthenticationHandler.getInstance(this.getProtocolVersion());
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        if (!protocolVersion.equals(this.protocolVersion)) {
            this.protocolVersion = protocolVersion;
            this.bankEncrKey = null;
            this.bankAuthKey = null;
            this.bankAuthDigest = null;
            this.bankEncrDigest = null;
        }
    }

    public RSAPublicKey getBankEncrKey() throws IOException, EbicsException {
        if (this.bankEncrKey == null) {
            this.getBankKeys(true);
        }
        return this.bankEncrKey;
    }

    public RSAPublicKey getBankAuthKey() throws IOException, EbicsException {
        if (this.bankAuthKey == null) {
            this.getBankKeys(true);
        }
        return this.bankAuthKey;
    }

    public HostID getBankID() {
        return this.bankID;
    }

    public HPDResponseOrderData getBankParameters() throws IOException, EbicsException {
        if (this.bankParameters != null) {
            return this.bankParameters;
        }
        FileTransfer transfer = new FileTransfer(this);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        transfer.fetchFile(OrderType.HPD, null, null, bos);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        try {
            ProtocolVersion pv = this.getProtocolVersion();
            this.bankParameters = new HPDResponseOrderData(pv);
            EbicsRootParser p = new EbicsRootParser(pv.getNamespace(), this.bankParameters);
            EbicsHandler.parse(bis, p, pv.getNamespaceSchemaLocation());
        }
        catch (SAXException se) {
            IOException toThrow = new IOException("Invalid server XML");
            toThrow.initCause(se);
            throw toThrow;
        }
        if (this.timestampBankParameters != null) {
            this.systemUser.getPartner().getBank().setBankParameters(this.timestampBankParameters, this.bankParameters);
        }
        return this.bankParameters;
    }

    public EbicsHEVResponse getEbicsVersions() throws IOException, EbicsException {
        return EbicsSession.getEbicsVersions(this.systemUser.getPartner().getBank(), this.engine);
    }

    public static EbicsHEVResponse getEbicsVersions(EbicsBank bank, EbicsHttpEngine engine) throws IOException, EbicsException {
        return EbicsSession.getEbicsVersions(bank.getURL(), bank.getHostId(), engine, logDir);
    }

    public static EbicsHEVResponse getEbicsVersions(EbicsBank bank, EbicsHttpEngine engine, File logDir) throws IOException, EbicsException {
        return EbicsSession.getEbicsVersions(bank.getURL(), bank.getHostId(), engine, logDir);
    }

    public static EbicsHEVResponse getEbicsVersions(URL url, String hostId, EbicsHttpEngine engine) throws IOException, EbicsException {
        return EbicsSession.getEbicsVersions(url, hostId, engine, logDir);
    }

    public static EbicsHEVResponse getEbicsVersions(URL url, String hostId, EbicsHttpEngine engine, File logDir) throws IOException, EbicsException {
        EbicsHEVResponse ebicsHEVResponse;
        block15: {
            EbicsHEVRequest request = new EbicsHEVRequest(new HostID(hostId));
            File logFile = EbicsSession.createLogFile(logDir);
            try (OutputStream os = EbicsSession.openURL(engine, url, logFile);){
                EbicsPrintStream eps = new EbicsPrintStream(os);
                eps.printOut(request);
            }
            InputStream is = EbicsSession.readResponse(engine, logFile);
            try {
                EbicsRootParser p = new EbicsRootParser("http://www.ebics.org/H000", new EbicsHEVResponse());
                EbicsHEVResponse toReturn = (EbicsHEVResponse)EbicsHandler.parse(is, p, "http://www.ebics.org/H000 http://www.ebics.org/H000/ebics_hev.xsd");
                SystemReturnCode src = toReturn.getSystemReturnCode();
                src.getReturnCode().throwException(src.getReportText());
                ebicsHEVResponse = toReturn;
                if (is == null) break block15;
            }
            catch (Throwable p) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            p.addSuppressed(throwable);
                        }
                    }
                    throw p;
                }
                catch (SAXException se) {
                    IOException ioe = new IOException("Invalid server XML");
                    ioe.initCause(se);
                    throw ioe;
                }
            }
            is.close();
        }
        return ebicsHEVResponse;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public void setBusinessUser(EbicsBusinessUser user) {
        this.businessUser = user;
    }

    public EbicsBusinessUser getBusinessUser() {
        return this.businessUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HPBResponseOrderData getHPB() throws IOException, EbicsException {
        HPBResponseOrderData hpb;
        OrderDetails orderDetails = new OrderDetails(OrderType.HPB, null, this.protocolVersion.compareTo(ProtocolVersion.H004) <= 0 ? OrderAttribute.DZHNN : null);
        EbicsPartner partner = this.systemUser.getPartner();
        byte[] nonceBytes = new byte[16];
        SecureRandom secureRandom = this.random;
        synchronized (secureRandom) {
            this.random.nextBytes(nonceBytes);
        }
        NoPubKeyDigestsRequestStaticHeader staticHeader = new NoPubKeyDigestsRequestStaticHeader(new HostID(partner.getBank().getHostId()), new Nonce(nonceBytes), new TimeStamp(), new PartnerID(partner.getPartnerID()), new UserID(this.businessUser.getUserID()), orderDetails, new SecurityMedium("0000"));
        staticHeader.setProduct(this.product);
        if (this.businessUser != this.systemUser) {
            staticHeader.setSystemID(new UserID(this.systemUser.getUserID()));
        }
        NoPubKeyDigestsRequestHeader header = new NoPubKeyDigestsRequestHeader(staticHeader);
        EbicsNoPubKeyDigestsRequest ebics = new EbicsNoPubKeyDigestsRequest(this.protocolVersion, header);
        EbicsKeyManagementResponse rebics = (EbicsKeyManagementResponse)this.sendRequest(null, ebics, EbicsKeyManagementResponse.createParser(ebics.getVersion()));
        rebics.checkOK();
        try {
            KeyManagementResponseDataTransfer dt = rebics.getBody().getDataTransfer();
            SecretKeySpec secretKey = this.decrypt(dt.getDataEncryption());
            dt.decrypt(this.getEncryptionHandler(), secretKey);
            InputStream is = dt.getOrderData();
            try {
                if (this.logFile != null) {
                    FileOutputStream fos = new FileOutputStream(this.logFile, true);
                    is = new YInputStream(is, fos);
                    fos.write("\n***** HPB \n".getBytes());
                }
                is = EbicsLog.wrapDataInput(is);
                ProtocolVersion pv = rebics.getVersion();
                hpb = new HPBResponseOrderData(pv);
                EbicsRootParser p = new EbicsRootParser(rebics.getVersion().getNamespace(), hpb);
                EbicsHandler.parse(is, p, pv.getNamespaceSchemaLocation());
                is = null;
            }
            finally {
                SystemUtils.close(is);
            }
        }
        catch (SAXException se) {
            IOException toThrow = new IOException("Invalid server XML");
            toThrow.initCause(se);
            throw toThrow;
        }
        return hpb;
    }

    synchronized void getBankKeys(boolean usePersistedKeys) throws IOException, EbicsException {
        byte[] bkAuthDigest;
        byte[] bkEncrDigest;
        EncryptionHandler eh = this.getEncryptionHandler();
        AuthenticationHandler ah = this.getAuthenticationHandler();
        if (usePersistedKeys) {
            if (this.bankEncrKey != null && this.bankAuthKey != null) {
                return;
            }
            EbicsBank bank = this.systemUser.getPartner().getBank();
            this.bankEncrKey = bank.getEncrKey(this.protocolVersion);
            this.bankAuthKey = bank.getAuthKey(this.protocolVersion);
            if (this.bankEncrKey != null && this.bankAuthKey != null) {
                try {
                    if (this.protocolVersion.compareTo(ProtocolVersion.H005) >= 0) {
                        this.bankEncrDigest = eh.getCertDigest(((CertificateAsKey)this.bankEncrKey).getCertificate());
                        this.bankAuthDigest = eh.getCertDigest(((CertificateAsKey)this.bankAuthKey).getCertificate());
                    } else {
                        this.bankEncrDigest = eh.getHash(this.bankEncrKey);
                        this.bankAuthDigest = ah.getHash(this.bankAuthKey);
                    }
                    return;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        HPBResponseOrderData hpb = this.getHPB();
        RSAPublicKey bkEncrKey = hpb.getEncryptionPubKeyInfo().getPublicKey();
        RSAPublicKey bkAuthKey = hpb.getAuthenticationPubKeyInfo().getPublicKey();
        if (this.protocolVersion.compareTo(ProtocolVersion.H005) >= 0) {
            bkEncrDigest = eh.getCertDigest(hpb.getEncryptionPubKeyInfo().getX509Data());
            bkAuthDigest = eh.getCertDigest(hpb.getAuthenticationPubKeyInfo().getX509Data());
        } else {
            X509Certificate x509;
            RSAPublicKey rsa;
            if (!(hpb.getEncryptionPubKeyInfo().getX509Data() == null || (rsa = (RSAPublicKey)(x509 = (X509Certificate)hpb.getEncryptionPubKeyInfo().getX509Data().getMainKey()[0]).getPublicKey()).getModulus().equals(bkEncrKey.getModulus()) && rsa.getPublicExponent().equals(bkEncrKey.getPublicExponent()))) {
                throw new RuntimeException("Encryption key does not match certificate");
            }
            if (!(hpb.getAuthenticationPubKeyInfo().getX509Data() == null || (rsa = (RSAPublicKey)(x509 = (X509Certificate)hpb.getAuthenticationPubKeyInfo().getX509Data().getMainKey()[0]).getPublicKey()).getModulus().equals(bkAuthKey.getModulus()) && rsa.getPublicExponent().equals(bkAuthKey.getPublicExponent()))) {
                throw new RuntimeException("Authentication key does not match certificate");
            }
            bkEncrDigest = eh.getHash(bkEncrKey);
            bkAuthDigest = ah.getHash(bkAuthKey);
        }
        this.systemUser.getPartner().getBank().setBankKeys(this.protocolVersion, hpb.getEncryptionPubKeyInfo(), bkEncrDigest, hpb.getAuthenticationPubKeyInfo(), bkAuthDigest);
        this.bankEncrKey = bkEncrKey;
        this.bankEncrDigest = bkEncrDigest;
        this.bankAuthKey = bkAuthKey;
        this.bankAuthDigest = bkAuthDigest;
    }

    public static boolean verifyNewKey(RSAPublicKey newKey, RSAPublicKey oldKey) {
        if (oldKey == null) {
            return false;
        }
        if (oldKey.getModulus().equals(newKey.getModulus()) && oldKey.getPublicExponent().equals(newKey.getPublicExponent())) {
            return true;
        }
        if (!(newKey instanceof CertificateAsKey)) {
            return false;
        }
        CertificateAsKey cKey = (CertificateAsKey)newKey;
        X509Certificate x509 = Provider.convertX509Data(cKey.getCertificate()).get(0);
        try {
            Signature s = Signature.getInstance("SHA256withRSA");
            s.initVerify(oldKey);
            s.update(x509.getTBSCertificate());
            return s.verify(x509.getSignature());
        }
        catch (Exception e) {
            LogUtils.logp(LOGGER, Level.INFO, CLASSNAME, "verifyNewKey", e);
            return false;
        }
    }

    public EbicsResponse sendSignedRequest(EbicsRequest ebics) throws IOException, EbicsException {
        EbicsResponse toReturn = this.sendSigned(ebics);
        if (toReturn.getHeader().getMutable().getReturnCode().equals(ReturnCode.EBICS_TX_RECOVERY_SYNC)) {
            throw new EbicsException(ReturnCode.EBICS_TX_RECOVERY_SYNC);
        }
        return toReturn;
    }

    EbicsResponse sendSigned(EbicsRequest ebics) throws IOException, EbicsException {
        if (ebics.getHeader().getStatic().getC1().getInitialisation() != null) {
            Body.InitialisationBody ib = ebics.getBody().getInitialisationBody();
            DataTransfer dt = ib != null ? ib.getDataTransfer() : null;
            this.logSignatureData(dt);
            if (dt != null) {
                this.encrypt(ebics.getHeader().getStatic(), dt);
            }
        }
        return this.sendSignedInternal(ebics, ebics.getVersion());
    }

    EbicsResponse sendSigned(EbicsInstRequest ebics) throws IOException, EbicsException {
        this.encrypt(ebics.getHeader(), (DataTransfer)ebics.getBody().getDataTransfer());
        return this.sendSignedInternal(ebics, ebics.getVersion());
    }

    private EbicsResponse sendSignedInternal(EbicsRootElement ebics, ProtocolVersion pv) throws IOException, EbicsException {
        byte[] signedDigest;
        OrderID tmp;
        EbicsSignatureContentHandler sch1 = new EbicsSignatureContentHandler();
        SignedInfoSignatureContentHandler sch2 = new SignedInfoSignatureContentHandler();
        sch2.setNextHandler(sch1);
        EbicsResponse rebics = (EbicsResponse)this.sendRequest(sch2, ebics, EbicsResponse.createParser(pv));
        if (rebics.getVersion().getVersion() >= 4 && (tmp = rebics.getHeader().getMutable().getOrderID()) != null) {
            this.lastOrderID = tmp;
        }
        rebics.getHeader().getMutable().throwException();
        de.businesslogics.ebics.schema.signature.Signature signature = rebics.getAuthSignature();
        SignedInfo sInfo = signature.getSignedInfo();
        try {
            sInfo.checkAuthentication(pv, sch1.digest().digest());
        }
        catch (AuthenticationFailedException afe) {
            throw new BankAuthenticationFailedException(afe);
        }
        try {
            BCRSAPkcs1PaddingCipher rsa = new BCRSAPkcs1PaddingCipher();
            rsa.init(2, this.getBankAuthKey());
            signedDigest = rsa.doFinal(signature.getSignatureValue().getValue());
        }
        catch (GeneralSecurityException gse) {
            IOException ioe = new IOException("Malformed signature or strange security setup");
            ioe.initCause(gse);
            throw ioe;
        }
        byte[] expected = pv.equals(ProtocolVersion.H002) ? X001PublicKey.digest(sch2.digest()) : X002PublicKey.digest(sch2.digest());
        if (!Arrays.equals(signedDigest, expected)) {
            throw new IOException("Wrong signature");
        }
        rebics.checkOK();
        return rebics;
    }

    MinimalEbicsResponse sendRequest(EbicsRootElement ebics, ElementParser ebicsParser) throws IOException, EbicsException {
        return this.sendRequest(null, ebics, ebicsParser);
    }

    private MinimalEbicsResponse sendRequest(SignatureContentHandler signatureHandler, EbicsRootElement ebics, ElementParser ebicsParser) throws IOException, EbicsException {
        EbicsHandler handler;
        SAXParser parser;
        this.createLog();
        if (ebics instanceof AuthenticableRootElement) {
            SignatureMethod signatureMethod;
            DigestMethod digestMethod;
            SignatureContentHandler sch = new EbicsSignatureContentHandler();
            EbicsPrintStream eps = new EbicsPrintStream(sch);
            eps.printOut(ebics);
            if (this.protocolVersion == ProtocolVersion.H002) {
                digestMethod = DigestMethod.SHA1;
                signatureMethod = SignatureMethod.RSA_SHA1;
            } else {
                digestMethod = DigestMethod.SHA256;
                signatureMethod = SignatureMethod.RSA_SHA256;
            }
            Reference reference = new Reference("#xpointer(//*[@authenticate='true'])", new Transforms(Transform.C14N), digestMethod, new Base64Element(sch.digest().digest()));
            SignedInfo sInfo = new SignedInfo(CanonicalizationMethod.C14N, signatureMethod, reference);
            SignatureValue sValue = new SignatureValue();
            de.businesslogics.ebics.schema.signature.Signature signature = new de.businesslogics.ebics.schema.signature.Signature(sInfo, sValue);
            ((AuthenticableRootElement)((Object)ebics)).setAuthSignature(signature);
            sch = new SignedInfoSignatureContentHandler();
            eps = new EbicsPrintStream(sch);
            eps.printOut(ebics);
            if (this.protocolVersion == ProtocolVersion.H002) {
                sValue.setSignature(this.systemUser.authenticate(X001PublicKey.digest(sch.digest())));
            } else {
                sValue.setSignature(this.systemUser.authenticate(X002PublicKey.digest(sch.digest())));
            }
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(EbicsHandler.VALIDATE);
        factory.setNamespaceAware(true);
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception e) {
            LogUtils.logp(LOGGER, Level.FINE, LOGGER.getName(), "sendRequest", "Failed to disallow DOCTYPE declaration!", e);
        }
        try {
            parser = factory.newSAXParser();
            if (factory.isValidating()) {
                XMLReader xmlReader = parser.getXMLReader();
                xmlReader.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
                xmlReader.setFeature("http://xml.org/sax/features/validation", true);
                xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                xmlReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", this.protocolVersion.getNamespaceSchemaLocation());
                if (!xmlReader.getFeature("http://xml.org/sax/features/use-attributes2")) {
                    throw new RuntimeException("http://xml.org/sax/features/use-attributes2");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("No parser available", e);
        }
        URL url = this.systemUser.getPartner().getBank().getURL();
        try (OutputStream os = EbicsSession.openURL(this.engine, url, this.logFile);){
            EbicsPrintStream eps = new EbicsPrintStream(os);
            eps.printOut(ebics);
        }
        try (InputStream iStream = EbicsSession.readResponse(this.engine, this.logFile);){
            InputSource is = new InputSource(iStream);
            handler = new EbicsHandler(ebicsParser);
            handler.setSignatureHandler(signatureHandler);
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (SAXException se) {
            IOException ioe = new IOException("Invalid server XML");
            ioe.initCause(se);
            throw ioe;
        }
        MinimalEbicsResponse toReturn = (MinimalEbicsResponse)handler.getRoot();
        AuthenticatedTimeStamp ats = toReturn.getTimestampBankParameters();
        if (ats != null) {
            Date d = ats.getDate();
            if (this.timestampBankParameters == null || this.timestampBankParameters.before(d)) {
                this.timestampBankParameters = d;
                this.bankParameters = null;
                this.systemUser.getPartner().getBank().setBankParameters(this.timestampBankParameters, null);
            }
        }
        return toReturn;
    }

    OrderID nextOrderID(OrderType orderType, OrderID proposed) {
        if (this.getProtocolVersion().getVersion() >= 4) {
            this.lastOrderID = null;
            return null;
        }
        if (proposed != null) {
            this.lastOrderID = proposed;
            return this.lastOrderID;
        }
        this.lastOrderID = new OrderID(this.systemUser.getPartner().nextOrderID(orderType.getValue()));
        return this.lastOrderID;
    }

    public Static createStaticHeader(OrderType orderType, OrderID orderID, OrderAttribute orderAttribute, SecurityMedium securityMedium, EbicsElement orderParams) {
        return this.createStaticHeader(orderType, orderID, orderAttribute, securityMedium, orderParams, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Static createStaticHeader(OrderType orderType, OrderID orderID, OrderAttribute orderAttribute, SecurityMedium securityMedium, EbicsElement orderParams, Nonce nonce) {
        TimeStamp timestamp;
        EbicsPartner partner = this.systemUser.getPartner();
        if (securityMedium == null) {
            securityMedium = new SecurityMedium(this.businessUser.getSecurityMedium());
        }
        if (orderType.equals(OrderType.HIA) || orderType.equals(OrderType.INI) || orderType.equals(OrderType.HSA)) {
            nonce = null;
            timestamp = null;
        } else {
            if (nonce == null) {
                byte[] nonceBytes = new byte[16];
                SecureRandom secureRandom = this.random;
                synchronized (secureRandom) {
                    this.random.nextBytes(nonceBytes);
                }
                nonce = new Nonce(nonceBytes);
            }
            timestamp = new TimeStamp();
        }
        de.businesslogics.ebics.schema.request.OrderDetails orderDetails = new de.businesslogics.ebics.schema.request.OrderDetails(orderType, orderID, this.protocolVersion.compareTo(ProtocolVersion.H005) >= 0 ? null : orderAttribute, orderParams);
        PartnerID partnerID = new PartnerID(partner.getPartnerID());
        UserID userID = new UserID(this.businessUser.getUserID());
        UserID systemID = this.businessUser == this.systemUser ? null : new UserID(this.systemUser.getUserID());
        return new Static(this.bankID, new Static.Initialisation(nonce, timestamp, partnerID, userID, systemID, this.product, orderDetails, securityMedium));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticHeaderInstantRequestType createStaticInstHeader(SecurityMedium securityMedium, BTUOrderParams btu, Nonce nonce) {
        EbicsPartner partner = this.systemUser.getPartner();
        if (securityMedium == null) {
            securityMedium = new SecurityMedium(this.businessUser.getSecurityMedium());
        }
        if (nonce == null) {
            byte[] nonceBytes = new byte[16];
            SecureRandom secureRandom = this.random;
            synchronized (secureRandom) {
                this.random.nextBytes(nonceBytes);
            }
            nonce = new Nonce(nonceBytes);
        }
        TimeStamp timestamp = new TimeStamp();
        StaticHeaderOrderDetailsType orderDetails = new StaticHeaderOrderDetailsType(btu);
        PartnerID partnerID = new PartnerID(partner.getPartnerID());
        UserID userID = new UserID(this.businessUser.getUserID());
        return new StaticHeaderInstantRequestType(this.bankID, nonce, timestamp, partnerID, userID, orderDetails, securityMedium);
    }

    PartnerID getPartnerID() {
        return new PartnerID(this.systemUser.getPartner().getPartnerID());
    }

    public OrderID getLastOrderID() {
        return this.lastOrderID;
    }

    UserID getBusinessUserID() {
        return new UserID(this.businessUser.getUserID());
    }

    private static OutputStream openURL(EbicsHttpEngine engine, URL url, File logFile) throws IOException {
        OutputStream toReturn = engine.getOutputStream(url);
        if (logFile != null) {
            try {
                FileOutputStream fos = new FileOutputStream(logFile, true);
                toReturn = new YOutputStream(fos, toReturn);
                fos.write(("\n****** request " + String.valueOf(url) + " " + String.valueOf(new Date()) + "\n").getBytes());
            }
            catch (IOException ioe) {
                SystemUtils.close(toReturn);
                throw ioe;
            }
        }
        return toReturn;
    }

    private static InputStream readResponse(EbicsHttpEngine engine, File logFile) throws IOException {
        InputStream toReturn = engine.getInputStream();
        if (logFile != null) {
            try {
                FileOutputStream fos = new FileOutputStream(logFile, true);
                toReturn = new YInputStream(toReturn, fos);
                fos.write("\n****** response \n".getBytes());
            }
            catch (IOException ioe) {
                SystemUtils.close(toReturn);
                throw ioe;
            }
        }
        return toReturn;
    }

    void createLog() {
        if (this.logFile == null) {
            this.logFile = EbicsSession.createLogFile(this.logDirectory);
        }
    }

    private static File createLogFile(File logDirectory) {
        if (logDirectory != null) {
            try {
                if (!logDirectory.exists()) {
                    logDirectory.mkdirs();
                }
                return File.createTempFile("ebicsClient", ".http", logDirectory);
            }
            catch (IOException ioe) {
                LOGGER.logp(Level.SEVERE, CLASSNAME, "createLogFile", "Cannot log", ioe);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logSignatureData(DataTransfer dt) {
        block7: {
            if (dt == null || dt.isEncrypted()) {
                return;
            }
            if (this.logFile == null && !EbicsLog.isActive()) {
                return;
            }
            try {
                OutputStream os;
                InputStream is;
                block8: {
                    is = dt.getSignatureStream();
                    if (is == null) break block7;
                    os = null;
                    try {
                        if (this.logFile != null) {
                            os = new FileOutputStream(this.logFile, true);
                            os.write("\n****** Signature data for next request\n".getBytes());
                        }
                        if ((os = EbicsLog.wrapSignatureOutput(os)) == null) break block8;
                        Streams.copy(is, os);
                        os = null;
                        is = null;
                    }
                    catch (Throwable throwable) {
                        SystemUtils.close(os);
                        SystemUtils.close(is);
                        throw throwable;
                    }
                }
                SystemUtils.close(os);
                SystemUtils.close(is);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not trace data", e);
            }
        }
    }

    SecretKeySpec decrypt(DataEncryption de) throws IOException, InvalidRequestContentException {
        EncryptionHandler handler = EncryptionHandler.getInstance(this.protocolVersion);
        boolean digestMatches = false;
        if (this.protocolVersion.compareTo(ProtocolVersion.H005) >= 0 && this.systemUser.getEncrPubKey() instanceof CertificateAsKey) {
            CertificateAsKey csk = (CertificateAsKey)this.systemUser.getEncrPubKey();
            digestMatches = handler.verifyDigest(de.getEncryptionPubKeyDigest(), handler.getCertDigest(csk.getCertificate()));
        }
        if (!digestMatches && !handler.verifyDigest(de.getEncryptionPubKeyDigest(), this.systemUser.getEncrPubKey())) {
            if (PEDANTIC_DIGEST) {
                throw new IOException("Server uses the wrong encryption digest");
            }
            LOGGER.log(Level.WARNING, "Server uses the wrong encryption digest.");
        }
        try {
            return handler.getDecoded(this.systemUser.decrypt(de.getTransactionKey().getValue()));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            IOException toThrow = new IOException("Malformed server response");
            toThrow.initCause(e);
            throw toThrow;
        }
    }

    private void encrypt(Static staticHeader, DataTransfer dataTransfer) throws IOException, EbicsException {
        this.getBankEncrKey();
        EncryptionHandler ehandler = this.getEncryptionHandler();
        AuthenticationHandler ahandler = this.getAuthenticationHandler();
        dataTransfer.encrypt(ehandler, this.getBankEncrKey(), this.bankEncrDigest, null);
        BankPubKeyDigests bd = new BankPubKeyDigests(ahandler.createPubKeyDigest(this.bankAuthDigest), ehandler.createPubKeyDigest(this.bankEncrDigest));
        EbicsElement ee = staticHeader.getC1().getElement();
        if (ee instanceof Static.Initialisation) {
            ((Static.Initialisation)ee).setBankPubKeyDigests(bd);
        }
    }

    private void encrypt(StaticHeaderInstantRequestType staticHeader, DataTransfer dataTransfer) throws IOException, EbicsException {
        this.getBankEncrKey();
        EncryptionHandler ehandler = this.getEncryptionHandler();
        AuthenticationHandler ahandler = this.getAuthenticationHandler();
        dataTransfer.encrypt(ehandler, this.getBankEncrKey(), this.bankEncrDigest, null);
        staticHeader.setBankPubKeyDigests(ahandler.createPubKeyDigest(this.bankAuthDigest));
    }

    protected void addSignatureData(UserSignatureData usd, EbicsBusinessUser user, byte[] digest, String filename, Date fileDate, String orderType) {
        byte[] signature = user.sign(digest, filename, fileDate, orderType);
        if (user.getSignatureVersion().equals(SignatureVersion.A004)) {
            if (this.protocolVersion.compareTo(ProtocolVersion.H005) < 0) {
                OrderSignature os = new OrderSignature(new PartnerID(user.getPartnerID()), signature);
                usd.getSignatures().add(os);
                return;
            }
            if (SANITY_CHECK) {
                throw new IllegalArgumentException("A004 not allowed in protocol version " + String.valueOf(this.protocolVersion));
            }
        }
        OrderSignatureDataType os = new OrderSignatureDataType(user.getSignatureVersion(), new Base64Element(signature), new PartnerID(user.getPartnerID()), new UserID(user.getUserID()));
        usd.getSignatures().add(os);
    }

    protected void addSignatureData(UserSignatureData usd, UserSignature signature) {
        if (signature.getVersion().equals(SignatureVersion.A004)) {
            if (this.protocolVersion.compareTo(ProtocolVersion.H005) < 0) {
                OrderSignature os = new OrderSignature(signature.getPartner(), signature.getSignature());
                usd.getSignatures().add(os);
                return;
            }
            if (SANITY_CHECK) {
                throw new IllegalArgumentException("A004 not allowed in protocol version " + String.valueOf(this.protocolVersion));
            }
        }
        OrderSignatureDataType os = new OrderSignatureDataType(signature.getVersion(), new Base64Element(signature.getSignature()), signature.getPartner(), signature.getUser());
        usd.getSignatures().add(os);
    }

    static {
        InputStream in;
        CLASSNAME = EbicsSession.class.getName();
        LOGGER = Logger.getLogger(CLASSNAME);
        SANITY_CHECK = Boolean.parseBoolean(System.getProperty("de.businesslogics.ebics.client.EbicsSession.sanityCheck", "true"));
        PEDANTIC_DIGEST = Boolean.parseBoolean(System.getProperty("de.businesslogics.ebics.client.EbicsSession.pedanticDigest", "false"));
        PRODUCT = null;
        String dir = System.getProperty("de.businesslogics.ebics.client.EbicsSession.logDir");
        if (dir != null) {
            logDir = new File(dir);
        }
        if ((in = EbicsSession.class.getResourceAsStream("/de/businesslogics/ebics/license")) == null) {
            in = EbicsSession.class.getResourceAsStream("/de/businesslogics/license/License.license");
        }
        if (in != null) {
            EbicsSession.setLicense(in);
        }
    }
}

