/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.io.YInputStream;
import de.businesslogics.io.YOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class EbicsLog {
    private static volatile ThreadLocal<EbicsLog> threadLocal;
    private EbicsLog oldLog;

    static OutputStream wrapDataOutput(OutputStream os) {
        if (threadLocal == null) {
            return os;
        }
        EbicsLog ebicsLog = threadLocal.get();
        if (ebicsLog == null) {
            return os;
        }
        OutputStream log = ebicsLog.getDataOutput();
        if (log == null) {
            return os;
        }
        if (os == null) {
            return log;
        }
        return new YOutputStream(os, log);
    }

    static OutputStream wrapSignatureOutput(OutputStream os) {
        if (threadLocal == null) {
            return os;
        }
        EbicsLog ebicsLog = threadLocal.get();
        if (ebicsLog == null) {
            return os;
        }
        OutputStream log = ebicsLog.getSignatureOutput();
        if (log == null) {
            return os;
        }
        if (os == null) {
            return log;
        }
        return new YOutputStream(os, log);
    }

    static InputStream wrapDataInput(InputStream is) {
        if (threadLocal == null) {
            return is;
        }
        EbicsLog ebicsLog = threadLocal.get();
        if (ebicsLog == null) {
            return is;
        }
        OutputStream log = ebicsLog.getDataOutput();
        if (log == null) {
            return is;
        }
        return new YInputStream(is, log);
    }

    static boolean isActive() {
        return threadLocal != null && threadLocal.get() != null;
    }

    protected abstract OutputStream getDataOutput();

    protected OutputStream getSignatureOutput() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void use() {
        if (threadLocal == null) {
            Class<EbicsLog> clazz = EbicsLog.class;
            // MONITORENTER : de.businesslogics.ebics.client.EbicsLog.class
            if (threadLocal == null) {
                threadLocal = new ThreadLocal();
            }
            // MONITOREXIT : clazz
        }
        this.oldLog = threadLocal.get();
        threadLocal.set(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void overwrite() {
        if (threadLocal == null) {
            Class<EbicsLog> clazz = EbicsLog.class;
            // MONITORENTER : de.businesslogics.ebics.client.EbicsLog.class
            if (threadLocal == null) {
                threadLocal = new ThreadLocal();
            }
            // MONITOREXIT : clazz
        }
        threadLocal.set(this);
    }

    public void unuse() {
        if (threadLocal != null) {
            threadLocal.set(this.oldLog);
        }
    }
}

