/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.ebics.client.EbicsHttpEngine;
import de.businesslogics.util.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.x500.X500Principal;

public class EbicsHttpEngineImpl
implements EbicsHttpEngine {
    private static final String CLASSNAME = EbicsHttpEngineImpl.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASSNAME);
    private static SSLSocketFactory defaultSocketFactory;
    private static HostnameVerifier defaultHostnameVerifier;
    private static int defaultConnectTimout;
    private static int defaultReadTimeout;
    private static final String PROXY_HOST;
    private static final int PROXY_PORT;
    private SSLSocketFactory sslSocketFactory = defaultSocketFactory;
    private URLConnection connection;

    @Deprecated
    public static SSLSocketFactory wrapSocketFactory(SSLContext sslContext) {
        return sslContext.getSocketFactory();
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier verifier) {
        defaultHostnameVerifier = verifier;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        LOGGER.entering("EbicsHttpEngineImpl", "getInputStream");
        InputStream toReturn = this.connection.getInputStream();
        LOGGER.exiting("EbicsHttpEngineImpl", "getInputStream");
        return toReturn;
    }

    @Override
    public OutputStream getOutputStream(URL url) throws IOException {
        LOGGER.entering("EbicsHttpEngineImpl", "getOutputStream");
        this.connection = this.connect(url);
        this.connection.setRequestProperty("Content-Type", "application/xml");
        this.sslSetupConnection();
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
        if (defaultConnectTimout >= 0) {
            this.connection.setConnectTimeout(defaultConnectTimout);
        }
        if (defaultReadTimeout >= 0) {
            this.connection.setReadTimeout(defaultReadTimeout);
        }
        OutputStream toReturn = this.connection.getOutputStream();
        this.logConnectionInfo();
        LOGGER.exiting("EbicsHttpEngineImpl", "getOutputStream");
        return toReturn;
    }

    protected void logConnectionInfo() {
        LOGGER.config("SSL cipher is " + ((HttpsURLConnection)this.connection).getCipherSuite());
    }

    protected URLConnection connect(URL url) throws IOException {
        if (PROXY_HOST != null) {
            Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(PROXY_HOST, PROXY_PORT));
            return url.openConnection(p);
        }
        return url.openConnection();
    }

    public static void setSSLContext(SSLContext context) {
        defaultSocketFactory = EbicsHttpEngineImpl.wrapSocketFactory(context);
    }

    public void setSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
    }

    public static SSLSocketFactory getDefaultSocketFactory() {
        return defaultSocketFactory;
    }

    public static int getDefaultConnectTimout() {
        return defaultConnectTimout;
    }

    public static void setDefaultConnectTimeout(int defaultConnectTimout) {
        EbicsHttpEngineImpl.defaultConnectTimout = defaultConnectTimout;
    }

    public static int getDefaultReadTimeout() {
        return defaultReadTimeout;
    }

    public static void setDefaultReadTimeout(int defaultReadTimeout) {
        EbicsHttpEngineImpl.defaultReadTimeout = defaultReadTimeout;
    }

    protected URLConnection getConnection() {
        return this.connection;
    }

    protected void sslSetupConnection() {
        LOGGER.entering("EbicsHttpEngine", "sslSetupConnection");
        HttpsURLConnection httpsUrlConnection = (HttpsURLConnection)this.connection;
        httpsUrlConnection.setSSLSocketFactory(this.sslSocketFactory);
        httpsUrlConnection.setHostnameVerifier(defaultHostnameVerifier != null ? defaultHostnameVerifier : new InternalHostnameVerifier());
        LOGGER.exiting("EbicsHttpEngine", "sslSetupConnection");
    }

    public static void setSSLSocketFactory(HttpsURLConnection con) {
        con.setSSLSocketFactory(defaultSocketFactory);
        con.setHostnameVerifier(defaultHostnameVerifier != null ? defaultHostnameVerifier : new InternalHostnameVerifier());
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerifier != null ? defaultHostnameVerifier : new InternalHostnameVerifier();
    }

    static {
        defaultHostnameVerifier = null;
        defaultConnectTimout = Integer.valueOf(System.getProperty("de.businesslogics.ebics.client.EbicsHttpEngineImpl.defaultConnectTimeout", "-1"));
        defaultReadTimeout = Integer.valueOf(System.getProperty("de.businesslogics.ebics.client.EbicsHttpEngineImpl.defaultReadTimeout", "-1"));
        PROXY_HOST = System.getProperty("de.businesslogics.ebics.client.EbicsHttpEngineImpl.proxyHost");
        PROXY_PORT = Integer.valueOf(System.getProperty("de.businesslogics.ebics.client.EbicsHttpEngineImpl.proxyPort", "80"));
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, new SecureRandom());
            defaultSocketFactory = EbicsHttpEngineImpl.wrapSocketFactory(sslContext);
            System.setProperty("sun.net.http.retryPost", "false");
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
    }

    public static class InternalHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            Certificate[] certs;
            try {
                certs = session.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                LogUtils.logp(LOGGER, Level.WARNING, "HostnameVerifer", "verify", "no certificates", e);
                return false;
            }
            if (!(certs[0] instanceof X509Certificate)) {
                LOGGER.warning("No X509 certificate");
                return false;
            }
            X509Certificate x509 = (X509Certificate)certs[0];
            X500Principal p = x509.getSubjectX500Principal();
            String certHostname = p.getName("RFC2253");
            int i = certHostname.indexOf("CN=") + 3;
            if (i < 3) {
                LOGGER.warning("CN= not found in " + certHostname);
                return false;
            }
            int i2 = certHostname.indexOf(44, i);
            certHostname = i2 > 0 ? certHostname.substring(i, i2) : certHostname.substring(i);
            if (!(certHostname = certHostname.trim()).equalsIgnoreCase(hostname)) {
                LOGGER.warning("Hostname differs " + hostname + "!=" + certHostname);
                return false;
            }
            LOGGER.info("Verified " + hostname);
            return true;
        }
    }
}

