/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.ebics.client.AustrianBTFTranslator;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.client.EbicsBusinessUser;
import de.businesslogics.ebics.client.EbicsSession;
import de.businesslogics.ebics.client.FetchTransferState;
import de.businesslogics.ebics.client.FileTransfer;
import de.businesslogics.ebics.client.SwissBTFTranslator;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.EbicsRootParser;
import de.businesslogics.ebics.schema.h003.FileFormat;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.h005.ServiceType;
import de.businesslogics.ebics.schema.orders.HVDOrderParams;
import de.businesslogics.ebics.schema.orders.HVDResponseOrderData;
import de.businesslogics.ebics.schema.orders.HVEOrderParams;
import de.businesslogics.ebics.schema.orders.HVSOrderParams;
import de.businesslogics.ebics.schema.orders.HVTOrderFlags;
import de.businesslogics.ebics.schema.orders.HVTOrderParams;
import de.businesslogics.ebics.schema.orders.HVTResponseOrderData;
import de.businesslogics.ebics.schema.orders.HVUOrderParams;
import de.businesslogics.ebics.schema.orders.HVUOriginatorInfo;
import de.businesslogics.ebics.schema.orders.HVUResponseOrderData;
import de.businesslogics.ebics.schema.orders.HVZOrderDetails;
import de.businesslogics.ebics.schema.orders.HVZOrderParams;
import de.businesslogics.ebics.schema.orders.HVZResponseOrderData;
import de.businesslogics.ebics.schema.orders.OrderDetails;
import de.businesslogics.ebics.schema.orders.StandardOrderParams;
import de.businesslogics.ebics.schema.orders.UserSignatureData;
import de.businesslogics.ebics.schema.request.Body;
import de.businesslogics.ebics.schema.request.DataTransfer;
import de.businesslogics.ebics.schema.request.EbicsRequest;
import de.businesslogics.ebics.schema.request.Header;
import de.businesslogics.ebics.schema.request.Mutable;
import de.businesslogics.ebics.schema.request.OrderAttribute;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.request.Static;
import de.businesslogics.ebics.schema.response.BankPubKeyUpdateRequiredException;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.response.EbicsResponse;
import de.businesslogics.ebics.schema.response.NoDownloadDataAvailableException;
import de.businesslogics.ebics.schema.types.DataDigest;
import de.businesslogics.ebics.schema.types.NumSegments;
import de.businesslogics.ebics.schema.types.OrderTListType;
import de.businesslogics.ebics.schema.types.PartnerID;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.TransactionPhase;
import de.businesslogics.util.xml.OutputSAXParserStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public class DistributedSignature
extends FileTransfer {
    private static final Logger LOGGER = Logger.getLogger(DistributedSignature.class.getName());

    public DistributedSignature(EbicsSession session) {
        super(session);
    }

    public HVUResponseOrderData getOverviewBTF(List<RestrictedServiceType> btfs) throws IOException, EbicsException {
        if (btfs != null && this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) < 0) {
            throw new UnsupportedOperationException("RestrictedServiceType are only available for EBICS 3.0 and newer");
        }
        HVUOrderParams params = new HVUOrderParams();
        if (btfs != null) {
            params.getServiceFilters().addAll(btfs);
        }
        return this.getHvuResponseOrderData(params);
    }

    public HVZResponseOrderData getDetailedOverviewBTF(List<RestrictedServiceType> btfs) throws IOException, EbicsException {
        if (btfs != null && this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) < 0) {
            throw new UnsupportedOperationException("RestrictedServiceType are only available for EBICS 3.0 and newer");
        }
        HVZOrderParams params = new HVZOrderParams();
        if (btfs != null) {
            params.getServiceFilters().addAll(btfs);
        }
        return this.getHvzResponseOrderData(params);
    }

    public HVUResponseOrderData getOverview(String[] orderTypes) throws EbicsException, IOException {
        return this.getOverview(orderTypes, "DE");
    }

    public HVUResponseOrderData getOverview(String[] orderTypes, String countryCode) throws EbicsException, IOException {
        HVUOrderParams params;
        if (orderTypes != null && this.session.getProtocolVersion().compareTo(ProtocolVersion.H004) <= 0) {
            params = new HVUOrderParams(new OrderTListType(this.convertToOrderType(orderTypes)));
        } else {
            params = new HVUOrderParams();
            this.convertAndAdd(orderTypes, params.getServiceFilters(), countryCode);
        }
        return this.getHvuResponseOrderData(params);
    }

    private void convertAndAdd(String[] orderTypes, List<ServiceType> serviceFilters, String countryCode) {
        if (orderTypes != null) {
            int i = orderTypes.length;
            while (--i >= 0) {
                if (BTFTranslator.isBTFString(orderTypes[i])) {
                    serviceFilters.add(BTFTranslator.convertFrom(orderTypes[i]));
                    continue;
                }
                OrderType orderType = new OrderType(orderTypes[i]);
                RestrictedServiceType rst = null;
                if (countryCode.equalsIgnoreCase("CH")) {
                    translator = new SwissBTFTranslator();
                    rst = translator.convertFetch(orderType);
                } else if (countryCode.equalsIgnoreCase("AT")) {
                    translator = new AustrianBTFTranslator();
                    rst = translator.convertFetch(orderType);
                } else {
                    rst = this.btfTranslator.convertSend(orderType);
                }
                if (rst != null) {
                    serviceFilters.add(rst);
                    continue;
                }
                throw new IllegalArgumentException("Unknown mapping for order type " + orderTypes[i]);
            }
        }
    }

    private HVUResponseOrderData getHvuResponseOrderData(HVUOrderParams params) throws IOException, EbicsException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            FetchTransferState ts = this.fetchFileIntern(OrderType.HVU, params, bos);
            while (this.nextChunk(ts)) {
            }
        }
        catch (NoDownloadDataAvailableException ndae) {
            return new HVUResponseOrderData(this.session.getProtocolVersion());
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        try {
            ProtocolVersion pv = this.session.getProtocolVersion();
            HVUResponseOrderData hvu = new HVUResponseOrderData(pv);
            EbicsRootParser p = new EbicsRootParser(pv.getNamespace(), hvu);
            EbicsHandler.parse(bis, p, pv.getNamespaceSchemaLocation());
            return hvu;
        }
        catch (SAXException se) {
            throw new IOException("Invalid server XML", se);
        }
    }

    public HVZResponseOrderData getDetailedOverview(String[] orderTypes) throws EbicsException, IOException {
        return this.getDetailedOverview(orderTypes, "DE");
    }

    public HVZResponseOrderData getDetailedOverview(String[] orderTypes, String countryCode) throws EbicsException, IOException {
        HVZOrderParams params;
        if (orderTypes != null && this.session.getProtocolVersion().compareTo(ProtocolVersion.H004) <= 0) {
            params = new HVZOrderParams(new OrderTListType(this.convertToOrderType(orderTypes)));
        } else {
            params = new HVZOrderParams();
            this.convertAndAdd(orderTypes, params.getServiceFilters(), countryCode);
        }
        return this.getHvzResponseOrderData(params);
    }

    private List<OrderType> convertToOrderType(String[] orderTypes) {
        ArrayList<OrderType> otList = new ArrayList<OrderType>(orderTypes.length);
        int i = orderTypes.length;
        while (--i >= 0) {
            if (orderTypes[i].length() != 3) {
                throw new IllegalArgumentException("Unknown order type " + orderTypes[i]);
            }
            otList.add(new OrderType(orderTypes[i]));
        }
        return otList;
    }

    private HVZResponseOrderData getHvzResponseOrderData(HVZOrderParams params) throws IOException, EbicsException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            FetchTransferState ts = this.fetchFileIntern(OrderType.HVZ, params, bos);
            while (this.nextChunk(ts)) {
            }
        }
        catch (NoDownloadDataAvailableException ndae) {
            return new HVZResponseOrderData(this.session.getProtocolVersion());
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        try {
            ProtocolVersion pv = this.session.getProtocolVersion();
            HVZResponseOrderData hvz = new HVZResponseOrderData(pv);
            EbicsRootParser p = new EbicsRootParser(pv.getNamespace(), hvz);
            EbicsHandler.parse(bis, p, pv.getNamespaceSchemaLocation());
            return hvz;
        }
        catch (SAXException se) {
            throw new IOException("Invalid server XML", se);
        }
    }

    public void fetchOrderFile(OrderDetails details, OutputStream os) throws EbicsException, IOException {
        EbicsElement transferType = details.isH004AndBelow() ? details.getOrderType() : details.getService();
        this.fetchOrderFileInternal(details.getOriginatorInfo().getPartnerID(), transferType, details.getOrderID(), os, details.getFileFormat());
    }

    public void fetchOrderFile(PartnerID partnerID, OrderType orderType, OrderID orderID, OutputStream os, FileFormat fileFormat) throws EbicsException, IOException {
        this.fetchOrderFileInternal(partnerID, orderType, orderID, os, fileFormat);
    }

    public void fetchOrderFile(PartnerID partnerID, RestrictedServiceType restrictedServiceType, OrderID orderID, OutputStream os) throws EbicsException, IOException {
        this.fetchOrderFileInternal(partnerID, restrictedServiceType, orderID, os, null);
    }

    private void fetchOrderFileInternal(PartnerID partnerID, EbicsElement transferType, OrderID orderID, OutputStream os, FileFormat fileFormat) throws EbicsException, IOException {
        HVTOrderFlags flags = new HVTOrderFlags();
        flags.setCompleteOrderData(true);
        HVTOrderParams params = this.buildHVTOrderParams(partnerID, transferType, orderID, flags, fileFormat);
        FetchTransferState ts = this.fetchFileIntern(OrderType.HVT, params, os);
        while (this.nextChunk(ts)) {
        }
    }

    public HVTResponseOrderData fetchOrderDetails(OrderDetails details, int fetchOffset, int fetchLimit) throws IOException, EbicsException {
        EbicsElement transferType = details.isH004AndBelow() ? details.getOrderType() : details.getService();
        return this.fetchOrderDetailsInternal(details.getOriginatorInfo().getPartnerID(), transferType, details.getOrderID(), fetchOffset, fetchLimit, details.getFileFormat());
    }

    public HVTResponseOrderData fetchOrderDetails(PartnerID partnerID, RestrictedServiceType restrictedServiceType, OrderID orderID, int fetchOffset, int fetchLimit) throws IOException, EbicsException {
        return this.fetchOrderDetailsInternal(partnerID, restrictedServiceType, orderID, fetchOffset, fetchLimit, null);
    }

    public HVTResponseOrderData fetchOrderDetails(PartnerID partnerID, OrderType orderType, OrderID orderID, int fetchOffset, int fetchLimit, FileFormat fileFormat) throws IOException, EbicsException {
        return this.fetchOrderDetailsInternal(partnerID, orderType, orderID, fetchOffset, fetchLimit, fileFormat);
    }

    private HVTResponseOrderData fetchOrderDetailsInternal(PartnerID partnerID, EbicsElement transferType, OrderID orderID, int fetchOffset, int fetchLimit, FileFormat fileFormat) throws IOException, EbicsException {
        HVTOrderFlags flags = new HVTOrderFlags();
        flags.setFetchOffset(fetchOffset);
        flags.setFetchLimit(fetchLimit);
        HVTOrderParams params = this.buildHVTOrderParams(partnerID, transferType, orderID, flags, fileFormat);
        HVTResponseOrderData hvt = new HVTResponseOrderData(this.session.getProtocolVersion());
        EbicsRootParser p = new EbicsRootParser(this.session.getProtocolVersion().getNamespace(), hvt);
        EbicsHandler eh = new EbicsHandler(p);
        try (OutputSAXParserStream ops = new OutputSAXParserStream(eh);){
            FetchTransferState ts = this.fetchFileIntern(OrderType.HVT, params, ops);
            while (this.nextChunk(ts)) {
            }
        }
        return hvt;
    }

    private HVTOrderParams buildHVTOrderParams(PartnerID partnerID, EbicsElement transferType, OrderID orderID, HVTOrderFlags flags, FileFormat fileFormat) {
        HVTOrderParams params;
        short protocolVersion = this.session.getProtocolVersion().getVersion();
        if (protocolVersion >= 5) {
            params = new HVTOrderParams(partnerID, (RestrictedServiceType)transferType, orderID, flags);
        } else {
            params = new HVTOrderParams(partnerID, (OrderType)transferType, orderID, flags);
            if (protocolVersion >= 4) {
                params.setFileFormat(fileFormat);
            }
        }
        return params;
    }

    public void fetchOrderDetails(OrderDetails details, OutputStream out, int fetchOffset, int fetchLimit) throws IOException, EbicsException {
        EbicsElement transferType = details.isH004AndBelow() ? details.getOrderType() : details.getService();
        this.fetchOrderDetailsInternal(details.getOriginatorInfo().getPartnerID(), transferType, details.getOrderID(), out, fetchOffset, fetchLimit, details.getFileFormat());
    }

    public void fetchOrderDetails(PartnerID partnerID, OrderType orderType, OrderID orderID, OutputStream out, int fetchOffset, int fetchLimit, FileFormat fileFormat) throws IOException, EbicsException {
        this.fetchOrderDetailsInternal(partnerID, orderType, orderID, out, fetchOffset, fetchLimit, fileFormat);
    }

    public void fetchOrderDetails(PartnerID partnerID, RestrictedServiceType restrictedServiceType, OrderID orderID, OutputStream out, int fetchOffset, int fetchLimit) throws IOException, EbicsException {
        this.fetchOrderDetailsInternal(partnerID, restrictedServiceType, orderID, out, fetchOffset, fetchLimit, null);
    }

    private void fetchOrderDetailsInternal(PartnerID partnerID, EbicsElement transferType, OrderID orderID, OutputStream out, int fetchOffset, int fetchLimit, FileFormat fileFormat) throws IOException, EbicsException {
        HVTOrderFlags flags = new HVTOrderFlags();
        flags.setFetchOffset(fetchOffset);
        flags.setFetchLimit(fetchLimit);
        HVTOrderParams params = this.buildHVTOrderParams(partnerID, transferType, orderID, flags, fileFormat);
        FetchTransferState ts = this.fetchFileIntern(OrderType.HVT, params, out);
        while (this.nextChunk(ts)) {
        }
    }

    public HVDResponseOrderData getDetails(OrderDetails details) throws EbicsException, IOException {
        HVDOrderParams params;
        if (details.isH004AndBelow()) {
            params = new HVDOrderParams(details.getOriginatorInfo().getPartnerID(), details.getOrderType(), details.getOrderID());
            if (this.session.getProtocolVersion().getVersion() >= 4) {
                params.setFileFormat(details.getFileFormat());
            }
        } else {
            params = new HVDOrderParams(details.getOriginatorInfo().getPartnerID(), details.getService(), details.getOrderID());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FetchTransferState ts = this.fetchFileIntern(OrderType.HVD, params, bos);
        while (this.nextChunk(ts)) {
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        try {
            ProtocolVersion pv = this.session.getProtocolVersion();
            HVDResponseOrderData hvd = new HVDResponseOrderData(pv);
            EbicsRootParser p = new EbicsRootParser(pv.getNamespace(), hvd);
            EbicsHandler.parse(bis, p, pv.getNamespaceSchemaLocation());
            return hvd;
        }
        catch (SAXException se) {
            throw new IOException("Invalid server XML", se);
        }
    }

    public HVDResponseOrderData getDetails(PartnerID partnerId, OrderType orderType, OrderID orderId) throws EbicsException, IOException {
        HVUOriginatorInfo originatorInfo = new HVUOriginatorInfo(partnerId, null, null, null);
        OrderDetails details = new OrderDetails(orderType, orderId, null, null, originatorInfo);
        return this.getDetails(details);
    }

    public HVDResponseOrderData getDetails(PartnerID partnerId, RestrictedServiceType restrictedServiceType, OrderID orderId) throws EbicsException, IOException {
        HVUOriginatorInfo originatorInfo = new HVUOriginatorInfo(partnerId, null, null, null);
        OrderDetails details = new OrderDetails(restrictedServiceType, orderId, null, null, originatorInfo);
        return this.getDetails(details);
    }

    public OrderID sign(OrderDetails details, byte[] digest) throws EbicsException, IOException {
        HVEOrderParams params;
        if (details.isH004AndBelow()) {
            params = new HVEOrderParams(details.getOriginatorInfo().getPartnerID(), details.getOrderType(), details.getOrderID());
            if (this.session.getProtocolVersion().getVersion() >= 4) {
                params.setFileFormat(details.getFileFormat());
            }
        } else {
            params = new HVEOrderParams(details.getOriginatorInfo().getPartnerID(), details.getService(), details.getOrderID());
        }
        return this.signOrCancel(OrderType.HVE, params, digest);
    }

    public void signWithUzhnn(OrderType orderType, OrderID orderID, byte[] digest) throws EbicsException, IOException {
        Static sh = this.session.createStaticHeader(orderType, orderID, OrderAttribute.UZHNN, null, new StandardOrderParams(null));
        Header header = new Header(sh, new Mutable(TransactionPhase.INITIALIZATION, null));
        Date now = new Date();
        UserSignatureData usd = new UserSignatureData(this.session.getProtocolVersion());
        this.session.addSignatureData(usd, this.getSigner(), digest, "VEU", now, orderType.getValue());
        DataTransfer dataTransfer = new DataTransfer();
        dataTransfer.setSignatureData(usd);
        sh.getInitialisation().setNumSegments(new NumSegments(0));
        dataTransfer.encrypt(this.session.getEncryptionHandler(), this.session.getBankEncrKey(), this.session.bankEncrDigest, null);
        Body body = new Body(new Body.InitialisationBody(null, dataTransfer));
        EbicsRequest ebics = new EbicsRequest(this.session.getProtocolVersion(), header, body);
        this.session.sendSignedRequest(ebics);
    }

    @Deprecated
    public OrderID sign(HVZOrderDetails hvz) throws EbicsException, IOException {
        return this.sign(hvz, hvz.getDataDigest().getValue());
    }

    public OrderID sign(PartnerID partnerID, OrderType orderType, OrderID orderID, byte[] digest) throws EbicsException, IOException {
        HVEOrderParams params = new HVEOrderParams(partnerID, orderType, orderID);
        return this.signOrCancel(OrderType.HVE, params, digest);
    }

    public OrderID sign(PartnerID partnerID, RestrictedServiceType restrictedServiceType, OrderID orderID, byte[] digest) throws EbicsException, IOException {
        HVEOrderParams params = new HVEOrderParams(partnerID, restrictedServiceType, orderID);
        return this.signOrCancel(OrderType.HVE, params, digest);
    }

    public OrderID cancel(OrderDetails details, byte[] digest) throws EbicsException, IOException {
        HVSOrderParams params;
        if (details.isH004AndBelow()) {
            params = new HVSOrderParams(details.getOriginatorInfo().getPartnerID(), details.getOrderType(), details.getOrderID());
            if (this.session.getProtocolVersion().getVersion() >= 4) {
                params.setFileFormat(details.getFileFormat());
            }
        } else {
            params = new HVSOrderParams(details.getOriginatorInfo().getPartnerID(), details.getService(), details.getOrderID());
        }
        return this.signOrCancel(OrderType.HVS, params, digest);
    }

    public OrderID cancel(PartnerID partnerID, OrderType orderType, OrderID orderID, byte[] digest, FileFormat fileFormat) throws EbicsException, IOException {
        HVSOrderParams params = new HVSOrderParams(partnerID, orderType, orderID);
        if (this.session.getProtocolVersion().getVersion() >= 4) {
            params.setFileFormat(fileFormat);
        }
        return this.signOrCancel(OrderType.HVS, params, digest);
    }

    public OrderID cancel(PartnerID partnerID, RestrictedServiceType restrictedServiceType, OrderID orderID, byte[] digest) throws EbicsException, IOException {
        HVSOrderParams params = new HVSOrderParams(partnerID, restrictedServiceType, orderID);
        return this.signOrCancel(OrderType.HVS, params, digest);
    }

    private OrderID signOrCancel(OrderType veuOrder, HVDOrderParams params, byte[] digest) throws EbicsException, IOException {
        EbicsResponse rebics;
        UserSignatureData usd = new UserSignatureData(this.session.getProtocolVersion());
        String orderType = params.getOrderType() != null ? params.getOrderType().getValue() : "BTU";
        EbicsBusinessUser signer = this.getSigner();
        Date now = new Date();
        this.session.addSignatureData(usd, signer, digest, "VEU", now, orderType);
        OrderID orderID = this.session.nextOrderID(veuOrder, null);
        Static sh = this.session.createStaticHeader(veuOrder, orderID, OrderAttribute.UZHNN, null, params);
        boolean retry = false;
        while (true) {
            Header header = new Header(sh, new Mutable(TransactionPhase.INITIALIZATION, null));
            DataTransfer dataTransfer = new DataTransfer();
            dataTransfer.setSignatureData(usd);
            if (this.session.getProtocolVersion().compareTo(ProtocolVersion.H005) >= 0) {
                dataTransfer.setDataDigest(new DataDigest(new byte[0], signer.getSignatureVersion()));
            }
            sh.getInitialisation().setNumSegments(new NumSegments(0));
            dataTransfer.encrypt(this.session.getEncryptionHandler(), this.session.getBankEncrKey(), this.session.bankEncrDigest, null);
            Body body = new Body(new Body.InitialisationBody(null, dataTransfer));
            EbicsRequest ebics = new EbicsRequest(this.session.getProtocolVersion(), header, body);
            try {
                rebics = this.session.sendSignedRequest(ebics);
            }
            catch (BankPubKeyUpdateRequiredException bpue) {
                if (retry) {
                    throw bpue;
                }
                retry = true;
                LOGGER.info("Got BankPubKeyUpdateRequiredException");
                this.session.getBankKeys(false);
                continue;
            }
            break;
        }
        if (orderID == null) {
            orderID = rebics.getHeader().getMutable().getOrderID();
        }
        return orderID;
    }

    protected EbicsBusinessUser getSigner() {
        return this.session.businessUser;
    }
}

