/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.ebics.schema.response.InvalidOrderDataFormatException;
import de.businesslogics.ebics.schema.signature.X509Data;
import de.businesslogics.ebics.security.EncryptionHandler;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.LogUtils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.logging.Level;

public class DifferingKeyDigestException
extends IOException {
    private static final long serialVersionUID = 1L;
    private String expectedString;
    private byte[] found;
    private final String foundKeyVersion;
    private final String expectedKeyVersion;

    private DifferingKeyDigestException(String expectedKeyVersion, String expected, String foundKeyVersion, byte[] found) {
        this.expectedKeyVersion = expectedKeyVersion;
        this.expectedString = expected;
        this.foundKeyVersion = foundKeyVersion;
        this.found = found;
    }

    @Deprecated
    public byte[] getExpected() {
        return HexTool.fromHex(this.expectedString);
    }

    public byte[] getFound() {
        return this.found;
    }

    public String getExpectedString() {
        return this.expectedString;
    }

    public String getExpectedKeyVersion() {
        return this.expectedKeyVersion;
    }

    public String getFoundKeyVersion() {
        return this.foundKeyVersion;
    }

    @Deprecated
    public static void compareDigests(String expectedKeyVersion, byte[] expected, String foundKeyVersion, byte[] found) throws DifferingKeyDigestException {
        if (!expectedKeyVersion.equals(foundKeyVersion) || !DifferingKeyDigestException.lazyEquals(expected, found)) {
            throw new DifferingKeyDigestException(expectedKeyVersion, HexTool.toHex(expected), foundKeyVersion, found);
        }
    }

    public static void compareDigestsString(String expectedKeyVersion, String expectedHash, String foundKeyVersion, byte[] foundHash) throws DifferingKeyDigestException {
        if (!expectedKeyVersion.equals(foundKeyVersion) || !DifferingKeyDigestException.lazyEqualsString(expectedHash, HexTool.toHex(foundHash))) {
            throw new DifferingKeyDigestException(expectedKeyVersion, expectedHash, foundKeyVersion, foundHash);
        }
    }

    @Deprecated
    public static void lazyCompareDigests(String expectedKeyVersion, byte[] expected, String foundKeyVersion, byte[] found, X509Data x509Data) throws DifferingKeyDigestException {
        if (expected == null) {
            return;
        }
        if (expectedKeyVersion.equals(foundKeyVersion)) {
            if (DifferingKeyDigestException.lazyEquals(expected, found)) {
                return;
            }
            if (x509Data != null) {
                if (DifferingKeyDigestException.lazyEquals(expected, EncryptionHandler.E002.getCertDigest(x509Data))) {
                    return;
                }
                try {
                    Object[] os = x509Data.getMainKey();
                    X509Certificate x509 = (X509Certificate)os[0];
                    if (DifferingKeyDigestException.lazyEquals(expected, EncryptionHandler.E002.getHash((RSAPublicKey)x509.getPublicKey()))) {
                        return;
                    }
                }
                catch (InvalidOrderDataFormatException e) {
                    LogUtils.logp(DifferingKeyDigestException.class, Level.INFO, "lazyCompareDigests", "Ignoring", e);
                }
            }
        }
        throw new DifferingKeyDigestException(expectedKeyVersion, HexTool.toHex(expected), foundKeyVersion, found);
    }

    public static void lazyCompareDigests(String expectedKeyVersion, String expectedHash, String foundKeyVersion, byte[] found, X509Data x509Data) throws DifferingKeyDigestException {
        if (expectedHash == null) {
            return;
        }
        if (expectedKeyVersion.equals(foundKeyVersion) && (DifferingKeyDigestException.lazyEqualsString(expectedHash, HexTool.toHex(found)) || DifferingKeyDigestException.lazyEqualsString(expectedHash, HexTool.toHex(EncryptionHandler.E002.getCertDigest(x509Data))))) {
            return;
        }
        throw new DifferingKeyDigestException(expectedKeyVersion, expectedHash, foundKeyVersion, found);
    }

    @Override
    public String getMessage() {
        return "Wrong digest found for key " + this.expectedKeyVersion + " expected " + this.expectedString + " found " + this.foundKeyVersion + ":" + HexTool.toHex(this.found);
    }

    private static boolean lazyEquals(byte[] expected, byte[] found) {
        if (found == null) {
            return false;
        }
        if (expected.length > found.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == found[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean lazyEqualsString(String expected, String found) {
        if (found == null || found.isEmpty()) {
            return false;
        }
        if (expected == null || expected.isEmpty()) {
            return true;
        }
        if (expected.length() > found.length()) {
            return false;
        }
        return found.toUpperCase().startsWith(expected.toUpperCase());
    }
}

