/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.security.jce.Provider;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;

public class CertificateAsKey
implements RSAPublicKey {
    private static final long serialVersionUID = 1L;
    private final RSAPublicKey key;
    private final byte[] cert;

    public CertificateAsKey(byte[] cert) {
        this.cert = cert;
        this.key = (RSAPublicKey)Provider.convertX509Data(cert).get(0).getPublicKey();
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithm();
    }

    @Override
    public byte[] getEncoded() {
        return this.key.getEncoded();
    }

    @Override
    public String getFormat() {
        return this.key.getFormat();
    }

    @Override
    public BigInteger getModulus() {
        return this.key.getModulus();
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.key.getPublicExponent();
    }

    public byte[] getCertificate() {
        return this.cert;
    }
}

