/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.ebics.schema.BTF;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.h005.ContainerFlagType;
import de.businesslogics.ebics.schema.h005.ContainerStringType;
import de.businesslogics.ebics.schema.h005.MessageType;
import de.businesslogics.ebics.schema.h005.NumStringType;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.h005.ScopeStringType;
import de.businesslogics.ebics.schema.h005.ServiceNameStringType;
import de.businesslogics.ebics.schema.h005.ServiceOptionStringType;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;

public abstract class BTFTranslatorBase {
    protected final Map<OrderType, RestrictedServiceType> sendOt2Btf = new HashMap<OrderType, RestrictedServiceType>();
    protected final Map<RestrictedServiceType, OrderType> sendBtf2Ot = new HashMap<RestrictedServiceType, OrderType>();
    protected final Map<OrderType, RestrictedServiceType> fetchOt2Btf = new HashMap<OrderType, RestrictedServiceType>();
    protected final Map<RestrictedServiceType, OrderType> fetchBtf2Ot = new HashMap<RestrictedServiceType, OrderType>();
    protected static final String SERVICE_PARTS_SEPERATOR = "_";
    protected static final String OPTIONAL_FIELDS_SEPERATOR = ":";
    protected static char D = (char)68;
    protected static char U = (char)85;

    public RestrictedServiceType convertFetch(OrderType ot) {
        return this.fetchOt2Btf.get(ot);
    }

    public OrderType convertFetch(RestrictedServiceType service) {
        return this.fetchBtf2Ot.get(service);
    }

    public RestrictedServiceType convertSend(OrderType ot) {
        return this.sendOt2Btf.get(ot);
    }

    public OrderType convertSend(RestrictedServiceType service) {
        return this.sendBtf2Ot.get(service);
    }

    public RestrictedServiceType addFetch(OrderType ot, RestrictedServiceType rst) {
        EbicsElement removed = this.fetchBtf2Ot.put(rst, ot);
        if (removed != null && !removed.equals(ot)) {
            this.fetchBtf2Ot.put(rst, (OrderType)removed);
            throw new IllegalStateException("Mapping already exists to order type " + String.valueOf(removed));
        }
        removed = this.fetchOt2Btf.put(ot, rst);
        if (removed != null) {
            this.fetchBtf2Ot.remove(removed);
        }
        return removed;
    }

    public RestrictedServiceType removeFetch(OrderType ot) {
        RestrictedServiceType removed = this.fetchOt2Btf.remove(ot);
        if (removed != null) {
            this.fetchBtf2Ot.remove(removed);
        }
        return removed;
    }

    public RestrictedServiceType addSend(OrderType ot, RestrictedServiceType rst) {
        EbicsElement removed = this.sendBtf2Ot.put(rst, ot);
        if (removed != null && !removed.equals(ot)) {
            this.sendBtf2Ot.put(rst, (OrderType)removed);
            throw new IllegalStateException("Mapping already exists to order type " + String.valueOf(removed));
        }
        removed = this.sendOt2Btf.put(ot, rst);
        if (removed != null) {
            this.sendBtf2Ot.remove(removed);
        }
        return removed;
    }

    public RestrictedServiceType removeSend(OrderType ot) {
        RestrictedServiceType removed = this.sendOt2Btf.remove(ot);
        if (removed != null) {
            this.sendBtf2Ot.remove(removed);
        }
        return removed;
    }

    protected void add(String serviceName, String serviceScope, String serviceOption, String message, String containerType, char uploadDownload, String orderType) {
        RestrictedServiceType rst = new RestrictedServiceType(new ServiceNameStringType(serviceName), new MessageType(message));
        if (serviceScope != null) {
            rst.setScope(new ScopeStringType(serviceScope));
        }
        if (serviceOption != null) {
            rst.setServiceOption(new ServiceOptionStringType(serviceOption));
        }
        if (containerType != null) {
            rst.setContainer(new ContainerFlagType(new ContainerStringType(containerType)));
        }
        OrderType ot = new OrderType(orderType);
        if (uploadDownload == 'U') {
            this.addSend(ot, rst);
        } else {
            this.addFetch(ot, rst);
        }
    }

    protected void add(String serviceName, String serviceScope, String serviceOption, String message, String variant, String version, String containerType, char uploadDownload, String orderType) {
        MessageType msgType = new MessageType(message);
        if (variant != null) {
            msgType.setVariant(new NumStringType(variant));
        }
        if (version != null) {
            msgType.setVersion(new NumStringType(version));
        }
        RestrictedServiceType rst = new RestrictedServiceType(new ServiceNameStringType(serviceName), msgType);
        if (serviceScope != null) {
            rst.setScope(new ScopeStringType(serviceScope));
        }
        if (serviceOption != null) {
            rst.setServiceOption(new ServiceOptionStringType(serviceOption));
        }
        if (containerType != null) {
            rst.setContainer(new ContainerFlagType(new ContainerStringType(containerType)));
        }
        OrderType ot = new OrderType(orderType);
        if (uploadDownload == 'U') {
            this.addSend(ot, rst);
        } else {
            this.addFetch(ot, rst);
        }
    }

    public static boolean isBTFString(String in) {
        if (in == null) {
            return false;
        }
        return RegularExpressions.BTF_SERVICE_PATTERN.matches(in);
    }

    public static RestrictedServiceType convertFrom(String btfString) throws IllegalArgumentException {
        Matcher m = RegularExpressions.BTF_SERVICE_PATTERN.getPattern().matcher(btfString);
        if (m.matches()) {
            RestrictedServiceType service = new RestrictedServiceType(new ServiceNameStringType(m.group("serviceName").toUpperCase()), new MessageType(m.group("msgName").toLowerCase()));
            if (!StringUtils.isEmpty(m.group("scope"))) {
                service.setScope(new ScopeStringType(m.group("scope").toUpperCase()));
            }
            if (!StringUtils.isEmpty(m.group("option"))) {
                service.setServiceOption(new ServiceOptionStringType(m.group("option").toUpperCase()));
            }
            if (!StringUtils.isEmpty(m.group("variant"))) {
                service.getMsgName().setVariant(new NumStringType(m.group("variant")));
            }
            if (!StringUtils.isEmpty(m.group("version"))) {
                service.getMsgName().setVersion(new NumStringType(m.group("version")));
            }
            if (!StringUtils.isEmpty(m.group("format"))) {
                service.getMsgName().setFormat(new MessageType.MessageType_L1(m.group("format").toUpperCase()));
            }
            if (!StringUtils.isEmpty(m.group("container"))) {
                service.setContainer(new ContainerFlagType(new ContainerStringType(m.group("container").toUpperCase())));
            }
            return service;
        }
        throw new IllegalArgumentException("The given input \"" + btfString + "\" does not match the BL-Syntax for formatting to BTF.");
    }

    public static BTF convertFromStringToBTF(String btfString) {
        BTF btf = new BTF();
        btf.setService(BTFTranslatorBase.convertFrom(btfString));
        return btf;
    }

    public static String convert(String serviceName, String scope, String serviceOption, String message, String variant, String version, String format, String container) {
        StringBuilder btf = new StringBuilder(serviceName);
        if (scope != null && !scope.isEmpty()) {
            btf.append(OPTIONAL_FIELDS_SEPERATOR);
            btf.append(scope);
        }
        if (serviceOption != null && !serviceOption.isEmpty()) {
            if (scope == null || scope.isEmpty()) {
                btf.append(OPTIONAL_FIELDS_SEPERATOR);
            }
            btf.append(OPTIONAL_FIELDS_SEPERATOR);
            btf.append(serviceOption);
        }
        btf.append(SERVICE_PARTS_SEPERATOR);
        btf.append(message);
        if (variant != null && !variant.isEmpty()) {
            btf.append(OPTIONAL_FIELDS_SEPERATOR);
            btf.append(variant);
        }
        if (version != null && !version.isEmpty()) {
            if (variant == null || variant.isEmpty()) {
                btf.append(OPTIONAL_FIELDS_SEPERATOR);
            }
            btf.append(OPTIONAL_FIELDS_SEPERATOR);
            btf.append(version);
        }
        if (format != null && !format.isEmpty()) {
            if (version == null || version.isEmpty()) {
                btf.append(OPTIONAL_FIELDS_SEPERATOR);
                if (variant == null || variant.isEmpty()) {
                    btf.append(OPTIONAL_FIELDS_SEPERATOR);
                }
            }
            btf.append(OPTIONAL_FIELDS_SEPERATOR);
            btf.append(format);
        }
        if (container != null && !container.isEmpty()) {
            btf.append(SERVICE_PARTS_SEPERATOR);
            btf.append(container);
        }
        assert (BTFTranslatorBase.isBTFString(btf.toString()));
        return btf.toString();
    }

    public static String convertToString(RestrictedServiceType r) {
        StringBuilder btf = new StringBuilder(r.getServiceName().getValue());
        ScopeStringType scope = r.getScope();
        ServiceOptionStringType serviceOption = r.getServiceOption();
        MessageType msg = r.getMsgName();
        NumStringType variant = msg.getVariant();
        NumStringType version = msg.getVersion();
        MessageType.MessageType_L1 format = msg.getFormat();
        if (scope != null && scope.getValue() != null) {
            btf.append(OPTIONAL_FIELDS_SEPERATOR);
            btf.append(scope.getValue());
        }
        if (serviceOption != null && serviceOption.getValue() != null) {
            if (scope == null || scope.getValue() == null) {
                btf.append(OPTIONAL_FIELDS_SEPERATOR);
            }
            btf.append(OPTIONAL_FIELDS_SEPERATOR);
            btf.append(serviceOption.getValue());
        }
        btf.append(SERVICE_PARTS_SEPERATOR);
        btf.append(msg.getValue());
        if (variant != null && variant.getValue() != null) {
            btf.append(OPTIONAL_FIELDS_SEPERATOR);
            btf.append(variant.getValue());
        }
        if (version != null && version.getValue() != null) {
            if (variant == null || variant.getValue() == null) {
                btf.append(OPTIONAL_FIELDS_SEPERATOR);
            }
            btf.append(OPTIONAL_FIELDS_SEPERATOR);
            btf.append(version.getValue());
        }
        if (format != null && format.getValue() != null) {
            if (version == null || version.getValue() == null) {
                btf.append(OPTIONAL_FIELDS_SEPERATOR);
                if (variant == null || variant.getValue() == null) {
                    btf.append(OPTIONAL_FIELDS_SEPERATOR);
                }
            }
            btf.append(OPTIONAL_FIELDS_SEPERATOR);
            btf.append(format.getValue());
        }
        if (r.getContainer() != null && r.getContainer().getContainerType() != null && r.getContainer().getContainerType().getValue() != null) {
            btf.append(SERVICE_PARTS_SEPERATOR);
            btf.append(r.getContainer().getContainerType().getValue());
        }
        assert (BTFTranslatorBase.isBTFString(btf.toString()));
        return btf.toString();
    }

    public abstract String getBTFFromSendOrderType2(String var1);
}

