/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.ebics.client.BTFTranslatorBase;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.request.OrderType;
import java.util.Collection;
import java.util.Collections;

public class BTFTranslator
extends BTFTranslatorBase {
    private static final String BBK = "BBK";
    private static final String BIL = "BIL";
    public static final Collection<OrderType> STANDARD_FETCH_ORDER_TYPES;
    public static final Collection<OrderType> STANDARD_SEND_ORDER_TYPES;
    private static final BTFTranslator t;

    public BTFTranslator() {
        this.add("RTP", "DE", null, "pain.013", null, U, "CU3");
        this.add("RTP", "DE", null, "pain.013", "ZIP", D, "CD3");
        this.add("RTP", "DE", null, "pain.014", "ZIP", D, "CD4");
        this.add("RTP", "DE", null, "pain.014", null, U, "CU4");
        this.add("SCT", null, null, "pain.001", null, U, "CCT");
        this.add("SDD", null, "B2B", "pain.008", null, U, "CDB");
        this.add("SDD", null, "COR", "pain.008", null, U, "CDD");
        this.add("SCT", null, "0CIT", "pain.001", null, U, "CIT");
        this.add("SDD", null, "0CIB", "pain.008", null, U, "CIB");
        this.add("SDD", null, "0CID", "pain.008", null, U, "CID");
        this.add("SCI", null, null, "pain.001", null, U, "CIP");
        this.add("SCT", "DE", null, "pain.001", "XML", U, "CCC");
        this.add("SDD", "DE", "B2B", "pain.008", "XML", U, "C2C");
        this.add("SDD", "DE", "COR", "pain.008", "XML", U, "CDC");
        this.add("REP", "DE", "SDD", "pain.002", "XML", D, "CBC");
        this.add("REP", "DE", "SDD", "pain.002", "ZIP", D, "CDZ");
        this.add("REP", "DE", "SCI", "pain.002", "ZIP", D, "CIZ");
        this.add("REP", "DE", "SCT", "pain.002", "XML", D, "CRC");
        this.add("REP", "DE", "SCT", "pain.002", "ZIP", D, "CRZ");
        this.add("STM", "DE", "SCI", "camt.054", "ZIP", D, "C5N");
        this.add("REP", "DE", "VOP", "pain.002", "ZIP", D, "VPZ");
        this.add("SCT", null, "VOI", "pain.001", null, U, "CTV");
        this.add("SCI", null, "VOI", "pain.001", null, U, "CIV");
        this.add("SCT", "DE", "VOI", "pain.001", "SVC", U, "VCS");
        this.add("SCI", "DE", "VOI", "pain.001", "SVC", U, "VIS");
        this.add("SCI", "DE", "VOO", "pain.001", "SVC", U, "CIS");
        this.add("SCT", "DE", "0VCX", "pain.001", "SVC", U, "VCX");
        this.add("SCI", "DE", "0VIX", "pain.001", "SVC", U, "VIX");
        this.add("SCI", "DE", "0CIX", "pain.001", "SVC", U, "CIX");
        this.add("XCT", "DE", null, "dtazv", null, U, "AZV");
        this.add("XCT", "DE", null, "pain.001", null, U, "AXZ");
        this.add("REP", "DE", "XCT", "pain.002", "ZIP", D, "AXS");
        this.add("REP", "SWF", "XCT", "trck.004", "ZIP", D, "T04");
        this.add("RFT", "SWF", null, "pain.001", null, U, "RTX");
        this.add("REP", "SWF", "RFT", "pain.002", "ZIP", D, "RTZ");
        this.add("XCT", "DE", "0AZM", "dtazv", null, U, "AZM");
        this.add("XCT", "DE", "0AZ2", "dtazv", null, U, "AZ2");
        this.add("XCT", "DE", "0AZ4", "dtazv", null, U, "AZ4");
        this.add("EDC", "DE", null, "dtaea", null, D, "EAB");
        this.add("EDC", "DE", null, "dtaead", null, D, "EAD");
        this.add("EDC", "DE", null, "dtaear", null, U, "EAR");
        this.add("IDC", "DE", null, "dtalc", null, U, "AIA");
        this.add("IDC", "DE", null, "dtalca", null, U, "AID");
        this.add("IDC", "DE", null, "dtalcr", null, D, "AKA");
        this.add("IDC", "DE", null, "dtalcd", null, D, "AKD");
        this.add("GUA", "DE", null, "gfb", null, D, "GFB");
        this.add("GUA", "DE", null, "gfk", null, U, "GFK");
        this.add("GUA", "DE", null, "gub", null, D, "GUB");
        this.add("GUA", "DE", null, "guk", null, U, "GUK");
        this.add("EOP", "DE", null, "camt.053", "ZIP", D, "C53");
        this.add("EOP", "DE", null, "mt940", null, D, "STA");
        this.add("STM", "DE", null, "camt.052", "ZIP", D, "C52");
        this.add("STM", "DE", null, "camt.054", "ZIP", D, "C54");
        this.add("STM", "DE", null, "mt942", null, D, "VMK");
        this.add("EOP", "DE", null, "pdf", "ZIP", D, "BKA");
        this.add("DAR", "DE", null, "pdf", "ZIP", D, "BKI");
        this.add("XCT", "DE", "URG", "pain.001", null, U, "CCU");
        this.add("REP", "DE", "URG", "pain.002", "ZIP", U, "CUZ");
        this.add("REP", "DE", null, "camt.029", "ZIP", D, "C29");
        this.add("SCT", "DE", null, "camt.055", null, U, "C55");
        this.add("SDD", null, null, "pain.007", null, U, "C07");
        this.add("SDD", "DE", null, "pain.007", "XML", U, "CC7");
        this.add("REP", "DE", null, "camt.086", "ZIP", D, "C86");
        this.add("SCC", "BGR", null, "pain.007", "SVC", U, "CK7");
        this.add("SCC", "BGR", null, "pain.008", "SVC", U, "CK8");
        this.add("SCC", "BGR", null, "pain.007", null, U, "CX7");
        this.add("SCC", "BGR", null, "pain.008", null, U, "CX8");
        this.add("SCT", "DE", null, "pain.001", "SVC", U, "CCS");
        this.add("SDD", "DE", "B2B", "pain.008", "SVC", U, "C2S");
        this.add("SDD", "DE", "COR", "pain.008", "SVC", U, "CDS");
        this.add("SDD", "DE", null, "pain.007", "SVC", U, "C7S");
        this.add("OTH", null, null, "mt300", null, D, "DDG");
        this.add("OTH", null, null, "mt300", null, U, "DHB");
        this.add("RFT", null, null, "mt101", null, U, "RFT");
        this.add("XCT", null, null, "mt100", null, U, "INT");
        this.add("XDD", null, null, "mt104", null, U, "IDD");
        this.add("EDC", null, null, "mt799", null, U, "AEA");
        this.add("BAM", null, null, "acmt.007", null, U, "B07");
        this.add("BAM", "DE", null, "acmt.010", "ZIP", D, "B10");
        this.add("BAM", "DE", null, "acmt.011", "ZIP", D, "B11");
        this.add("BAM", null, null, "acmt.013", null, U, "B13");
        this.add("BAM", "DE", null, "acmt.014", "ZIP", D, "B14");
        this.add("BAM", null, null, "acmt.015", null, U, "B15");
        this.add("BAM", null, null, "acmt.017", null, U, "B17");
        this.add("BAM", null, null, "acmt.019", null, U, "B19");
        this.add("BAM", null, null, "acmt.022", null, U, "B22");
        this.add("BAM", "DE", null, "misc", "ZIP", U, "B99");
        this.add("ECO", "DE", "0B1H", "pain.008", "SVC", U, "B1H");
        this.add("ECO", "DE", "0B1K", "pain.008", "SVC", U, "B1K");
        this.add("ECO", "DE", "0BCH", "pain.001", "SVC", U, "BCH");
        this.add("ECO", "DE", "0BCK", "pain.001", "SVC", U, "BCK");
        this.add("ECO", "DE", "0BDH", "pain.001", "SVC", U, "BDH");
        this.add("ECO", "DE", "0BDK", "pain.001", "SVC", U, "BDK");
        this.add("OTH", "DE", null, "bzahl", null, U, "GBZ");
        this.add("OTH", "DE", "0WPA", "mt5xx", null, D, "WPA");
        this.add("OTH", "DE", "0WPC", "mt5xx", null, D, "WPC");
        this.add("OTH", BIL, "0CZ3", "pain.013", "XML", U, "CZ3");
        this.add("OTH", BIL, "0CZ4", "pain.014", "XML", D, "CZ4");
        this.add("OTH", BIL, "0DKI", "misc", null, D, "DKI");
        this.add("OTH", BIL, "0DMI", "misc", null, D, "DMI");
        this.add("OTH", BIL, "0DSW", "misc", null, D, "DSW");
        this.add("OTH", BIL, "0EEA", "misc", null, D, "EEA");
        this.add("OTH", BIL, "0EEZ", "misc", null, D, "EEZ");
        this.add("OTH", BIL, "0ESA", "misc", null, U, "ESA");
        this.add("OTH", BIL, "0ESG", "misc", null, D, "ESG");
        this.add("OTH", BIL, "0ESP", "misc", null, U, "ESP");
        this.add("OTH", BIL, "0ESR", "misc", null, U, "ESR");
        this.add("OTH", BIL, "0GRC", "misc", null, D, "GRC");
        this.add("OTH", BIL, "0IBI", "misc", null, D, "IBI");
        this.add("OTH", BIL, "0IBK", "misc", null, D, "IBK");
        this.add("OTH", BIL, "0IBU", "misc", null, D, "IBU");
        this.add("OTH", BIL, "0IBW", "misc", null, D, "IBW");
        this.add("OTH", BIL, "0IKI", "misc", null, U, "IKI");
        this.add("OTH", BIL, "0IKK", "misc", null, U, "IKK");
        this.add("OTH", BIL, "0IKU", "misc", null, U, "IKU");
        this.add("OTH", BIL, "0IKW", "misc", null, U, "IKW");
        this.add("OTH", BIL, "0KTH", "misc", null, U, "KTH");
        this.add("OTH", BIL, "0KTR", "misc", null, D, "KTR");
        this.add("OTH", BIL, "0UPD", "misc", null, D, "UPD");
        this.add("SDD", BIL, "0CD1", "pain.008", null, U, "CD1");
        this.add("SDD", BIL, "0C1C", "pain.008", "XML", U, "C1C");
        this.add("SDD", BIL, "0C1S", "pain.008", "SVC", U, "C1S");
        this.add("SCC", "DE", "0C7X", "pain.007", null, U, "C7X");
        this.add("SCC", "DE", "0C8X", "pain.008", null, U, "C8X");
        this.add("SCC", "DE", "0CXN", "pain.007", "SVC", U, "CXN");
        this.add("SCT", "DE", "0CCX", "pain.001", "SVC", U, "CCX");
        this.add("SCT", "DE", "0CXS", "pain.001", "SVC", U, "CXS");
        this.add("SDD", "DE", "0CDX", "pain.008", "SVC", U, "CDX");
        this.add("SDD", "DE", "0C2X", "pain.008", "SVC", U, "C2X");
        this.add("SDD", "DE", "0CS7", "pain.007", "SVC", U, "CS7");
        this.add("SDD", BIL, "0X1X", "pain.008", null, U, "C1X");
        this.addBbk("SCT", null, "icf", "QC1");
        this.addBbk("SCT", null, "iqf", "QC4");
        this.addBbk("SDD", "COR", "idf", "QD5");
        this.addBbk("SDD", "B2B", "idf", "QD6");
        this.addBbk("SCC", null, "idf", "QK1");
        this.addBbk("CHQ", "0BSE", "idf", "QS1");
        this.addBbk("CHQ", "0ISE", "idf", "QS2");
        this.addBbk("CHQ", "0ISR", "idf", "QS3");
        this.addBbk("OTH", null, "mt920bbksw", "QMA");
        this.addBbk("SCT", null, "cvf", "QC2");
        this.addBbk("SCT", null, "scf", "QC3");
        this.addBbk("SCT", null, "qvf", "QC5");
        this.addBbk("SCT", null, "oqf", "QC6");
        this.addBbk("SCC", null, "dvf", "QK2");
        this.addBbk("SCC", null, "dnf", "QK3");
        this.addBbk("SCC", null, "sdf", "QK4");
        this.addBbk("SCC", null, "udf", "QK5");
        this.addBbk("SCC", null, "rsf", "QK6");
        this.addBbk("REP", null, "drc", "QR1");
        this.addBbk("REP", null, "drr", "QR5");
        this.addBbk("REP", null, "drq", "QR9");
        this.addBbk("SDD", "COR", "dvf", "QD7");
        this.addBbk("SDD", "COR", "dnf", "QD8");
        this.addBbk("SDD", "COR", "sdf", "QD9");
        this.addBbk("SDD", "B2B", "dvf", "QDA");
        this.addBbk("SDD", "B2B", "dnf", "QDB");
        this.addBbk("SDD", "B2B", "sdf", "QDC");
        this.addBbk("SDD", "COR", "udf", "QDD");
        this.addBbk("SDD", "B2B", "udf", "QDE");
        this.addBbk("SDD", "COR", "rsf", "QDF");
        this.addBbk("SDD", "B2B", "rsf", "QDG");
        this.addBbk("REP", "COR", "drd", "QR3");
        this.addBbk("REP", "B2B", "drd", "QR4");
        this.addBbk("REP", null, "rocs.001", "QSD");
        this.addBbk("CHQ", "0BSE", "dvf", "QS4");
        this.addBbk("CHQ", "0BSE", "dnf", "QS5");
        this.addBbk("CHQ", "0BSE", "sdf", "QS6");
        this.addBbk("CHQ", "0ISE", "dvf", "QS7");
        this.addBbk("CHQ", "0ISE", "dnf", "QS8");
        this.addBbk("CHQ", "0ISR", "sdf", "QS9");
        this.addBbk("CHQ", "0ISR", "dvf", "QSA");
        this.addBbk("CHQ", "0BSE", "udf", "QSB");
        this.addBbk("CHQ", "0ISE", "udf", "QSC");
        this.addBbk("CHQ", "0ISR", "udf", "QSE");
        this.addBbk("CHQ", "0BSE", "rsf", "QSF");
        this.addBbk("CHQ", "0ISE", "rsf", "QSG");
        this.addBbk("CHQ", "0ISR", "rsf", "QSH");
        this.addBbk("REP", "0BSE", "drd", "QR6");
        this.addBbk("REP", "0ISE", "drd", "QR7");
        this.addBbk("REP", "0ISR", "drd", "QR8");
        this.addBbk("REP", null, "bleit", "QBL");
        this.addBbk("REP", null, "bleit2", "QBE");
        this.addBbk("REP", null, "intba", "QBA");
        this.addBbk("STM", null, "mt942bbksw", "QMU");
        this.addBbk("EOP", null, "mt940bbksw", "QMK");
        this.addBbk("STM", null, "m3bbksw", "QMN");
        this.addBbk("STM", null, "camt.052", "Q52");
        this.addBbk("EOP", null, "camt.053", "Q53");
        this.addBbk("DCT", "URG", "gtdta", "QG1");
        this.addBbk("DCT", "URG", "gtbbksw", "QG2");
        this.addBbk("SCT", null, "bcf", "QB1");
        this.addBbk("XCT", "URG", "dtbbksw", "QDT");
        this.addBbk("XCT", "URG", "wtbbksw", "QWT");
        this.addBbk("OTH", "URG", "m6bbksw", "QMH");
        this.addBbk("REP", "URG", "wabbksw", "QWA");
        this.addBbk("REP", "URG", "m3bbksw", "QM3");
        this.addBbk("REP", "URG", "m7bbksw", "QM7");
        this.addBbk("REP", "URG", "m8bbksw", "QM8");
        this.addBbk("REP", "URG", "m9bbksw", "QM9");
        this.add("DCT", BIL, "URG", "gtbbksw", null, U, "XG2");
        this.add("XCT", BIL, "URG", "dtbbksw", null, U, "XDT");
        this.add("XCT", BIL, "URG", "wtbbksw", null, U, "XWT");
        this.add("XCT", BIL, "URG", "dtazv", null, U, "XDZ");
        this.add("REP", BIL, "URG", "m3bbksw", null, D, "YM3");
        this.add("OTH", BIL, "URG", "m6bbksw", null, D, "YM6");
        this.add("REP", BIL, "URG", "m7bbksw", null, D, "YM7");
        this.add("REP", BIL, "URG", "m8bbksw", null, D, "YM8");
        this.add("REP", BIL, "URG", "m9bbksw", null, D, "YM9");
        this.add("DCT", BIL, "URG", "gtbbksw", null, D, "YG2");
        this.add("REP", BIL, "URG", "wabbksw", null, D, "YWA");
        this.add("OTH", BIL, null, "rfbbkazv", null, U, "FTB");
        this.add("OTH", BIL, null, "rfbbkazv", null, D, "FTB");
        this.add("SCI", "EBA", "O2SX", "pacs.008", "001", "08", null, U, "JIA");
        this.add("SCI", "EBA", "S2BX", "pacs.008", "001", "08", null, U, "JIB");
        this.add("SCI", "EBA", "B2SP", "pacs.002", "001", "10", null, U, "JIC");
        this.add("SCI", "EBA", "S2OP", "pacs.002", "001", "10", null, U, "JID");
        this.add("SCI", "EBA", "O2SX", "pacs.028", "001", "03", null, U, "JIE");
        this.add("SCI", "EBA", "S2BX", "pacs.028", "001", "03", null, U, "JIF");
        this.add("SCI", "EBA", "S2OX", "camt.052", "001", "10", null, U, "JIG");
        this.add("SCI", "EBA", "S2OX", "camt.054", "001", "06", null, U, "JIH");
        this.add("SCI", "EBA", "S2XN", "pacs.002", "001", "10", null, U, "JIK");
        this.add("SCI", "EBA", "O2SX", "camt.056", "001", "08", null, U, "JIR");
        this.add("SCI", "EBA", "S2BX", "camt.056", "001", "08", null, U, "JIS");
        this.add("SCI", "EBA", "B2SN", "camt.029", "001", "09", null, U, "JIT");
        this.add("SCI", "EBA", "S2ON", "camt.029", "001", "09", null, U, "JIU");
        this.add("SCI", "EBA", "B2SP", "pacs.004", "001", "09", null, U, "JIV");
        this.add("SCI", "EBA", "S2OP", "pacs.004", "001", "09", null, U, "JIW");
        this.add("SCI", "EBA", "O2SX", "admi.004", "001", "01", null, U, "JIX");
        this.add("SCI", "EBA", "S2OX", "admi.004", "001", "01", null, U, "JIY");
        this.add("SCI", "EBA", "O2SX", "camt.027", "001", "07", null, U, "JIZ");
        this.add("SCI", "EBA", "S2OX", "camt.027", "001", "07", null, U, "JOZ");
        this.add("SCI", "EBA", "S2OX", "psr", null, null, null, U, "JI1");
        this.add("SCI", "EBA", "S2OX", "rsf", null, null, null, U, "JI2");
        this.add("SCI", "EBA", "S2OX", "drr", null, null, null, U, "JI3");
        this.add("SCI", "EBA", "S2OX", "msr", null, null, null, U, "JI4");
        this.add("SCI", "EBA", "S2OX", "rtf", null, null, null, U, "JI5");
        this.add("SCI", "EBA", "T2OX", "camt.052", "001", "06", null, U, "JI6");
        this.add("SCI", "EBA", "T2OX", "camt.053", "001", "06", null, U, "JI7");
        this.add("SCI", "EBA", "T2OX", "camt.004", "001", "07", null, U, "JII");
        this.add("SCI", "EBA", "O2TX", "camt.050", "001", "05", null, U, "JIJ");
        this.add("SCI", "EBA", "T2OX", "camt.025", "001", "04", null, U, "JIM");
        this.add("SCI", "EBA", "O2TX", "camt.003", "001", "06", null, U, "JIN");
        this.add("SCI", "EBA", "S2BX", "pacs.002", "001", "03", null, U, "JIL");
        this.add("SCI", "EBA", "O2TX", "camt.005", "001", "07", null, U, "JIO");
        this.add("SCI", "EBA", "T2OX", "camt.006", "001", "07", null, U, "JIP");
        this.add("R2P", "EBA", "R2SX", "pain.013", "001", "07", null, U, "JPA");
        this.add("R2P", "EBA", "S2AX", "pain.013", "001", "07", null, U, "JPB");
        this.add("R2P", "EBA", "A2SX", "pain.014", "001", "07", null, U, "JPC");
        this.add("R2P", "EBA", "S2PX", "pain.014", "001", "07", null, U, "JPD");
        this.add("R2P", "EBA", "R2SX", "pacs.028", "001", "03", null, U, "JPE");
        this.add("R2P", "EBA", "S2AX", "pacs.028", "001", "03", null, U, "JPF");
        this.add("R2P", "EBA", "R2SX", "camt.055", "001", "08", null, U, "JPG");
        this.add("R2P", "EBA", "S2AX", "camt.055", "001", "08", null, U, "JPH");
        this.add("R2P", "EBA", "R2SX", "camt.029", "001", "09", null, U, "JPI");
        this.add("R2P", "EBA", "S2AX", "camt.029", "001", "09", null, U, "JPJ");
        this.add("R2P", "EBA", "P2SX", "admi.004", "001", "02", null, U, "JPX");
        this.add("R2P", "EBA", "S2PX", "admi.004", "001", "02", null, U, "JPY");
        this.add("R2P", "EBA", null, "drr", null, null, null, U, "JP1");
        this.add("R2P", "EBA", null, "msr", null, null, null, U, "JP2");
        this.add("R2P", "EBA", null, "rtf", null, null, null, U, "JP3");
        this.addEba("SCT", null, "ccf.s", "JAD");
        this.addEba("SCT", null, "ccf.b", "JBD");
        this.addEba("SCT", null, "crr.x", "JA4");
        this.addEba("SCT", null, "cvf.s", "JAB");
        this.addEba("SCT", null, "cvf.b", "JBB");
        this.addEba("SCT", null, "drr.x ", "JA1");
        this.addEba("SCT", null, "icf.s", "JAA");
        this.addEba("SCT", null, "icf.b", "JBA");
        this.addEba("SCT", null, "iqf.s", "JQA");
        this.addEba("SCT", null, "iqf.b", "JRA");
        this.addEba("SCT", null, "mar.x", "JA6");
        this.addEba("SCT", null, "nsr.x", "JA2");
        this.addEba("SCT", null, "oqf.s", "JQC");
        this.addEba("SCT", null, "oqf.b", "JRC");
        this.addEba("SCT", null, "pcf.s", "JAG");
        this.addEba("SCT", null, "pcf.b", "JBG");
        this.addEba("SCT", null, "psr.x", "JA5");
        this.addEba("SCT", null, "qvf.s", "JQB");
        this.addEba("SCT", null, "qvf.b", "JRB");
        this.addEba("SCT", null, "rtf.x", "JA3");
        this.addEba("SCT", null, "scf.s", "JAC");
        this.addEba("SCT", null, "scf.b", "JBC");
        this.addEba("SCT", null, "nrr.x", "JA7");
        this.addEba("SCT", "CGS", "scf.s", "JAN");
        this.addEba("SCT", "CGS", "scf.b", "JBN");
        this.addEba("SCT", "CGS", "ccf.s", "JAO");
        this.addEba("SCT", "CGS", "ccf.b", "JBO");
        this.addEba("SCT", "CGS", "pcf.s", "JAP");
        this.addEba("SCT", "CGS", "pcf.b", "JBP");
        this.addEba("SCT", "CGS", "drr.x", "JB1");
        this.addEba("SCT", "CGS", "msr.x", "JB2");
        this.addEba("SCT", "CGS", "rtf.x", "JB3");
        this.addEba("SCT", "CGS", "psr.x", "JB4");
        this.addEba("SCT", "CGS", "mar.x", "JB5");
        this.addEba("SCT", "CGS", "oqf.s", "JAR");
        this.addEba("SCT", "CGS", "oqf.b", "JBR");
        this.addEba("SCT", "CGS", "lnr.s", "JNA");
        this.addEba("SCT", "CGS", "nrr.x", "JB6");
        this.addEba("SCT", "CGS", "lmr.s", "JMA");
        this.addEba("SCT", "CGS", "igf.s", "JSA");
        this.addEba("SCT", "CGS", "ogf.s", "JAS");
        this.addEba("SCT", "CGS", "rsf.s", "JAT");
        this.addEba("SCT", "CGS", "rsf.b", "JBT");
        this.addEba("SDD", "B2B", "cdf.s", "JED");
        this.addEba("SDD", "B2B", "cdf.b", "JFD");
        this.addEba("SDD", "B2B", "dnf.s", "JEE");
        this.addEba("SDD", "B2B", "dnf.b", "JFE");
        this.addEba("SDD", "B2B", "drr.x", "JE1");
        this.addEba("SDD", "B2B", "dvf.s", "JEB");
        this.addEba("SDD", "B2B", "dvf.b", "JFB");
        this.addEba("SDD", "B2B", "idf.s", "JEA");
        this.addEba("SDD", "B2B", "idf.b", "JFA");
        this.addEba("SDD", "B2B", "mar.x", "JE6");
        this.addEba("SDD", "B2B", "msr.x", "JE2");
        this.addEba("SDD", "B2B", "psr.x", "JE5");
        this.addEba("SDD", "B2B", "rsf.s", "JEF");
        this.addEba("SDD", "B2B", "rsf.b", "JFF");
        this.addEba("SDD", "B2B", "rtf.x", "JE3");
        this.addEba("SDD", "B2B", "sdf.s", "JCC");
        this.addEba("SDD", "B2B", "sdf.b", "JDC");
        this.addEba("SDD", "COR", "cdf.s", "JCD");
        this.addEba("SDD", "COR", "cdf.b", "JDD");
        this.addEba("SDD", "COR", "dnf.s", "JCE");
        this.addEba("SDD", "COR", "dnf.b", "JDE");
        this.addEba("SDD", "COR", "drr.x", "JC1");
        this.addEba("SDD", "COR", "dvf.s", "JCB");
        this.addEba("SDD", "COR", "dvf.b", "JDB");
        this.addEba("SDD", "COR", "idf.s", "JCA");
        this.addEba("SDD", "COR", "idf.b", "JDA");
        this.addEba("SDD", "COR", "mar.x", "JC6");
        this.addEba("SDD", "COR", "msr.x", "JC2");
        this.addEba("SDD", "COR", "psr.x", "JC5");
        this.addEba("SDD", "COR", "rsf.s", "JCF");
        this.addEba("SDD", "COR", "rsf.b", "JDF");
        this.addEba("SDD", "COR", "rtf.x", "JC3");
        this.addEba("SDD", "COR", "sdf.s", "JCC");
        this.addEba("SDD", "COR", "sdf.b", "JDC");
        this.addEba("SDD", "CGSCOR", "dnf.s", "JCI");
        this.addEba("SDD", "CGSCOR", "dnf.b", "JDI");
        this.addEba("SDD", "CGSCOR", "rsf.s", "JCL");
        this.addEba("SDD", "CGSCOR", "rsf.b", "JDL");
        this.addEba("SDD", "CGSCOR", "drr.x", "JD1");
        this.addEba("SDD", "CGSCOR", "msr.x", "JD2");
        this.addEba("SDD", "CGSCOR", "rtf.x", "JD3");
        this.addEba("SDD", "CGSCOR", "psr.x", "JD4");
        this.addEba("SDD", "CGSCOR", "mar.x", "JD5");
        this.addEba("SDD", "CGSCOR", "lnr.s", "JNC");
        this.addEba("SDD", "CGSCOR", "lmr.s", "JMC");
        this.addEba("SDD", "CGSCOR", "dlr.s", "JUC");
        this.addEba("SDD", "CGSB2B", "dnf.s", "JEH");
        this.addEba("SDD", "CGSB2B", "dnf.b", "JFH");
        this.addEba("SDD", "CGSB2B", "rsf.s", "JEI");
        this.addEba("SDD", "CGSB2B", "rsf.b", "JFI");
        this.addEba("SDD", "CGSB2B", "drr.x", "JF1");
        this.addEba("SDD", "CGSB2B", "msr.x", "JF2");
        this.addEba("SDD", "CGSB2B", "rtf.x", "JF3");
        this.addEba("SDD", "CGSB2B", "psr.x", "JF4");
        this.addEba("SDD", "CGSB2B", "mar.x", "JF5");
        this.addEba("SDD", "CGSB2B", "lnr.s", "JNE");
        this.addEba("SDD", "CGSB2B", "lmr.s", "JME");
        this.addEba("SDD", "CGSB2B", "dlr.s", "JUE");
        this.addEba("SDD", "CGSCOR", "igf.s", "JKA");
        this.addEba("SDD", "CGSCOR", "ogf.s", "JCS");
        this.addEba("SDD", "CGSB2B", "igf.s", "JLA");
        this.addEba("SDD", "CGSB2B", "ogf.s", "JES");
        this.addEba("SCC", null, "cdf.s", "JGD");
        this.addEba("SCC", null, "cdf.b", "JHD");
        this.addEba("SCC", null, "dnf.s", "JGE");
        this.addEba("SCC", null, "dnf.b", "JHE");
        this.addEba("SCC", null, "drr.x", "JG1");
        this.addEba("SCC", null, "dvf.s", "JGB");
        this.addEba("SCC", null, "dvf.b", "JHB");
        this.addEba("SCC", null, "idf.s", "JGA");
        this.addEba("SCC", null, "idf.b", "JHA");
        this.addEba("SCC", null, "msr.x", "JG2");
        this.addEba("SCC", null, "psr.x", "JG5");
        this.addEba("SCC", null, "rsf.s", "JGF");
        this.addEba("SCC", null, "rsf.b", "JHF");
        this.addEba("SCC", null, "rtf.x", "JG3");
        this.addEba("SCC", null, "sdf.s", "JGC");
        this.addEba("SCC", null, "sdf.b", "JHC");
        this.add("OTH", "DE", null, "wssparam", null, D, "WSS");
        this.add("XCT", "AT", null, "pain.001", null, U, "ATX");
        this.add("MCT", "CH", null, "pain.001", null, U, "XE2");
        this.add("XCT", null, null, "pain.001", null, U, "XCT");
    }

    @Override
    public String getBTFFromSendOrderType2(String orderType) {
        RestrictedServiceType rst = t.convertSend(new OrderType(orderType));
        if (rst != null) {
            return BTFTranslator.convertToString(rst);
        }
        return null;
    }

    private void addBbk(String serviceName, String serviceOption, String message, String orderType) {
        this.add(serviceName, BBK, serviceOption, message, null, 'U', orderType);
    }

    private void addEba(String serviceName, String serviceOption, String message, String orderType) {
        this.add(serviceName, "EBA", serviceOption, message, null, 'U', orderType);
    }

    public static String getSendOrderTypeFromBTF(String s) throws IllegalArgumentException {
        OrderType ot;
        RestrictedServiceType rst = BTFTranslator.convertFromStringToBTF(s).getService();
        if (rst != null && (ot = t.convertSend(rst)) != null) {
            return ot.getValue();
        }
        return null;
    }

    public static String getFetchOrderTypeFromBTF(String s) throws IllegalArgumentException {
        RestrictedServiceType rst = BTFTranslator.convertFromStringToBTF(s).getService();
        if (rst != null) {
            OrderType ot = t.convertFetch(rst);
            if (ot != null) {
                return ot.getValue();
            }
            if (rst.getScope() != null && BBK.equals(rst.getScope().getValue()) && (ot = t.convertSend(rst)) != null) {
                return ot.getValue();
            }
        }
        return null;
    }

    public static String getBTFFromSendOrderType(String orderType) {
        RestrictedServiceType rst = t.convertSend(new OrderType(orderType));
        if (rst != null) {
            return BTFTranslator.convertToString(rst);
        }
        return null;
    }

    public static String getBTFFromFetchOrderType(String orderType) {
        RestrictedServiceType rst = t.convertFetch(new OrderType(orderType));
        if (rst != null) {
            return BTFTranslator.convertToString(rst);
        }
        rst = t.convertSend(new OrderType(orderType));
        if (rst != null && rst.getScope() != null && BBK.equals(rst.getScope().getValue())) {
            return BTFTranslator.convertToString(rst);
        }
        return null;
    }

    static {
        t = new BTFTranslator();
        STANDARD_FETCH_ORDER_TYPES = Collections.unmodifiableCollection(BTFTranslator.t.fetchOt2Btf.keySet());
        STANDARD_SEND_ORDER_TYPES = Collections.unmodifiableCollection(BTFTranslator.t.sendOt2Btf.keySet());
    }
}

