/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum BTFServiceOption {
    URG,
    COR,
    B2B,
    CFD,
    SDD,
    MCT,
    SCT,
    UCF,
    ICT;

    private static final Map<Locale, ResourceBundle> bundles;

    public static String getDescription(BTFServiceOption serviceOption, Locale locale) {
        if (serviceOption != null) {
            try {
                return BTFServiceOption.getBundle(locale).getString(serviceOption.name());
            }
            catch (MissingResourceException missingResourceException) {
                return serviceOption.name();
            }
        }
        return null;
    }

    private static ResourceBundle getBundle(Locale locale) {
        ResourceBundle result = bundles.get(locale);
        if (result == null) {
            result = ResourceBundle.getBundle("de.businesslogics.ebics.client.BTFServiceOption", locale);
            bundles.put(locale, result);
        }
        return result;
    }

    static {
        bundles = new HashMap<Locale, ResourceBundle>();
    }
}

