/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum BTFServiceName {
    DCT(Direction.UPLOAD),
    DDD(Direction.UPLOAD),
    EOP(Direction.DOWNLOAD),
    REP(Direction.DOWNLOAD),
    SCT(Direction.UPLOAD),
    SDD(Direction.UPLOAD),
    STM(Direction.DOWNLOAD),
    XCT(Direction.UPLOAD),
    ADD(Direction.BOTH),
    ACH(Direction.BOTH),
    ACT(Direction.BOTH),
    ARD(Direction.BOTH),
    ASW(Direction.BOTH),
    BAM(Direction.BOTH),
    BAV(Direction.BOTH),
    BCO(Direction.BOTH),
    CAI(Direction.BOTH),
    CBA(Direction.BOTH),
    CBT(Direction.BOTH),
    CCP(Direction.BOTH),
    CHQ(Direction.BOTH),
    CIM(Direction.BOTH),
    DAR(Direction.BOTH),
    DCO(Direction.BOTH),
    DVD(Direction.BOTH),
    ECH(Direction.BOTH),
    ECO(Direction.BOTH),
    EDC(Direction.BOTH),
    FCB(Direction.BOTH),
    FCT(Direction.BOTH),
    FXC(Direction.BOTH),
    GUA(Direction.BOTH),
    ICT(Direction.BOTH),
    IDC(Direction.BOTH),
    INV(Direction.BOTH),
    LCH(Direction.BOTH),
    MCT(Direction.BOTH),
    MKT(Direction.BOTH),
    PCO(Direction.BOTH),
    PMC(Direction.BOTH),
    PSR(Direction.BOTH),
    RCA(Direction.BOTH),
    RCH(Direction.BOTH),
    RCO(Direction.BOTH),
    RCT(Direction.BOTH),
    RDD(Direction.BOTH),
    RFT(Direction.BOTH),
    RSD(Direction.BOTH),
    RTP(Direction.BOTH),
    SCI(Direction.BOTH),
    SCC(Direction.BOTH),
    STD(Direction.BOTH),
    SES(Direction.BOTH),
    SEV(Direction.BOTH),
    SSM(Direction.BOTH),
    STR(Direction.BOTH),
    TRA(Direction.BOTH),
    VCT(Direction.BOTH),
    XDD(Direction.BOTH),
    OTH(Direction.BOTH);

    private final Direction direction;
    private static final Map<Locale, ResourceBundle> bundles;

    private BTFServiceName(Direction direction) {
        this.direction = direction;
    }

    public boolean isUploadService() {
        return Direction.UPLOAD.equals((Object)this.direction) || Direction.BOTH.equals((Object)this.direction);
    }

    public boolean isDownloadService() {
        return Direction.DOWNLOAD.equals((Object)this.direction) || Direction.BOTH.equals((Object)this.direction);
    }

    public static String getDescription(BTFServiceName serviceName, Locale locale) {
        if (serviceName != null) {
            try {
                return BTFServiceName.getBundle(locale).getString(serviceName.name());
            }
            catch (MissingResourceException missingResourceException) {
                return serviceName.name();
            }
        }
        return null;
    }

    private static ResourceBundle getBundle(Locale locale) {
        ResourceBundle result = bundles.get(locale);
        if (result == null) {
            result = ResourceBundle.getBundle("de.businesslogics.ebics.client.BTFServiceName", locale);
            bundles.put(locale, result);
        }
        return result;
    }

    static {
        bundles = new HashMap<Locale, ResourceBundle>();
    }

    private static enum Direction {
        UPLOAD,
        DOWNLOAD,
        BOTH;

    }
}

