/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.client;

import de.businesslogics.ebics.client.BTFTranslatorBase;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.request.OrderType;
import java.util.Collection;
import java.util.Collections;

public class AustrianBTFTranslator
extends BTFTranslatorBase {
    public static final Collection<OrderType> STANDARD_FETCH_ORDER_TYPES;
    public static final Collection<OrderType> STANDARD_SEND_ORDER_TYPES;
    private static final AustrianBTFTranslator t;

    public AustrianBTFTranslator() {
        this.add("SCT", "AT", null, "pain.001", null, U, "CCT");
        this.add("SCT", "AT", "URG", "pain.001", null, U, "CCU");
        this.add("SCI", "AT", null, "pain.001", null, U, "CIP");
        this.add("SDD", "AT", "COR", "pain.008", null, U, "CDD");
        this.add("SDD", "AT", "B2B", "pain.008", null, U, "CDB");
        this.add("XCT", null, null, "pain.001", null, U, "XCT");
        this.add("REP", "AT", "VOP", "pain.002", "ZIP", D, "VPZ");
        this.add("SCT", "AT", "VOI", "pain.001", null, U, "CTV");
        this.add("SCI", "AT", "VOI", "pain.001", null, U, "CIV");
        this.add("XCT", "AT", null, "pain.001", null, U, "AXZ");
        this.add("REP", "AT", "XCT", "pain.002", "ZIP", D, "AXS");
        this.add("RFT", "AT", null, "mt101", null, U, "RFT");
        this.add("EOP", "AT", null, "mt940", null, D, "STA");
        this.add("STM", "AT", null, "mt942", null, D, "VMK");
        this.add("EOP", "AT", null, "camt.053", "ZIP", D, "C53");
        this.add("STM", "AT", null, "camt.054", "ZIP", D, "C54");
        this.add("STM", "AT", null, "camt.052", "ZIP", D, "C52");
        this.add("EOP", "AT", null, "pdf", "ZIP", D, "BKA");
        this.add("REP", "BIL", null, "camt.086", "ZIP", D, "C86");
        this.add("REP", "AT", "SCT", "pain.002", "ZIP", D, "CRZ");
        this.add("REP", "AT", "SDD", "pain.002", "ZIP", D, "CDZ");
        this.add("OTH", "BIL", "DKI", "misc.", null, D, "DKI");
    }

    @Override
    public String getBTFFromSendOrderType2(String orderType) {
        RestrictedServiceType rst = t.convertSend(new OrderType(orderType));
        if (rst != null) {
            return AustrianBTFTranslator.convertToString(rst);
        }
        return null;
    }

    public static String getSendOrderTypeFromBTF(String s) throws IllegalArgumentException {
        OrderType ot;
        RestrictedServiceType rst = AustrianBTFTranslator.convertFromStringToBTF(s).getService();
        if (rst != null && (ot = t.convertSend(rst)) != null) {
            return ot.getValue();
        }
        return null;
    }

    public static String getFetchOrderTypeFromBTF(String s) throws IllegalArgumentException {
        OrderType ot;
        RestrictedServiceType rst = AustrianBTFTranslator.convertFromStringToBTF(s).getService();
        if (rst != null && (ot = t.convertFetch(rst)) != null) {
            return ot.getValue();
        }
        return null;
    }

    public static String getBTFFromSendOrderType(OrderType ot) {
        RestrictedServiceType rst = t.convertSend(ot);
        if (rst != null) {
            return AustrianBTFTranslator.convertToString(rst);
        }
        return null;
    }

    public static String getBTFFromSendOrderType(String orderType) {
        RestrictedServiceType rst = t.convertSend(new OrderType(orderType));
        if (rst != null) {
            return AustrianBTFTranslator.convertToString(rst);
        }
        return null;
    }

    public static String getBTFFromFetchOrderType(OrderType ot) {
        RestrictedServiceType rst = t.convertFetch(ot);
        if (rst != null) {
            return AustrianBTFTranslator.convertToString(rst);
        }
        return null;
    }

    public static String getBTFFromFetchOrderType(String orderType) {
        RestrictedServiceType rst = t.convertFetch(new OrderType(orderType));
        if (rst != null) {
            return AustrianBTFTranslator.convertToString(rst);
        }
        return null;
    }

    static {
        t = new AustrianBTFTranslator();
        STANDARD_FETCH_ORDER_TYPES = Collections.unmodifiableCollection(AustrianBTFTranslator.t.fetchOt2Btf.keySet());
        STANDARD_SEND_ORDER_TYPES = Collections.unmodifiableCollection(AustrianBTFTranslator.t.sendOt2Btf.keySet());
    }
}

