/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.crypto;

import de.businesslogics.crypto.Cipher;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;

public class CipherOutputStream
extends OutputStream {
    private final OutputStream out;
    private Cipher cipher;
    private final byte[] one_byte = new byte[1];

    public CipherOutputStream(Cipher cipher, OutputStream out) {
        this.cipher = cipher;
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.one_byte[0] = (byte)b;
        this.write(this.one_byte, 0, 1);
    }

    @Override
    public void close() throws IOException {
        if (this.cipher != null) {
            try {
                byte[] w = this.cipher.doFinal();
                if (w != null) {
                    this.out.write(w);
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
            finally {
                this.cipher = null;
            }
        }
        this.out.close();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] w = this.cipher.update(b, off, len);
        if (w != null) {
            this.out.write(w);
        }
    }
}

