/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.crypto;

import de.businesslogics.crypto.Cipher;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;

public class CipherInputStream
extends InputStream {
    private Cipher cipher;
    private final InputStream in;
    final byte[] one_byte = new byte[1];
    byte[] pending = null;
    int pendingPos;
    boolean eof = false;

    public CipherInputStream(Cipher cipher, InputStream in) {
        this.cipher = cipher;
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int toReturn = this.read(this.one_byte, 0, 1);
        if (toReturn != 1) {
            return toReturn;
        }
        return this.one_byte[0] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.pending == null) {
            this.pending = new byte[128];
            if (!this.fillPending()) {
                return -1;
            }
        }
        int read = 0;
        while (length > 0) {
            int pl = this.pending.length - this.pendingPos;
            if (length < pl) {
                System.arraycopy(this.pending, this.pendingPos, buffer, offset, length);
                this.pendingPos += length;
                return read + length;
            }
            System.arraycopy(this.pending, this.pendingPos, buffer, offset, pl);
            offset += pl;
            length -= pl;
            read += pl;
            if (this.fillPending()) continue;
            return read > 0 ? read : -1;
        }
        return read;
    }

    @Override
    public int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        int result = this.in.available();
        if (this.pending != null) {
            result += this.pending.length - this.pendingPos;
        }
        return result;
    }

    private boolean fillPending() throws IOException {
        if (this.cipher == null) {
            this.eof = true;
            return false;
        }
        byte[] buffer = this.pending.length < 128 ? new byte[128] : this.pending;
        this.pendingPos = 0;
        do {
            int i;
            if ((i = this.in.read(buffer)) < 0) {
                try {
                    this.pending = this.cipher.doFinal();
                }
                catch (GeneralSecurityException gse) {
                    this.pending = null;
                }
                this.cipher = null;
                this.eof = this.pending == null;
                return !this.eof;
            }
            this.pending = this.cipher.update(buffer, 0, i);
        } while (this.pending == null);
        return true;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

