/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.crypto;

import de.businesslogics.bouncycastle.crypto.BlockCipher;
import de.businesslogics.bouncycastle.crypto.engines.AESFastEngine;
import de.businesslogics.bouncycastle.crypto.engines.DESEngine;
import de.businesslogics.bouncycastle.crypto.engines.DESedeEngine;
import de.businesslogics.bouncycastle.crypto.modes.CBCBlockCipher;
import de.businesslogics.bouncycastle.crypto.modes.SICBlockCipher;
import de.businesslogics.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import de.businesslogics.crypto.Cipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class BCBlockCipher
extends BaseBlockCipher
implements Cipher {
    protected BCBlockCipher(BlockCipher cipher, int ivLength) {
        super(cipher, ivLength);
    }

    public void setPadding(String padding) throws NoSuchPaddingException {
        super.engineSetPadding(padding);
    }

    @Override
    public void init(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        super.engineInit(opmode, key, params, null);
    }

    public void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        super.engineInit(opmode, key, params, random);
    }

    @Override
    public byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        return super.engineDoFinal(null, 0, 0);
    }

    @Override
    public byte[] doFinal(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        return super.engineDoFinal(input, 0, input.length);
    }

    @Override
    public byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return super.engineDoFinal(input, inputOffset, inputLen);
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        return super.engineDoFinal(input, inputOffset, inputLen, output, 0);
    }

    @Override
    public int getBlockSize() {
        return super.engineGetBlockSize();
    }

    @Override
    public int getOutputSize(int inputLen) {
        return super.engineGetOutputSize(inputLen);
    }

    @Override
    public byte[] update(byte[] input, int inputOffset, int inputLen) {
        return super.engineUpdate(input, inputOffset, inputLen);
    }

    public static BCBlockCipher createDESedeCBCPKCS5Padding() {
        return new BCBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine()), 64);
    }

    public static BCBlockCipher createDESedeCBCX923Padding() {
        BCBlockCipher toReturn = new BCBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine()), 64);
        try {
            toReturn.setPadding("X9.23Padding");
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Weird security setup", e);
        }
        return toReturn;
    }

    public static BCBlockCipher createDESCBCPKCS5Padding() {
        return new BCBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new DESEngine()), 64);
    }

    public static BCBlockCipher createAESCBCX923Padding() {
        BCBlockCipher toReturn = new BCBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()), 128);
        try {
            toReturn.setPadding("X9.23Padding");
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Weird security setup", e);
        }
        return toReturn;
    }

    public static BCBlockCipher createAESCTRPKCS7Padding() {
        BCBlockCipher toReturn = new BCBlockCipher((BlockCipher)new SICBlockCipher((BlockCipher)new AESFastEngine()), 128);
        try {
            toReturn.setPadding("PKCS7Padding");
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Weird security setup", e);
        }
        return toReturn;
    }

    public static BCBlockCipher createAESCTRNoPadding() {
        BCBlockCipher toReturn = new BCBlockCipher((BlockCipher)new SICBlockCipher((BlockCipher)new AESFastEngine()), 128);
        try {
            toReturn.setPadding("NoPadding");
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Weird security setup", e);
        }
        return toReturn;
    }
}

