/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bltransfer.ebics.client;

import de.businesslogics.ebics.client.EbicsBusinessUser;
import de.businesslogics.ebics.client.EbicsSession;
import de.businesslogics.ebics.client.FetchTransferState;
import de.businesslogics.ebics.client.FileTransfer;
import de.businesslogics.ebics.client.SendTransferState;
import de.businesslogics.ebics.schema.Token;
import de.businesslogics.ebics.schema.orders.GenericOrderParams;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.types.Parameter;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.io.ByteArrayContentFactory;
import de.businesslogics.util.Base64Util;
import de.businesslogics.util.HexTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Scanner;

public final class KeyMgmt
extends FileTransfer {
    public static final OrderType ORDER_TYPE = new OrderType("XKM");
    private GenericOrderParams orderParams;
    private List<SignInfo> signInfoList;
    private byte[] signedRequest;

    public KeyMgmt(EbicsSession session) {
        super(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SignInfo> fetchSignInfo(SignatureVersion sigVersion, RSAPublicKey newSigKey, List<X509Certificate> newSigCerts, RSAPublicKey newAuthKey, List<X509Certificate> newAuthCerts, RSAPublicKey newEncrKey, List<X509Certificate> newEncrCerts) throws EbicsException, IOException {
        this.orderParams = new GenericOrderParams();
        if (newSigKey != null) {
            KeyMgmt.addParams(this.orderParams, "SIG_", newSigKey, newSigCerts);
            this.orderParams.getParameters().add(new Parameter(new Token("SIG_VERSION"), new Parameter.Value(sigVersion.getValue())));
        }
        KeyMgmt.addParams(this.orderParams, "AUTH_", newAuthKey, newAuthCerts);
        KeyMgmt.addParams(this.orderParams, "ENCR_", newEncrKey, newEncrCerts);
        ByteArrayOutputStream responseData = new ByteArrayOutputStream();
        FetchTransferState state = this.fetchFileIntern(ORDER_TYPE, this.orderParams, responseData);
        while (this.nextChunk(state)) {
        }
        this.signInfoList = new ArrayList<SignInfo>();
        try (Scanner responseScanner = new Scanner(new ByteArrayInputStream(responseData.toByteArray()));){
            while (responseScanner.hasNextLine()) {
                String line = responseScanner.nextLine();
                if (line.length() <= 3) continue;
                this.signInfoList.add(new SignInfo(line.substring(0, 3), Base64Util.decode(line.substring(3))));
            }
            List<SignInfo> list = this.signInfoList;
            return list;
        }
    }

    public byte[] buildSignedRequest() {
        if (this.signInfoList == null) {
            throw new RuntimeException("Cannot build request before fetching the information from the transfer system!");
        }
        EbicsBusinessUser user = this.session.getBusinessUser();
        Date now = new Date();
        StringBuilder requestData = new StringBuilder();
        for (SignInfo signInfo : this.signInfoList) {
            byte[] signature = user.sign(signInfo.getDigest(), "memory", now, signInfo.getOrderType());
            requestData.append(signInfo.getOrderType()).append(Base64Util.encode(signInfo.getDigest())).append(':').append(Base64Util.encode(signature)).append('\n');
        }
        this.signedRequest = requestData.toString().getBytes();
        return this.signedRequest;
    }

    public OrderID updateKeys() throws IOException, EbicsException {
        if (this.signedRequest == null || this.orderParams == null) {
            throw new RuntimeException("Cannot send request before creating the signed information!");
        }
        SendTransferState state = this.sendFileIntern(new ByteArrayContentFactory(this.signedRequest), "memory", ORDER_TYPE, null, null, false, this.orderParams, null);
        while (this.nextChunk(state)) {
        }
        return state.getOrderID();
    }

    private static void addParams(GenericOrderParams params, String prefix, RSAPublicKey newKey, List<X509Certificate> certs) {
        if (newKey == null) {
            return;
        }
        List<Parameter> ps = params.getParameters();
        Token t = new Token(prefix + "MODULUS");
        Parameter.Value v = new Parameter.Value(Base64Util.encode(HexTool.stripZeros(newKey.getModulus().toByteArray())));
        ps.add(new Parameter(t, v));
        t = new Token(prefix + "EXPONENT");
        v = new Parameter.Value(Base64Util.encode(HexTool.stripZeros(newKey.getPublicExponent().toByteArray())));
        ps.add(new Parameter(t, v));
        if (certs == null) {
            return;
        }
        try {
            for (int i = 0; i < certs.size(); ++i) {
                t = new Token(prefix + "CERT" + i);
                v = new Parameter.Value(Base64Util.encode(certs.get(i).getEncoded()));
                ps.add(new Parameter(t, v));
            }
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class SignInfo {
        private final String orderType;
        private final byte[] digest;

        public SignInfo(String orderType, byte[] digest) {
            this.orderType = orderType;
            this.digest = digest;
        }

        public String getOrderType() {
            return this.orderType;
        }

        public byte[] getDigest() {
            return this.digest;
        }
    }
}

