/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bcs.core;

import java.io.Serializable;

public final class OrderNumber
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String orderNumber;

    public OrderNumber(String orderNumber) {
        if (orderNumber.length() != 4) {
            throw new IllegalArgumentException("Order number has to be 4 characters long");
        }
        this.orderNumber = orderNumber;
    }

    public static String fullNext(String in) {
        char[] c = new char[4];
        in.getChars(0, 4, c, 0);
        for (int i = 3; i >= 0; --i) {
            if (c[i] >= 'Z') {
                c[i] = i == 0 ? 65 : 48;
                continue;
            }
            if (c[i] == '9') {
                c[i] = 65;
                break;
            }
            int n = i;
            c[n] = (char)(c[n] + '\u0001');
            break;
        }
        return new String(c);
    }

    public static String next(String in) {
        char[] c = new char[4];
        in.getChars(0, 4, c, 0);
        for (int i = 3; i > 0; --i) {
            if (c[i] >= 'Z') {
                c[i] = 48;
                continue;
            }
            if (c[i] == '9') {
                c[i] = 65;
                break;
            }
            int n = i;
            c[n] = (char)(c[n] + '\u0001');
            break;
        }
        return new String(c);
    }

    public OrderNumber next() {
        return new OrderNumber(OrderNumber.next(this.orderNumber));
    }

    public OrderNumber fullNext() {
        return new OrderNumber(OrderNumber.fullNext(this.orderNumber));
    }

    public static String previous(String in) {
        char[] c = new char[4];
        in.getChars(0, 4, c, 0);
        for (int i = 3; i > 0; --i) {
            if (c[i] == 'A') {
                c[i] = 57;
                break;
            }
            if (c[i] == '0') {
                c[i] = 90;
                continue;
            }
            int n = i;
            c[n] = (char)(c[n] - '\u0001');
            break;
        }
        return new String(c);
    }

    public OrderNumber previous() {
        return new OrderNumber(OrderNumber.previous(this.orderNumber));
    }

    public String toString() {
        return this.orderNumber;
    }

    public int hashCode() {
        return this.orderNumber.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof OrderNumber) {
            return this.orderNumber.equals(((OrderNumber)o).orderNumber);
        }
        return false;
    }
}

