/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bcs.appetizer;

import de.businesslogics.bcs.appetizer.Messages;
import de.businesslogics.ebics.security.SignatureHandler;
import de.businesslogics.io.Streams;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

public class INILetter {
    private static final float LEADING = 20.0f;
    public static byte[] IMAGE = null;

    public static void printINI(OutputStream os, String hostId, String customerId, String userId, Date date, Locale locale) {
        INILetter.printINI(os, hostId, customerId, userId, null, null, null, null, date, locale);
    }

    public static void printINI(OutputStream os, String hostId, String customerId, byte[] ini, byte[] hash, Date iniDate, Locale locale) {
        byte[] exponent = new byte[128];
        byte[] modulus = new byte[128];
        System.arraycopy(ini, 16, exponent, 0, 128);
        System.arraycopy(ini, 148, modulus, 0, 128);
        INILetter.printINI(os, hostId, customerId, new String(ini, 4, 8), new String(ini, 0, 4), exponent, modulus, hash, iniDate, locale);
    }

    public static void printINI(OutputStream os, String hostId, String customerId, String userId, String keyVersion, RSAPublicKey pubKey, Date iniDate, Locale locale) {
        byte[] exponent = pubKey.getPublicExponent().toByteArray();
        byte[] modulus = pubKey.getModulus().toByteArray();
        SignatureHandler sh = SignatureHandler.getInstance(Integer.parseInt(keyVersion.substring(1)));
        byte[] hash = sh.getHash(pubKey);
        INILetter.printINI(os, hostId, customerId, userId, keyVersion, exponent, modulus, hash, iniDate, locale);
    }

    private static void printINI(OutputStream os, String hostId, String customerId, String userId, String keyVersion, byte[] exponent, byte[] modulus, byte[] hash, Date iniDate, Locale locale) {
        ResourceBundle bundle = Messages.getBundle(locale);
        try {
            BLDocument document = PDFCreator.getInstance().createDocument(BLDocument.PageLayout.A4, locale, 70.0f, 30.0f, 70.0f, 30.0f);
            document.addMetaInformation(bundle.getString("INILetter.title"), "Business-Logics GmbH", "BL-Demo", true, true);
            document.open(os);
            if (IMAGE != null) {
                document.addLogo(IMAGE, 20.0f);
            }
            INILetter.write(document, hostId, customerId, userId, keyVersion, exponent, modulus, hash, iniDate, bundle);
            document.close();
        }
        catch (PDFException pdfe) {
            throw new RuntimeException(pdfe);
        }
    }

    private static void write(BLDocument document, String hostId, String customerId, String userId, String keyVersion, byte[] exponent, byte[] modulus, byte[] hash, Date iniDate, ResourceBundle bundle) throws PDFException {
        Object headline = bundle.getString("INILetter.header");
        if (!StringUtils.isEmpty(keyVersion)) {
            headline = (String)headline + " (" + keyVersion + ")";
        }
        document.addHeadline((String)headline, BLFont.H1_INI_HIA, 0.0f);
        if (iniDate == null) {
            iniDate = new Date();
        }
        BLTable<?> t = PDFCreator.getInstance().createTable(2, Alignment.ALIGN_LEFT);
        t.setBorder(BLBorder.NO_BORDER);
        t.setWidth(30.0f);
        t.addCell(bundle.getString("INILetter.date"));
        SimpleDateFormat SDF = new SimpleDateFormat(bundle.getString("INILetter.dateFormat"));
        t.addCell(SDF.format(iniDate));
        t.addCell(bundle.getString("INILetter.time"));
        t.addCell(new SimpleDateFormat(bundle.getString("INILetter.timeformat")).format(iniDate));
        t.addCell(bundle.getString("INILetter.recipient"));
        t.addCell(hostId);
        t.addCell(bundle.getString("INILetter.userId"));
        t.addCell(userId);
        t.addCell(bundle.getString("INILetter.customerId"));
        t.addCell(customerId);
        if (!StringUtils.isEmpty(keyVersion)) {
            t.addCell(bundle.getString("INILetter.version"));
            t.addCell(keyVersion);
        }
        document.addTable(t);
        if (!StringUtils.isEmpty(keyVersion)) {
            document.addTextln(bundle.getString("INILetter.publicKey"), 20.0f);
            INILetter.addBytes(document, bundle.getString("INILetter.exponent"), new BigInteger(1, exponent));
            INILetter.addBytes(document, bundle.getString("INILetter.modulus"), new BigInteger(1, modulus));
            INILetter.addHash(document, bundle.getString("INILetter.digest"), hash);
            document.addTextln(bundle.getString("INILetter.confirm"), 20.0f);
        } else {
            document.addTextln(bundle.getString("INILetter.confirmPUB"), 20.0f);
        }
        document.addSignatureFields(bundle.getString("INILetter.placeDate"), bundle.getString("INILetter.companyName"), bundle.getString("INILetter.signature"));
    }

    private static void addHash(BLDocument document, String name, byte[] hash) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(1);
        t.setWidth(100.0f);
        t.setBorder(BLBorder.NO_BORDER);
        t.addCell(name);
        document.addTable(t);
        t = PDFCreator.getInstance().createTable(hash.length % 16 == 0 ? 16 : 10);
        t.setBorder(BLBorder.NO_BORDER);
        byte[] b = new byte[1];
        byte[] byArray = hash;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte value;
            b[0] = value = byArray[i];
            t.addCell(HexTool.toHex(b));
        }
        document.addTable(t);
    }

    private static void addBytes(BLDocument document, String name, BigInteger value) throws PDFException {
        int length = value.bitLength();
        BLTable<?> t = PDFCreator.getInstance().createTable(2);
        t.setWidth(100.0f);
        t.setBorder(BLBorder.NO_BORDER);
        t.addCell(name);
        t.addCell(Integer.toString(length), Alignment.ALIGN_RIGHT, null);
        document.addTable(t);
        boolean small = value.bitLength() > 2048;
        t = PDFCreator.getInstance().createTable(small ? 32 : 16);
        t.setBorder(BLBorder.NO_BORDER);
        t.setWidth(80.0f);
        byte[] b = new byte[1];
        byte[] arr = value.toByteArray();
        int i = 0;
        while (arr[i] == 0) {
            ++i;
        }
        i = small ? (i -= 31 - (arr.length - i - 1) % 32) : (i -= 15 - (arr.length - i - 1) % 16);
        while (i < 0) {
            t.addCell("00", small ? BLFont.FONT_SMALL : BLFont.FONT_NORMAL);
            ++i;
        }
        while (i < arr.length) {
            b[0] = arr[i];
            t.addCell(HexTool.toHex(b), small ? BLFont.FONT_SMALL : BLFont.FONT_NORMAL);
            ++i;
        }
        document.addTable(t);
    }

    static {
        try {
            InputStream is = INILetter.class.getResourceAsStream("/bllogo.png");
            if (is != null) {
                IMAGE = Streams.readAllAndClose(is);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

