/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bcs.appetizer;

import de.businesslogics.bcs.appetizer.INILetter;
import de.businesslogics.bcs.appetizer.Messages;
import de.businesslogics.bouncycastle.openssl.jcajce.JcaPEMWriter;
import de.businesslogics.ebics.schema.types.AuthenticationVersion;
import de.businesslogics.ebics.schema.types.EncryptionVersion;
import de.businesslogics.ebics.security.AuthenticationHandler;
import de.businesslogics.ebics.security.EncryptionHandler;
import de.businesslogics.ebics.security.SignatureHandler;
import de.businesslogics.io.Streams;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.security.auth.x500.X500Principal;

public class HIALetter {
    private static final float LEADING = 20.0f;
    private static final long UNLIMITED_VALIDITY = SignatureHandler.ENDLESS_CERT_EXPIRATION - 86400000L;
    public static byte[] IMAGE = null;

    public static void printINIandHIA(OutputStream os, String hostId, String partnerId, String userId, String keyVersion, X509Certificate pubKey, EncryptionVersion ev, X509Certificate encrKey, AuthenticationVersion av, X509Certificate authKey, Date iniDate, Locale locale) {
        HIALetter.printINIandHIA(os, null, hostId, partnerId, userId, null, keyVersion, pubKey, ev, encrKey, av, authKey, iniDate, locale);
    }

    public static void printINIandHIA(OutputStream os, String bankName, String hostId, String partnerId, String userId, String username, String keyVersion, X509Certificate pubKey, EncryptionVersion ev, X509Certificate encrKey, AuthenticationVersion av, X509Certificate authKey, Date iniDate, Locale locale) {
        ResourceBundle bundle = Messages.getBundle(locale);
        try {
            BLDocument document = PDFCreator.getInstance().createDocument(BLDocument.PageLayout.A4, locale, 70.0f, 30.0f, 70.0f, 30.0f);
            document.addMetaInformation(bundle.getString("HIALetter.titleINIHIA"), "Business-Logics GmbH", "HIALetter", true, true);
            document.open(os);
            if (IMAGE != null) {
                document.addLogo(IMAGE, 20.0f);
            }
            document.addHeadline(bundle.getString("HIALetter.titleINIHIA"), BLFont.H1_INI_HIA, 0.0f);
            if (iniDate == null) {
                iniDate = new Date();
            }
            BLTable<?> t = PDFCreator.getInstance().createTable(2, Alignment.ALIGN_LEFT);
            t.setBorder(BLBorder.NO_BORDER);
            t.setWidths(new int[]{20, 80});
            if (username != null && username.length() > 0) {
                t.addCell(bundle.getString("HIALetter.username"));
                t.addCell(username);
            }
            t.addCell(bundle.getString("INILetter.date"));
            SimpleDateFormat SDF = new SimpleDateFormat(bundle.getString("HIALetter.format"));
            t.addCell(SDF.format(iniDate));
            t.addCell(bundle.getString("INILetter.recipient"));
            if (bankName == null || bankName.length() == 0) {
                t.addCell(hostId);
            } else {
                t.addCell(bankName);
                t.addCell(bundle.getString("HIALetter.hostId"));
                t.addCell(hostId);
            }
            t.addCell(bundle.getString("INILetter.customerId"));
            t.addCell(partnerId);
            t.addCell(bundle.getString("INILetter.userId"));
            t.addCell(userId);
            document.addTable(t);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            HIALetter.write(document, "INILetter.certificate", keyVersion, pubKey, digest.digest(pubKey.getEncoded()), bundle, locale);
            HIALetter.write(document, "HIALetter.encrCert", ev.getValue(), encrKey, digest.digest(encrKey.getEncoded()), bundle, locale);
            HIALetter.write(document, "HIALetter.authCert", av.getValue(), authKey, digest.digest(authKey.getEncoded()), bundle, locale);
            document.addTextln(bundle.getString("HIALetter.confirm"), 20.0f);
            document.addSignatureFields(bundle.getString("HIALetter.placeDate"), bundle.getString("HIALetter.companyName"), bundle.getString("HIALetter.signature"));
            document.close();
        }
        catch (PDFException | GeneralSecurityException pdfe) {
            throw new RuntimeException(pdfe);
        }
    }

    public static void printINIandHIA(OutputStream os, String bankName, String hostId, String partnerId, String userId, String keyVersion, RSAPublicKey pubKey, EncryptionVersion ev, RSAPublicKey encrKey, AuthenticationVersion av, RSAPublicKey authKey, Date iniDate, Locale locale) {
        HIALetter.printINIandHIA(os, bankName, hostId, partnerId, userId, null, keyVersion, pubKey, ev, encrKey, av, authKey, iniDate, locale);
    }

    public static void printINIandHIA(OutputStream os, String bankName, String hostId, String partnerId, String userId, String username, String keyVersion, RSAPublicKey pubKey, EncryptionVersion ev, RSAPublicKey encrKey, AuthenticationVersion av, RSAPublicKey authKey, Date iniDate, Locale locale) {
        ResourceBundle bundle = Messages.getBundle(locale);
        try {
            BLDocument document = PDFCreator.getInstance().createDocument(BLDocument.PageLayout.A4, 70.0f, 30.0f, 70.0f, 30.0f);
            document.addMetaInformation(bundle.getString("HIALetter.titleINIHIA"), "Business-Logics GmbH", "HIALetter", true, true);
            document.open(os);
            if (IMAGE != null) {
                document.addLogo(IMAGE, 20.0f);
            }
            document.addHeadline(bundle.getString("HIALetter.titleINIHIA"), BLFont.H1_INI_HIA, 0.0f);
            BLTable<?> t = PDFCreator.getInstance().createTable(2, Alignment.ALIGN_LEFT);
            t.setBorder(BLBorder.NO_BORDER);
            if (username != null && username.length() > 0) {
                t.setWidths(new int[]{20, 80});
                t.addCell(bundle.getString("HIALetter.username"));
                t.addCell(username);
            } else {
                t.setWidths(new int[]{15, 85});
            }
            t.addCell(bundle.getString("INILetter.date"));
            SimpleDateFormat SDF = new SimpleDateFormat(bundle.getString("HIALetter.format"));
            t.addCell(SDF.format(iniDate));
            t.addCell(bundle.getString("INILetter.recipient"));
            if (bankName == null || bankName.length() == 0) {
                t.addCell(hostId);
            } else {
                t.addCell(bankName);
                t.addCell(bundle.getString("HIALetter.hostId"));
                t.addCell(hostId);
            }
            t.addCell(bundle.getString("INILetter.customerId"));
            t.addCell(partnerId);
            t.addCell(bundle.getString("INILetter.userId"));
            t.addCell(userId);
            document.addTable(t);
            int maxKeyLength = Math.max(pubKey.getModulus().bitLength(), Math.max(authKey.getModulus().bitLength(), encrKey.getModulus().bitLength()));
            BLFont font = maxKeyLength <= 2048 ? BLFont.COURIER_SMALL : BLFont.COURIER_VERY_SMALL;
            SignatureHandler sh = SignatureHandler.getInstance(Integer.parseInt(keyVersion.substring(1)));
            byte[] hash = sh.getHash(pubKey);
            document.addTextln(bundle.getString("INILetter.publicKey") + " (" + keyVersion + ")", 20.0f);
            document.addTextln(HIALetter.toText(hash, false));
            document.addTextln(bundle.getString("HIALetter.exponent") + ": " + HIALetter.toText(pubKey.getPublicExponent().toByteArray(), true), font);
            document.addTextln(bundle.getString("HIALetter.modulus") + " (" + pubKey.getModulus().bitLength() + "): " + HIALetter.toText(pubKey.getModulus().toByteArray(), true), font);
            document.addTextln(bundle.getString("HIALetter.authKey") + " (" + av.getValue() + ")", 20.0f);
            hash = AuthenticationHandler.getInstance(av).getHash(authKey);
            document.addTextln(HIALetter.toText(hash, false));
            document.addTextln(bundle.getString("HIALetter.exponent") + ": " + HIALetter.toText(authKey.getPublicExponent().toByteArray(), true), font);
            document.addTextln(bundle.getString("HIALetter.modulus") + " (" + authKey.getModulus().bitLength() + "): " + HIALetter.toText(authKey.getModulus().toByteArray(), true), font);
            document.addTextln(bundle.getString("HIALetter.encrKey") + " (" + ev.getValue() + ")", 20.0f);
            hash = EncryptionHandler.getInstance(ev).getHash(encrKey);
            document.addTextln(HIALetter.toText(hash, false));
            document.addTextln(bundle.getString("HIALetter.exponent") + ": " + HIALetter.toText(encrKey.getPublicExponent().toByteArray(), true), font);
            document.addTextln(bundle.getString("HIALetter.modulus") + " (" + encrKey.getModulus().bitLength() + "): " + HIALetter.toText(encrKey.getModulus().toByteArray(), true), font);
            document.addTextln(bundle.getString("HIALetter.confirm"), 30.0f);
            document.addSignatureFields(bundle.getString("HIALetter.placeDate"), bundle.getString("HIALetter.companyName"), bundle.getString("HIALetter.signature"));
            document.close();
        }
        catch (PDFException pdfe) {
            throw new RuntimeException(pdfe);
        }
    }

    private static String toText(byte[] in, boolean removeZeros) {
        StringBuilder b = new StringBuilder();
        byte[] tmp = new byte[1];
        for (byte value : in) {
            if (value == 0 && removeZeros) continue;
            removeZeros = false;
            tmp[0] = value;
            b.append(HexTool.toHex(tmp));
            b.append(" ");
        }
        return b.toString();
    }

    public static void printHIA(OutputStream os, String bankName, String partnerId, String userId, EncryptionVersion ev, RSAPublicKey encrKey, AuthenticationVersion av, RSAPublicKey authKey, Date iniDate, Locale locale) {
        ResourceBundle bundle = Messages.getBundle(locale);
        try {
            BLDocument document = PDFCreator.getInstance().createDocument(BLDocument.PageLayout.A4, 70.0f, 30.0f, 70.0f, 30.0f);
            document.addMetaInformation(bundle.getString("HIALetter.titleINIHIA"), "Business-Logics GmbH", "HIALetter", true, true);
            document.open(os);
            if (IMAGE != null) {
                document.addLogo(IMAGE, 20.0f);
            }
            HIALetter.write(document, bankName, partnerId, userId, ev, encrKey, av, authKey, iniDate, bundle);
            document.close();
        }
        catch (PDFException pdfe) {
            throw new RuntimeException(pdfe);
        }
    }

    private static void write(BLDocument document, String bundleName, String version, X509Certificate certificate, byte[] hash, ResourceBundle bundle, Locale locale) throws PDFException {
        MessageFormat mf = new MessageFormat(bundle.getString(bundleName + "_hash"), bundle.getLocale());
        String nameHash = mf.format(new Object[]{"SHA-256"}, new StringBuffer(), (FieldPosition)null).toString();
        Object nameCert = bundle.getString(bundleName);
        if (!StringUtils.isEmpty(version)) {
            mf = new MessageFormat(bundle.getString(bundleName + "_version"), bundle.getLocale());
            nameCert = (String)nameCert + " " + mf.format(new Object[]{version}, new StringBuffer(), (FieldPosition)null).toString();
        }
        BLTable<?> t = PDFCreator.getInstance().createTable(2);
        t.setWidth(100.0f);
        t.setCellspacing(5.0f);
        t.setBorder(BLBorder.NO_BORDER);
        HIALetter.addHashAndCertInfo(t, nameHash, hash, certificate, bundle, locale);
        HIALetter.addCertificate(t, (String)nameCert, certificate);
        document.addTable(t, 20.0f);
    }

    private static void write(BLDocument document, String bankName, String partnerId, String userId, EncryptionVersion ev, RSAPublicKey encrKey, AuthenticationVersion av, RSAPublicKey authKey, Date iniDate, ResourceBundle bundle) throws PDFException {
        document.addHeadline(bundle.getString("HIALetter.titleHIA"), BLFont.H1_INI_HIA, 0.0f);
        BLTable<?> t = PDFCreator.getInstance().createTable(2, Alignment.ALIGN_LEFT);
        t.setBorder(BLBorder.NO_BORDER);
        t.setWidth(50.0f);
        t.setWidths(new int[]{40, 60});
        t.addCell(bundle.getString("HIALetter.dateTime"));
        SimpleDateFormat SDF = new SimpleDateFormat(bundle.getString("HIALetter.format"));
        t.addCell(SDF.format(iniDate));
        t.addCell(bundle.getString("HIALetter.recipient"));
        t.addCell(bankName);
        t.addCell(bundle.getString("HIALetter.userId"));
        t.addCell(userId);
        t.addCell(bundle.getString("HIALetter.customerId"));
        t.addCell(partnerId);
        document.addTable(t);
        HIALetter.addKey(document, bundle.getString("HIALetter.authKey") + " (" + av.getValue() + ")", authKey, AuthenticationHandler.getInstance(av).getHash(authKey), bundle);
        HIALetter.addKey(document, bundle.getString("HIALetter.encrKey") + " (" + ev.getValue() + ")", encrKey, EncryptionHandler.getInstance(ev).getHash(encrKey), bundle);
        document.addTextln(bundle.getString("HIALetter.confirm"), 20.0f);
        document.addSignatureFields(bundle.getString("HIALetter.placeDate"), bundle.getString("HIALetter.companyName"), bundle.getString("HIALetter.signature"));
    }

    private static void addKey(BLDocument document, String name, RSAPublicKey key, byte[] hash, ResourceBundle bundle) throws PDFException {
        document.addTextln(name, 20.0f);
        HIALetter.addBytes(document, bundle.getString("HIALetter.exponent"), key.getPublicExponent());
        HIALetter.addBytes(document, bundle.getString("HIALetter.modulus"), key.getModulus());
        HIALetter.addHash(document, bundle.getString("HIALetter.digest"), hash);
    }

    private static void addCertificate(BLTable<?> table, String name, X509Certificate cert) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(1);
        t.setWidth(100.0f);
        t.setBorder(BLBorder.NO_BORDER);
        t.addCell(name);
        t.addCell(HIALetter.getPrintableCert(cert), BLFont.COURIER_VERY_SMALL);
        table.addCell(t);
    }

    private static void addHashAndCertInfo(BLTable<?> table, String nameHash, byte[] hash, X509Certificate cert, ResourceBundle bundle, Locale locale) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(1);
        t.setWidth(100.0f);
        t.setBorder(BLBorder.NO_BORDER);
        t.addCell(nameHash);
        t.addEmptyCell(5.0f);
        BLTable<?> t2 = HIALetter.getHash(hash, hash.length % 8 == 0 ? 8 : 10);
        t.addCell(t2);
        table.addCell(t);
        t.addEmptyCell(5.0f);
        String subject = HIALetter.getNameFromX500Principal(cert.getSubjectX500Principal());
        String issuer = HIALetter.getNameFromX500Principal(cert.getIssuerX500Principal());
        if (subject.equals(issuer)) {
            t.addCell(bundle.getString("HIALetter.selfSignedCertificate"));
        } else {
            t.addCell(MessageFormat.format(bundle.getString("HIALetter.issuedTo"), subject), BLFont.FONT_SMALL);
            t.addCell(MessageFormat.format(bundle.getString("HIALetter.issuedBy"), issuer), BLFont.FONT_SMALL);
        }
        Date fromDate = cert.getNotBefore();
        String from = fromDate != null ? DateFormat.getDateInstance().format(fromDate) : "";
        Date toDate = cert.getNotAfter();
        if (toDate != null && toDate.getTime() < UNLIMITED_VALIDITY) {
            t.addCell(MessageFormat.format(bundle.getString("HIALetter.validFromTo"), from, DateFormat.getDateInstance().format(toDate)), BLFont.FONT_SMALL);
        } else {
            t.addCell(MessageFormat.format(bundle.getString("HIALetter.validFrom"), from), BLFont.FONT_SMALL);
        }
    }

    private static String getNameFromX500Principal(X500Principal x500Principal) {
        if (x500Principal != null) {
            String name = x500Principal.getName();
            return name != null ? name : "";
        }
        return "";
    }

    private static void addHash(BLDocument document, String name, byte[] hash) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(1);
        t.setWidth(100.0f);
        t.setBorder(BLBorder.NO_BORDER);
        t.addCell(name);
        document.addTable(t);
        t = HIALetter.getHash(hash, hash.length % 16 == 0 ? 16 : 10);
        document.addTable(t);
    }

    private static String getPrintableCert(X509Certificate cert) {
        try {
            StringWriter w = new StringWriter();
            JcaPEMWriter pem = new JcaPEMWriter((Writer)w);
            pem.writeObject((Object)cert);
            pem.close();
            return w.toString();
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    private static BLTable<?> getHash(byte[] hash, int columns) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(columns);
        t.setBorder(BLBorder.NO_BORDER);
        byte[] b = new byte[1];
        byte[] byArray = hash;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte value;
            b[0] = value = byArray[i];
            t.addCell(HexTool.toHex(b));
        }
        return t;
    }

    private static void addBytes(BLDocument document, String name, BigInteger value) throws PDFException {
        BLFont font;
        int length = value.bitLength();
        BLTable<?> t = PDFCreator.getInstance().createTable(2);
        t.setWidth(100.0f);
        t.setBorder(BLBorder.NO_BORDER);
        t.addCell(name);
        t.addCell(Integer.toString(length), Alignment.ALIGN_RIGHT, null);
        document.addTable(t);
        boolean small = value.bitLength() > 1024;
        boolean verySmall = value.bitLength() > 3072;
        t = PDFCreator.getInstance().createTable(small ? 32 : 16);
        t.setBorder(BLBorder.NO_BORDER);
        t.setWidth(95.0f);
        t.setUseDescender(true);
        byte[] b = new byte[1];
        byte[] arr = value.toByteArray();
        int i = 0;
        while (arr[i] == 0) {
            ++i;
        }
        i = small ? (i -= 31 - (arr.length - i - 1) % 32) : (i -= 15 - (arr.length - i - 1) % 16);
        BLFont bLFont = font = small ? BLFont.FONT_SMALL : BLFont.FONT_NORMAL;
        if (verySmall) {
            font = BLFont.FONT_VERY_SMALL;
        }
        while (i < 0) {
            t.addCell("00", font);
            ++i;
        }
        while (i < arr.length) {
            b[0] = arr[i];
            t.addCell(HexTool.toHex(b), font);
            ++i;
        }
        document.addTable(t);
    }

    static {
        try {
            InputStream is = INILetter.class.getResourceAsStream("/bllogo.png");
            if (is != null) {
                IMAGE = Streams.readAllAndClose(is);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

