/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bankrechner;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;

public class SystemProperties {
    public static final String EXPORT_CSV_ENCODING = "de.businesslogics.bankrechner.export.csv.encoding";
    public static final String EXPORT_CSV_LIMIT = "de.businesslogics.bankrechner.export.csv.limit";
    public static final String ALLOW_INVALID_ORDER_TYPE_NAMES = "de.businesslogics.bankrechner.transaction.allowInvalidNames";
    public static final String CUSTOMERCREDIT_MULTIPLE_PAYMENT_TYPE_INFORMATION = "de.businesslogics.bankrechner.transaction.customercredit.enableMltplPmtTpInf";
    public static final String DIRECTDEBIT_MULTIPLE_PAYMENT_TYPE_INFORMATION = "de.businesslogics.bankrechner.transaction.directdebit.enableMltplPmtTpInf";

    public static final Charset getExportCsvEncoding() {
        Charset charset = StandardCharsets.UTF_8;
        String charsetName = System.getProperty(EXPORT_CSV_ENCODING);
        if (charsetName != null && !charsetName.isEmpty()) {
            try {
                charset = Charset.forName(charsetName);
            }
            catch (Exception e) {
                Logger.getLogger(SystemProperties.class.getName()).warning("Invalid value of SystemProperty 'de.businesslogics.bankrechner.export.csv.encoding'");
            }
        }
        return charset;
    }

    public static final Integer getExportCsvLimit() {
        return Integer.getInteger(EXPORT_CSV_LIMIT);
    }

    public static final boolean isAllowInvalidOrderTypes() {
        return Boolean.getBoolean(ALLOW_INVALID_ORDER_TYPE_NAMES);
    }

    public static final boolean isCustomerCreditMultiplePaymentTypeInformation() {
        return Boolean.getBoolean(CUSTOMERCREDIT_MULTIPLE_PAYMENT_TYPE_INFORMATION);
    }

    public static final boolean isDirectdebitMultiplePaymentTypeInformation() {
        return Boolean.getBoolean(DIRECTDEBIT_MULTIPLE_PAYMENT_TYPE_INFORMATION);
    }
}

