/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.bankrechner;

import de.businesslogics.ebics.schema.types.AuthenticatedReturnCode;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.ReturnCode;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class BcsMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static HashMap<Integer, BcsMessage> INSTANCES = new HashMap();
    public static final BcsMessage OK = new BcsMessage(1, 0, ReturnCode.EBICS_OK);
    public static final BcsMessage UNKNOWN_USER = new BcsMessage(2, 0, ReturnCode.EBICS_INVALID_USER_OR_USER_STATE);
    public static final BcsMessage INVALID_PASSWORD = new BcsMessage(3, 0, ReturnCode.EBICS_INTERNAL_ERROR);
    public static final BcsMessage USER_LOCKED = new BcsMessage(5, 0, ReturnCode.EBICS_INVALID_USER_OR_USER_STATE);
    public static final BcsMessage INVALID_ORDERTYPE = new BcsMessage(7, 0, ReturnCode.EBICS_INVALID_ORDER_TYPE);
    public static final BcsMessage UNSUPPORTED_COMPRESSION = new BcsMessage(7, 1, ReturnCode.EBICS_INCOMPATIBLE_ORDER_ATTRIBUTE);
    public static final BcsMessage UNSUPPORTED_ENCRYPTION = new BcsMessage(7, 2, ReturnCode.EBICS_INCOMPATIBLE_ORDER_ATTRIBUTE);
    public static final BcsMessage NO_DATA_YET_AVAILABLE = new BcsMessage(13, 0, AuthenticatedReturnCode.EBICS_NO_DOWNLOAD_DATA_AVAILABLE);
    public static final BcsMessage NO_PERMISSION_FOR_ORDERTYPE = new BcsMessage(15, 0, AuthenticatedReturnCode.EBICS_AUTHORISATION_ORDER_TYPE_FAILED);
    public static final BcsMessage FORM_ERROR = new BcsMessage(16, 0, ReturnCode.EBICS_INVALID_REQUEST);
    public static final BcsMessage NEW_PASSWORD_REQUIRED = new BcsMessage(16, 1, ReturnCode.EBICS_INTERNAL_ERROR);
    public static final BcsMessage WRONG_LENGTH_OF_EU_KEY = new BcsMessage(16, 2, AuthenticatedReturnCode.EBICS_KEYMGMT_KEYLENGTH_ERROR_SIGNATURE);
    public static final BcsMessage INVALID_ORDER_DATA = new BcsMessage(16, 3, AuthenticatedReturnCode.EBICS_INVALID_ORDER_DATA_FORMAT);
    public static final BcsMessage NO_D_FILES_ALLOWED = new BcsMessage(16, 4, AuthenticatedReturnCode.EBICS_AUTHORISATION_ORDER_TYPE_FAILED);
    public static final BcsMessage NO_O_FILES_ALLOWED = new BcsMessage(16, 5, AuthenticatedReturnCode.EBICS_AUTHORISATION_ORDER_TYPE_FAILED);
    public static final BcsMessage USER_NOW_LOCKED = new BcsMessage(17, 0, ReturnCode.EBICS_INTERNAL_ERROR);
    public static final BcsMessage NO_DATA_AVAILABLE = new BcsMessage(24, 0, AuthenticatedReturnCode.EBICS_NO_DOWNLOAD_DATA_AVAILABLE);
    public static final BcsMessage UNKNOWN_ERROR = new BcsMessage(26, 0, ReturnCode.EBICS_INTERNAL_ERROR);
    public static final BcsMessage ORDER_ALREADY_SENT = new BcsMessage(26, 1, AuthenticatedReturnCode.EBICS_ORDERID_ALREADY_EXISTS);
    public static final BcsMessage WRONG_SIGNATURE = new BcsMessage(26, 2, AuthenticatedReturnCode.EBICS_SIGNATURE_VERIFICATION_FAILED);
    public static final BcsMessage ORDER_NOT_WAITING_FOR_DS = new BcsMessage(26, 3, ReturnCode.EBICS_DISTRIBUTED_SIGNATURE_AUTHORISATION_FAILED);
    public static final BcsMessage ENCRYPTION_VERSION_NOT_SUPPORTED = new BcsMessage(26, 4, AuthenticatedReturnCode.EBICS_KEYMGMT_UNSUPPORTED_VERSION_ENCRYPTION);
    public static final BcsMessage AUTHENTICATION_VERSION_NOT_SUPPORTED = new BcsMessage(26, 5, AuthenticatedReturnCode.EBICS_KEYMGMT_UNSUPPORTED_VERSION_AUTHENTICATION);
    public static final BcsMessage ENCRYPTION_KEYLENGTH_ERROR = new BcsMessage(26, 6, AuthenticatedReturnCode.EBICS_KEYMGMT_KEYLENGTH_ERROR_ENCRYPTION);
    public static final BcsMessage AUTHENTICATION_KEYLENGTH_ERROR = new BcsMessage(26, 7, AuthenticatedReturnCode.EBICS_KEYMGMT_KEYLENGTH_ERROR_AUTHENTICATION);
    public static final BcsMessage IDENTICAL_SIGNATURE_ERROR = new BcsMessage(26, 8, AuthenticatedReturnCode.EBICS_DUPLICATE_SIGNATURE);
    public static final BcsMessage ACCOUNT_AUTHORISATION_FAILED = new BcsMessage(26, 9, AuthenticatedReturnCode.EBICS_ACCOUNT_AUTHORISATION_FAILED);
    public static final BcsMessage AMOUNT_CHECK_FAILED = new BcsMessage(26, 10, AuthenticatedReturnCode.EBICS_AMOUNT_CHECK_FAILED);
    public static final BcsMessage INVALID_SIGNER_STATE = new BcsMessage(26, 11, AuthenticatedReturnCode.EBICS_INVALID_SIGNER_STATE);
    public static final BcsMessage ORDER_NOT_WAITING_FOR_SIGNATURES = new BcsMessage(26, 12, AuthenticatedReturnCode.EBICS_ORDERID_UNKNOWN);
    public static final BcsMessage ORDER_ALREADY_EXISTS = new BcsMessage(26, 13, ReturnCode.EBICS_ORDER_ALREADY_EXISTS);
    public static final BcsMessage UNKNOWN_ERROR_RETRY = new BcsMessage(27, 0, ReturnCode.EBICS_INTERNAL_ERROR);
    public static final BcsMessage COMMUNICATION_ABORT = new BcsMessage(29, 0, ReturnCode.EBICS_INTERNAL_ERROR);
    public static final BcsMessage NEW_BPD_AVAILABLE = new BcsMessage(50, 0, ReturnCode.EBICS_INTERNAL_ERROR);
    public static final BcsMessage BANK_KEY_OUT_OF_DATE = new BcsMessage(51, 0, ReturnCode.EBICS_BANK_PUBKEY_UPDATE_REQUIRED);
    public static final BcsMessage EU_VERSION_NOT_SUPPORTED = new BcsMessage(52, 1, AuthenticatedReturnCode.EBICS_KEYMGMT_UNSUPPORTED_VERSION_SIGNATURE);
    public static final BcsMessage USER_EU_NOT_ALLOWED = new BcsMessage(55, 0, AuthenticatedReturnCode.EBICS_INVALID_SIGNER_STATE);
    public static final BcsMessage ENCRYPTION_KEY_NOT_READY = new BcsMessage(56, 0, ReturnCode.EBICS_INVALID_USER_OR_USER_STATE);
    public static final BcsMessage UNSUPPORTED_ENCRYPTION_VERSION = new BcsMessage(66, 0, AuthenticatedReturnCode.EBICS_KEYMGMT_UNSUPPORTED_VERSION_ENCRYPTION);
    public static final BcsMessage INVALID_TIMESTAMP = new BcsMessage(67, 0, ReturnCode.EBICS_TX_MESSAGE_REPLAY);
    private String key;
    private final int code;
    private final int subCode;
    private transient ReturnCode returnCode;
    private transient OlderReturnCode olderCode;

    private BcsMessage(int code, int subCode, ReturnCode returnCode) {
        this.key = subCode == 0 ? String.valueOf(code) : String.valueOf(code) + "_" + String.valueOf(subCode);
        this.code = code;
        this.subCode = subCode;
        this.returnCode = returnCode;
        BcsMessage old = INSTANCES.put(this.hashCode(), this);
        assert (old == null);
    }

    public int getCode() {
        return this.code;
    }

    public boolean isError() {
        return this.code != BcsMessage.OK.code && this.code != BcsMessage.NEW_BPD_AVAILABLE.code;
    }

    public ReturnCode getDefaultReturnCode() {
        return this.returnCode;
    }

    public ReturnCode getReturnCode(ProtocolVersion pv) {
        short v;
        if (this.olderCode != null && this.olderCode.pv >= (v = pv.getVersion())) {
            return this.olderCode.rc;
        }
        return this.returnCode;
    }

    public String getMessage(Locale locale) {
        return ResourceBundle.getBundle("de.businesslogics.bankrechner.BcsMessage", locale).getString(this.key);
    }

    public int getSubCode() {
        return this.subCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BcsMessage)) {
            return false;
        }
        BcsMessage bm = (BcsMessage)obj;
        return bm.code == this.code && bm.subCode == this.subCode;
    }

    public int hashCode() {
        return this.code << 16 | this.subCode;
    }

    private Object readResolve() {
        BcsMessage toReturn = INSTANCES.get(this.hashCode());
        if (toReturn == null) {
            return UNKNOWN_ERROR;
        }
        return toReturn;
    }

    public static Collection<BcsMessage> getInstances() {
        return INSTANCES.values();
    }

    public String toString() {
        return this.getMessage(Locale.getDefault());
    }

    static {
        BcsMessage.NO_D_FILES_ALLOWED.olderCode = BcsMessage.NO_O_FILES_ALLOWED.olderCode = new OlderReturnCode(ProtocolVersion.H004, ReturnCode.EBICS_INCOMPATIBLE_ORDER_ATTRIBUTE);
    }

    private static class OlderReturnCode
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final short pv;
        private final ReturnCode rc;

        OlderReturnCode(ProtocolVersion pv, ReturnCode rc) {
            this.pv = pv.getVersion();
            this.rc = rc;
        }
    }
}

