/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.yubikey.api;

import com.yubico.client.v2.VerificationResponse;
import com.yubico.client.v2.YubicoClient;
import com.yubico.client.v2.exceptions.YubicoValidationFailure;
import com.yubico.client.v2.exceptions.YubicoVerificationException;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.banking.database.vo.YubikeyHistory;

public class YubikeyWrapper {
    private static final String DEMO_CODE = "BL_YUBIKEY_TEST";
    private static final String DEMO_CODE2 = "BL_YUBIKEY_TEST_2";
    private static final YubicoClient yubicoClient = YubicoClient.getClient((Integer)39926, (String)"0cpm2LAYYxTD4m+4pXeu1JDJSqk=");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyForUser(String otp, User user) throws YubicoVerificationException {
        block16: {
            YubikeyHistory h = new YubikeyHistory();
            h.setUser(user);
            h.setOpt(otp);
            try {
                if (DEMO_CODE.equals(otp) && YubikeyWrapper.hasKey(DEMO_CODE, user)) {
                    h.setPublicId(DEMO_CODE);
                    h.setErrorMessage(DEMO_CODE);
                    boolean bl = true;
                    return bl;
                }
                if (DEMO_CODE2.equals(otp) && YubikeyWrapper.hasKey(DEMO_CODE2, user)) {
                    h.setPublicId(DEMO_CODE2);
                    h.setErrorMessage(DEMO_CODE2);
                    boolean bl = true;
                    return bl;
                }
                if (YubicoClient.isValidOTPFormat((String)otp)) {
                    VerificationResponse response = yubicoClient.verify(otp);
                    try {
                        h.setPublicId(response.getPublicId());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    h.setErrorMessage(response.getStatus().name());
                    if (response.isOk()) {
                        boolean hasKey = YubikeyWrapper.hasKey(response.getPublicId(), user);
                        if (!hasKey) {
                            h.setErrorMessage("Wrong PublicId for User");
                        }
                        boolean bl = hasKey;
                        return bl;
                    }
                    break block16;
                }
                h.setErrorMessage("Not a valid OTP");
            }
            catch (YubicoVerificationException v) {
                h.setErrorMessage(v.toString());
                throw v;
            }
            catch (YubicoValidationFailure v2) {
                h.setErrorMessage(v2.toString());
            }
            finally {
                h.save();
            }
        }
        return false;
    }

    public static boolean hasKey(String publicId, User user) {
        return Yubikey.hasYubiKey(publicId, user);
    }

    public static boolean isValidOTPFormat(String otp) {
        if (DEMO_CODE.equals(otp) || DEMO_CODE2.equals(otp)) {
            return true;
        }
        return YubicoClient.isValidOTPFormat((String)otp);
    }

    public static String verify(String otp) throws YubicoVerificationException, YubicoValidationFailure {
        block13: {
            if (DEMO_CODE.equals(otp)) {
                return DEMO_CODE;
            }
            if (DEMO_CODE2.equals(otp)) {
                return DEMO_CODE2;
            }
            YubikeyHistory h = new YubikeyHistory();
            h.setOpt(otp);
            try {
                if (!YubicoClient.isValidOTPFormat((String)otp)) break block13;
                VerificationResponse response = yubicoClient.verify(otp);
                try {
                    h.setPublicId(response.getPublicId());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                h.setErrorMessage(response.getStatus().name());
                if (response.isOk()) {
                    String string = response.getPublicId();
                    return string;
                }
            }
            catch (YubicoVerificationException v) {
                if (v.getCause() != null) {
                    h.setErrorMessage(v.getCause().toString());
                } else {
                    h.setErrorMessage(v.toString());
                }
                throw v;
            }
            catch (YubicoValidationFailure v2) {
                h.setErrorMessage(v2.toString());
                throw v2;
            }
            finally {
                h.save();
            }
        }
        return null;
    }
}

