/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.yubikey.api;

import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.banking.database.vo.YubikeyHistory;
import de.businesslogics.crypto.BCBlockCipher;
import de.businesslogics.util.HexTool;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;

public class Oath {
    private static final int TIME_PERIOD = 30;
    private static final int ALLOWED_TIME_PERIOD_DISCREPANCE = 10;
    private static final int DIGITS = 6;
    private static final String DEMO_CODE = "BL_OAUTH_TEST";
    private static final SecretKey SECRET_KEY = new SecretKeySpec(HexTool.fromHex("C56452B1F4D98618C65D0D7E4C3A8C92"), "AES");

    private Oath() {
    }

    public static boolean checkCode(String key, String code) {
        Base32 codec = new Base32();
        byte[] decodedKey = codec.decode(key);
        long currentBucket = System.currentTimeMillis() / 30000L;
        for (int i = -10; i <= 10; ++i) {
            String expect = Oath.hmacSha1(decodedKey, currentBucket + (long)i);
            if (!code.equals(expect)) continue;
            return true;
        }
        return false;
    }

    public static String getKeyFromURI(String uri) {
        int start = uri.indexOf("secret=") + 7;
        if (start > 7) {
            int end = uri.indexOf(38, start);
            return uri.substring(start, end);
        }
        return null;
    }

    public static String createNewToken() {
        SecureRandom randomBytes = new SecureRandom();
        byte[] key = new byte[20];
        randomBytes.nextBytes(key);
        return new Base32(false).encodeAsString(key);
    }

    public static String formatToken(String key) {
        StringBuilder b = new StringBuilder(key.toLowerCase());
        int max = key.length() / 4;
        if (max * 4 == key.length()) {
            --max;
        }
        for (int i = 0; i < max; ++i) {
            b.insert(4 + i * 5, ' ');
        }
        return b.toString();
    }

    private static String hmacSha1(byte[] decodedKey, long data) {
        try {
            SecretKeySpec signKey = new SecretKeySpec(decodedKey, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signKey);
            byte[] value = new byte[8];
            long l = data;
            int i = 8;
            while (i-- > 0) {
                value[i] = (byte)l;
                l >>>= 8;
            }
            byte[] hash = mac.doFinal(value);
            int offset = hash[hash.length - 1] & 0xF;
            long truncatedHash = 0L;
            for (int i2 = 0; i2 < 4; ++i2) {
                truncatedHash <<= 8;
                truncatedHash |= (long)(hash[offset + i2] & 0xFF);
            }
            truncatedHash &= Integer.MAX_VALUE;
            truncatedHash = (long)((double)truncatedHash % Math.pow(10.0, 6.0));
            return String.format("%06d", truncatedHash);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getURI(String key, String issuer, String username) {
        try {
            issuer = issuer.replace(':', '.');
            username = username.replace(':', '.');
            URI uri = new URI("otpauth", null, "totp", -1, "/" + issuer + ":" + username, "secret=" + key + "&issuer=" + issuer, null);
            return uri.toASCIIString();
        }
        catch (URISyntaxException syntax) {
            throw new RuntimeException(syntax);
        }
    }

    public static String encrypt(String key, String username) {
        if (DEMO_CODE.equals(key)) {
            username = DEMO_CODE;
        }
        try {
            return username.replace(':', '.') + ":" + Oath.encrypt(key);
        }
        catch (GeneralSecurityException se) {
            throw new RuntimeException(se);
        }
    }

    public static String encryptURI(String uri) {
        try {
            String path = new URI(uri).getPath();
            return Oath.encrypt(Oath.getKeyFromURI(uri), path.substring(path.indexOf(58) + 1));
        }
        catch (URISyntaxException s) {
            throw new RuntimeException(s);
        }
    }

    private static String decrypt(String data) {
        String encrypted = data;
        int pos = data.indexOf(58);
        if (pos > 0) {
            encrypted = data.substring(pos + 1);
        }
        String iv = encrypted.substring(0, encrypted.indexOf(44));
        String rest = encrypted.substring(encrypted.indexOf(44) + 1);
        try {
            BCBlockCipher c = BCBlockCipher.createAESCTRNoPadding();
            c.init(2, SECRET_KEY, new IvParameterSpec(HexTool.fromHex(iv)));
            return new String(c.doFinal(HexTool.fromHex(rest)), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String encrypt(String plain) throws GeneralSecurityException {
        byte[] iv = new byte[16];
        SecureRandom.getInstanceStrong().nextBytes(iv);
        BCBlockCipher c = BCBlockCipher.createAESCTRNoPadding();
        c.init(1, SECRET_KEY, new IvParameterSpec(iv));
        return HexTool.toHex(iv) + "," + HexTool.toHex(c.doFinal(plain.getBytes()));
    }

    public static boolean isDemoCode(String otp) {
        return DEMO_CODE.equals(otp);
    }

    public static boolean isValidOath(String otp) {
        if (DEMO_CODE.equals(otp)) {
            return true;
        }
        if (otp == null || otp.length() != 6) {
            return false;
        }
        try {
            Integer.valueOf(otp);
            return true;
        }
        catch (NumberFormatException nf) {
            return false;
        }
    }

    public static boolean validate(String otp, User user) throws Exception {
        YubikeyHistory h = new YubikeyHistory();
        h.setUser(user);
        h.setOpt(otp);
        List<Yubikey> list = Yubikey.findOathForUser(user);
        for (Yubikey k : list) {
            String key = Oath.decrypt(k.getOathData());
            if ((!DEMO_CODE.equals(key) || !DEMO_CODE.equals(otp)) && !Oath.checkCode(key, otp)) continue;
            h.setPublicId("Oath." + k.getId());
            h.setErrorMessage("OK");
            h.save();
            return true;
        }
        h.setErrorMessage("No valid key found.");
        h.save();
        return false;
    }
}

