/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.gui;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.PreferenceBundleHandler;
import java.util.Locale;
import java.util.ResourceBundle;

public enum PreferenceConstants implements DatabasePreferenceConstant
{
    DO_VOP_CHECK("doVopCheck", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DO_LOCAL_VOP_CHECK("doLocalVopCheck", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    MAX_PAYMENTS_LOCAL_VOP_CHECK("maxPaymentsLocalVopCheck", String.valueOf(200), DatabasePreferenceConstant.DataType.INTEGER, true, false, false),
    FAX_APPROVAL("faxApproval", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    DISPLAY_FAX_APPROVAL("useTransportSignature", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    CREATE_DELETE_AFTER_TRANSFER_BUTTON("createDeleteAfterTransferButton", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    PTK_DELAY("PtkDelay", String.valueOf(60), DatabasePreferenceConstant.DataType.INTEGER, true, false, false),
    VPZ_DELAY("VpzDelay", String.valueOf(60), DatabasePreferenceConstant.DataType.INTEGER, true, false, false),
    PRINT_SEND_REPORT("printSendReport", "prompt", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    SEND_REPORT_WITH_DETAILS("sendReportWithDetails", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, true),
    SEND_REPORT_DETAILS_WITH_PAGE_BREAK("sendReportDetailsWithPageBreak", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, true),
    SEND_REPORT_WITH_PTK("sendReportWithPTK", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    SEND_REPORT_WITH_STATUS_REPORTS("sendReportWithStatusReports", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    SEND_REPORT_WITH_TICKET("sendReportWithTicket", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    SEND_REPORT_WITH_VOP_RESULTS("sendReportWithVopResults", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    MAX_PTK_INTERVAL("MaxPTKInterval", String.valueOf(90), DatabasePreferenceConstant.DataType.INTEGER, false, false, false),
    CLEAN_UP("cleanUp", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    CLEAN_SEND_FILES("cleanSend", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    CLEAN_FETCH_FILES("cleanFetch", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    CLEAN_NOTIFICATION_FILES("cleanNotification", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    CLEAN_PROTOCOL("cleanProtocol", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    CLEAN_SEND_AGE("cleanSendAge", String.valueOf(5), DatabasePreferenceConstant.DataType.INTEGER, false, true, false),
    CLEAN_FETCH_AGE("cleanFetchAge", String.valueOf(5), DatabasePreferenceConstant.DataType.INTEGER, false, true, false),
    CLEAN_NOTIFICATION_AGE("cleanNotificationAge", String.valueOf(5), DatabasePreferenceConstant.DataType.INTEGER, false, true, false),
    CLEAN_PROTOCOL_AGE("cleanProtocolAge", String.valueOf(5), DatabasePreferenceConstant.DataType.INTEGER, false, true, false),
    CLEAN_SEND_UNIT("cleanSendUnit", String.valueOf(3), DatabasePreferenceConstant.DataType.ENUM_COMBO, false, true, false),
    CLEAN_FETCH_UNIT("cleanFetchUnit", String.valueOf(3), DatabasePreferenceConstant.DataType.ENUM_COMBO, false, true, false),
    CLEAN_NOTIFICATION_UNIT("cleanNotificationUnit", String.valueOf(3), DatabasePreferenceConstant.DataType.ENUM_COMBO, false, true, false),
    CLEAN_PROTOCOL_UNIT("cleanProtocolUnit", String.valueOf(3), DatabasePreferenceConstant.DataType.ENUM_COMBO, false, true, false),
    PRESELECT_FROM_TO_FETCH("preselectFromToFetch", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    USE_HAA("useHAA", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    SHOW_NOTIFICATION_VIEW("showNotificationView", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    PRINT_NEW_NOTIFICATIONS("PrintNewNotifications", "prompt", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    IMPORT_UNKNOWN_SENDITEMS("importFromPTK", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, true),
    SHOW_ADDITIONAL_INFORMATION("showAdditionalInformationFromPTK", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    CHECK_DOUBLE_TRANSMISSION("checkDoubleTransmission", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    CHECK_SEPA_VERSION("checkSepaVersion", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    VERSION_TYPE_PROVIDER("versionTypeProvider", String.valueOf(0), DatabasePreferenceConstant.DataType.INTEGER, false, false, false),
    DATABASE_MIGRATION("databaseMigration", null, DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    PROTOCOL_DATABASE_MIGRATION_DONE("protocolDatabaseMigrationDone", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    ALLOW_CALLBACK_FOR_ALL_STATES("allowCallbackForAllStates", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DISPLAY_EXTENDED_STATE("displayExtendedState", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DISPLAY_COLORED_STATES("displayColoredStates", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DO_ADDITIONAL_PAIN002_CHECK("doAdditionalPain002Check", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    DISPLAY_PROTOCOL_ERROR_DIALOG("displayProtocolErrorDialog", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    DISPLAY_REAL_TIME_NOTIFICATIONS("displayRealTimeNotifications", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    FETCH_PAYMENT_STATUS_REPORT_WHEN_NOTIFIED("fetchPaymentStatusReportWhenNotified", "prompt", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    AUTOMATIC_NOT_FETCH("automaticNot", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    REFRESH_WITH_NOT_FETCH("refreshWithNotFetch", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false);

    private static final PreferenceBundleHandler BUNDLE_HANDLER;
    private final String id;
    private String defaultValue;
    private final boolean userSpecific;
    private final DatabasePreferenceConstant.DataType type;
    private final boolean onlyAdmin;
    private final boolean onlyAdminOrTenantAdmin;

    private PreferenceConstants(String id, String defaultValue, DatabasePreferenceConstant.DataType type, boolean userSpecific, boolean onlyAdmin, boolean onlyAdminOrTenantAdmin) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.type = type;
        this.userSpecific = userSpecific;
        this.onlyAdmin = onlyAdmin;
        this.onlyAdminOrTenantAdmin = onlyAdminOrTenantAdmin;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public boolean isUserSpecific() {
        return this.userSpecific;
    }

    @Override
    public DatabasePreferenceConstant.DataType getType() {
        return this.type;
    }

    @Override
    public boolean isOnlyConfigurableByAdmin() {
        return this.onlyAdmin;
    }

    @Override
    public boolean isOnlyConfigurableByAdminOrTenantAdmin() {
        return this.onlyAdminOrTenantAdmin;
    }

    @Override
    public String getLabel(Locale locale) {
        return BUNDLE_HANDLER.getString(this.id, locale);
    }

    @Override
    public String[][] getSelectableOptions(Locale locale) {
        if (this == PRINT_SEND_REPORT || this == PRINT_NEW_NOTIFICATIONS || this == FETCH_PAYMENT_STATUS_REPORT_WHEN_NOTIFIED) {
            return new String[][]{{BankingApiMessages.getString(locale, "GeneralMessages.yes", new Object[0]), "always"}, {BankingApiMessages.getString(locale, "GeneralMessages.no", new Object[0]), "never"}, {BankingApiMessages.getString(locale, "GeneralMessages.alwaysAsk", new Object[0]), "prompt"}};
        }
        if (this == CLEAN_SEND_UNIT || this == CLEAN_FETCH_UNIT || this == CLEAN_PROTOCOL_UNIT || this == CLEAN_NOTIFICATION_UNIT) {
            return new String[][]{{BankingApiMessages.getString(locale, "GeneralMessages.days", new Object[0]), "0"}, {BankingApiMessages.getString(locale, "GeneralMessages.weeks", new Object[0]), "1"}, {BankingApiMessages.getString(locale, "GeneralMessages.months", new Object[0]), "2"}, {BankingApiMessages.getString(locale, "GeneralMessages.years", new Object[0]), "3"}};
        }
        return null;
    }

    static {
        BUNDLE_HANDLER = new PreferenceBundleHandler(){

            @Override
            protected ResourceBundle loadBundle(Locale locale) {
                return ResourceBundle.getBundle("de.businesslogics.banking.transfer.gui.PreferenceConstants", locale);
            }
        };
    }
}

