/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.NotificationTrx;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.transfer.api.SEPANotificationProcessing;
import de.businesslogics.banking.transfer.api.SEPANotificationUtil;
import de.businesslogics.banking.transfer.api.TransferApiMessages;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.format.sepa.GeneralSEPAReportExtractor;
import de.businesslogics.format.sepa.StatusCode;
import de.businesslogics.util.BLLogger;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class VOPNotificationProcessing
extends SEPANotificationProcessing {
    Set<Integer> recipientIds = new HashSet<Integer>();

    public VOPNotificationProcessing(BLLogger logger, EncryptData encryptData) {
        super(Notification.Type.Pain002Vop, logger, encryptData);
    }

    @Override
    public String getDescription() {
        return TransferApiMessages.getString(Locale.getDefault(), "VOPNotificationProcessing.description", new Object[0]);
    }

    @Override
    protected void checkDocument(EbicsElement d) throws IOException {
        String msg = null;
        if (!GeneralSEPAReportExtractor.isVopReport(d, true)) {
            msg = GeneralSEPAReportExtractor.isDebitReport(d) ? (this.startedByImport ? TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.importedFileContainsDebitNotifications", new Object[0]) : MessageFormat.format(TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.fetchedFileContainsDebitNotifications", new Object[0]), this.bank.getDisplayName(), this.fetchType, this.getDescription())) : (GeneralSEPAReportExtractor.isInstantPaymentReport(d) ? (this.startedByImport ? TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.importedFileContainsInstantNotifications", new Object[0]) : MessageFormat.format(TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.fetchedFileContainsInstantNotifications", new Object[0]), this.bank.getDisplayName(), this.fetchType, this.getDescription())) : (this.startedByImport ? TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.importedFileContainsCreditNotifications", new Object[0]) : MessageFormat.format(TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.fetchedFileContainsCreditNotifications", new Object[0]), this.bank.getDisplayName(), this.fetchType, this.getDescription())));
        }
        if (msg != null) {
            throw new IOException(msg);
        }
    }

    @Override
    protected void saveRecipientVopResults(Notification notification) {
        Send send = SEPANotificationUtil.findSEPASendOrder(notification, this.logger);
        if (send != null) {
            this.findAllRecipientIds(send);
        }
        for (NotificationTrx notificationTrx : NotificationTrx.find(notification)) {
            this.saveRecipientVopResult(notificationTrx, notification.getFetched());
        }
    }

    private void saveRecipientVopResult(NotificationTrx notificationTrx, Timestamp date) {
        List<PaymentType> allowedTypes = List.of(PaymentType.SEPA, PaymentType.MANDATE);
        String trxStatus = notificationTrx.getTxSts();
        PaymentRecipient recipient = null;
        if (notificationTrx.getRecipientAccountNumber() != null) {
            recipient = PaymentRecipient.findRecipientByAccountInfo(allowedTypes, notificationTrx.getRecipient(), notificationTrx.getRecipientAccountNumber(), null, List.of(this.bank.getTenant()));
        } else {
            int n;
            List<PaymentRecipient> paymentRecipients = PaymentRecipient.findRecipientByName(allowedTypes, notificationTrx.getRecipient(), notificationTrx.getNotification().getBank().getTenant());
            if (paymentRecipients != null && (n = paymentRecipients.size()) == 1) {
                recipient = paymentRecipients.get(0);
            }
        }
        if (recipient != null && (recipient.getVopDate() == null || recipient.getVopDate().compareTo(date) <= 0)) {
            recipient.setVopDate(date);
            if (trxStatus != null) {
                String[] statusReasonInfos = notificationTrx.getStatusReasonInfo().split("_");
                if (StatusCode.VopResultCodes.RVNA.name().equals(trxStatus) && statusReasonInfos.length > 0 && statusReasonInfos[0].length() == 4) {
                    recipient.setVopReason(statusReasonInfos[0]);
                } else {
                    recipient.setVopReason(null);
                }
                Object info = null;
                if (statusReasonInfos.length > 1) {
                    if (StatusCode.VopResultCodes.RVMC.name().equals(trxStatus)) {
                        recipient.setVopName(statusReasonInfos[1]);
                    } else if (StatusCode.VopResultCodes.RVNA.name().equals(trxStatus)) {
                        info = statusReasonInfos[1];
                        if (statusReasonInfos.length > 2) {
                            if (((String)info).length() < 105 || statusReasonInfos[2].length() < 105) {
                                info = (String)info + "\n";
                            }
                            info = (String)info + statusReasonInfos[2];
                        }
                    } else if (StatusCode.VopResultCodes.RCVC.name().equals(trxStatus)) {
                        recipient.setVopName(null);
                    }
                }
                recipient.setVopAdditionalInfo((String)info);
            }
            recipient.setVopResult(trxStatus);
            DB.save(recipient);
            this.recipientIds.remove(recipient.getId());
        }
    }

    private void findAllRecipientIds(Send send) {
        List<SignedPayment> payments = SignedPayment.findBySend(send);
        ArrayList<PaymentType> allowedTypes = new ArrayList<PaymentType>();
        allowedTypes.add(PaymentType.SEPA);
        allowedTypes.add(PaymentType.MANDATE);
        for (SignedPayment payment : payments) {
            int n;
            List<PaymentRecipient> paymentRecipients = PaymentRecipient.findRecipientByName(allowedTypes, payment.getRecipient(), payment.getAccount().getBank().getTenant());
            if (paymentRecipients == null || (n = paymentRecipients.size()) != 1) continue;
            this.recipientIds.add(paymentRecipients.get(0).getId());
        }
    }

    private void saveRemainingVopResults(Timestamp date) {
        for (Integer id : this.recipientIds) {
            PaymentRecipient recipient = PaymentRecipient.findByIdAndTenants(id, List.of(this.bank.getTenant()));
            if (recipient == null || recipient.getVopDate() != null && recipient.getVopDate().compareTo(date) > 0) continue;
            recipient.setVopResult("RCVC");
            recipient.setVopDate(date);
            DB.save(recipient);
        }
    }
}

