/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.PtkEntry;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.transfer.api.FetchDeleteHandler;
import de.businesslogics.banking.transfer.api.NotificationDeleteHandler;
import de.businesslogics.banking.transfer.api.SendOrderHandler;
import de.businesslogics.banking.transfer.gui.PreferenceConstants;
import de.businesslogics.util.IProgressMonitorWrapper;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class TransferCleanUp {
    private int sendDeleted = 0;
    private int fetchDeleted = 0;
    private int notificationDeleted = 0;
    private int protocolDeleted = 0;
    private List<Send> sendToDelete;
    private List<Fetch> fetchToDelete;
    private List<Notification> notificationToDelete;
    private List<Fetch> notificationFetchToDelete;
    private List<Fetch> protocolFetchToDelete;
    private boolean findDataWasCalled = false;

    public void findDataToDelete(DatabasePreferenceStore store) {
        Date oldest;
        int age;
        int unit;
        this.findDataWasCalled = true;
        if (store.getBoolean(PreferenceConstants.CLEAN_SEND_FILES)) {
            unit = store.getInt(PreferenceConstants.CLEAN_SEND_UNIT);
            age = store.getInt(PreferenceConstants.CLEAN_SEND_AGE);
            oldest = Util.computeFromNow(age, unit).getTime();
            this.sendToDelete = SendOrderHandler.findOlderThan(oldest);
            this.sendDeleted = this.sendToDelete.size();
        }
        if (store.getBoolean(PreferenceConstants.CLEAN_FETCH_FILES)) {
            unit = store.getInt(PreferenceConstants.CLEAN_FETCH_UNIT);
            age = store.getInt(PreferenceConstants.CLEAN_FETCH_AGE);
            oldest = Util.computeFromNow(age, unit).getTime();
            this.fetchToDelete = FetchDeleteHandler.findOlderThan(oldest);
            this.fetchDeleted = this.fetchToDelete.size();
        }
        if (store.getBoolean(PreferenceConstants.CLEAN_NOTIFICATION_FILES)) {
            unit = store.getInt(PreferenceConstants.CLEAN_NOTIFICATION_UNIT);
            age = store.getInt(PreferenceConstants.CLEAN_NOTIFICATION_AGE);
            oldest = Util.computeFromNow(age, unit).getTime();
            this.notificationToDelete = NotificationDeleteHandler.findOlderThan(oldest);
            this.notificationDeleted = this.notificationToDelete.size();
            this.notificationFetchToDelete = FetchDeleteHandler.findNotificationFilesOlderThan(oldest);
            this.fetchDeleted += this.notificationFetchToDelete.size();
        }
        if (store.getBoolean(PreferenceConstants.CLEAN_PROTOCOL)) {
            unit = store.getInt(PreferenceConstants.CLEAN_PROTOCOL_UNIT);
            age = store.getInt(PreferenceConstants.CLEAN_PROTOCOL_AGE);
            oldest = new Timestamp(Util.computeFromNow(age, unit).getTime().getTime());
            this.protocolDeleted = 0;
            this.protocolDeleted += PtkEntry.findOlderThan((Timestamp)oldest);
            this.protocolDeleted += HacEntry.findOlderThan((Timestamp)oldest);
            this.protocolFetchToDelete = FetchDeleteHandler.findProtocolFilesOlderThan(oldest);
            this.fetchDeleted += FetchDeleteHandler.deleteProtocolFilesOlderThan(oldest);
        }
    }

    public boolean doCleanup(DatabasePreferenceStore store, IProgressMonitorWrapper monitor) {
        if (!this.findDataWasCalled) {
            this.findDataToDelete(store);
        }
        if (store.getBoolean(PreferenceConstants.CLEAN_SEND_FILES)) {
            SendOrderHandler.delete(this.sendToDelete);
        }
        if (store.getBoolean(PreferenceConstants.CLEAN_FETCH_FILES)) {
            FetchDeleteHandler.delete(this.fetchToDelete);
        }
        if (store.getBoolean(PreferenceConstants.CLEAN_NOTIFICATION_FILES)) {
            NotificationDeleteHandler.deleteNotifications(this.notificationToDelete);
            FetchDeleteHandler.delete(this.notificationFetchToDelete);
        }
        if (store.getBoolean(PreferenceConstants.CLEAN_PROTOCOL)) {
            int unit = store.getInt(PreferenceConstants.CLEAN_PROTOCOL_UNIT);
            int age = store.getInt(PreferenceConstants.CLEAN_PROTOCOL_AGE);
            Timestamp oldest = new Timestamp(Util.computeFromNow(age, unit).getTime().getTime());
            this.protocolDeleted = 0;
            this.protocolDeleted += PtkEntry.deleteOlderThan(oldest);
            this.protocolDeleted += HacEntry.deleteOlderThan(oldest);
            FetchDeleteHandler.delete(this.protocolFetchToDelete);
        }
        this.findDataWasCalled = false;
        return true;
    }

    public int getSendDeleted() {
        return this.sendDeleted;
    }

    public int getFetchDeleted() {
        return this.fetchDeleted;
    }

    public int getNotificationDeleted() {
        return this.notificationDeleted;
    }

    public int getProtocolDeleted() {
        return this.protocolDeleted;
    }
}

