/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.AbstractCsvExport;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.transfer.api.SendUtil;
import de.businesslogics.banking.transfer.api.TransferApiMessages;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class SentTableCsvExport
extends AbstractCsvExport<Send> {
    private final Locale locale;
    private boolean useStateLabel = true;
    private final DateFormat dateFormat;
    private final NumberFormat numberFormat;

    public SentTableCsvExport(Locale locale) {
        this.locale = locale;
        this.dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        this.numberFormat = NumberFormat.getIntegerInstance(locale);
    }

    public SentTableCsvExport(Locale locale, boolean useStateLabel) {
        this.locale = locale;
        this.useStateLabel = useStateLabel;
        this.dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        this.numberFormat = NumberFormat.getIntegerInstance(locale);
    }

    @Override
    protected boolean writeHeader(Writer writer) throws IOException {
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.bank", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.orderType", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.orderNumber", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.submitter", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.sendingTime", new Object[0]));
        if (this.useStateLabel) {
            this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.state", new Object[0]));
        } else {
            this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.status", new Object[0]));
        }
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.amount", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.size", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.fileName", new Object[0]));
        return true;
    }

    @Override
    protected boolean writeItem(Writer writer, Send item) throws IOException {
        if (item == null) {
            return false;
        }
        this.addCell(writer, item.getBank().getDisplayName());
        this.addCell(writer, item.getOriginalSendType());
        this.addCell(writer, item.getOrderNumber());
        this.addCell(writer, item.getSender());
        this.addCell(writer, this.dateFormat.format(item.getSent()));
        this.addCell(writer, SendUtil.getExtendedState(item, this.locale));
        this.addCell(writer, PaymentUtils.formatAmount(item.getAmount(), Currency.getInstance(item.getCurrency()), this.locale), true);
        this.addCell(writer, TransferApiMessages.getString("sendorder.print.filesize.info", this.numberFormat.format(item.getSize())));
        this.addCell(writer, item.getOrigFileName());
        return true;
    }
}

