/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.SendStateUtil;
import de.businesslogics.banking.api.VopUtil;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.PaymentFilter;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.transfer.api.SEPANotificationUtil;
import de.businesslogics.banking.transfer.gui.PreferenceConstants;
import de.businesslogics.format.camt029.Camt029StatusCode;
import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.format.ptk2.Result;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class SendUtil {
    private static Date VOP_DATE = null;

    private static Date getVopDate() {
        if (VOP_DATE == null) {
            String defaultVopDate = "20251005";
            String vopDate = System.getProperty("vopDate", defaultVopDate);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            try {
                VOP_DATE = sdf.parse(vopDate);
            }
            catch (Exception e) {
                try {
                    VOP_DATE = sdf.parse(defaultVopDate);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return VOP_DATE;
    }

    public static boolean isBeforeVopDate() {
        return new Date().before(SendUtil.getVopDate());
    }

    public static String convertSendState(SignedPayment signedPayment, Locale locale) {
        return SendUtil.convertSendState(signedPayment.getSend(), signedPayment, locale);
    }

    public static String convertSendState(Send send, Locale locale) {
        return SendUtil.convertSendState(send, null, locale);
    }

    private static String convertSendState(Send send, SignedPayment signedPayment, Locale locale) {
        return SendUtil.convertSendState(send, signedPayment, false, locale);
    }

    private static String convertSendState(Send send, SignedPayment signedPayment, boolean ignoreCancellation, Locale locale) {
        if (send == null && signedPayment == null) {
            return "";
        }
        Send.State in = signedPayment != null ? signedPayment.getState() : send.getState();
        if (in == null) {
            return "";
        }
        String state = SendUtil.convertSendState(in, send, locale);
        if (state != null && !ignoreCancellation) {
            if (signedPayment != null) {
                return SendUtil.addCancellationInfoForSignedPayment(state, signedPayment, locale);
            }
            return SendUtil.addCancellationInfoForSend(state, send, locale);
        }
        return state;
    }

    private static String addCancellationInfoForSignedPayment(String state, SignedPayment signedPayment, Locale locale) {
        if (signedPayment.getCallback() != null) {
            String cnclStatus = signedPayment.getCancellationStatus();
            if (Camt029StatusCode.CNCL.name().equals(cnclStatus)) {
                return BankingApiMessages.getString(locale, "SendUtil.state.canceledByRecall", new Object[0]);
            }
            if (Camt029StatusCode.RJCR.name().equals(cnclStatus)) {
                return SendUtil.addCancellationInfo(state, BankingApiMessages.getString(locale, "SendUtil.state.cancellationRejected", new Object[0]));
            }
            return SendUtil.addCancellationInfo(state, BankingApiMessages.getString(locale, "SendUtil.state.cancellationRequested", new Object[0]));
        }
        return state;
    }

    private static String addCancellationInfoForSend(String state, Send send, Locale locale) {
        Send callback = send.getCallback();
        if (callback != null) {
            String cnclStatus = send.getCancellationStatus();
            if (Camt029StatusCode.CNCL.name().equals(cnclStatus)) {
                return BankingApiMessages.getString(locale, "SendUtil.state.canceledByRecall", new Object[0]);
            }
            if (Camt029StatusCode.RJCR.name().equals(cnclStatus)) {
                return SendUtil.addCancellationInfo(state, BankingApiMessages.getString(locale, "SendUtil.state.cancellationRejected", new Object[0]));
            }
            return SendUtil.addCancellationInfo(state, send, locale);
        }
        return state;
    }

    private static String addCancellationInfo(String state, Send send, Locale locale) {
        int countPaymentsWithCallbackFlag;
        int countPayments = SignedPayment.findCountBySend(send);
        if (countPayments == (countPaymentsWithCallbackFlag = SignedPayment.findCountBySendWithCallbackFlag(send))) {
            return SendUtil.addCancellationInfo(state, BankingApiMessages.getString(locale, "SendUtil.state.cancellationRequested", new Object[0]));
        }
        return SendUtil.addCancellationInfo(state, BankingApiMessages.getString(locale, "SendUtil.state.cancellationPartiallyRequested", new Object[0]));
    }

    private static String addCancellationInfo(String state, String cancellationInfo) {
        StringBuilder sb = new StringBuilder(state);
        sb.append(" (");
        sb.append(cancellationInfo);
        sb.append(")");
        return sb.toString();
    }

    public static String convertSendState(Send.State in, Send send, Locale locale) {
        switch (in) {
            case CONFIRMED: {
                return BankingApiMessages.getString(locale, "SendUtil.state.confirmed", new Object[0]);
            }
            case FINISHED_ERROR: {
                String msg = null;
                String error = null;
                if (send != null) {
                    error = send.getErrorCode();
                }
                if (error != null) {
                    msg = Character.isDigit(error.charAt(0)) ? Result.getInstance(Integer.valueOf(error)).toString() : HAC30Entry.getReasonMessage(locale, error, HAC30Entry.Action.FILE_UPLOAD);
                }
                if (msg == null) {
                    return BankingApiMessages.getString(locale, "GeneralMessages.error", new Object[0]);
                }
                return msg;
            }
            case FINISHED_OK: {
                return BankingApiMessages.getString(locale, "SendUtil.state.finishedOk", new Object[0]);
            }
            case SENT: {
                return BankingApiMessages.getString(locale, "SendUtil.state.sent", new Object[0]);
            }
            case WAITING_IN_DS: {
                return BankingApiMessages.getString(locale, "SendUtil.state.waitingInDS", new Object[0]);
            }
            case CANCELED: {
                return BankingApiMessages.getString(locale, "SendUtil.state.canceled", new Object[0]);
            }
            case SIGNATURE_STILL_MISSING: {
                return BankingApiMessages.getString(locale, "SendUtil.state.signatureStillMissing", new Object[0]);
            }
            case NOT_CONFIRMED: {
                return BankingApiMessages.getString(locale, "SendUtil.state.notConfirmed", new Object[0]);
            }
        }
        return null;
    }

    public static STATE_IMAGE getStateImage(Send send) {
        if (Send.State.FINISHED_ERROR.equals((Object)send.getState()) || Send.State.SIGNATURE_STILL_MISSING.equals((Object)send.getState())) {
            return STATE_IMAGE.WARNING;
        }
        return null;
    }

    public static STATE_IMAGE getExtendedStateImage(Send send) {
        boolean isBookedPartially = false;
        BOOKED_STATE bookedState = SendUtil.getBookedState(send);
        if (BOOKED_STATE.COMPLETELY_BOOKED.equals((Object)bookedState)) {
            return STATE_IMAGE.BOOKED;
        }
        if (BOOKED_STATE.PARTIALLY_BOOKED.equals((Object)bookedState)) {
            isBookedPartially = true;
        }
        if (Send.State.FINISHED_ERROR.equals((Object)send.getState()) || Send.State.SIGNATURE_STILL_MISSING.equals((Object)send.getState()) || SEPANotificationUtil.isStatusCodeRejected(send.getSts()) || SEPANotificationUtil.isPartiallyRejected(send.getSts())) {
            return STATE_IMAGE.WARNING;
        }
        String sts = send.getSts();
        if (sts != null && !sts.isEmpty()) {
            if (SEPANotificationUtil.isStatusCodeBooked(SendUtil.isInstantPaymentOrder(send), sts) || SEPANotificationUtil.isPartiallyBooked(sts)) {
                return STATE_IMAGE.BOOKED;
            }
            return STATE_IMAGE.INFO;
        }
        if (isBookedPartially) {
            return STATE_IMAGE.BOOKED;
        }
        return null;
    }

    public static STATE_IMAGE getStateImage(SignedPayment signedPayment) {
        return SendUtil.getStateImage(signedPayment.getSend());
    }

    public static STATE_IMAGE getExtendedStateImage(SignedPayment signedPayment) {
        if (signedPayment.getBooking() != null) {
            return STATE_IMAGE.BOOKED;
        }
        Send send = signedPayment.getSend();
        if (Send.State.FINISHED_ERROR.equals((Object)send.getState()) || Send.State.SIGNATURE_STILL_MISSING.equals((Object)send.getState())) {
            return STATE_IMAGE.WARNING;
        }
        String sts = signedPayment.getSts();
        if (sts != null && !sts.isEmpty()) {
            if (SEPANotificationUtil.isStatusCodeRejected(sts)) {
                return STATE_IMAGE.WARNING;
            }
            if (SEPANotificationUtil.isStatusCodeBooked(SendUtil.isInstantPaymentOrder(send), sts)) {
                return STATE_IMAGE.BOOKED;
            }
            return STATE_IMAGE.INFO;
        }
        return null;
    }

    public static String getStateFilterText(PaymentFilter.State state, Locale locale) {
        return SendStateUtil.getStateFilterText(state, locale);
    }

    public static String getExtendedState(Send send, Locale locale) {
        if (send == null) {
            return null;
        }
        boolean isBookedPartially = false;
        BOOKED_STATE bookedState = SendUtil.getBookedState(send);
        if (BOOKED_STATE.COMPLETELY_BOOKED.equals((Object)bookedState)) {
            return SendUtil.addCancellationInfoForSend(BankingApiMessages.getString(locale, "GeneralMessages.booked", new Object[0]), send, locale);
        }
        if (BOOKED_STATE.PARTIALLY_BOOKED.equals((Object)bookedState)) {
            isBookedPartially = true;
        }
        String sts = send.getSts();
        String vopSts = send.getVopSts();
        if (sts != null && !sts.isEmpty()) {
            String extendedState = SEPANotificationUtil.isStatusCodeRejected(sts) ? BankingApiMessages.getString(locale, "SendUtil.state.rejected", new Object[0]) : (SEPANotificationUtil.isStatusCodeBooked(SendUtil.isInstantPaymentOrder(send), sts) ? BankingApiMessages.getString(locale, "GeneralMessages.booked", new Object[0]) : (SEPANotificationUtil.isStatusCodeBookingInPreparation(sts) ? BankingApiMessages.getString(locale, "SendUtil.state.bookingInPreparation", new Object[0]) : (SEPANotificationUtil.isStatusCodePending(sts) ? BankingApiMessages.getString(locale, "SendUtil.state.pending", new Object[0]) : (SEPANotificationUtil.isPartiallyRejected(sts) ? BankingApiMessages.getString(locale, "SendUtil.state.rejectedPartially", new Object[0]) : (SEPANotificationUtil.isPartiallyBooked(sts) ? BankingApiMessages.getString(locale, "SendUtil.state.bookedPartially", new Object[0]) : SendUtil.getEbicsStateWithNotificationInfo(send, null, locale))))));
            return SendUtil.addCancellationInfoForSend(extendedState, send, locale);
        }
        if (vopSts != null && !vopSts.isEmpty()) {
            return SendUtil.getEbicsStateWithVopResultInfo(send, null, locale);
        }
        if (isBookedPartially) {
            return SendUtil.addCancellationInfoForSend(BankingApiMessages.getString(locale, "SendUtil.state.bookedPartially", new Object[0]), send, locale);
        }
        return SendUtil.convertSendState(send, null, locale);
    }

    public static BOOKED_STATE getBookedState(Send send) {
        int countSignedPayments = SignedPayment.findCountBySend(send);
        int countBookedSignedPayments = 0;
        if (countSignedPayments > 0) {
            countBookedSignedPayments = SignedPayment.findCountBookedBySend(send);
            if (countBookedSignedPayments == countSignedPayments) {
                return BOOKED_STATE.COMPLETELY_BOOKED;
            }
            if (countBookedSignedPayments > 0) {
                return BOOKED_STATE.PARTIALLY_BOOKED;
            }
        }
        return BOOKED_STATE.NOT_BOOKED;
    }

    public static String getExtendedState(SignedPayment signedPayment, Locale locale) {
        if (signedPayment.getBooking() != null) {
            return SendUtil.addCancellationInfoForSignedPayment(BankingApiMessages.getString(locale, "GeneralMessages.booked", new Object[0]), signedPayment, locale);
        }
        String sts = signedPayment.getSts();
        String vopSts = signedPayment.getVopSts();
        if (sts != null && !sts.isEmpty()) {
            String extendedState = SEPANotificationUtil.isStatusCodeRejected(sts) ? BankingApiMessages.getString(locale, "SendUtil.state.rejected", new Object[0]) : (SEPANotificationUtil.isStatusCodeBooked(SendUtil.isInstantPaymentOrder(signedPayment.getSend()), sts) ? BankingApiMessages.getString(locale, "GeneralMessages.booked", new Object[0]) : (SEPANotificationUtil.isStatusCodeBookingInPreparation(sts) ? BankingApiMessages.getString(locale, "SendUtil.state.bookingInPreparation", new Object[0]) : (SEPANotificationUtil.isStatusCodePending(sts) ? BankingApiMessages.getString(locale, "SendUtil.state.pending", new Object[0]) : SendUtil.getEbicsStateWithNotificationInfo(signedPayment.getSend(), signedPayment, locale))));
            return SendUtil.addCancellationInfoForSignedPayment(extendedState, signedPayment, locale);
        }
        if (vopSts != null && !vopSts.isEmpty()) {
            return SendUtil.getEbicsStateWithVopResultInfo(signedPayment.getSend(), signedPayment, locale);
        }
        return SendUtil.convertSendState(signedPayment.getSend(), signedPayment, locale);
    }

    public static boolean isInstantPaymentOrder(Send send) {
        PaymentTransferType.PmtType pmtType = send.getPmtType();
        if (pmtType != null && PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER.equals((Object)pmtType)) {
            return true;
        }
        return "CIP".equals(send.getOrderType()) || "XIP".equals(send.getOrderType());
    }

    private static String getEbicsStateWithNotificationInfo(Send send, SignedPayment signedPayment, Locale locale) {
        String state = SendUtil.convertSendState(send, signedPayment, true, locale);
        return SendUtil.addNotificationInfo(state, locale);
    }

    private static String addNotificationInfo(String state, Locale locale) {
        StringBuilder sb = new StringBuilder(state);
        sb.append(" (");
        sb.append(BankingApiMessages.getString(locale, "SendUtil.state.notificationsExist", new Object[0]));
        sb.append(")");
        return sb.toString();
    }

    private static String getEbicsStateWithVopResultInfo(Send send, SignedPayment signedPayment, Locale locale) {
        String state = SendUtil.convertSendState(send, signedPayment, false, locale);
        if (send == null && signedPayment == null) {
            return state;
        }
        Send.State in = signedPayment != null ? signedPayment.getState() : send.getState();
        if (in == null || in == Send.State.CONFIRMED || in == Send.State.FINISHED_OK) {
            return state;
        }
        return SendUtil.addVopResultInfo(state, locale);
    }

    private static String addVopResultInfo(String state, Locale locale) {
        StringBuilder sb = new StringBuilder(state);
        sb.append(" (");
        sb.append(BankingApiMessages.getString(locale, "SendUtil.state.vopResultsExist", new Object[0]));
        sb.append(")");
        return sb.toString();
    }

    public static boolean isCancellableState(Send.State state) {
        return Send.State.SENT.equals((Object)state) || Send.State.CONFIRMED.equals((Object)state) || Send.State.WAITING_IN_DS.equals((Object)state) || Send.State.SIGNATURE_STILL_MISSING.equals((Object)state);
    }

    public static boolean isDeletableState(Send.State state) {
        return Send.State.NOT_CONFIRMED.equals((Object)state) || Send.State.CANCELED.equals((Object)state) || Send.State.FINISHED_ERROR.equals((Object)state);
    }

    public static boolean useVopByDefault(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user).getBoolean(PreferenceConstants.DO_VOP_CHECK);
    }

    public static boolean userHasAnyVopBanks(User user, boolean checkSendPermission) {
        return BankUser.findBanksForUser(user).stream().map(BankUser::getBank).anyMatch(b -> b.isVopActivated() && (!checkSendPermission || VopUtil.hasVopPermission(user, b, Arrays.asList(PaymentTransferType.PmtType.SEPA_TRANSFER, PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER, PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT, PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT))));
    }

    public static enum STATE_IMAGE {
        BOOKED,
        WARNING,
        INFO;

    }

    public static enum BOOKED_STATE {
        COMPLETELY_BOOKED,
        PARTIALLY_BOOKED,
        NOT_BOOKED;

    }
}

