/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.PDFUtil;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.ProtocolUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.DsSigningInfo;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.transfer.api.SendOrderHandler;
import de.businesslogics.banking.transfer.api.SendUtil;
import de.businesslogics.banking.transfer.gui.PreferenceConstants;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

public class SendOverviewPrinter {
    private final User user;
    private final Locale locale;
    private final BLLogger logger;
    private final GeneralMessages messages;

    public SendOverviewPrinter(User user, Locale locale, BLLogger logger) {
        this.user = user;
        this.locale = locale;
        this.logger = logger;
        this.messages = GeneralMessages.getInstance(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File print(List<Send> sendOrdersToPrint) throws PDFException, IOException {
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, this.user);
        boolean printExtendedState = store.getBoolean(PreferenceConstants.DISPLAY_EXTENDED_STATE);
        LinkedHashMap bankOrderMap = new LinkedHashMap();
        for (Send sendOrder : sendOrdersToPrint) {
            if (bankOrderMap.containsKey(sendOrder.getBank())) {
                ((List)bankOrderMap.get(sendOrder.getBank())).add(sendOrder);
                continue;
            }
            ArrayList<Send> sendOrders = new ArrayList<Send>();
            sendOrders.add(sendOrder);
            bankOrderMap.put(sendOrder.getBank(), sendOrders);
        }
        File pdfFile = Util.createTempFile("SendOrders", ".pdf", true);
        String documentTitle = "SendOrders";
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(pdfFile);
            BLDocument document = Util.createBLDocument(os, BLDocument.PageLayout.A4_LANDSCAPE, "SendOrders", Util.printLogo(this.user), this.locale);
            document.addHeadline(this.messages.ORDERS, PDFUtil.BF, Alignment.ALIGN_CENTER, 20.0f);
            for (BankSettings bank : bankOrderMap.keySet()) {
                String bankCustomerID = bank.getCustomerId();
                document.addHeadline(this.messages.BANK_ACCESS + ": " + Util.getNameWithIdInBrackets(bank.getDisplayName(), bankCustomerID), PDFUtil.BF, Alignment.ALIGN_LEFT, 10.0f);
                int tableWidth = 100;
                int countColumns = 7;
                BLTable<?> table = PDFCreator.getInstance().createTable(countColumns);
                int[] columnWidths = new int[]{18, 13, 13, 14, 14, 16, 12};
                table.setBorder(BLBorder.NO_BORDER);
                table.setWidth(tableWidth);
                table.setWidths(columnWidths);
                table.setSpacingAfter(20.0f);
                PDFUtil.addHeaderCell(table, this.messages.ORDER, Alignment.ALIGN_LEFT);
                PDFUtil.addHeaderCell(table, this.messages.SENDING_TIME, Alignment.ALIGN_LEFT);
                PDFUtil.addHeaderCell(table, this.messages.ACCEPTING_TIME, Alignment.ALIGN_LEFT);
                PDFUtil.addHeaderCell(table, this.messages.SIGNER + " 1", Alignment.ALIGN_LEFT);
                PDFUtil.addHeaderCell(table, this.messages.SIGNER + " 2", Alignment.ALIGN_LEFT);
                PDFUtil.addHeaderCell(table, this.messages.STATE, Alignment.ALIGN_LEFT);
                PDFUtil.addHeaderCell(table, this.messages.AMOUNT, Alignment.ALIGN_RIGHT);
                for (Send sendOrder : (List)bankOrderMap.get(bank)) {
                    List<DsSigningInfo> signingInfos;
                    PDFUtil.addTextCell(table, PaymentTypeUtil.geOrderIdentification(sendOrder), Alignment.ALIGN_LEFT);
                    PDFUtil.addTextCell(table, this.getFormattedDateTime(sendOrder.getSent()), Alignment.ALIGN_LEFT);
                    int maxSigners = 2;
                    int countSigners = 0;
                    SendOrderHandler sendOrderHandler = new SendOrderHandler(sendOrder);
                    PDFUtil.addTextCell(table, this.getFormattedDateTime(ProtocolUtil.getAcceptanceTime(sendOrder)), Alignment.ALIGN_LEFT);
                    DsOrderDetails orderDetails = sendOrderHandler.parseProtocol(this.locale);
                    if (orderDetails != null && (signingInfos = orderDetails.getSigningInfos()) != null) {
                        for (DsSigningInfo signingInfo : signingInfos) {
                            String customerID;
                            String userID = signingInfo.getUserId();
                            String userName = BankUser.findLoginUserNameByUserIdAndCustomerId(userID, customerID = signingInfo.getCustomerId());
                            if (userName == null || userName.trim().length() == 0) {
                                userName = signingInfo.getUserName();
                            }
                            String userInfo = customerID != null && !customerID.equals(bankCustomerID) ? Util.getNameWithIdInBrackets(userName, customerID + " / " + userID) : Util.getNameWithIdInBrackets(userName, userID);
                            PDFUtil.addTextCell(table, userInfo, Alignment.ALIGN_LEFT);
                            if (++countSigners != maxSigners) continue;
                            break;
                        }
                    }
                    for (int i = 0; i < maxSigners - countSigners; ++i) {
                        PDFUtil.addTextCell(table, "", Alignment.ALIGN_LEFT);
                    }
                    String state = printExtendedState ? SendUtil.getExtendedState(sendOrder, this.locale) : SendUtil.convertSendState(sendOrder, this.locale);
                    PDFUtil.addTextCell(table, state, Alignment.ALIGN_LEFT);
                    PDFUtil.addTextCell(table, this.getFormattedAmount(sendOrder.getAmount(), sendOrder.getCurrency()), Alignment.ALIGN_RIGHT);
                }
                document.addTable(table);
            }
            document.close();
        }
        catch (IOException ioe) {
            block14: {
                if (this.logger == null) break block14;
                this.logger.logError("IOException", ioe);
            }
            SystemUtils.close(os);
        }
        catch (PDFException pdfe) {
            block15: {
                if (this.logger == null) break block15;
                this.logger.logError("PDFException", pdfe);
                {
                    catch (Throwable throwable) {
                        SystemUtils.close(os);
                        throw throwable;
                    }
                }
            }
            SystemUtils.close(os);
        }
        SystemUtils.close(os);
        return pdfFile;
    }

    private String getFormattedDateTime(Date date) {
        if (date != null) {
            return DateFormat.getDateTimeInstance(2, 3).format(date);
        }
        return "";
    }

    private String getFormattedAmount(BigDecimal amount, String currencyCode) {
        if (amount == null) {
            return "";
        }
        Currency currency = null;
        if (currencyCode != null) {
            try {
                currency = Currency.getInstance(currencyCode);
            }
            catch (IllegalArgumentException no) {
                return "";
            }
        }
        return PaymentUtils.formatAmount(amount, currency, this.locale);
    }
}

