/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DSUtil;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.ProtocolListenerDS;
import de.businesslogics.banking.api.ProtocolUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.DsSigningInfo;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.PtkEntry;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.ds.LocalDSUtil;
import de.businesslogics.banking.transfer.api.CustomerProtocolSettings;
import de.businesslogics.banking.transfer.api.ProtocolFormat;
import de.businesslogics.banking.transfer.api.SEPANotificationUtil;
import de.businesslogics.banking.transfer.api.SendUtil;
import de.businesslogics.banking.transfer.api.TransferApiMessages;
import de.businesslogics.banking.transfer.gui.PreferenceConstants;
import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.format.iso20022.pain00200103.Hac2Pdf;
import de.businesslogics.format.ptk2.AccountCheckResult;
import de.businesslogics.format.ptk2.DSFinishResult;
import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ptk2.DisplayResult;
import de.businesslogics.format.ptk2.ExpirationResult;
import de.businesslogics.format.ptk2.PTKEntry;
import de.businesslogics.format.ptk2.PTKParser;
import de.businesslogics.format.ptk2.SignatureResult;
import de.businesslogics.format.ptk2.TransferResult;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFElement;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import io.ebean.Query;
import io.ebean.Transaction;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;

public final class SendOrderHandler {
    private static final List<Runnable> REFRESH_HANDLER = new ArrayList<Runnable>();
    private final Send send;
    private final File dataFile;
    private final Map<Locale, String> tickets = new HashMap<Locale, String>();

    public static void registerRefreshHandler(Runnable runnable) {
        REFRESH_HANDLER.add(runnable);
    }

    public static void unregisterRefreshHandler(Runnable runnable) {
        REFRESH_HANDLER.remove(runnable);
    }

    public static void fireRefresh() {
        if (!REFRESH_HANDLER.isEmpty()) {
            for (Runnable refreshHandler : REFRESH_HANDLER) {
                refreshHandler.run();
            }
        }
    }

    public static List<Send> findOlderThan(Date oldest) {
        List list = DB.find(Send.class).where().lt("sent", (Object)oldest).findList();
        return list;
    }

    public static int deleteOlderThan(Date oldest) {
        List list = DB.find(Send.class).where().lt("sent", (Object)oldest).findList();
        SendOrderHandler.delete(list);
        return list.size();
    }

    public static void delete(List<Send> list) {
        try (Transaction t = DB.beginTransaction();){
            for (Send s : list) {
                new SendOrderHandler(s).delete();
            }
            t.commit();
            SendOrderHandler.fireRefresh();
        }
    }

    public static void delete(BankSettings bank) {
        File toReturn = SendOrderHandler.getBankDir(bank);
        SystemUtils.deleteRecursive(toReturn);
        Send.deleteByBank(bank);
    }

    public static File getSendDataDir() {
        return WorkspaceFileSystem.SENT_DIR;
    }

    public static File getBankDir(BankSettings b) {
        return new File(SendOrderHandler.getSendDataDir(), b.getUniqueKey());
    }

    public static SendOrderHandler findByHash(File file) throws IOException, NoSuchAlgorithmException {
        String hash = SystemUtils.calculateMD5Hash(file);
        Send send = Send.findNewestByHash(hash);
        if (send != null) {
            return new SendOrderHandler(send);
        }
        return null;
    }

    public SendOrderHandler(Send vo) {
        this.send = vo;
        this.dataFile = this.send.getFile() != null ? WorkspaceFileSystem.getFile(this.send.getFile()) : LocalDSUtil.getDataFileFromDs(vo);
    }

    public void storeAmountAndCurrency(BigDecimal amount, Currency currency) {
        this.send.setAmount(amount);
        if (currency != null) {
            this.send.setCurrency(currency.getCurrencyCode());
        } else {
            this.send.setCurrency(null);
        }
        this.send.save();
        SendOrderHandler.fireRefresh();
    }

    public String getOrderId() {
        return this.send.getOriginalSendType() + " " + this.send.getOrderNumber();
    }

    public void setState(Send.State state) {
        this.send.setState(state);
        this.send.save();
        SendOrderHandler.fireRefresh();
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public void delete() {
        if (this.dataFile != null && !this.dataFile.delete()) {
            this.dataFile.deleteOnExit();
        }
        this.send.delete();
    }

    public String getTicketFromProtocol(Locale locale) {
        String result = this.tickets.get(locale);
        if (result != null) {
            return result;
        }
        List<HacEntry> hacs = ProtocolUtil.findHacEntriesWithTicket(this.send);
        if (hacs != null && !hacs.isEmpty()) {
            result = hacs.get(0).getAdditionalInformation();
            this.tickets.put(locale, result);
            return result;
        }
        List<PtkEntry> ptks = ProtocolUtil.findPtkEntriesWithTicket(this.send);
        for (PtkEntry ptkEntry : ptks) {
            PTKEntry e;
            try {
                e = new PTKParser(new StringReader(ptkEntry.toString())).nextEntry();
            }
            catch (Exception exception) {
                continue;
            }
            DisplayMessage ticket = e.getResult() instanceof AccountCheckResult ? ((AccountCheckResult)e.getResult()).getTicket() : (e.getResult() instanceof DisplayResult ? ((DisplayResult)e.getResult()).getTicket() : (e.getResult() instanceof DSFinishResult ? ((DSFinishResult)e.getResult()).getTicket() : (e.getResult() instanceof ExpirationResult ? ((ExpirationResult)e.getResult()).getTicket() : (e.getResult() instanceof SignatureResult ? ((SignatureResult)e.getResult()).getTicket() : (e.getResult() instanceof TransferResult ? ((TransferResult)e.getResult()).getTicket() : null)))));
            if (ticket == null) continue;
            StringBuilder ticketBuilder = new StringBuilder();
            ticket.appendText(locale, ticketBuilder);
            result = ticketBuilder.toString();
            this.tickets.put(locale, result);
            return result;
        }
        return null;
    }

    public Send getSend() {
        return this.send;
    }

    private DsOrderDetails getDsOrderDetailsFromProtocol(Locale locale) {
        try {
            List hacList = ProtocolUtil.getHacEntries(this.send).findList();
            if (hacList.size() != 0) {
                return this.parseProtocol(locale);
            }
        }
        catch (Exception hacList) {
            // empty catch block
        }
        try {
            List ptkList = ProtocolUtil.getPtkEntries(this.send).findList();
            if (ptkList.size() != 0) {
                return this.parseProtocol(locale);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public DsOrderDetails parseProtocol(Locale locale) {
        String ticket;
        ProtocolListenerDS listener = new ProtocolListenerDS();
        Query<HacEntry> query = ProtocolUtil.getHacEntries(this.send);
        MyHacConsumer consumer = new MyHacConsumer(listener);
        query.findEach((Consumer)consumer);
        if (consumer.orderDetails != null && consumer.orderDetails.getTicket() == null && (ticket = this.getTicketFromProtocol(locale)) != null) {
            consumer.orderDetails.setTicket(ticket.getBytes());
        }
        if (consumer.orderDetails == null) {
            Query<PtkEntry> queryPtk = ProtocolUtil.getPtkEntries(this.send);
            MyPTKConsumer consumerPtk = new MyPTKConsumer(listener);
            queryPtk.findEach((Consumer)consumerPtk);
            return consumerPtk.orderDetails;
        }
        return consumer.orderDetails;
    }

    public File printSendReport(Locale locale, User user, SendReportPrintHelper helper) throws IOException, PDFException {
        boolean printLogo = Util.printLogo(user);
        return this.printSendReport(locale, user, helper, printLogo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File printSendReport(Locale locale, User user, SendReportPrintHelper helper, boolean printLogo) throws IOException, PDFException {
        String fileNamePart1 = this.send.getBank().getDisplayName();
        String fileNamePart2 = this.send.getAccounts().size() == 1 ? "_" + this.send.getAccounts().get(0).getName() : "";
        String fileName = StringUtils.convertToValidFileName(fileNamePart1 + fileNamePart2) + "_" + this.send.getOrderNumber() + "_";
        File dest = Util.createTempFile(fileName, ".pdf", true);
        String trimmedFileName = dest.getPath().substring(0, dest.getPath().lastIndexOf(95)) + ".pdf";
        File trimmedFile = new File(trimmedFileName);
        int suffix = 1;
        while (trimmedFile.exists() && suffix < 1000) {
            String trimmedFileNameWithSuffix = trimmedFileName.substring(0, trimmedFileName.length() - 4) + "-" + suffix++ + ".pdf";
            trimmedFile = new File(trimmedFileNameWithSuffix);
        }
        if (dest.renameTo(trimmedFile)) {
            dest = trimmedFile;
        }
        OutputStream fos = null;
        try {
            List<Notification> statusReports;
            List<Notification> vopResults;
            String orderInfo;
            boolean hasOrderName;
            fos = Files.newOutputStream(dest.toPath(), new OpenOption[0]);
            BLDocument document = Util.createBLDocument(fos, BLDocument.PageLayout.A4, BankingApiMessages.getString(locale, "GeneralMessages.sentReport", new Object[0]), printLogo, locale);
            GeneralMessages messages = GeneralMessages.getInstance(locale);
            String orderName = helper.getOrderName(this.send, locale);
            String orderNumber = this.send.getOrderNumber();
            String orderIdentification = Util.getOrderRepresentation(this.send);
            boolean bl = hasOrderName = orderName != null;
            if (hasOrderName) {
                orderInfo = orderNumber;
            } else {
                orderName = messages.ORDER;
                orderInfo = orderIdentification;
            }
            BankSettings bank = this.send.getBank();
            String bankName = bank.getDisplayName();
            String title = this.getReportHeadline(locale, orderName, orderInfo, bankName);
            BLFont font = BLFont.FONT_BIG_BOLD;
            document.addHeadline(title, font, Alignment.ALIGN_CENTER, 10.0f);
            String description = this.send.getState() != null && Send.State.NOT_CONFIRMED == this.send.getState() ? TransferApiMessages.getString(locale, "sendorder.print.messagenotconfirmedWithOrderName", orderName, bankName) : TransferApiMessages.getString(locale, "sendorder.print.messageWithOrderName", orderName, bankName);
            document.addTextln(description, 0.0f, 10.0f);
            BLTable<?> t = PDFCreator.getInstance().createTable(2);
            t.setWidth(100.0f);
            t.setWidths(new int[]{1, 3});
            t.setBorder(BLBorder.NO_BORDER);
            t.addCell(messages.ORDER);
            t.addCell(orderIdentification);
            t.addCell(TransferApiMessages.getString(locale, "sendorder.print.timestamp", new Object[0]));
            Timestamp submissionTime = this.send.getSent();
            t.addCell(DateFormat.getDateTimeInstance().format(submissionTime));
            Send calledBackOrder = Send.findCalledBackOrder(this.send);
            if (calledBackOrder != null) {
                t.addCell(BankingApiMessages.getString(locale, "PaymentTypeUtil.cancelledOrder", new Object[0]));
                t.addCell(Util.getOrderRepresentation(calledBackOrder));
            }
            t.addCell(messages.BANK);
            t.addCell(bankName);
            t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.url", new Object[0]));
            t.addCell(this.send.getBank().getUrl());
            String senderInfo = this.send.getSender();
            String senderCustomerId = null;
            String senderUserId = null;
            if (senderInfo != null) {
                String statusCode;
                String scheme;
                List<DsSigningInfo> signingInfos;
                DsOrderDetails orderDetails = this.getDsOrderDetailsFromProtocol(locale);
                int posOpenBracket = senderInfo.lastIndexOf("(");
                int posClosingBracket = senderInfo.lastIndexOf(")");
                int posSlash = senderInfo.lastIndexOf("/");
                if (posOpenBracket > 0 && posSlash > posOpenBracket && posClosingBracket > posSlash) {
                    senderCustomerId = senderInfo.substring(posOpenBracket + 1, posSlash).trim();
                    senderUserId = senderInfo.substring(posSlash + 1, posClosingBracket).trim();
                }
                t.addCell(GeneralMessages.getInstance((Locale)locale).SUBMITTED_ON);
                Timestamp protocolTime = null;
                if (orderDetails != null) {
                    protocolTime = orderDetails.getSubmissionDate();
                }
                t.addCell(this.getSubmitterInfo(locale, senderInfo, protocolTime != null ? protocolTime : submissionTime));
                boolean lastRejected = Send.State.CANCELED.equals((Object)this.send.getState());
                HashMap<String, DsSigningInfo> signingInfoMap = new HashMap<String, DsSigningInfo>();
                DsOrderDetails orderDetailsFromDb = DsOrderDetails.findBySend(this.send);
                if (orderDetailsFromDb != null && (signingInfos = orderDetailsFromDb.getSigningInfos()) != null) {
                    for (DsSigningInfo signingInfo : signingInfos) {
                        signingInfoMap.put(signingInfo.getUserId(), signingInfo);
                    }
                }
                if (orderDetails != null) {
                    List decline;
                    Iterator<DsSigningInfo> signerIterator = LocalDSUtil.getSortedSigningInfos(orderDetails).iterator();
                    while (signerIterator.hasNext()) {
                        DsSigningInfo signingInfoFromDb;
                        DsSigningInfo signingInfo = signerIterator.next();
                        if (lastRejected && !signerIterator.hasNext()) {
                            t.addCell(GeneralMessages.getInstance((Locale)locale).CANCELLED_ON);
                        } else {
                            t.addCell(GeneralMessages.getInstance((Locale)locale).SIGNED_ON);
                        }
                        String customerId = signingInfo.getCustomerId();
                        String userId = signingInfo.getUserId();
                        String userName = senderCustomerId != null && senderCustomerId.equals(customerId) && senderUserId != null && senderUserId.equals(userId) ? senderInfo : ((signingInfoFromDb = (DsSigningInfo)signingInfoMap.get(signingInfo.getUserId())) != null ? signingInfoFromDb.getUserName() : signingInfo.getUserName());
                        t.addCell(DSUtil.getUserInfoText(locale, customerId, userId, userName, signingInfo.getSignDate()));
                    }
                    List accept = ProtocolUtil.getHacEntries(orderDetails, HAC30Entry.Action.ORDER_HAC_FINAL_POS.ordinal()).findList();
                    if (!accept.isEmpty()) {
                        t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.acceptedOn", new Object[0]));
                        t.addCell(MessageFormat.format("{0,date} {0,time}", ((HacEntry)accept.getLast()).getHacTime()));
                    }
                    if (!(decline = ProtocolUtil.getHacEntries(orderDetails, HAC30Entry.Action.ORDER_HAC_FINAL_NEG.ordinal()).findList()).isEmpty()) {
                        t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.declinedOn", new Object[0]));
                        t.addCell(MessageFormat.format("{0,date} {0,time}", ((HacEntry)decline.getLast()).getHacTime()));
                    }
                }
                if (this.send.getOrigFileName() != null && !this.send.getOrigFileName().isEmpty()) {
                    t.addCell(messages.FILE);
                    t.addCell(this.send.getOrigFileName());
                }
                t.addCell(messages.FILE_SIZE);
                t.addCell(Util.getFormattedSizeInBytes(this.send.getSize(), locale));
                String signatureHash = this.send.getSignatureHash();
                if (signatureHash != null && signatureHash.length() > 0) {
                    t.addCell(messages.HASH_VALUE);
                    t.addCell(signatureHash);
                }
                if ((scheme = this.send.getScheme()) != null && scheme.length() > 0) {
                    t.addCell(messages.SCHEME);
                    t.addCell(scheme);
                }
                boolean manualApproval = this.send.hasManualApproval();
                t.addCell(TransferApiMessages.getString(locale, "sendorder.approvalMethod", new Object[0]));
                String approval = manualApproval ? BankingApiMessages.getString(locale, "GeneralMessages.manualFaxApproval", new Object[0]) : TransferApiMessages.getString(locale, "sendorder.approvalMethod.electronic", new Object[0]);
                t.addCell(approval);
                String additionalOrderInfo = this.send.getAdditionalOrderInfo();
                if (additionalOrderInfo != null && additionalOrderInfo.length() > 0) {
                    t.addCell(messages.ORDER_DATA_ADDITIONAL_INFO);
                    t.addCell(additionalOrderInfo);
                }
                String stateLabel = (statusCode = SEPANotificationUtil.getStatusCodeText(this.send, locale)) != null ? BankingApiMessages.getString(locale, "SendUtil.stateFromProtocol", new Object[0]) : GeneralMessages.getInstance((Locale)locale).STATE;
                t.addCell(stateLabel);
                t.addCell(SendUtil.convertSendState(this.send, locale));
                Notification notification = Notification.findNewestSEPANotification(this.send);
                if (notification != null) {
                    t.addCell(TransferApiMessages.getString(locale, "NotificationUtil.newestStatusReport", new Object[0]));
                    t.addCell(DateFormat.getDateTimeInstance().format(notification.getFetched()));
                }
                if (statusCode != null) {
                    t.addCell(GeneralMessages.getInstance((Locale)locale).STATE);
                    t.addCell(statusCode);
                }
            }
            t.setHorizontalAlignment(Alignment.ALIGN_LEFT);
            document.addTable(t);
            Tenant tenant = this.send.getBank().getTenant();
            DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user, tenant);
            if (store.getBoolean(PreferenceConstants.SEND_REPORT_WITH_TICKET)) {
                String ticket = this.getTicketFromProtocol(locale);
                if (ticket == null && (ticket = helper.generateTicket(this, locale)) != null) {
                    this.tickets.put(locale, ticket);
                }
                if (ticket != null) {
                    document.addVSpace(20.0f);
                    document.addTextln(ticket, BLFont.COURIER_SMALL, 0.0f);
                }
            }
            if (store.getBoolean(PreferenceConstants.SEND_REPORT_WITH_PTK)) {
                this.printProtocol(document, locale, orderName, orderInfo, bankName);
            }
            if (store.getBoolean(PreferenceConstants.SEND_REPORT_WITH_DETAILS) && this.dataFile != null && (!this.send.isWithSalaries() || Util.displaySalaries(user) || this.send.getPmtType() == null || !this.send.getPmtType().isCallbackType())) {
                helper.printDetails(document, this.send);
            }
            if (store.getBoolean(PreferenceConstants.SEND_REPORT_WITH_VOP_RESULTS) && (vopResults = Notification.getSEPAVopNotifications(this.send)).size() > 0) {
                helper.printStatusReports(document, vopResults);
            }
            if (store.getBoolean(PreferenceConstants.SEND_REPORT_WITH_STATUS_REPORTS) && (statusReports = Notification.getSEPANonVopNotifications(this.send)).size() > 0) {
                helper.printStatusReports(document, statusReports);
            }
            document.close();
        }
        catch (Throwable throwable) {
            SystemUtils.close(fos);
            throw throwable;
        }
        SystemUtils.close(fos);
        return dest;
    }

    private String getSubmitterInfo(Locale locale, String senderInfo, Date time) {
        int posSlash = senderInfo.indexOf("/");
        int posSpace = senderInfo.indexOf(" ");
        int lastPosBracket = senderInfo.lastIndexOf(")");
        if (posSlash > 0 && posSpace > posSlash && lastPosBracket > posSpace + 1) {
            String customerID = senderInfo.substring(0, posSlash);
            String userID = senderInfo.substring(posSlash + 1, posSpace);
            String userName = senderInfo.substring(posSpace + 2, lastPosBracket);
            return DSUtil.getUserInfoText(locale, customerID, userID, userName, this.send.getSent());
        }
        return DSUtil.getUserInfoText(locale, senderInfo, this.send.getSent());
    }

    private String getReportHeadline(Locale locale, String orderName, String orderInfo, String bankName) {
        return TransferApiMessages.getString(locale, "sendorder.print.titleWithOrderName", orderName, orderInfo, bankName);
    }

    private String getBankProtocolHeadline(Locale locale, String orderName, String orderInfo, String bankName) {
        return TransferApiMessages.getString(locale, "sendorder.print.protocolWithOrderName", orderName, orderInfo, bankName);
    }

    private void printProtocol(BLDocument document, Locale locale, String orderName, String orderInfo, String bankName) throws PDFException {
        ProtocolFormat format = CustomerProtocolSettings.byBank(this.send.getBank()).getProtocolFormat();
        PDFElement<?> protocolElement = null;
        if (ProtocolFormat.HAC == format) {
            protocolElement = this.printHac(locale);
        }
        if (protocolElement == null) {
            Query<PtkEntry> query = ProtocolUtil.getPtkEntries(this.send);
            StringBuilder ptkBuilder = new StringBuilder();
            query.findEach(ptk -> {
                ptkBuilder.append(ptk.getData());
                ptkBuilder.append("\r\n");
            });
            if (ptkBuilder.length() > 0) {
                protocolElement = PDFCreator.getInstance().createParagraph(ptkBuilder.toString(), BLFont.COURIER_SMALL);
            }
            if (protocolElement == null && format == ProtocolFormat.PTK) {
                protocolElement = this.printHac(locale);
            }
        }
        if (protocolElement != null) {
            document.newPage();
            document.addHeadline(this.getBankProtocolHeadline(locale, orderName, orderInfo, bankName), BLFont.FONT_BIG_BOLD, Alignment.ALIGN_CENTER, 10.0f);
            document.add(protocolElement);
        }
    }

    private PDFElement<?> printHac(Locale locale) throws PDFException {
        Query<HacEntry> query = ProtocolUtil.getHacEntries(this.send);
        if (query.findCount() > 0) {
            Hac2Pdf hac2pdf = new Hac2Pdf(false, locale);
            query.findEach(hac -> hac2pdf.addEntry(ProtocolUtil.toHAC(hac)));
            return hac2pdf.getHacTable();
        }
        return null;
    }

    private static class MyHacConsumer
    implements Consumer<HacEntry> {
        private DsOrderDetails orderDetails;
        private final ProtocolListenerDS listener;

        public MyHacConsumer(ProtocolListenerDS listenerDS) {
            this.listener = listenerDS;
        }

        @Override
        public void accept(HacEntry hac) {
            if (this.orderDetails == null) {
                this.orderDetails = this.listener.createOrderDetailsFromHac(hac);
            }
            this.listener.checkOriginatorInfo(null, hac, this.orderDetails);
            this.listener.checkSignerInfo(null, hac, this.orderDetails);
        }
    }

    private static class MyPTKConsumer
    implements Consumer<PtkEntry> {
        private final PTKParser parser = new PTKParser();
        private DsOrderDetails orderDetails;
        private final ProtocolListenerDS listener;

        public MyPTKConsumer(ProtocolListenerDS listenerDS) {
            this.listener = listenerDS;
        }

        @Override
        public void accept(PtkEntry ptk) {
            try {
                PTKEntry entry = this.parser.getEntry(StringUtils.getStringArrayFromString(ptk.getData(), "\n"));
                if (entry != null) {
                    if (this.orderDetails == null) {
                        this.orderDetails = this.listener.createOrderDetailsFromPtk(ptk, entry);
                    }
                    this.listener.checkOriginatorInfo(entry, ptk, this.orderDetails);
                    this.listener.checkSignerInfo(entry, ptk, this.orderDetails);
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface SendReportPrintHelper {
        public String generateTicket(SendOrderHandler var1, Locale var2) throws IOException;

        public void printDetails(BLDocument var1, Send var2) throws PDFException, IOException;

        public void printStatusReports(BLDocument var1, List<Notification> var2) throws PDFException, IOException;

        public String getOrderName(Send var1, Locale var2);

        public String getFormat(Send var1);
    }
}

