/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.NotificationPmtInf;
import de.businesslogics.banking.database.vo.NotificationTrx;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.transfer.api.SendUtil;
import de.businesslogics.banking.transfer.gui.PreferenceConstants;
import de.businesslogics.format.sepa.StatusCode;
import de.businesslogics.util.BLLogger;
import io.ebean.Transaction;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public class SEPANotificationUtil {
    private static final long ONE_DAY = 86400000L;
    private static final long THIRTY_DAYS = 2592000000L;
    private static final String PARTIAL_BOOKED = "PBK";
    private static final String PARTIAL_REJECTED = "PRJ";
    private static final String ACCP = "ACCP";
    private static final String ACSC = "ACSC";
    private static final String ACSP = "ACSP";
    private static final String PART = "PART";
    private static final String PDNG = "PDNG";
    private static final String RJCT = "RJCT";
    private static final String VOP_MATCH = "RCVC";
    private static final String VOP_NO_MATCH = "RVNM";
    private static final String VOP_CLOSE_MATCH = "RVMC";
    private static final String VOP_NOT_APPLICABLE = "RVNA";
    private static final String VOP_HAS_MISMATCHES = "RVCM";

    public static Send findSEPASendOrder(Notification notification, BLLogger logger) {
        if (notification.getOrgnlMsgId() != null) {
            String originalMessageId = notification.getOrgnlMsgId();
            Timestamp messageCreationDate = notification.getFetched();
            List<Send> sendVOs = Send.findByMessageId(notification.getBank(), originalMessageId);
            if (!sendVOs.isEmpty()) {
                boolean doAdditionalCheck;
                if (sendVOs.size() > 1) {
                    if (notification.getOrgnlCtrlSum() != null) {
                        Iterator<Send> it = sendVOs.iterator();
                        while (it.hasNext()) {
                            Send send = it.next();
                            if (send.getAmount() == null || send.getAmount().compareTo(notification.getOrgnlCtrlSum()) == 0) continue;
                            it.remove();
                        }
                    }
                    if (sendVOs.size() > 1) {
                        logger.logWarning("Found " + sendVOs.size() + " send orders with msgId '" + originalMessageId + "' for the pain.002-message from " + String.valueOf(messageCreationDate));
                    }
                }
                if (!(doAdditionalCheck = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, null).getBoolean(PreferenceConstants.DO_ADDITIONAL_PAIN002_CHECK))) {
                    return sendVOs.get(0);
                }
                String orglMsgNmId = notification.getOrgnlMsgNmId();
                if (orglMsgNmId != null && orglMsgNmId.length() >= 8) {
                    String originalMessageType = orglMsgNmId.substring(0, 8);
                    sendVOs = SEPANotificationUtil.checkMessageType(originalMessageType, sendVOs);
                    if (sendVOs.size() != 1) {
                        logger.logWarning("Found " + sendVOs.size() + " send orders with msgId '" + originalMessageId + "', msgType '" + originalMessageType + "' for the pain.002-message from " + String.valueOf(messageCreationDate));
                    }
                } else {
                    logger.logWarning("pain.002-message from " + String.valueOf(messageCreationDate) + " is invalid. orglMsgNmId is missing. MessageType is not checked !");
                }
                long reportCreationTime = messageCreationDate.getTime();
                long closestNegativeDelay = 0L;
                Send closestSendInFuture = null;
                for (Send send : sendVOs) {
                    long delay = reportCreationTime - send.getSent().getTime();
                    if (delay < 0L) {
                        closestNegativeDelay = delay;
                        closestSendInFuture = send;
                        continue;
                    }
                    if (delay <= 2592000000L) {
                        return send;
                    }
                    logger.logWarning("Found send order with msgId " + originalMessageId + " for the pain.002-message from " + String.valueOf(messageCreationDate) + ", but its send time " + String.valueOf(send.getSent()) + " is too far in the past!");
                }
                if (closestSendInFuture != null) {
                    if (Math.abs(closestNegativeDelay) <= 86400000L) {
                        logger.logWarning("Found send order with msgId " + originalMessageId + " for the pain.002-message from " + String.valueOf(messageCreationDate) + " with a send time " + String.valueOf(closestSendInFuture.getSent()) + " that is not too far in the future!");
                        return closestSendInFuture;
                    }
                    logger.logWarning("Found send order with msgId " + originalMessageId + " for the pain.002-message from " + String.valueOf(messageCreationDate) + ", but its send time " + String.valueOf(closestSendInFuture.getSent()) + " is too far in the future!");
                }
                logger.logWarning("No send order with msgId " + originalMessageId + " has a send time that fits to the pain.002-message from " + String.valueOf(messageCreationDate));
            } else {
                logger.logWarning("Found no send order with msgId " + originalMessageId + " for the pain.002-message from " + String.valueOf(messageCreationDate));
            }
        } else {
            logger.logError("pain.002-message from " + String.valueOf(notification.getFetched()) + " is invalid. OrgnlMsgId is missing !");
        }
        return null;
    }

    private static List<Send> checkMessageType(String messageType, List<Send> originalVOs) {
        ArrayList<Send> fittingVOs = new ArrayList<Send>();
        for (Send send : originalVOs) {
            String scheme = send.getScheme();
            if (scheme == null || scheme.length() < 8 || !messageType.equals(scheme.substring(0, 8))) continue;
            fittingVOs.add(send);
        }
        return fittingVOs;
    }

    public static void setAdditionalStates(Notification notification, Send send, BLLogger logger) {
        Timestamp creationDate = notification.getFetched();
        String grpSts = notification.getGrpSts();
        try (Transaction t = DB.beginTransaction();){
            boolean isNewestNotification;
            List<Notification> notifications;
            boolean isVopResult;
            boolean isInstantPaymentOrder = SendUtil.isInstantPaymentOrder(send);
            boolean hasGrpSts = grpSts != null && !grpSts.isEmpty() && !grpSts.equals(PART);
            boolean bl = isVopResult = notification.getType() == Notification.Type.Pain002Vop;
            if (isVopResult) {
                notifications = Notification.findPain002VopNotifications(send, true);
                SignedPayment.setVopStatusCode(grpSts, send);
            } else {
                notifications = Notification.findPain002Notifications(send, true);
            }
            int countNotifications = notifications != null ? notifications.size() : 0;
            boolean bl2 = isNewestNotification = countNotifications <= 1 || !creationDate.before(notifications.get(0).getFetched());
            if (isNewestNotification) {
                if (hasGrpSts) {
                    if (isVopResult) {
                        send.setVopSts(grpSts);
                    } else {
                        send.setSts(grpSts);
                    }
                } else if (isVopResult) {
                    send.setVopSts(PART);
                } else {
                    send.setSts(PART);
                }
                send.save();
            }
            List<NotificationPmtInf> pmtInfs = NotificationPmtInf.find(notification);
            int countPmtInfs = pmtInfs.size();
            List<SignedPayment> signedPayments = SignedPayment.findBySend(send);
            if (signedPayments.size() > 0) {
                HashMap<String, List> map = new HashMap<String, List>();
                for (SignedPayment p : signedPayments) {
                    String s = p.getPmtInfId() + " - " + p.getReference();
                    map.computeIfAbsent(s, k -> new ArrayList()).add(p);
                }
                if (countPmtInfs > 0) {
                    HashSet allTrxStatusCodes = new HashSet();
                    int countTrxInReport = 0;
                    for (NotificationPmtInf pmtInf : pmtInfs) {
                        String pmtInfId = pmtInf.getOrgnlPmtInfId();
                        String pmtInfSts = pmtInf.getPmtInfSts();
                        boolean hasPmtInfSts = pmtInfSts != null && !pmtInfSts.isEmpty() && !pmtInfSts.equals(PART);
                        List<NotificationTrx> trxs = NotificationTrx.find(pmtInf);
                        if (trxs.size() > 0) {
                            HashSet<String> trxStatusCodes = new HashSet<String>();
                            for (NotificationTrx trx : trxs) {
                                boolean hasTrxSts;
                                String trxSts = trx.getTxSts();
                                String endToEndId = trx.getOrgnlEndToEndId();
                                String status = null;
                                String statusReasonInfo = null;
                                boolean bl3 = hasTrxSts = trxSts != null && !trxSts.isEmpty();
                                if (hasTrxSts) {
                                    trxStatusCodes.add(trxSts);
                                    status = trxSts;
                                    statusReasonInfo = trx.getStatusReasonInfo();
                                } else if (hasPmtInfSts) {
                                    status = pmtInfSts;
                                } else if (hasGrpSts) {
                                    status = grpSts;
                                }
                                if (status != null) {
                                    List list = (List)map.get(pmtInfId + " - " + endToEndId);
                                    if (list == null || list.size() != 1) continue;
                                    SignedPayment signedPayment = (SignedPayment)list.get(0);
                                    trx.setSend(send);
                                    trx.setSignedPayment(signedPayment);
                                    DB.save(trx);
                                    if (!SEPANotificationUtil.isFinalStatus(isInstantPaymentOrder, status) && !isNewestNotification && !SEPANotificationUtil.isNewestNotification(creationDate, signedPayment, isVopResult)) continue;
                                    if (isVopResult) {
                                        signedPayment.setVopSts(status);
                                    } else {
                                        signedPayment.setSts(status);
                                        if (statusReasonInfo != null) {
                                            signedPayment.setStatusReasonInfo(statusReasonInfo);
                                        }
                                    }
                                    DB.save(signedPayment);
                                    continue;
                                }
                                logger.logError("SEPA notification with ID = " + notification.getId() + " is invalid. StatusCode is missing on all levels.");
                            }
                            allTrxStatusCodes.addAll(trxStatusCodes);
                            countTrxInReport += trxs.size();
                            continue;
                        }
                        String status = null;
                        if (hasPmtInfSts) {
                            status = pmtInfSts;
                        } else if (hasGrpSts) {
                            status = grpSts;
                        }
                        if (status == null) continue;
                        boolean isFinalStatus = SEPANotificationUtil.isFinalStatus(isInstantPaymentOrder, status);
                        if (isFinalStatus || isNewestNotification) {
                            if (isVopResult) {
                                SignedPayment.setVopStatusCode(status, send, pmtInfId);
                                continue;
                            }
                            SignedPayment.setStatusCode(status, send, pmtInfId);
                            continue;
                        }
                        for (SignedPayment s : signedPayments) {
                            if (!pmtInfId.equals(s.getPmtInfId()) || !SEPANotificationUtil.isNewestNotification(creationDate, s, isVopResult)) continue;
                            if (isVopResult) {
                                s.setVopSts(status);
                            } else {
                                s.setSts(status);
                            }
                            DB.save(s);
                        }
                    }
                    if (isNewestNotification && allTrxStatusCodes.size() == 1) {
                        String uniqueTrxSts = (String)allTrxStatusCodes.iterator().next();
                        int originalCount = signedPayments.size();
                        if (originalCount == countTrxInReport) {
                            if (isVopResult) {
                                send.setVopSts(uniqueTrxSts);
                            } else {
                                send.setSts(uniqueTrxSts);
                            }
                            send.save();
                        } else if (SEPANotificationUtil.isStatusCodeRejected(uniqueTrxSts)) {
                            send.setSts(PARTIAL_REJECTED);
                            send.save();
                        } else if (SEPANotificationUtil.isStatusCodeBooked(isInstantPaymentOrder, uniqueTrxSts)) {
                            send.setSts(PARTIAL_BOOKED);
                            send.save();
                        }
                    }
                } else if (hasGrpSts) {
                    if (isVopResult) {
                        SignedPayment.setVopStatusCode(grpSts, send);
                    } else if (SEPANotificationUtil.isFinalStatus(isInstantPaymentOrder, grpSts) || isNewestNotification) {
                        SignedPayment.setStatusCode(grpSts, send);
                    } else {
                        for (SignedPayment signedPayment : signedPayments) {
                            if (!SEPANotificationUtil.isNewestNotification(creationDate, signedPayment, isVopResult)) continue;
                            signedPayment.setSts(grpSts);
                            DB.save(signedPayment);
                        }
                    }
                } else {
                    logger.logError("SEPA notification with ID = " + notification.getId() + " is invalid. StatusCode is missing on group level.");
                }
            }
            t.commit();
        }
    }

    private static boolean isNewestNotification(Timestamp creationDate, SignedPayment signedPayment, boolean isVopResult) {
        Notification newestNotification;
        Notification notification = newestNotification = isVopResult ? Notification.findNewestPain002VopNotification(signedPayment) : Notification.findNewestPain002Notification(signedPayment);
        if (newestNotification != null) {
            return !creationDate.before(newestNotification.getFetched());
        }
        return true;
    }

    private static boolean isFinalStatus(boolean isInstantPaymentOrder, String statusCode) {
        return SEPANotificationUtil.isStatusCodeBooked(isInstantPaymentOrder, statusCode) || SEPANotificationUtil.isStatusCodeRejected(statusCode);
    }

    public static boolean isStatusCodeBooked(boolean isInstantPaymentOrder, String statusCode) {
        if (isInstantPaymentOrder) {
            return ACCP.equals(statusCode);
        }
        return ACSC.equals(statusCode);
    }

    public static boolean isPartiallyBooked(String statusCode) {
        return PARTIAL_BOOKED.equals(statusCode);
    }

    public static boolean isStatusCodeBookingInPreparation(String statusCode) {
        return ACSP.equals(statusCode);
    }

    public static boolean isStatusCodePending(String statusCode) {
        return PDNG.equals(statusCode);
    }

    public static boolean isStatusCodeRejected(String statusCode) {
        return RJCT.equals(statusCode);
    }

    public static boolean isPartiallyRejected(String statusCode) {
        return PARTIAL_REJECTED.equals(statusCode);
    }

    public static boolean hasVopResult(String statusCode) {
        return VOP_MATCH.equals(statusCode) || VOP_NO_MATCH.equals(statusCode) || VOP_CLOSE_MATCH.equals(statusCode) || VOP_NOT_APPLICABLE.equals(statusCode) || VOP_HAS_MISMATCHES.equals(statusCode);
    }

    public static boolean hasOnlyVopNotifications(Send send) {
        return Notification.getNotificationCount(send) == Notification.getVopNotificationCount(send) && Notification.getVopNotificationCount(send) > 0;
    }

    public static String getStatusCodeText(Send send, Locale locale) {
        String sts = send.getSts();
        if (sts != null && !sts.isEmpty()) {
            if (PARTIAL_BOOKED.equals(sts)) {
                return BankingApiMessages.getString(locale, "SendUtil.state.bookedPartially", new Object[0]);
            }
            if (PARTIAL_REJECTED.equals(sts)) {
                return BankingApiMessages.getString(locale, "SendUtil.state.rejectedPartially", new Object[0]);
            }
            String statusCodeText = StatusCode.getShortDescription(sts, SEPANotificationUtil.getContext(send.getPmtType()), null, locale);
            if (statusCodeText != null && !statusCodeText.equals(sts)) {
                return statusCodeText + " (" + sts + ")";
            }
            return sts;
        }
        return null;
    }

    private static StatusCode.StatusCodeContext getContext(PaymentTransferType.PmtType pmtType) {
        if (PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER.equals((Object)pmtType)) {
            return StatusCode.StatusCodeContext.SCT_INST;
        }
        return StatusCode.StatusCodeContext.SEPA;
    }

    public static Set<String> findPmtInfStates(Notification notification) {
        TreeSet<String> states = new TreeSet<String>();
        for (NotificationPmtInf pmtInf : NotificationPmtInf.find(notification)) {
            String state = pmtInf.getPmtInfSts();
            if (state == null || state.length() <= 0) continue;
            states.add(state);
        }
        return states;
    }

    public static Set<String> findTrxStates(Notification notification) {
        TreeSet<String> states = new TreeSet<String>();
        for (NotificationPmtInf pmtInf : NotificationPmtInf.find(notification)) {
            for (NotificationTrx trx : NotificationTrx.find(pmtInf)) {
                String state = trx.getTxSts();
                if (state == null || state.length() <= 0) continue;
                states.add(state);
            }
        }
        return states;
    }
}

