/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.ZipHandler;
import de.businesslogics.banking.api.ZipProcessing;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.NotificationPmtInf;
import de.businesslogics.banking.database.vo.NotificationTrx;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.transfer.api.BaseNotificationProcessing;
import de.businesslogics.banking.transfer.api.SEPANotificationUtil;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.format.sepa.GeneralSEPAReportExtractor;
import de.businesslogics.format.sepa.RejectedSEPALogicalFile;
import de.businesslogics.format.sepa.RejectedSEPAOrder;
import de.businesslogics.format.sepa.RejectedSEPAPayment;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.StatusReason;
import de.businesslogics.format.sepa.StatusTransactionInfo;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import io.ebean.Transaction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class SEPANotificationProcessing
extends BaseNotificationProcessing
implements ZipProcessing {
    private static final String PIPE = "|";
    private static final String UNDERSCORE = "_";

    public SEPANotificationProcessing(Notification.Type type, BLLogger logger, EncryptData encryptData) {
        super(type, logger, encryptData);
    }

    @Override
    public void parse(InputStream in) throws Exception {
        ZipHandler zipHandler = new ZipHandler(this, this.logger);
        zipHandler.process(in);
        this.setProcessingResult(zipHandler.getProcessingResult());
    }

    @Override
    public void processUnzipped(String originalFilename, InputStream in) throws Exception {
        List<EbicsElement> documents = GeneralSEPAReportExtractor.getDocuments(in);
        for (EbicsElement d : documents) {
            this.checkDocument(d);
            File dataFile = this.createDataFile();
            try (OutputStream out = this.encryptData.openOutputStream(dataFile);){
                EbicsPrintStream eps = new EbicsPrintStream(out);
                GeneralSEPAReportExtractor.addNameSpaceDecl(eps, d);
                eps.printOutPossibleRoot(d);
            }
            this.checkNotification(dataFile, GeneralSEPAReportExtractor.getCreationDate(d));
        }
    }

    protected abstract void checkDocument(EbicsElement var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Notification saveNotification(File dataFile, java.util.Date creationDate, String md5Hash) {
        List<RejectedSEPAOrder> orders;
        InputStream in;
        Notification notification;
        block34: {
            notification = this.createBaseNotification(dataFile, creationDate, md5Hash);
            in = null;
            in = this.encryptData.openInputStream(dataFile);
            orders = GeneralSEPAReportExtractor.getRejectedOrders(in);
            if (orders != null && orders.size() == 1) break block34;
            int countOrders = orders != null ? orders.size() : 0;
            this.logger.logError("Could not save SEPA notification: '" + dataFile.getAbsolutePath() + "' contains " + countOrders + " orders , but it should contain exactly 1 order!");
            Notification notification2 = notification;
            SystemUtils.close(in);
            return notification2;
        }
        try {
            Send send;
            RejectedSEPAOrder order = orders.get(0);
            notification.setOrgnlMsgId(order.getOriginalMessageId());
            notification.setOrgnlMsgNmId(order.getOriginalMessageName());
            notification.setOrgnlNbOfTxs(order.getCountTransactions());
            notification.setOrgnlCtrlSum(order.getTotalAmount());
            String groupStatus = order.getStatusCode();
            if (groupStatus != null && groupStatus.trim().length() > 0) {
                notification.setGrpSts(groupStatus);
            }
            notification.save();
            int countRejcetionsPmtInf = 0;
            int countRejectionsTrx = 0;
            List<RejectedSEPALogicalFile> logicalFiles = order.getRejectedLogicalFiles();
            List<StatusTransactionInfo> relevantStatusTransactionInfos = order.getGroupStatusTransactionInfos();
            relevantStatusTransactionInfos.removeIf(info -> info.getCountTransactions() == 0);
            if (logicalFiles != null && logicalFiles.size() > 0) {
                try (Transaction t = DB.beginTransaction();){
                    for (RejectedSEPALogicalFile logicalFile : logicalFiles) {
                        String pmtInfId = logicalFile.getLogicalFileId();
                        NotificationPmtInf notificationPmtInf = new NotificationPmtInf();
                        notificationPmtInf.setNotification(notification);
                        notificationPmtInf.setOrgnlPmtInfId(pmtInfId);
                        notificationPmtInf.setOrgnlNbOfTxs(logicalFile.getCountTransactions());
                        notificationPmtInf.setOrgnlCtrlSum(logicalFile.getTotalAmount());
                        String pmtInfStatus = logicalFile.getStatusCode();
                        if (pmtInfStatus != null && pmtInfStatus.trim().length() > 0) {
                            notificationPmtInf.setPmtInfSts(pmtInfStatus);
                            if ("RJCT".equals(pmtInfStatus)) {
                                countRejcetionsPmtInf += notificationPmtInf.getOrgnlNbOfTxs().intValue();
                            }
                        }
                        DB.save(notificationPmtInf);
                        List<RejectedSEPAPayment> payments = logicalFile.getRejectedPayments();
                        if (payments == null || payments.size() <= 0) continue;
                        for (RejectedSEPAPayment payment : payments) {
                            NotificationTrx notificationTrx = new NotificationTrx();
                            notificationTrx.setNotification(notification);
                            notificationTrx.setPmtInf(notificationPmtInf);
                            SEPAPaymentData paymentData = payment.getPayment();
                            String endToEndId = paymentData.getEndToEndId();
                            notificationTrx.setOrgnlEndToEndId(endToEndId);
                            notificationTrx.setOrgnlInstrId(paymentData.getInstructionId());
                            notificationTrx.setOriginator(paymentData.getOriginator());
                            notificationTrx.setOriginatorAccountNumber(paymentData.getOriginatorIban());
                            notificationTrx.setOriginatorBankCode(paymentData.getOriginatorBic());
                            notificationTrx.setRecipient(paymentData.getRecipient());
                            notificationTrx.setRecipientAccountNumber(paymentData.getRecipientIban());
                            notificationTrx.setRecipientBankCode(paymentData.getRecipientBic());
                            notificationTrx.setAmount(paymentData.getAmount());
                            if (paymentData.getCurrency() != null) {
                                notificationTrx.setAmountCurrency(paymentData.getCurrency().getCurrencyCode());
                            } else {
                                notificationTrx.setAmountCurrency("EUR");
                            }
                            notificationTrx.setPurpose(paymentData.getPurpose());
                            if (paymentData.getExecutionDate() != null) {
                                notificationTrx.setExecutionDate(new Timestamp(paymentData.getExecutionDate().getTime()));
                            }
                            notificationTrx.setCreditorId(paymentData.getCreditorId());
                            notificationTrx.setMandateId(paymentData.getMandateId());
                            if (paymentData.getMandateSignDate() != null) {
                                notificationTrx.setMandateSignDate(new Date(paymentData.getMandateSignDate().getTime()));
                            }
                            notificationTrx.setStatusReasonInfo(SEPANotificationProcessing.getStatusReasonInfo(payment.getStatusReasons()));
                            String trxStatus = payment.getStatusCode();
                            if (trxStatus != null && trxStatus.trim().length() > 0) {
                                notificationTrx.setTxSts(trxStatus);
                                if ("RJCT".equals(trxStatus)) {
                                    ++countRejectionsTrx;
                                }
                            }
                            DB.save(notificationTrx);
                        }
                    }
                    t.commit();
                }
            } else if (this.getType().equals((Object)Notification.Type.Pain002Vop) && relevantStatusTransactionInfos.size() > 0 && order.getCountTransactions() == relevantStatusTransactionInfos.get(0).getCountTransactions() && (send = SEPANotificationUtil.findSEPASendOrder(notification, this.logger)) != null) {
                for (SignedPayment payment : SignedPayment.findBySend(send)) {
                    NotificationTrx notificationTrx = new NotificationTrx();
                    notificationTrx.setNotification(notification);
                    String endToEndId = payment.getReference();
                    notificationTrx.setOrgnlEndToEndId(endToEndId);
                    notificationTrx.setRecipient(payment.getRecipient());
                    notificationTrx.setStatusReasonInfo("");
                    String trxStatus = relevantStatusTransactionInfos.get(0).getStatusCode();
                    if (trxStatus != null && trxStatus.trim().length() > 0) {
                        notificationTrx.setTxSts(trxStatus);
                    }
                    DB.save(notificationTrx);
                }
            }
            if (countRejectionsTrx > 0) {
                notification.setNbOfRjct(countRejectionsTrx);
            } else if (countRejcetionsPmtInf > 0) {
                notification.setNbOfRjct(countRejcetionsPmtInf);
            } else if (notification.getGrpSts() != null && "RJCT".equals(notification.getGrpSts())) {
                notification.setNbOfRjct(notification.getOrgnlNbOfTxs());
            }
            notification.save();
        }
        catch (Exception e) {
            Notification notification3;
            try {
                this.logger.logError("Could not save SEPA notification '" + dataFile.getAbsolutePath() + "'", e);
                notification3 = notification;
            }
            catch (Throwable throwable) {
                SystemUtils.close(in);
                throw throwable;
            }
            SystemUtils.close(in);
            return notification3;
        }
        SystemUtils.close(in);
        Send send = SEPANotificationUtil.findSEPASendOrder(notification, this.logger);
        if (send != null) {
            notification.setSend(send);
            notification.save();
            SEPANotificationUtil.setAdditionalStates(notification, send, this.logger);
        }
        if (this.getType().equals((Object)Notification.Type.Pain002Vop)) {
            this.saveRecipientVopResults(notification);
        }
        return notification;
    }

    protected void saveRecipientVopResults(Notification notification) {
    }

    static String getStatusReasonInfo(List<StatusReason> statusReasons) {
        if (statusReasons == null || statusReasons.size() == 0) {
            return "";
        }
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (StatusReason statusReason : statusReasons) {
            String additionalInfo;
            String statusReasonCode = statusReason.getStatusReasonCode();
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(PIPE);
            }
            if (statusReasonCode != null) {
                sb.append(statusReasonCode);
            }
            if ((additionalInfo = StringUtils.getStringFromStringList(statusReason.getAdditionalInfos(), UNDERSCORE)) == null || additionalInfo.length() <= 0) continue;
            sb.append(UNDERSCORE);
            sb.append(additionalInfo);
        }
        return sb.toString();
    }

    public static List<StatusReason> getStatusReasons(String statusReasonInfo) {
        ArrayList<StatusReason> statusReasons = new ArrayList<StatusReason>();
        StringTokenizer st = new StringTokenizer(statusReasonInfo, PIPE);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s == null || s.length() <= 0) continue;
            StatusReason statusReason = new StatusReason();
            if (s.contains(UNDERSCORE)) {
                int firstPosUndersore = s.indexOf(UNDERSCORE);
                if (firstPosUndersore > 0) {
                    statusReason.setStatusReasonCode(s.substring(0, firstPosUndersore));
                    if (firstPosUndersore + 1 < s.length()) {
                        s = s.substring(firstPosUndersore + 1);
                    }
                }
                if (s.length() > 0) {
                    StringTokenizer st2 = new StringTokenizer(s, UNDERSCORE);
                    while (st2.hasMoreTokens()) {
                        statusReason.addAdditionalInfo(st2.nextToken());
                    }
                }
            } else {
                statusReason.setStatusReasonCode(s);
            }
            statusReasons.add(statusReason);
        }
        return statusReasons;
    }
}

