/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.NotificationTrx;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.transfer.api.NotificationHandler;
import de.businesslogics.banking.transfer.api.NotificationUtil;
import de.businesslogics.banking.transfer.api.PrintDialogInfo;
import de.businesslogics.banking.transfer.api.TransferApiMessages;
import de.businesslogics.format.sepa.GeneralSEPAReportExtractor;
import de.businesslogics.format.sepa.RejectedSEPAOrder;
import de.businesslogics.format.sepa.pdf.StatusReportGenerator;
import de.businesslogics.pdf.BLDocument;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;

public class SEPANotificationPrinter
implements NotificationHandler {
    private final EncryptData encryptData;
    private final Locale locale;
    private Exception myException;
    private StatusReportGenerator generator;
    private boolean printOnlyRejected;

    public SEPANotificationPrinter(EncryptData encryptData, Locale locale) {
        this.encryptData = encryptData;
        this.locale = locale;
    }

    @Override
    public void addToDocument(Notification item, BLDocument doc) throws Exception {
        if (this.myException != null) {
            Exception e = this.myException;
            this.myException = null;
            throw e;
        }
        this.generator.setPrintOnlyRejected(this.printOnlyRejected);
        this.generator.addToDocument(StatusReportGenerator.getReportType(NotificationUtil.getHandlerKey(item)), item.getBank().getDisplayName(), doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLDocument.PageLayout getPageSize(Notification item) {
        InputStream in = null;
        try {
            in = this.encryptData.openInputStream(WorkspaceFileSystem.getFile(item.getFile()));
            List<RejectedSEPAOrder> orders = GeneralSEPAReportExtractor.getRejectedOrders(in);
            for (RejectedSEPAOrder order : orders) {
                Send send = item.getSend();
                if (send == null) continue;
                order.setOrderType(send.getOriginalSendType());
                order.setOrderNumber(send.getOrderNumber());
            }
            this.generator = new StatusReportGenerator(orders, this.locale);
        }
        catch (Exception e) {
            try {
                this.myException = e;
            }
            catch (Throwable throwable) {
                Util.closeStream(in);
                throw throwable;
            }
            Util.closeStream(in);
        }
        Util.closeStream(in);
        if (this.generator != null) {
            return this.generator.getPageSize();
        }
        return BLDocument.PageLayout.A4;
    }

    public void setPrintOnlyRejected(boolean printOnlyRejected) {
        this.printOnlyRejected = printOnlyRejected;
    }

    public PrintDialogInfo checkNotification(Notification notification) {
        int countRejected = notification.getNbOfRjct() != null ? notification.getNbOfRjct() : 0;
        int totalCount = NotificationTrx.findCountByNotification(notification);
        if (countRejected > 0 && countRejected < totalCount) {
            String messageKey = totalCount >= 1000 ? "SEPANoticationPrinter.printOnlyRejected.messageManyPayments" : "SEPANoticationPrinter.printOnlyRejected.message";
            return new PrintDialogInfo(PrintDialogInfo.Type.PRINT_REJECTED_OR_ALL, TransferApiMessages.getString(this.locale, "SEPANoticationPrinter.printOnlyRejected.title", new Object[0]), MessageFormat.format(TransferApiMessages.getString(this.locale, messageKey, new Object[0]), totalCount, countRejected));
        }
        if (totalCount >= 1000) {
            return new PrintDialogInfo(PrintDialogInfo.Type.PRINT_OR_CANCEL, TransferApiMessages.getString(this.locale, "SEPANoticationPrinter.printManyPayments.title", new Object[0]), MessageFormat.format(TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationPrinter.printManyPayments.message", new Object[0]), totalCount));
        }
        return null;
    }
}

