/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.transfer.api.SEPANotificationProcessing;
import de.businesslogics.banking.transfer.api.TransferApiMessages;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.format.sepa.GeneralSEPAReportExtractor;
import de.businesslogics.util.BLLogger;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;

public final class SEPAInstantNotificationProcessing
extends SEPANotificationProcessing {
    public SEPAInstantNotificationProcessing(BLLogger logger, EncryptData encryptData) {
        super(Notification.Type.Pain002Inst, logger, encryptData);
    }

    @Override
    public String getDescription() {
        return TransferApiMessages.getString(Locale.getDefault(), "SEPAInstantNotificationProcessing.description", new Object[0]);
    }

    @Override
    protected void checkDocument(EbicsElement d) throws IOException {
        if (GeneralSEPAReportExtractor.isDebitReport(d)) {
            String msg = this.startedByImport ? TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.importedFileContainsDebitNotifications", new Object[0]) : MessageFormat.format(TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.fetchedFileContainsDebitNotifications", new Object[0]), this.bank.getDisplayName(), this.fetchType, this.getDescription());
            throw new IOException(msg);
        }
        if (GeneralSEPAReportExtractor.isVopReport(d, false)) {
            String msg = this.startedByImport ? TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.importedFileContainsVopNotifications", new Object[0]) : MessageFormat.format(TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.fetchedFileContainsVopNotifications", new Object[0]), this.bank.getDisplayName(), this.fetchType, this.getDescription());
            throw new IOException(msg);
        }
    }
}

