/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.transfer.api.SEPANotificationProcessing;
import de.businesslogics.banking.transfer.api.TransferApiMessages;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.format.sepa.GeneralSEPAReportExtractor;
import de.businesslogics.util.BLLogger;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;

public final class SEPAForeignNotificationProcessing
extends SEPANotificationProcessing {
    public SEPAForeignNotificationProcessing(BLLogger logger, EncryptData encryptData) {
        super(Notification.Type.Pain002Foreign, logger, encryptData);
    }

    @Override
    public String getDescription() {
        return TransferApiMessages.getString(Locale.getDefault(), "SEPAForeignNotificationProcessing.description", new Object[0]);
    }

    @Override
    protected void checkDocument(EbicsElement d) throws IOException {
        String msg = null;
        if (GeneralSEPAReportExtractor.isDebitReport(d)) {
            msg = this.startedByImport ? TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.importedFileContainsDebitNotifications", new Object[0]) : MessageFormat.format(TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.fetchedFileContainsDebitNotifications", new Object[0]), this.bank.getDisplayName(), this.fetchType, this.getDescription());
        } else if (GeneralSEPAReportExtractor.isInstantPaymentReport(d)) {
            msg = this.startedByImport ? TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.importedFileContainsInstantNotifications", new Object[0]) : MessageFormat.format(TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.fetchedFileContainsInstantNotifications", new Object[0]), this.bank.getDisplayName(), this.fetchType, this.getDescription());
        } else if (GeneralSEPAReportExtractor.isVopReport(d, false)) {
            msg = this.startedByImport ? TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.importedFileContainsVopNotifications", new Object[0]) : MessageFormat.format(TransferApiMessages.getString(Locale.getDefault(), "SEPANoticationProcessing.fetchedFileContainsVopNotifications", new Object[0]), this.bank.getDisplayName(), this.fetchType, this.getDescription());
        }
        if (msg != null) {
            throw new IOException(msg);
        }
    }
}

