/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.SendOrderNameHandler;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.transfer.api.NotificationSettings;
import de.businesslogics.banking.transfer.api.ProtocolFormat;
import de.businesslogics.banking.transfer.api.TransferApiMessages;
import de.businesslogics.format.camt029.Camt029LogicalFile;
import de.businesslogics.format.camt029.Camt029LogicalFileReasonCode;
import de.businesslogics.format.camt029.Camt029StatusCode;
import de.businesslogics.format.camt029.Camt029Transaction;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.StatusReason;
import de.businesslogics.format.sepa.pdf.Messages;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Locale;

public class NotificationUtil {
    public static void storeErrorNotification(Send send, ProtocolFormat protocolFormat) {
        BankSettings bank = send.getBank();
        String protocolType = protocolFormat.toString();
        Notification notification = new Notification();
        notification.setBank(bank);
        if (protocolType.matches("[A-Z0-9]{3}")) {
            notification.setOrderType(protocolType);
        } else {
            notification.setOrderType("FDL");
            notification.setFileType(protocolType);
        }
        if (ProtocolFormat.HAC.equals((Object)protocolFormat)) {
            notification.setType(Notification.Type.HAC);
        } else {
            notification.setType(Notification.Type.PTK);
        }
        notification.setSend(send);
        notification.setOrderInfo("SEND." + protocolType + "." + Util.getOrderRepresentation(send));
        notification.setFetched(new Timestamp(System.currentTimeMillis()));
        DB.save(notification);
    }

    public static String getErrorProtocolTitle(Send send, String protocolFormat, Locale locale) {
        String orderDescription = Util.getOrderRepresentation(send);
        return TransferApiMessages.getString(locale, "NotificationUtil.errorProtocolTitle", protocolFormat, orderDescription, send.getBank().getDisplayName());
    }

    public static String getErrorProtocolMessage(Send send, String protocolFormat, Locale locale) {
        String orderDescription = Util.getOrderRepresentation(send);
        return TransferApiMessages.getString(locale, "NotificationUtil.errorProtocolMessage", orderDescription);
    }

    public static String getDescription(Notification notification, Locale locale, SendOrderNameHandler orderNameHandler) {
        if (notification.isAdditionalInfoFromPTK()) {
            return TransferApiMessages.getString(locale, "NotificationUtil.infoProtocolOverviewText", "PTK");
        }
        if (notification.isAdditionalInfoFromHAC()) {
            return TransferApiMessages.getString(locale, "NotificationUtil.infoProtocolOverviewText", "HAC");
        }
        if (notification.isErrorNotificationFromHAC()) {
            String specialOrderDescription = NotificationUtil.getSpecialOrderDescription(notification, orderNameHandler, locale);
            if (specialOrderDescription != null) {
                return TransferApiMessages.getString(locale, "NotificationUtil.errorProtocolOverviewSpecialText", "HAC", specialOrderDescription);
            }
            return TransferApiMessages.getString(locale, "NotificationUtil.errorProtocolOverviewText", "HAC", NotificationUtil.getOrderDescription(notification, orderNameHandler, locale));
        }
        if (notification.isErrorNotificationFromPTK()) {
            String specialOrderDescription = NotificationUtil.getSpecialOrderDescription(notification, orderNameHandler, locale);
            if (specialOrderDescription != null) {
                return TransferApiMessages.getString(locale, "NotificationUtil.errorProtocolOverviewSpecialText", "PTK", specialOrderDescription);
            }
            return TransferApiMessages.getString(locale, "NotificationUtil.errorProtocolOverviewText", "PTK", NotificationUtil.getOrderDescription(notification, orderNameHandler, locale));
        }
        Notification.Type type = notification.getType();
        if (Notification.Type.Camt029.equals((Object)type)) {
            return NotificationUtil.getCamt029Description(notification.getSend(), orderNameHandler, locale);
        }
        String orderInfo = type.getHandlerKey();
        if (orderInfo != null && orderInfo.startsWith("YM")) {
            return TransferApiMessages.getString(locale, "NotificationUtil.bbkNotification", orderInfo.substring(1));
        }
        boolean isPain002Notification = type.isPain002Notification();
        Send send = notification.getSend();
        if (send != null) {
            String handlerKey;
            String specialName;
            if (orderNameHandler.displaySpecialName() && (specialName = orderNameHandler.getSpecialName(handlerKey = send.getPmtType() != null ? send.getPmtType().getHandlerKey() : send.getOriginalSendType(), send.getOrderNumber(), locale)) != null) {
                if (isPain002Notification) {
                    String bundleKey = Notification.Type.Pain002Vop.equals((Object)type) ? "NotificationUtil.pain002VopVerificationResult" : "NotificationUtil.pain002StatusReportOverviewTextSpecialOrder";
                    return TransferApiMessages.getString(locale, bundleKey, specialName);
                }
                return TransferApiMessages.getString(locale, "NotificationUtil.statusReportOverviewTextSpecialOrder", orderInfo, specialName);
            }
            if (isPain002Notification) {
                if (Notification.Type.Pain002Vop.equals((Object)type)) {
                    String orderName = PaymentTypeUtil.getNameForSendReport(locale, send);
                    if (orderName != null) {
                        return TransferApiMessages.getString(locale, "NotificationUtil.pain002VopVerificationResult", orderName);
                    }
                    return TransferApiMessages.getString(locale, "NotificationUtil.pain002VopVerificationResultOrder", Util.getOrderRepresentation(send));
                }
                return NotificationUtil.getPain002Description(locale, type, Util.getOrderRepresentation(send), null);
            }
            return TransferApiMessages.getString(locale, "NotificationUtil.statusReportOverviewText", orderInfo, Util.getOrderRepresentation(send));
        }
        String originalMessageId = notification.getOrgnlMsgId();
        if (originalMessageId != null) {
            if (isPain002Notification) {
                if (Notification.Type.Pain002Vop.equals((Object)type)) {
                    return TransferApiMessages.getString(locale, "NotificationUtil.pain002VopVerificationResultMsgId", originalMessageId);
                }
                return NotificationUtil.getPain002Description(locale, type, null, originalMessageId);
            }
            return TransferApiMessages.getString(locale, "NotificationUtil.statusReportOverviewText2", orderInfo, originalMessageId);
        }
        return notification.getFetchType();
    }

    public static String getLogicalFileStatusDescription(Locale locale, Camt029LogicalFile logicalFile, String status) {
        Messages messages = new Messages(locale);
        StringBuilder sb = new StringBuilder();
        if (Camt029StatusCode.CNCL.name().equals(status)) {
            sb.append(MessageFormat.format(messages.getString("Camt029Report.logicalFile.success"), logicalFile.getPmtInfId()));
        } else if (Camt029StatusCode.RJCR.name().equals(status)) {
            sb.append(MessageFormat.format(messages.getString("Camt029Report.logicalFile.rejected"), logicalFile.getPmtInfId()));
        } else if (Camt029StatusCode.PDCR.name().equals(status)) {
            sb.append(MessageFormat.format(messages.getString("Camt029Report.logicalFile.PDCR"), logicalFile.getPmtInfId()));
        } else if (Camt029StatusCode.UWFW.name().equals(status)) {
            sb.append(MessageFormat.format(messages.getString("Camt029Report.logicalFile.UWFW"), logicalFile.getPmtInfId()));
        } else if (Camt029StatusCode.CWFW.name().equals(status)) {
            sb.append(MessageFormat.format(messages.getString("Camt029Report.logicalFile.CWFW"), logicalFile.getPmtInfId()));
        } else {
            sb.append(MessageFormat.format(messages.getString("Camt029Report.logicalFile.otherState"), logicalFile.getPmtInfId(), status));
        }
        StatusReason statusReason = logicalFile.getStatusReasonInfo();
        if (statusReason != null) {
            sb.append("\n");
            sb.append(MessageFormat.format(messages.getString("Camt029Report.reason"), Camt029LogicalFileReasonCode.getDescription(statusReason.getStatusReasonCode(), locale)));
        }
        return sb.toString();
    }

    public static String getTransactionStatusDescription(Locale locale, String status) {
        Messages messages = new Messages(locale);
        StringBuilder sb = new StringBuilder();
        boolean cancellationSuccessful = Camt029StatusCode.CNCL.name().equals(status);
        if (cancellationSuccessful) {
            sb.append(messages.getString("Camt029Report.transactions.success"));
        } else if (Camt029StatusCode.RJCR.name().equals(status)) {
            sb.append(messages.getString("Camt029Report.transactions.rejected"));
        } else if (Camt029StatusCode.PDCR.name().equals(status)) {
            sb.append(messages.getString("Camt029Report.transactions.PDCR"));
        } else if (Camt029StatusCode.UWFW.name().equals(status)) {
            sb.append(messages.getString("Camt029Report.transactions.UWFW"));
        } else if (Camt029StatusCode.CWFW.name().equals(status)) {
            sb.append(messages.getString("Camt029Report.transactions.CWFW"));
        } else {
            sb.append(MessageFormat.format(messages.getString("Camt029Report.transactions.otherState"), status));
        }
        return sb.toString();
    }

    public static String getTransactionDetails(Locale locale, Camt029Transaction transaction) {
        String recipientIban;
        SEPAPaymentData paymentData = transaction.getPaymentData();
        StringBuilder sb = new StringBuilder();
        String recipient = StringUtils.checkNullAndTrim(paymentData.getRecipient());
        if (recipient.length() > 0) {
            sb.append(recipient);
        }
        if ((recipientIban = IbanUtil.formatIBAN(StringUtils.checkNullAndTrim(paymentData.getRecipientIban()))).length() > 0) {
            String recipientBic = StringUtils.checkNullAndTrim(paymentData.getRecipientBic());
            sb.append(" (");
            if (recipientBic.length() > 0) {
                sb.append(recipientBic).append("/");
            }
            sb.append(recipientIban).append("), ");
        }
        sb.append(PaymentUtils.formatAmount(paymentData.getAmount(), paymentData.getCurrency(), locale));
        if (paymentData.getExecutionDate() != null) {
            sb.append(", ").append(DateFormat.getDateInstance().format(paymentData.getExecutionDate()));
        }
        String endToEndId = StringUtils.checkNullAndTrim(paymentData.getEndToEndId());
        sb.append(", ").append(BankingApiMessages.getString(locale, "GeneralMessages.endToEndReference", new Object[0])).append(": ");
        if (endToEndId.length() > 0) {
            sb.append(endToEndId);
        } else {
            sb.append(StringUtils.checkNullAndTrim(transaction.getEndToEndId()));
        }
        return sb.toString();
    }

    private static String getPain002Description(Locale locale, Notification.Type type, String orderRepresentation, String originalMessageId) {
        switch (type) {
            case Pain002Credit: {
                if (orderRepresentation != null) {
                    return TransferApiMessages.getString(locale, "NotificationUtil.pain002CreditStatusReportOverviewText", orderRepresentation);
                }
                return TransferApiMessages.getString(locale, "NotificationUtil.pain002CreditStatusReportOverviewText2", originalMessageId);
            }
            case Pain002Debit: {
                if (orderRepresentation != null) {
                    return TransferApiMessages.getString(locale, "NotificationUtil.pain002DebitStatusReportOverviewText", orderRepresentation);
                }
                return TransferApiMessages.getString(locale, "NotificationUtil.pain002DebitStatusReportOverviewText2", originalMessageId);
            }
            case Pain002Inst: {
                if (orderRepresentation != null) {
                    return TransferApiMessages.getString(locale, "NotificationUtil.pain002InstantStatusReportOverviewText", orderRepresentation);
                }
                return TransferApiMessages.getString(locale, "NotificationUtil.pain002InstantStatusReportOverviewText2", originalMessageId);
            }
            case Pain002Foreign: {
                if (orderRepresentation != null) {
                    return TransferApiMessages.getString(locale, "NotificationUtil.pain002ForeignStatusReportOverviewText", orderRepresentation);
                }
                return TransferApiMessages.getString(locale, "NotificationUtil.pain002ForeignStatusReportOverviewText2", originalMessageId);
            }
        }
        return "";
    }

    private static String getSpecialOrderDescription(Notification notification, SendOrderNameHandler orderNameHandler, Locale locale) {
        Send send = notification.getSend();
        if (send != null) {
            String handlerKey = send.getPmtType() != null ? send.getPmtType().getHandlerKey() : send.getOriginalSendType();
            return orderNameHandler.getSpecialName(handlerKey, send.getOrderNumber(), locale);
        }
        return null;
    }

    private static String getOrderDescription(Notification notification, SendOrderNameHandler orderNameHandler, Locale locale) {
        Send send = notification.getSend();
        if (send != null) {
            return Util.getOrderRepresentation(notification.getSend());
        }
        String orderInfo = notification.getOrderInfo();
        if (orderInfo.length() > 10) {
            return orderInfo.substring(9);
        }
        return "";
    }

    private static String getCamt029Description(Send send, SendOrderNameHandler orderNameHandler, Locale locale) {
        if (send != null) {
            String specialName;
            if (orderNameHandler.displaySpecialName() && (specialName = orderNameHandler.getSpecialName(send.getOriginalSendType(), send.getOrderNumber(), locale)) != null) {
                return TransferApiMessages.getString(locale, "NotificationUtil.camt029OverviewTextSpecialOrder", specialName);
            }
            return TransferApiMessages.getString(locale, "NotificationUtil.camt029OverviewTextGeneralOrder", Util.getOrderRepresentation(send));
        }
        return TransferApiMessages.getString(locale, "NotificationUtil.camt029OverviewText", new Object[0]);
    }

    public static String getHandlerKey(Notification notification) {
        return notification.getType().getHandlerKey();
    }

    public static Notification.Type getSEPANotificationType(Fetch fetch) {
        NotificationSettings settings;
        String fetchType = fetch.getFetchType();
        if (fetchType.equals((settings = NotificationSettings.getForBank(fetch.getBank())).getFetchTypeForCreditNotifications())) {
            return Notification.Type.Pain002Credit;
        }
        if (fetchType.equals(settings.getFetchTypeForInstantNotifications())) {
            return Notification.Type.Pain002Debit;
        }
        if (fetchType.equals(settings.getFetchTypeForInstantNotifications())) {
            return Notification.Type.Pain002Inst;
        }
        return null;
    }
}

