/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.FetchParameterUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.CmBank;
import de.businesslogics.banking.database.vo.NotificationSetting;
import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.util.StringUtils;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class NotificationSettings {
    private static final String[] bbkOrderTypes = new String[]{"YM3", "YM6", "YM7", "YM8", "YM9"};
    private NotificationSetting settings;

    public static NotificationSettings getForBank(BankSettings bank) {
        return new NotificationSettings(bank);
    }

    public NotificationSettings(BankSettings bank) {
        NotificationSetting vo = NotificationSetting.get(bank);
        if (vo == null) {
            vo = new NotificationSetting();
            vo.setBank(bank);
            vo.setActive(NotificationSettings.getDefaultActive());
            vo.setFetchMode(NotificationSettings.getDefaultFetchMode());
            vo.setCreditNotifications(NotificationSettings.getDefaultFetchCreditNotifications());
            vo.setForeignNotifications(NotificationSettings.getDefaultFetchForeignNotifications());
            vo.setInstantNotifications(NotificationSettings.getDefaultFetchInstantNotifications());
            vo.setDebitNotifications(NotificationSettings.getDefaultFetchDebitNotifications());
            vo.setCallbackNotifications(NotificationSettings.getDefaultFetchCallbackNotifications());
            vo.setBundesbank(NotificationSettings.getDefaultFetchBundesbankNotifications());
            vo.save();
        }
        this.settings = vo;
    }

    public void save() {
        this.settings.save();
    }

    public BankSettings getBank() {
        return this.settings.getBank();
    }

    public List<String> getFetchTypes(BankUser bankUser, boolean isBundesbankClient) {
        ArrayList<String> permittedFetchTypes = new ArrayList<String>();
        if (this.isActivated()) {
            if (this.fetchCreditNotifications()) {
                this.checkPermissionForFetchType(bankUser, this.getFetchTypeForCreditNotifications(), permittedFetchTypes);
            }
            if (this.fetchForeignNotifications()) {
                this.checkPermissionForFetchType(bankUser, this.getFetchTypeForForeignNotifications(), permittedFetchTypes);
            }
            if (this.fetchInstantNotifications()) {
                this.checkPermissionForFetchType(bankUser, this.getFetchTypeForInstantNotifications(), permittedFetchTypes);
            }
            if (this.fetchDebitNotifications()) {
                this.checkPermissionForFetchType(bankUser, this.getFetchTypeForDebitNotifications(), permittedFetchTypes);
            }
            if (this.fetchVopNotifications()) {
                this.checkPermissionForFetchType(bankUser, this.getFetchTypeForVopNotifications(), permittedFetchTypes);
            }
            if (this.fetchCallbackNotifications()) {
                this.checkPermissionForFetchType(bankUser, this.getFetchTypeForCallbackNotifications(), permittedFetchTypes);
            }
            if (isBundesbankClient && this.fetchBundesbankNotifications()) {
                for (String bbkFetchType : this.getFetchTypesForBBktNotifications()) {
                    this.checkPermissionForFetchType(bankUser, bbkFetchType, permittedFetchTypes);
                }
            }
        }
        return permittedFetchTypes;
    }

    private void checkPermissionForFetchType(BankUser bankUser, String fetchType, List<String> permittedOrderTypes) {
        if (Util.hasFetchPermission(bankUser, fetchType)) {
            permittedOrderTypes.add(fetchType);
        }
    }

    public boolean isActivated() {
        return this.settings.isActive();
    }

    public void setIsActivated(boolean isActivated) {
        this.settings.setActive(isActivated);
    }

    public YYMMDD getLastFetchDate() {
        Date dbLastFetch = this.settings.getLastFetch();
        if (dbLastFetch == null) {
            return null;
        }
        return new YYMMDD(dbLastFetch.getTime());
    }

    public void setLastFetchDate(YYMMDD lastFetch) {
        if (lastFetch == null) {
            this.settings.setLastFetch(null);
        } else {
            this.settings.setLastFetch(new Date(lastFetch.getTime()));
        }
    }

    public CmBank.FetchMode getFetchMode() {
        return this.settings.getFetchMode();
    }

    public void setFetchMode(CmBank.FetchMode fetchMode) {
        this.settings.setFetchMode(fetchMode);
    }

    public boolean fetchCreditNotifications() {
        return this.settings.isCreditNotifications();
    }

    public void setFetchCreditNotifications(boolean fetchCreditNotifications) {
        this.settings.setCreditNotifications(fetchCreditNotifications);
    }

    public boolean fetchForeignNotifications() {
        return this.settings.isForeignNotifications();
    }

    public void setFetchForeignNotifications(boolean fetchForeignNotifications) {
        this.settings.setForeignNotifications(fetchForeignNotifications);
    }

    public boolean fetchInstantNotifications() {
        return this.settings.isInstantNotifications();
    }

    public void setFetchInstantNotifications(boolean fetchInstantNotifications) {
        this.settings.setInstantNotifications(fetchInstantNotifications);
    }

    public boolean fetchDebitNotifications() {
        return this.settings.isDebitNotifications();
    }

    public void setFetchDebitNotifications(boolean fetchDebitNotifications) {
        this.settings.setDebitNotifications(fetchDebitNotifications);
    }

    public boolean fetchVopNotifications() {
        return this.settings.isVopNotifications();
    }

    public void setFetchVopNotifications(boolean fetchVopNotifications) {
        this.settings.setVopNotifications(fetchVopNotifications);
    }

    public boolean fetchCallbackNotifications() {
        return this.settings.isCallbackNotifications();
    }

    public void setFetchCallbackNotifications(boolean fetchCallbackNotifications) {
        this.settings.setCallbackNotifications(fetchCallbackNotifications);
    }

    public boolean fetchBundesbankNotifications() {
        return this.settings.isBundesbank();
    }

    public void setFetchBundesbankNotifications(boolean fetchBundesbankNotifications) {
        this.settings.setBundesbank(fetchBundesbankNotifications);
    }

    public static boolean getDefaultActive() {
        return true;
    }

    public static CmBank.FetchMode getDefaultFetchMode() {
        return CmBank.FetchMode.DATE;
    }

    public static boolean getDefaultFetchCreditNotifications() {
        return true;
    }

    public static boolean getDefaultFetchForeignNotifications() {
        return true;
    }

    public static boolean getDefaultFetchVopNotifications() {
        return true;
    }

    public static boolean getDefaultFetchInstantNotifications() {
        return true;
    }

    public static boolean getDefaultFetchDebitNotifications() {
        return true;
    }

    public static boolean getDefaultFetchCallbackNotifications() {
        return true;
    }

    public static boolean getDefaultFetchBundesbankNotifications() {
        return true;
    }

    public String getFetchTypeForCreditNotifications() {
        String fetchTypeFromDb = StringUtils.checkNullAndTrim(this.settings.getCreditFetchType());
        if (fetchTypeFromDb.length() > 0) {
            return BankUtils.getProperFetchType(this.isEbics30OrNewer(), fetchTypeFromDb, this.getBank().getCountryCode());
        }
        return this.getDefaultFetchTypeForCreditNotifications();
    }

    public void setFetchTypeForCreditNotifications(String fetchType) {
        this.settings.setCreditFetchType(fetchType);
    }

    public String getFetchTypeForForeignNotifications() {
        String fetchTypeFromDb = StringUtils.checkNullAndTrim(this.settings.getForeignFetchType());
        if (fetchTypeFromDb.length() > 0) {
            return BankUtils.getProperFetchType(this.isEbics30OrNewer(), fetchTypeFromDb, this.getBank().getCountryCode());
        }
        return this.getDefaultFetchTypeForForeignNotifications();
    }

    public void setFetchTypeForForeignNotifications(String fetchType) {
        this.settings.setForeignFetchType(fetchType);
    }

    public String getFetchTypeForInstantNotifications() {
        String fetchTypeFromDb = StringUtils.checkNullAndTrim(this.settings.getInstantFetchType());
        if (fetchTypeFromDb.length() > 0) {
            return BankUtils.getProperFetchType(this.isEbics30OrNewer(), fetchTypeFromDb, this.getBank().getCountryCode());
        }
        return this.getDefaultFetchTypeForInstantNotifications();
    }

    public void setFetchTypeForInstantNotifications(String fetchType) {
        this.settings.setInstantFetchType(fetchType);
    }

    public String getFetchTypeForDebitNotifications() {
        String fetchTypeFromDb = StringUtils.checkNullAndTrim(this.settings.getDebitFetchType());
        if (fetchTypeFromDb.length() > 0) {
            return BankUtils.getProperFetchType(this.isEbics30OrNewer(), fetchTypeFromDb, this.getBank().getCountryCode());
        }
        return this.getDefaultFetchTypeForDebitNotifications();
    }

    public void setFetchTypeForDebitNotifications(String fetchType) {
        this.settings.setDebitFetchType(fetchType);
    }

    public String getFetchTypeForVopNotifications() {
        String fetchTypeFromDb = StringUtils.checkNullAndTrim(this.settings.getVopFetchType());
        if (fetchTypeFromDb.length() > 0) {
            return BankUtils.getProperFetchType(this.isEbics30OrNewer(), fetchTypeFromDb, this.getBank().getCountryCode());
        }
        return this.getDefaultFetchTypeForVopNotifications();
    }

    public void setFetchTypeForVopNotifications(String fetchType) {
        this.settings.setVopFetchType(fetchType);
    }

    public String getFetchTypeForCallbackNotifications() {
        String fetchTypeFromDb = StringUtils.checkNullAndTrim(this.settings.getCallbackFetchType());
        if (fetchTypeFromDb.length() > 0) {
            return BankUtils.getProperFetchType(this.isEbics30OrNewer(), fetchTypeFromDb, this.getBank().getCountryCode());
        }
        return this.getDefaultFetchTypeForCallbackNotifications();
    }

    public void setFetchTypeForCallbackNotifications(String fetchType) {
        this.settings.setCallbackFetchType(fetchType);
    }

    public String getDefaultFetchTypeForCreditNotifications() {
        return FetchParameterUtil.getDefaultFetchParameter(FetchParameterUtil.StatementType.pain002ReportSCT, this.isEbics30OrNewer(), this.settings.getBank().getCountryCode());
    }

    public String getDefaultFetchTypeForForeignNotifications() {
        return FetchParameterUtil.getDefaultFetchParameter(FetchParameterUtil.StatementType.pain002ReportAXS, this.isEbics30OrNewer(), this.settings.getBank().getCountryCode());
    }

    public String getDefaultFetchTypeForInstantNotifications() {
        return FetchParameterUtil.getDefaultFetchParameter(FetchParameterUtil.StatementType.pain002ReportSCI, this.isEbics30OrNewer(), this.settings.getBank().getCountryCode());
    }

    public String getDefaultFetchTypeForDebitNotifications() {
        return FetchParameterUtil.getDefaultFetchParameter(FetchParameterUtil.StatementType.pain002ReportSDD, this.isEbics30OrNewer(), this.settings.getBank().getCountryCode());
    }

    public String getDefaultFetchTypeForVopNotifications() {
        return FetchParameterUtil.getDefaultFetchParameter(FetchParameterUtil.StatementType.pain002ReportVOP, this.isEbics30OrNewer(), this.settings.getBank().getCountryCode());
    }

    public String getDefaultFetchTypeForCallbackNotifications() {
        return FetchParameterUtil.getDefaultFetchParameter(FetchParameterUtil.StatementType.camt029Report, this.isEbics30OrNewer(), this.settings.getBank().getCountryCode());
    }

    private boolean isEbics30OrNewer() {
        return BankUtils.isProtocolH005OrNewer(this.settings.getBank().getProtocolVersion());
    }

    private String[] getFetchTypesForBBktNotifications() {
        if (this.isEbics30OrNewer()) {
            ArrayList<String> bbkBTFs = new ArrayList<String>();
            for (String orderType : bbkOrderTypes) {
                String btf = BTFTranslator.getBTFFromFetchOrderType(orderType);
                if (btf == null) continue;
                bbkBTFs.add(btf);
            }
            return bbkBTFs.toArray(new String[0]);
        }
        return bbkOrderTypes;
    }
}

